/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.audit;

import com.ibm.keymanager.audit.AuditOutcomeType;
import com.ibm.keymanager.audit.ResourceInfo;
import com.ibm.keymanager.audit.Security_Event;
import com.ibm.keymanager.audit.UserInfo;
import java.util.Date;

public class Runtime_Event
implements Security_Event {
    public static final String AUDIT_START = "auditStart";
    public static final String AUDIT_STOP = "auditStop";
    public static final String START = "start";
    public static final String STOP = "stop";
    public static final String NEW_KEY_REQUEST = "newKeyRequest";
    public static final String NEW_KEY_RESPONSE = "newKeyResponse";
    public static final String REKEY_REQUEST = "reKeyRequest";
    public static final String REKEY_RESPONSE = "reKeyResponse";
    public static final String KEY_REQUEST = "keyRequest";
    public static final String KEY_RESPONSE = "keyResponse";
    private Object source;
    private String action;
    private ResourceInfo resource;
    private AuditOutcomeType outcome;
    private String message;
    private Date timestamp;
    private UserInfo user;

    public Runtime_Event(Object source, String action, ResourceInfo resource, AuditOutcomeType outcome) {
        this.source = source;
        this.action = action;
        this.resource = resource;
        this.outcome = outcome;
        this.timestamp = new Date();
    }

    public Runtime_Event(Object source, String action, String resource, boolean outcome) {
        this.source = source;
        this.action = action;
        this.resource = new ResourceInfo(resource);
        this.outcome = new AuditOutcomeType(outcome);
        this.timestamp = new Date();
    }

    public Runtime_Event(Object source, String action, UserInfo user, ResourceInfo resource, AuditOutcomeType outcome) {
        this.source = source;
        this.action = action;
        this.resource = resource;
        this.outcome = outcome;
        this.timestamp = new Date();
        this.user = user;
    }

    public Runtime_Event(Object source, String action, String resource, String user, boolean outcome) {
        this.source = source;
        this.action = action;
        this.resource = new ResourceInfo(resource);
        this.user = new UserInfo(user);
        this.outcome = new AuditOutcomeType(outcome);
        this.timestamp = new Date();
    }

    public String getAction() {
        return this.action;
    }

    public UserInfo getUser() {
        return this.user;
    }

    public ResourceInfo getResource() {
        return this.resource;
    }

    public void setAuditMsg(String msg) {
        this.message = msg;
    }

    public String getAuditMsg() {
        return this.message;
    }

    public String getEventType() {
        return "SECURITY_RUNTIME";
    }

    public void setTimestamp(Date date) {
        this.timestamp = date;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public Object getEventSource() {
        return this.source;
    }

    public AuditOutcomeType getOutcome() {
        return this.outcome;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Runtime event:[");
        sb.append("\n  timestamp=" + this.timestamp);
        sb.append("\n  event source=" + this.source.getClass().getName());
        sb.append("\n  outcome=" + this.outcome.toString());
        sb.append("\n  event type=SECURITY_RUNTIME");
        if (this.message != null) {
            sb.append("\n  message=" + this.message);
        }
        sb.append("\n  resource=" + this.resource);
        sb.append("\n  action=" + this.action);
        if (this.user != null) {
            sb.append("\n  user=" + this.user);
        }
        sb.append("\n  ]\n");
        return sb.toString();
    }
}

