/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.audit;

import com.ibm.keymanager.audit.AuditOutcomeType;
import com.ibm.keymanager.audit.Security_Event;
import com.ibm.keymanager.audit.UserInfo;
import java.util.Date;

public class ConfigMgmt_Event
implements Security_Event {
    public static final String TYPE_CONFIG = "config";
    public static final String TYPE_SERVER = "server";
    private Object source;
    private String action;
    private String type;
    private String message;
    private UserInfo user;
    private AuditOutcomeType outcome;
    private Date timestamp;

    public ConfigMgmt_Event(Object source, String action, String type, UserInfo user, AuditOutcomeType outcome) {
        this.source = source;
        this.action = action;
        this.type = type;
        this.user = user;
        this.outcome = outcome;
        this.timestamp = new Date();
    }

    public ConfigMgmt_Event(Object source, String action, UserInfo user, AuditOutcomeType outcome) {
        this.source = source;
        this.action = action;
        this.type = TYPE_CONFIG;
        this.user = user;
        this.outcome = outcome;
        this.timestamp = new Date();
    }

    public ConfigMgmt_Event(Object source, String action, String user, boolean outcome) {
        this.source = source;
        this.action = action;
        this.type = TYPE_CONFIG;
        this.user = new UserInfo(user);
        this.outcome = new AuditOutcomeType(outcome);
        this.timestamp = new Date();
    }

    public String getAction() {
        return this.action;
    }

    public String getType() {
        return this.type;
    }

    public UserInfo getUser() {
        return this.user;
    }

    public void setAuditMsg(String msg) {
        this.message = msg;
    }

    public String getAuditMsg() {
        return this.message;
    }

    public String getEventType() {
        return "SECURITY_MGMT_CONFIG";
    }

    public void setTimestamp(Date date) {
        this.timestamp = date;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public Object getEventSource() {
        return this.source;
    }

    public AuditOutcomeType getOutcome() {
        return this.outcome;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Configuration management event:[");
        sb.append("\n  timestamp=" + this.timestamp);
        sb.append("\n  event source=" + this.source.getClass().getName());
        sb.append("\n  outcome=" + this.outcome.toString());
        sb.append("\n  event type=SECURITY_MGMT_CONFIG");
        if (this.message != null) {
            sb.append("\n  message=" + this.message);
        }
        sb.append("\n  action=" + this.action);
        sb.append("\n  command type=" + this.type);
        sb.append("\n  user=" + this.user);
        sb.append("\n  ]\n");
        return sb.toString();
    }
}

