/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.audit;

import com.ibm.keymanager.audit.AuditOutcomeType;
import com.ibm.keymanager.audit.Security_Event;
import com.ibm.keymanager.audit.UserInfo;
import java.util.Date;

public class AuthnTerminate_Event
implements Security_Event {
    public static final String IDLE_TIMEOUT = "idleTimeout";
    public static final String SESSION_EXPIRED = "sessionExpired";
    public static final String SESSION_TERMINATEDBYADMIN = "sessionTerminatedByAdmin";
    public static final String USER_LOGGEDOUT = "userLoggedOut";
    public static final String REAUTH_LOCKOUT = "reauthLockout";
    private Object source;
    private String authnType;
    private UserInfo[] users;
    private AuditOutcomeType outcome;
    private String message;
    private Date timestamp;
    private String terminateReason;

    public AuthnTerminate_Event(Object source, String authn_type, String user_name, String terminate_reason, boolean outcome) {
        this.source = source;
        this.authnType = authn_type;
        this.users = new UserInfo[]{new UserInfo(user_name)};
        this.terminateReason = terminate_reason;
        this.outcome = new AuditOutcomeType(outcome);
        this.timestamp = new Date();
    }

    public AuthnTerminate_Event(Object source, String authn_type, UserInfo user, String terminate_reason, AuditOutcomeType outcome) {
        this.source = source.getClass().getName();
        this.authnType = authn_type;
        this.users = new UserInfo[]{user};
        this.terminateReason = terminate_reason;
        this.outcome = outcome;
        this.timestamp = new Date();
    }

    public AuthnTerminate_Event(Object source, String authn_type, UserInfo[] users, String terminate_reason, AuditOutcomeType outcome) {
        this.source = source.getClass().getName();
        this.authnType = authn_type;
        this.users = users;
        this.terminateReason = terminate_reason;
        this.outcome = outcome;
    }

    public String getTerminateReason() {
        return this.terminateReason;
    }

    public UserInfo[] getUsers() {
        return this.users;
    }

    public String getAuthnType() {
        return this.authnType;
    }

    public void setAuditMsg(String msg) {
        this.message = msg;
    }

    public String getAuditMsg() {
        return this.message;
    }

    public String getEventType() {
        return "SECURITY_AUTHN";
    }

    public void setTimestamp(Date date) {
        this.timestamp = date;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public Object getEventSource() {
        return this.source;
    }

    public AuditOutcomeType getOutcome() {
        return this.outcome;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Authentication terminate event:[");
        sb.append("\n  timestamp=" + this.timestamp.toString());
        sb.append("\n  event source=" + this.source.getClass().getName());
        sb.append("\n  outcome=" + this.outcome);
        sb.append("\n  event type=SECURITY_AUTHN");
        if (this.message != null) {
            sb.append("\n message=" + this.message);
        }
        sb.append("\n  anthentication type=" + this.authnType);
        String users = this.users[0].toString();
        for (int i = 1; i < this.users.length; ++i) {
            users = users + "," + this.users[i].toString();
        }
        sb.append("\n  users=" + users);
        sb.append("\n  terminate reason=" + this.terminateReason);
        sb.append("\n  ]\n");
        return sb.toString();
    }
}

