/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.audit;

public class AuditOutcomeType {
    public static final int STATUS_UNDEFINED = 9999;
    private boolean result;
    private int majorStatus = 9999;
    private int minorStatus = 9999;
    private String failureReason;

    public AuditOutcomeType(boolean result, int majorStatus, int minorStatus, String failureReason) {
        this.result = result;
        this.majorStatus = majorStatus;
        this.minorStatus = minorStatus;
        this.failureReason = failureReason;
    }

    public AuditOutcomeType(boolean result, String failureReason) {
        this.result = result;
        this.failureReason = failureReason;
    }

    public AuditOutcomeType(boolean result) {
        this.result = result;
    }

    public int getMajorStatus() {
        return this.majorStatus;
    }

    public int getMinorStatus() {
        return this.minorStatus;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public boolean getResult() {
        return this.result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.result) {
            sb.append("[result=successful");
        } else {
            sb.append("[result=unsuccessful");
        }
        if (this.majorStatus != 9999) {
            sb.append(";major status=" + this.majorStatus);
            if (this.minorStatus == 9999) {
                sb.append(";minor status=undefined");
            } else {
                sb.append(";minor status=" + this.minorStatus);
            }
        }
        if (this.failureReason != null) {
            sb.append(";failure reason=" + this.failureReason);
        }
        sb.append("]");
        return sb.toString();
    }
}

