/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.audit;

import com.ibm.keymanager.KMSDebug;
import com.ibm.keymanager.KeyManagerException;
import com.ibm.keymanager.audit.SecurityEventListener;
import com.ibm.keymanager.audit.Security_Event;
import com.ibm.keymanager.config.Config;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;

public class Audit {
    static final String AUDIT_EVENT_TYPES = "Audit.event.types";
    static final String AUDIT_EVENT_OUTCOME = "Audit.event.outcome";
    static final String all_type = "all";
    static final String none_type = "none";
    private KMSDebug debug = KMSDebug.getInstance();
    public static final String authentication_type = "authentication";
    public static final String authorization_type = "authorization";
    public static final String authorization_terminate_type = "authorization_terminate";
    public static final String data_synchronization_type = "data_synchronization";
    public static final String runtime_type = "runtime";
    public static final String audit_management_type = "audit_management";
    public static final String config_management_type = "configuration_management";
    public static final String resource_management_type = "resource_management";
    public static final String success_outcome = "success";
    public static final String failure_outcome = "failure";
    private boolean inited;
    private boolean isClosed;
    private SecurityEventListener listener;
    private ArrayList event_types = new ArrayList();
    private String etypesSt;
    private String outcomeSt;
    private boolean[] outcome_indicator = new boolean[2];
    private boolean[] needUpdate = new boolean[2];
    private static Audit audit;

    public static Audit getInstance() {
        if (audit == null) {
            audit = new Audit();
            Audit.audit.isClosed = false;
            Audit.audit.inited = false;
        }
        return audit;
    }

    private Audit() {
    }

    public void init(Config kmconfig) throws KeyManagerException {
        this.debug.entry("audit", "Audit", "init");
        if (!this.inited || this.isClosed) {
            this.debug.trace("audit", "Audit", "init", "initialize audit");
            String etypes = null;
            try {
                etypes = (String)kmconfig.get(AUDIT_EVENT_TYPES);
            }
            catch (KeyManagerException ex) {
                etypes = null;
            }
            this.etypesSt = etypes;
            this.initEventTypes(etypes);
            String outcome_st = null;
            try {
                outcome_st = (String)kmconfig.get(AUDIT_EVENT_OUTCOME);
            }
            catch (KeyManagerException ex) {
                outcome_st = null;
            }
            this.outcomeSt = outcome_st;
            this.initOutcomeTypes(outcome_st);
            this.listener = SecurityEventListener.getInstance();
            this.listener.init(kmconfig);
            this.inited = true;
            this.isClosed = false;
        }
    }

    private void initOutcomeTypes(String outcomeSt) {
        this.debug.entry("audit", "Audit", "initOutcomeTypes");
        if (outcomeSt == null) {
            this.outcome_indicator[0] = true;
            this.outcome_indicator[1] = true;
        } else {
            String delim = ",";
            if (outcomeSt.indexOf(";") >= 0) {
                delim = ";";
            }
            StringTokenizer st = new StringTokenizer(outcomeSt, delim);
            while (st.hasMoreElements()) {
                String value = st.nextToken().trim();
                if (value.equalsIgnoreCase(success_outcome)) {
                    this.outcome_indicator[0] = true;
                    continue;
                }
                if (!value.equalsIgnoreCase(failure_outcome)) continue;
                this.outcome_indicator[1] = true;
            }
        }
        this.debug.trace("audit", "Audit", "initOutcomeTypes", "audit success?" + this.outcome_indicator[0] + " audit failure?" + this.outcome_indicator[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initEventTypes(String etypes) {
        this.debug.trace("audit", "Audit", "initEventTypes", etypes);
        if (etypes == null) {
            etypes = all_type;
        } else {
            etypes = etypes.toLowerCase();
            String delim = ",";
            if (etypes.indexOf(";") >= 0) {
                delim = ";";
            }
            StringTokenizer st = new StringTokenizer(etypes, delim);
            ArrayList arrayList = this.event_types;
            synchronized (arrayList) {
                this.event_types = new ArrayList();
                while (st.hasMoreElements()) {
                    this.event_types.add(st.nextToken());
                }
            }
        }
        if (this.debug.isOn("audit") && this.event_types != null) {
            Iterator it = this.event_types.iterator();
            String temp = "";
            while (it.hasNext()) {
                String tmp = (String)it.next();
                temp = temp + tmp + ",";
            }
            this.debug.trace("audit", "Audit", "initEventTypes", "event types to be audited=" + temp);
        }
    }

    public void refresh(Config kmconfig) {
        this.debug.entry("audit", "Audit", "refresh");
        if (!this.isClosed && this.inited) {
            String etypes = null;
            try {
                etypes = (String)kmconfig.get(AUDIT_EVENT_TYPES);
                if (etypes != null && !etypes.equalsIgnoreCase(this.etypesSt)) {
                    this.debug.trace("audit", "Audit", "refresh", "refresh event types, new types are " + etypes);
                    this.etypesSt = etypes;
                    this.initEventTypes(etypes);
                }
            }
            catch (KeyManagerException ex) {
                // empty catch block
            }
            String outcome_st = null;
            try {
                outcome_st = (String)kmconfig.get(AUDIT_EVENT_OUTCOME);
                if (outcome_st != null && !outcome_st.equalsIgnoreCase(this.outcomeSt)) {
                    this.debug.trace("audit", "Audit", "refresh", "refresh outcome types, new outcome types are " + outcome_st);
                    this.outcomeSt = outcome_st;
                    this.initOutcomeTypes(outcome_st);
                }
            }
            catch (KeyManagerException ex) {
                // empty catch block
            }
            this.listener.refresh(kmconfig);
        }
    }

    public void shutdown() throws KeyManagerException {
        this.debug.entry("audit", "Audit", "shutdown");
        if (!this.isClosed) {
            this.debug.trace("audit", "Audit", "shutdown", "shut down audit");
            if (this.listener != null) {
                this.listener.shutdown();
            }
            this.listener = null;
            this.isClosed = true;
        }
        audit = null;
    }

    public void record(Security_Event event) throws KeyManagerException {
        if (this.isClosed || !this.inited) {
            throw new KeyManagerException("Can not do record, Audit object state is incorrect");
        }
        this.listener.notifyEvent(event);
    }

    public boolean isOn(String event_type, String outcome) throws KeyManagerException {
        if (!this.isClosed && this.inited) {
            if (event_type != null && outcome != null) {
                return this.checkTypeAndOutcome(event_type, outcome);
            }
            throw new KeyManagerException("Type and outcome must be specify");
        }
        throw new KeyManagerException("Audit is closed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkTypeAndOutcome(String event_type, String outcome) throws KeyManagerException {
        boolean isTypeOn = false;
        ArrayList arrayList = this.event_types;
        synchronized (arrayList) {
            if (this.event_types.size() == 1) {
                if (this.event_types.contains(all_type)) {
                    isTypeOn = true;
                } else if (this.event_types.contains(none_type)) {
                    isTypeOn = false;
                } else if (this.event_types.contains(event_type)) {
                    isTypeOn = true;
                }
            } else if (this.event_types.contains(event_type)) {
                isTypeOn = true;
            }
        }
        if (outcome.equals(success_outcome)) {
            return this.outcome_indicator[0] && isTypeOn;
        }
        if (outcome.equals(failure_outcome)) {
            return this.outcome_indicator[1] && isTypeOn;
        }
        return false;
    }
}

