/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.admin.cli;

import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.jsse2.IBMJSSEProvider2;
import com.ibm.keymanager.KMSDebug;
import com.ibm.keymanager.KeyManagementServer;
import com.ibm.keymanager.KeyManagerException;
import com.ibm.keymanager.ServerParameters;
import com.ibm.keymanager.admin.Admin;
import com.ibm.keymanager.audit.Audit;
import com.ibm.keymanager.audit.AuditOutcomeType;
import com.ibm.keymanager.audit.Authn_Event;
import com.ibm.keymanager.audit.ConfigMgmt_Event;
import com.ibm.keymanager.audit.DataSync_Event;
import com.ibm.keymanager.audit.ResourceInfo;
import com.ibm.keymanager.audit.ResourceMgmt_Event;
import com.ibm.keymanager.audit.Runtime_Event;
import com.ibm.keymanager.audit.Security_Event;
import com.ibm.keymanager.audit.UserInfo;
import com.ibm.keymanager.config.Config;
import com.ibm.keymanager.drivetable.DriveTable;
import com.ibm.keymanager.drivetable.DriveTableEntry;
import com.ibm.keymanager.i18n.PropertyResource;
import com.ibm.keymanager.keystore.KeyStoreLoader;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.Collator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import javax.security.auth.login.LoginException;

public class KMSAdmin {
    private String[] args;
    private KMSDebug debug;
    private Config config;
    private Audit audit;
    private Admin admin;
    private DriveTable driveTable;
    private ServerParameters serverParams;
    private ServerThread thread;
    private KeyStore keyStore;
    private KeyStoreLoader ksLoader;
    private int serverState;
    static final int ADDDRIVE = 0;
    static final int LISTDRIVES = 1;
    static final int LISTCERTS = 2;
    static final int LISTCONFIG = 3;
    static final int MODDRIVE = 4;
    static final int EXPORT = 5;
    static final int SYNC = 6;
    static final int IMPORT = 7;
    static final int REMOVEDRIVE = 8;
    static final int MODCONFIG = 10;
    static final int START = 11;
    static final int STOP = 12;
    static final int LOGOUT = 13;
    static final int HELP = 14;
    static final int EXIT = 15;
    static final int REFRESH = 16;
    static final int STATUS = 17;
    private int command;
    private HashMap argsSet = new HashMap();
    private PropertyResource pr = PropertyResource.getInstance("i18n.admin.cli.");
    private static final Collator collator = Collator.getInstance();

    public KMSAdmin(String[] args) throws KeyManagerException {
        this.args = args;
        this.init();
    }

    private void init() throws KeyManagerException {
        this.config = Config.getInstance("com.ibm.keymanager.config.ConfigImpl");
        this.debug = KMSDebug.getInstance();
        if (this.args.length != 0) {
            try {
                this.config.init(this.args[0]);
            }
            catch (Exception e) {
                System.out.println(this.pr.getString("notStart") + " :" + e.getMessage());
                throw new KeyManagerException(e.getMessage());
            }
        } else {
            this.config.init();
        }
        this.debug.init(this.config);
        this.audit = Audit.getInstance();
        this.audit.init(this.config);
        this.driveTable = DriveTable.getInstance(this.config, this.audit, null);
        this.admin = new Admin(this.config, this.debug, this.audit, this.driveTable);
        this.ksLoader = KeyStoreLoader.getInstance(this.config, this.debug);
    }

    private void login() {
        String username = null;
        char[] password = null;
        BufferedReader br = null;
        boolean login = false;
        int count = 0;
        PasswordMask mask = new PasswordMask();
        mask.start();
        while (true) {
            if (username == null || username.length() == 0) {
                System.out.print(this.pr.getString("login"));
                br = new BufferedReader(new InputStreamReader(System.in));
                try {
                    username = br.readLine();
                }
                catch (IOException ex) {}
                continue;
            }
            mask.setMask(true);
            System.out.print(this.pr.getString("password"));
            br = new BufferedReader(new InputStreamReader(System.in));
            try {
                password = br.readLine().toCharArray();
            }
            catch (IOException ex) {
                // empty catch block
            }
            try {
                login = this.admin.login(username, password);
                try {
                    if (this.audit.isOn("authentication", "success")) {
                        Authn_Event event = new Authn_Event((Object)this, "TokenUserName", username, true);
                        this.audit.record(event);
                    }
                }
                catch (KeyManagerException ex) {
                    this.debug.trace("admin", "KMSAdmin", "login", ex);
                }
            }
            catch (LoginException ex) {
                login = false;
                this.debug.trace("admin", "KMSAdmin", "login", ex);
                try {
                    if (this.audit.isOn("authentication", "failure")) {
                        Authn_Event event = new Authn_Event((Object)this, "TokenUserName", username, false);
                        String msg = ex.getMessage();
                        if (msg != null) {
                            event.setAuditMsg(msg);
                        }
                        this.audit.record(event);
                    }
                }
                catch (KeyManagerException ex2) {
                    this.debug.trace("admin", "KMSAdmin", "login", ex2);
                }
            }
            if (!login) {
                System.out.println(this.pr.getString("loginIncorrect"));
                mask.setMask(false);
                username = null;
            } else {
                mask.setDone(true);
            }
            if (login || ++count >= 3) break;
        }
        if (!login) {
            System.out.println(this.pr.getString("bye"));
            System.exit(0);
        }
    }

    public void run() {
        try {
            try {
                if (this.audit.isOn("runtime", "success")) {
                    Runtime_Event event = new Runtime_Event((Object)this, "runKMSAdmin", new UserInfo("KMSAdmin"), new ResourceInfo("KMSAdmin", "application"), new AuditOutcomeType(true));
                    this.audit.record(event);
                }
            }
            catch (KeyManagerException ex) {
                this.debug.trace("admin", "KMSAdmin", "run", ex);
            }
            Object username = null;
            Object password = null;
            BufferedReader br = null;
            boolean login = false;
            boolean count = false;
            String loginModule = null;
            try {
                loginModule = (String)this.config.get("Admin.loginModule");
            }
            catch (KeyManagerException ex) {
                // empty catch block
            }
            if (loginModule != null) {
                this.login();
                System.out.println(this.pr.getString("grantAccess"));
            }
            block30: while (true) {
                System.out.print("# ");
                this.command = -1;
                br = new BufferedReader(new InputStreamReader(System.in));
                String input = br.readLine();
                this.parse(input);
                if (this.admin == null) {
                    System.out.println(this.pr.getString("waitserver"));
                    continue;
                }
                switch (this.command) {
                    case 0: {
                        this.processAddDrive();
                        continue block30;
                    }
                    case 1: {
                        this.processListDrives();
                        continue block30;
                    }
                    case 2: {
                        this.processListCerts();
                        continue block30;
                    }
                    case 3: {
                        this.processListConfig();
                        continue block30;
                    }
                    case 4: {
                        this.processModDrive();
                        continue block30;
                    }
                    case 5: {
                        this.processExport();
                        continue block30;
                    }
                    case 6: {
                        this.processSync();
                        continue block30;
                    }
                    case 7: {
                        this.processImport();
                        continue block30;
                    }
                    case 8: {
                        this.processDelDrive();
                        continue block30;
                    }
                    case 10: {
                        this.processModConfig();
                        continue block30;
                    }
                    case 11: {
                        this.processStartKMS();
                        continue block30;
                    }
                    case 12: {
                        this.processStopKMS();
                        continue block30;
                    }
                    case 13: {
                        count = false;
                        this.admin.logout();
                        if (loginModule == null) continue block30;
                        this.login();
                        continue block30;
                    }
                    case 14: {
                        this.displayHelp();
                        continue block30;
                    }
                    case 15: {
                        if (this.serverState == 1) {
                            this.processStopKMS();
                        }
                        this.admin.logout();
                        this.admin.shutdown();
                        if (this.debug != null) {
                            this.debug.shutdown();
                        }
                        try {
                            if (this.audit.isOn("runtime", "success")) {
                                Runtime_Event event = new Runtime_Event((Object)this, "exitKMSAdmin", new UserInfo("KMSAdmin"), new ResourceInfo("KMSAdmin", "application"), new AuditOutcomeType(true));
                                this.audit.record(event);
                            }
                        }
                        catch (KeyManagerException ex) {
                            this.debug.trace("admin", "KMSAdmin", "run", ex);
                        }
                        if (this.audit != null) {
                            this.audit.shutdown();
                        }
                        System.exit(0);
                        continue block30;
                    }
                    case 16: {
                        this.admin.refresh();
                        continue block30;
                    }
                    case 17: {
                        if (this.serverState == 1) {
                            String tcpport = (String)this.config.get("TransportListener.tcp.port");
                            String sslport = (String)this.config.get("TransportListener.ssl.port");
                            System.out.println(this.pr.getString("serverrun") + " " + this.pr.getString("tcpport") + " " + tcpport.trim() + ", " + this.pr.getString("sslport") + " " + sslport);
                            continue block30;
                        }
                        if (this.serverState == 0) {
                            System.out.println(this.pr.getString("servernostart"));
                            continue block30;
                        }
                        if (this.serverState != -1) continue block30;
                        System.out.println(this.pr.getString("serverfail"));
                        continue block30;
                    }
                    case -1: {
                        continue block30;
                    }
                }
                this.invalidInput();
            }
        }
        catch (Exception ex) {
            try {
                if (this.audit.isOn("runtime", "failure")) {
                    Runtime_Event event = new Runtime_Event((Object)this, "runKMSAdmin", new UserInfo("KMSAdmin"), new ResourceInfo("KMSAdmin", "application"), new AuditOutcomeType(false));
                    this.audit.record(event);
                }
            }
            catch (KeyManagerException ex2) {
                this.debug.trace("admin", "KMSAdmin", "run", ex2);
            }
            String msg = ex.getLocalizedMessage();
            if (msg != null) {
                System.out.println(ex.getLocalizedMessage());
            }
            System.exit(-1);
            return;
        }
    }

    private void processModConfig() {
        String msg;
        ConfigMgmt_Event event;
        boolean isSet = false;
        String property = null;
        String value = null;
        Set set = this.argsSet.keySet();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (collator.compare(key, "-set") == 0) {
                isSet = true;
                continue;
            }
            if (collator.compare(key, "-unset") == 0) {
                isSet = false;
                continue;
            }
            if (collator.compare(key, "-property") == 0) {
                property = (String)this.argsSet.get(key);
                continue;
            }
            if (collator.compare(key, "-value") != 0) continue;
            value = (String)this.argsSet.get(key);
        }
        if (isSet) {
            if (property != null) {
                if (value == null) {
                    this.invalidInput();
                    return;
                }
                try {
                    this.admin.setConfigProperty(property, value);
                    try {
                        if (this.audit.isOn("configuration_management", "success")) {
                            event = new ConfigMgmt_Event((Object)this, "modify", new UserInfo("KMSAdmin"), new AuditOutcomeType(true));
                            event.setAuditMsg("set property " + property + "=" + value);
                            this.audit.record(event);
                        }
                    }
                    catch (KeyManagerException ex) {
                        this.debug.trace("admin", "KMSAdmin", "processModConfig", ex);
                    }
                }
                catch (KeyManagerException ex) {
                    this.debug.trace("admin", "KMSAdmin", "processModConfig", ex);
                    msg = ex.getLocalizedMessage();
                    if (msg != null) {
                        System.out.println(this.pr.getString("failmodconfig") + " " + msg);
                    } else {
                        System.out.println(this.pr.getString("failmodconfig"));
                    }
                    try {
                        if (this.audit.isOn("configuration_management", "failure")) {
                            ConfigMgmt_Event event2 = new ConfigMgmt_Event((Object)this, "modify", new UserInfo("KMSAdmin"), new AuditOutcomeType(false));
                            event2.setAuditMsg("set property " + property + "=" + value);
                            if (msg != null) {
                                event2.setAuditMsg(msg);
                            }
                            this.audit.record(event2);
                        }
                    }
                    catch (KeyManagerException ex2) {
                        this.debug.trace("admin", "KMSAdmin", "processModConfig", ex2);
                    }
                }
            } else {
                this.invalidInput();
            }
        } else if (property != null) {
            try {
                this.admin.deleteConfigProperty(property);
                try {
                    if (this.audit.isOn("configuration_management", "success")) {
                        event = new ConfigMgmt_Event((Object)this, "delete", new UserInfo("KMSAdmin"), new AuditOutcomeType(true));
                        event.setAuditMsg("delete property " + property);
                        this.audit.record(event);
                    }
                }
                catch (KeyManagerException ex2) {
                    this.debug.trace("admin", "KMSAdmin", "processModConfig", ex2);
                }
            }
            catch (KeyManagerException ex) {
                this.debug.trace("admin", "KMSAdmin", "processModConfig", ex);
                msg = ex.getLocalizedMessage();
                if (msg != null) {
                    System.out.println(this.pr.getString("faildelconfig") + " " + msg);
                } else {
                    System.out.println(this.pr.getString("faildelconfig"));
                }
                try {
                    if (this.audit.isOn("configuration_management", "failure")) {
                        ConfigMgmt_Event event3 = new ConfigMgmt_Event((Object)this, "delete", new UserInfo("KMSAdmin"), new AuditOutcomeType(false));
                        event3.setAuditMsg("delete property " + property);
                        this.audit.record(event3);
                    }
                }
                catch (KeyManagerException ex2) {
                    this.debug.trace("admin", "KMSAdmin", "processModConfig", ex2);
                }
            }
        } else {
            this.invalidInput();
        }
    }

    private void processDelDrive() {
        String drivename = null;
        Set set = this.argsSet.keySet();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (collator.compare(key, "-drivename") != 0) continue;
            drivename = (String)this.argsSet.get(key);
        }
        if (drivename == null) {
            this.invalidInput();
        } else {
            try {
                this.admin.removeDrive(drivename);
                try {
                    if (this.audit.isOn("resource_management", "success")) {
                        ResourceMgmt_Event event = new ResourceMgmt_Event((Object)this, "delete", drivename, "KMSAdmin", true);
                        this.audit.record(event);
                    }
                }
                catch (KeyManagerException ex) {
                    this.debug.trace("admin", "KMSAdmin", "processDelDrive", ex);
                }
            }
            catch (KeyManagerException ex) {
                String msg = ex.getLocalizedMessage();
                if (msg != null) {
                    System.out.println(this.pr.getString("faildeldrive") + " " + msg);
                } else {
                    System.out.println(this.pr.getString("faildeldrive"));
                }
                this.debug.trace("admin", "KMSAdmin", "processDelDrive", ex);
                try {
                    if (this.audit.isOn("resource_management", "failure")) {
                        ResourceMgmt_Event event = new ResourceMgmt_Event((Object)this, "delete", drivename, "KMSAdmin", false);
                        if (msg != null) {
                            event.setAuditMsg(msg);
                        }
                        this.audit.record(event);
                    }
                }
                catch (KeyManagerException ex2) {
                    this.debug.trace("admin", "KMSAdmin", "processDelDrive", ex2);
                }
            }
        }
    }

    private void processSync() {
        int type = 0;
        String ipaddr = null;
        int action = 11;
        String actionSt = null;
        String typeSt = null;
        Set set = this.argsSet.keySet();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (collator.compare(key, "-all") == 0) {
                type = 0xF0F0FFE & 0xF0F0FFD;
                typeSt = "config and drive table";
                continue;
            }
            if (collator.compare(key, "-config") == 0) {
                type = 0xF0F0FFE;
                typeSt = "config";
                continue;
            }
            if (collator.compare(key, "-drivetab") == 0) {
                type = 0xF0F0FFD;
                typeSt = "drive table";
                continue;
            }
            if (collator.compare(key, "-ipaddr") == 0) {
                ipaddr = (String)this.argsSet.get(key);
                continue;
            }
            if (collator.compare(key, "-merge") == 0) {
                action = 11;
                actionSt = "merge";
                continue;
            }
            if (collator.compare(key, "-rewrite") != 0) continue;
            action = 10;
            actionSt = "rewrite";
        }
        if (ipaddr == null || type == 0) {
            this.invalidInput();
        } else {
            try {
                System.out.println(this.pr.getString("contactserver") + " " + ipaddr);
                this.admin.sync(ipaddr, type, action);
                System.out.println(this.pr.getString("synccomplete"));
                try {
                    if (this.audit.isOn("data_synchronization", "success")) {
                        DataSync_Event event = new DataSync_Event(this, actionSt, new ResourceInfo(typeSt), new UserInfo("KMSAdmin"), new AuditOutcomeType(true));
                        this.audit.record(event);
                    }
                }
                catch (KeyManagerException ex) {
                    this.debug.trace("admin", "KMSAdmin", "processSync", ex);
                }
            }
            catch (Exception ex) {
                String msg = ex.getLocalizedMessage();
                if (msg != null) {
                    System.out.println(this.pr.getString("syncfail") + " " + msg);
                } else {
                    System.out.println(this.pr.getString("syncfail"));
                }
                try {
                    if (this.audit.isOn("data_synchronization", "failure")) {
                        DataSync_Event event = new DataSync_Event(this, actionSt, new ResourceInfo(typeSt), new UserInfo("KMSAdmin"), new AuditOutcomeType(false));
                        if (msg != null) {
                            event.setAuditMsg(msg);
                        }
                        this.audit.record(event);
                    }
                }
                catch (KeyManagerException ex2) {
                    this.debug.trace("admin", "KMSAdmin", "processSync", ex2);
                }
            }
        }
    }

    private void processStopKMS() {
        if (this.serverState != 1) {
            System.out.println(this.pr.getString("notStart"));
            return;
        }
        System.out.println(this.pr.getString("stop"));
        this.debug.trace("admin", "KMSAdmin", "processStopKMS", "shut down the server");
        try {
            this.serverParams.shutdownAll();
        }
        catch (KeyManagerException ex) {
            String msg = ex.getLocalizedMessage();
            if (msg != null) {
                System.out.println(this.pr.getString("errorshutserver") + " " + msg);
            } else {
                System.out.println(this.pr.getString("errorshutserver"));
            }
            return;
        }
        if (this.thread != null && this.thread.isAlive()) {
            try {
                this.debug.trace("admin", "KMSAdmin", "processStopKMS", "interrupt the thread");
                this.thread.interrupt();
            }
            catch (SecurityException ex) {
                this.debug.trace("admin", "KMSAdmin", "processStopKMS", ex);
            }
        }
        this.thread = null;
        this.serverParams = null;
        this.ksLoader.removeAll();
        try {
            this.init();
            try {
                if (this.audit.isOn("runtime", "success")) {
                    Runtime_Event event = new Runtime_Event((Object)this, "stop", new UserInfo("KMSAdmin"), new ResourceInfo("KMS server", "application"), new AuditOutcomeType(true));
                    this.audit.record(event);
                }
            }
            catch (KeyManagerException ex) {
                this.debug.trace("admin", "KMSAdmin", "processStopKMS", ex);
            }
        }
        catch (KeyManagerException ex) {
            if (this.debug != null) {
                this.debug.trace("admin", "KMSAdmin", "processStopKMS", ex);
            }
            System.exit(1);
        }
        this.serverState = 0;
    }

    private void processStartKMS() {
        if (this.serverState == 1) {
            System.out.println(this.pr.getString("running"));
        } else {
            Set keyset = this.argsSet.keySet();
            String password = null;
            Iterator it = keyset.iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                if (collator.compare(key, "-password") != 0) continue;
                password = (String)this.argsSet.get(key);
            }
            if (this.keyStore != null) {
                this.keyStore = null;
            }
            if (password == null) {
                try {
                    password = (String)this.config.get("config.keystore.password");
                }
                catch (KeyManagerException ex) {
                    // empty catch block
                }
                while (password == null || password.length() == 0) {
                    password = this.promptPassword();
                }
            }
            try {
                this.keyStore = this.ksLoader.loadKeyStore("TapeKS", password.toCharArray());
                System.out.println(this.pr.getString("loadks"));
            }
            catch (Exception ex) {
                this.debug.trace("admin", "KMSAdmin", "processStartKMS", ex);
                String mesg = ex.getLocalizedMessage();
                if (mesg != null) {
                    System.out.println(this.pr.getString("failstart") + " " + mesg);
                } else {
                    System.out.println(this.pr.getString("failstart"));
                }
                this.serverState = -1;
                try {
                    if (this.audit.isOn("runtime", "failure")) {
                        Runtime_Event event = new Runtime_Event((Object)this, "start", new UserInfo("KMSAdmin"), new ResourceInfo("KMS server", "application"), new AuditOutcomeType(false));
                        String msg = ex.getMessage();
                        if (msg != null) {
                            event.setAuditMsg(msg);
                        }
                        this.audit.record(event);
                    }
                }
                catch (KeyManagerException ex2) {
                    this.debug.trace("admin", "KMSAdmin", "processStartKMS", ex2);
                }
                return;
            }
            String ks = null;
            String adminKS = null;
            try {
                ks = (String)this.config.get("config.keystore.file");
                adminKS = (String)this.config.get("Admin.ssl.keystore.name");
                if (adminKS == null) {
                    adminKS = (String)this.config.get("ssl.keystore.name");
                }
            }
            catch (KeyManagerException ex) {
                // empty catch block
            }
            if (adminKS == null) {
                System.out.println(this.pr.getString("unableloadks"));
                return;
            }
            String adminKSPwd = null;
            String admin_ks_type = null;
            String admin_ts_type = null;
            String trans_ks_type = null;
            String trans_ts_type = null;
            try {
                admin_ks_type = (String)this.config.get("Admin.ssl.keystore.type");
                admin_ts_type = (String)this.config.get("Admin.ssl.truststore.type");
                trans_ks_type = (String)this.config.get("TransportListener.ssl.keystore.type");
                trans_ts_type = (String)this.config.get("TransportListener.ssl.truststore.type");
            }
            catch (KeyManagerException ex) {
                // empty catch block
            }
            try {
                this.checkKSTSMatch(admin_ks_type, admin_ts_type, trans_ks_type, trans_ts_type);
            }
            catch (KeyManagerException ex) {
                System.out.println(ex.getLocalizedMessage());
                this.ksLoader.removeAll();
                this.serverState = -1;
                try {
                    if (this.audit.isOn("runtime", "failure")) {
                        Runtime_Event event = new Runtime_Event((Object)this, "start", new UserInfo("KMSAdmin"), new ResourceInfo("KMS server", "application"), new AuditOutcomeType(false));
                        String msg = ex.getMessage();
                        if (msg != null) {
                            event.setAuditMsg(msg);
                        }
                        this.audit.record(event);
                    }
                }
                catch (KeyManagerException ex2) {
                    this.debug.trace("admin", "KMSAdmin", "processStartKMS", ex2);
                }
                return;
            }
            try {
                if (!adminKS.equals(ks)) {
                    System.out.println(this.pr.getString("loadadminks"));
                    adminKSPwd = this.initProp("Admin.ssl.keystore.password");
                    if (adminKSPwd == null) {
                        adminKSPwd = this.promptPassword();
                    }
                    this.ksLoader.loadKeyManagers("AdminKS", adminKSPwd.toCharArray());
                } else {
                    if (admin_ks_type != null && admin_ks_type.equalsIgnoreCase("PKCS11IMPLKS")) {
                        throw new KeyManagerException(this.pr.getString("hwcryptomsg1"));
                    }
                    this.ksLoader.loadKeyManagers("AdminKS", password.toCharArray());
                }
            }
            catch (KeyManagerException ex) {
                this.ksLoader.removeAll();
                this.serverState = -1;
                System.out.println(ex.getLocalizedMessage());
                this.debug.trace("admin", "KMSAdmin", "processStartKMS", ex);
                try {
                    if (this.audit.isOn("runtime", "failure")) {
                        Runtime_Event event = new Runtime_Event((Object)this, "start", new UserInfo("KMSAdmin"), new ResourceInfo("KMS server", "application"), new AuditOutcomeType(false));
                        String msg = ex.getMessage();
                        if (msg != null) {
                            event.setAuditMsg(msg);
                        }
                        this.audit.record(event);
                    }
                }
                catch (KeyManagerException ex2) {
                    this.debug.trace("admin", "KMSAdmin", "processStartKMS", ex2);
                }
                return;
            }
            String transportKS = null;
            try {
                transportKS = (String)this.config.get("TransportListener.ssl.keystore.name");
                if (transportKS == null) {
                    transportKS = (String)this.config.get("ssl.keystore.name");
                }
            }
            catch (KeyManagerException ex) {
                // empty catch block
            }
            if (transportKS == null) {
                System.out.println(this.pr.getString("unloadtransks"));
                this.ksLoader.removeAll();
                this.serverState = -1;
                try {
                    if (this.audit.isOn("runtime", "failure")) {
                        Runtime_Event event = new Runtime_Event((Object)this, "start", new UserInfo("KMSAdmin"), new ResourceInfo("KMS server", "application"), new AuditOutcomeType(false));
                        this.audit.record(event);
                    }
                }
                catch (KeyManagerException ex2) {
                    this.debug.trace("admin", "KMSAdmin", "processStartKMS", ex2);
                }
                return;
            }
            try {
                if (transportKS.equals(ks)) {
                    if (trans_ks_type != null && trans_ks_type.equalsIgnoreCase("PKCS11IMPLKS")) {
                        throw new KeyManagerException(this.pr.getString("hwcryptomsg1"));
                    }
                    this.ksLoader.loadKeyManagers("ListKS", password.toCharArray());
                } else if (transportKS.equals(adminKS)) {
                    this.ksLoader.loadKeyManagers("ListKS", adminKSPwd.toCharArray());
                } else {
                    System.out.println(this.pr.getString("loadtransks"));
                    String tpPwd = this.initProp("TransportListener.ssl.keystore.password");
                    if (tpPwd == null) {
                        tpPwd = this.promptPassword();
                    }
                    this.ksLoader.loadKeyManagers("ListKS", tpPwd.toCharArray());
                    tpPwd = null;
                }
                adminKSPwd = null;
            }
            catch (KeyManagerException ex) {
                this.ksLoader.removeAll();
                this.serverState = -1;
                adminKSPwd = null;
                System.out.println(ex.getLocalizedMessage());
                this.debug.trace("admin", "KMSAdmin", "processStartKMS", ex);
                try {
                    if (this.audit.isOn("runtime", "failure")) {
                        Runtime_Event event = new Runtime_Event((Object)this, "start", new UserInfo("KMSAdmin"), new ResourceInfo("KMS server", "application"), new AuditOutcomeType(false));
                        String msg = ex.getMessage();
                        if (msg != null) {
                            event.setAuditMsg(msg);
                        }
                        this.audit.record(event);
                    }
                }
                catch (KeyManagerException ex2) {
                    this.debug.trace("admin", "KMSAdmin", "processStartKMS", ex2);
                }
                return;
            }
            this.startKMS(password);
        }
    }

    private String initProp(String key) {
        String value = null;
        try {
            value = (String)this.config.get(key);
        }
        catch (KeyManagerException ex) {
            // empty catch block
        }
        if (value == null) {
            try {
                value = (String)this.config.get(key.substring(key.indexOf(".") + 1));
            }
            catch (KeyManagerException keyManagerException) {
                // empty catch block
            }
        }
        return value;
    }

    private void checkKSTSMatch(String admin_ks_type, String admin_ts_type, String trans_ks_type, String trans_ts_type) throws KeyManagerException {
        if (admin_ks_type != null && admin_ks_type.equalsIgnoreCase("PKCS11IMPLKS") || admin_ts_type != null && admin_ts_type.equalsIgnoreCase("PKCS11IMPLKS")) {
            if (trans_ks_type != null && trans_ks_type.equalsIgnoreCase("PKCS11IMPLKS")) {
                throw new KeyManagerException(this.pr.getString("hwcryptomsg2"));
            }
            if (trans_ts_type != null && trans_ts_type.equalsIgnoreCase("PKCS11IMPLKS")) {
                throw new KeyManagerException(this.pr.getString("hwcryptomsg2"));
            }
        }
        if (trans_ks_type != null && trans_ks_type.equalsIgnoreCase("PKCS11IMPLKS") || trans_ts_type != null && trans_ts_type.equalsIgnoreCase("PKCS11IMPLKS")) {
            if (admin_ks_type != null && admin_ks_type.equalsIgnoreCase("PKCS11IMPLKS")) {
                throw new KeyManagerException(this.pr.getString("hwcryptomsg2"));
            }
            if (admin_ts_type != null && admin_ts_type.equalsIgnoreCase("PKCS11IMPLKS")) {
                throw new KeyManagerException(this.pr.getString("hwcryptomsg2"));
            }
        }
    }

    private void startKMS(String password) {
        try {
            String[] serverArgs = new String[4];
            serverArgs[0] = "-F";
            serverArgs[1] = this.args[0];
            this.debug.trace("admin", "KMSAdmin", "processStartKMS", "config file=" + serverArgs[1]);
            serverArgs[2] = "-P";
            serverArgs[3] = password;
            this.config.write(serverArgs[1]);
            this.thread = new ServerThread(serverArgs);
            this.thread.run();
        }
        catch (Exception ex) {
            this.debug.trace("admin", "KMSAdmin", "processStartKMS", ex);
            this.ksLoader.removeAll();
            this.serverState = -1;
            try {
                this.init();
            }
            catch (KeyManagerException ex2) {
                this.debug.trace("admin", "KMSAdmin", "processStartKMS", ex2);
                System.exit(1);
            }
            try {
                if (this.audit.isOn("runtime", "failure")) {
                    Runtime_Event event = new Runtime_Event((Object)this, "start", new UserInfo("KMSAdmin"), new ResourceInfo("KMS server", "application"), new AuditOutcomeType(false));
                    String msg = ex.getMessage();
                    if (msg != null) {
                        event.setAuditMsg(msg);
                    }
                    this.audit.record(event);
                }
            }
            catch (KeyManagerException ex2) {
                this.debug.trace("admin", "KMSAdmin", "processStartKMS", ex2);
            }
        }
    }

    private void processImport() {
        Set keyset = this.argsSet.keySet();
        String fileName = null;
        int type = -1;
        String typeSt = null;
        int action = -1;
        String actionSt = null;
        Iterator it = keyset.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (collator.compare(key, "-url") == 0) {
                fileName = (String)this.argsSet.get(key);
                continue;
            }
            if (collator.compare(key, "-drivetab") == 0) {
                type = 0xF0F0FFD;
                typeSt = "drive table";
                continue;
            }
            if (collator.compare(key, "-config") == 0) {
                type = 0xF0F0FFE;
                typeSt = "config";
                continue;
            }
            if (collator.compare(key, "-rewrite") == 0) {
                action = 10;
                actionSt = "rewrite";
                continue;
            }
            if (collator.compare(key, "-merge") != 0) continue;
            action = 11;
            actionSt = "merge";
        }
        if (fileName == null || type == -1 || action == -1) {
            this.invalidInput();
            return;
        }
        try {
            this.admin.loadFrom(type, action, fileName);
            try {
                Security_Event event;
                if (type == 0xF0F0FFD) {
                    if (this.audit.isOn("resource_management", "success")) {
                        event = new ResourceMgmt_Event((Object)this, actionSt, typeSt, "KMSAdmin", true);
                        ((ResourceMgmt_Event)event).setAuditMsg("import from " + fileName);
                        this.audit.record(event);
                    }
                } else if (type == 0xF0F0FFE && this.audit.isOn("configuration_management", "success")) {
                    event = new ConfigMgmt_Event(this, actionSt, typeSt, new UserInfo("KMSAdmin"), new AuditOutcomeType(true));
                    ((ConfigMgmt_Event)event).setAuditMsg("import from " + fileName);
                    this.audit.record(event);
                }
            }
            catch (KeyManagerException ex) {
                this.debug.trace("admin", "KMSAdmin", "processImport", ex);
            }
        }
        catch (KeyManagerException ex) {
            this.debug.trace("admin", "KMSAdmin", "processImport", ex);
            String msg = ex.getLocalizedMessage();
            if (msg != null) {
                System.out.println(this.pr.getString("failimport") + " " + msg);
            } else {
                System.out.println(this.pr.getString("failimport"));
            }
            try {
                if (type == 0xF0F0FFD) {
                    if (this.audit.isOn("resource_management", "failure")) {
                        ResourceMgmt_Event event = new ResourceMgmt_Event((Object)this, actionSt, typeSt, "KMSAdmin", false);
                        event.setAuditMsg("import from " + fileName);
                        this.audit.record(event);
                    }
                } else if (type == 0xF0F0FFE && this.audit.isOn("configuration_management", "failure")) {
                    ConfigMgmt_Event event = new ConfigMgmt_Event(this, actionSt, typeSt, new UserInfo("KMSAdmin"), new AuditOutcomeType(false));
                    event.setAuditMsg("import from " + fileName);
                    this.audit.record(event);
                }
            }
            catch (KeyManagerException ex2) {
                this.debug.trace("admin", "KMSAdmin", "processImport", ex2);
            }
        }
    }

    private void processExport() {
        Set keyset = this.argsSet.keySet();
        String fileName = null;
        int type = -1;
        Iterator it = keyset.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (collator.compare(key, "-url") == 0) {
                fileName = (String)this.argsSet.get(key);
                continue;
            }
            if (collator.compare(key, "-drivetab") == 0) {
                type = 0xF0F0FFD;
                continue;
            }
            if (collator.compare(key, "-config") != 0) continue;
            type = 0xF0F0FFE;
        }
        if (fileName == null || type == -1) {
            this.invalidInput();
            return;
        }
        try {
            this.admin.unloadTo(type, fileName);
            try {
                Security_Event event;
                if (type == 0xF0F0FFD) {
                    if (this.audit.isOn("resource_management", "success")) {
                        event = new ResourceMgmt_Event((Object)this, "export", "drive table", "KMSAdmin", true);
                        ((ResourceMgmt_Event)event).setAuditMsg("export to " + fileName);
                        this.audit.record(event);
                    }
                } else if (type == 0xF0F0FFE && this.audit.isOn("configuration_management", "success")) {
                    event = new ConfigMgmt_Event(this, "export", "config", new UserInfo("KMSAdmin"), new AuditOutcomeType(true));
                    ((ConfigMgmt_Event)event).setAuditMsg("export to " + fileName);
                    this.audit.record(event);
                }
            }
            catch (KeyManagerException ex) {
                this.debug.trace("admin", "KMSAdmin", "processExport", ex);
            }
        }
        catch (KeyManagerException ex) {
            this.debug.trace("admin", "KMSAdmin", "processExport", ex);
            String msg = ex.getLocalizedMessage();
            if (msg != null) {
                System.out.println(this.pr.getString("failexp") + " " + msg);
            } else {
                System.out.println(this.pr.getString("failexp"));
            }
            try {
                if (type == 0xF0F0FFD) {
                    if (this.audit.isOn("resource_management", "failure")) {
                        ResourceMgmt_Event event = new ResourceMgmt_Event((Object)this, "export", "drive table", "KMSAdmin", false);
                        event.setAuditMsg("export to " + fileName);
                        this.audit.record(event);
                    }
                } else if (type == 0xF0F0FFE && this.audit.isOn("configuration_management", "failure")) {
                    ConfigMgmt_Event event = new ConfigMgmt_Event(this, "export", "config", new UserInfo("KMSAdmin"), new AuditOutcomeType(false));
                    event.setAuditMsg("export to " + fileName);
                    this.audit.record(event);
                }
            }
            catch (KeyManagerException ex2) {
                this.debug.trace("admin", "KMSAdmin", "processExport", ex2);
            }
        }
    }

    private void processListConfig() {
        Map map = this.admin.listConfig();
        Set keyset = map.keySet();
        StringBuffer sb = new StringBuffer();
        Iterator it = keyset.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Object value = map.get(key);
            sb.append(key + "=" + value + "\n");
        }
        try {
            if (this.audit.isOn("resource_management", "success")) {
                ConfigMgmt_Event event = new ConfigMgmt_Event((Object)this, "show", "KMSAdmin", true);
                this.audit.record(event);
            }
        }
        catch (KeyManagerException ex) {
            this.debug.trace("admin", "KMSAdmin", "processListConfig", ex);
        }
        System.out.println(sb.toString());
    }

    private void processListCerts() {
        ResourceMgmt_Event event;
        Set keyset = this.argsSet.keySet();
        String alias = null;
        boolean verbose = false;
        Iterator it = keyset.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (collator.compare(key, "-alias") == 0) {
                alias = (String)this.argsSet.get(key);
                continue;
            }
            if (collator.compare(key, "-verbose") != 0 && collator.compare(key, "-v") != 0) continue;
            verbose = true;
        }
        if (alias != null) {
            this.listCert(alias, verbose, true);
            try {
                if (this.audit.isOn("resource_management", "success")) {
                    event = new ResourceMgmt_Event((Object)this, "retrieve", "cert with alias" + alias, "KMSAdmin", true);
                    this.audit.record(event);
                }
            }
            catch (KeyManagerException ex) {
                this.debug.trace("admin", "KMSAdmin", "processListCerts", ex);
            }
        } else {
            this.listCerts(verbose);
            try {
                if (this.audit.isOn("resource_management", "success")) {
                    event = new ResourceMgmt_Event((Object)this, "retrieve", "certs in key store", "KMSAdmin", true);
                    this.audit.record(event);
                }
            }
            catch (KeyManagerException ex) {
                this.debug.trace("admin", "KMSAdmin", "processListCerts", ex);
            }
        }
    }

    private void listCerts(boolean verbose) {
        if (this.keyStore == null) {
            try {
                this.keyStore = this.loadKeyStore(null);
            }
            catch (Exception ex) {
                this.debug.trace("admin", "KMSAdmin", "listCerts", ex);
            }
        }
        if (this.keyStore == null) {
            System.out.println(this.pr.getString("notLoadKS"));
        } else {
            Enumeration<String> enumeration = null;
            try {
                enumeration = this.keyStore.aliases();
            }
            catch (KeyStoreException ex) {
                this.debug.trace("admin", "KMSAdmin", "listCerts", ex);
                return;
            }
            int size = 0;
            try {
                size = this.keyStore.size();
            }
            catch (KeyStoreException ex) {
                this.debug.trace("admin", "KMSAdmin", "listCerts", ex);
                return;
            }
            System.out.println(this.pr.getString("entriesKS") + size);
            int count = 1;
            while (enumeration.hasMoreElements()) {
                String alias = enumeration.nextElement();
                if (count == 1) {
                    this.listCert(alias, verbose, true);
                    count = 2;
                    continue;
                }
                this.listCert(alias, verbose, false);
            }
        }
    }

    private void listCert(String alias, boolean verbose, boolean first) {
        block19: {
            if (this.keyStore == null) {
                try {
                    this.keyStore = this.loadKeyStore(null);
                }
                catch (Exception ex) {
                    this.debug.trace("admin", "KMSAdmin", "listCert", ex);
                    this.keyStore = null;
                }
            }
            if (this.keyStore == null) {
                System.out.println(this.pr.getString("notLoadKS"));
            } else {
                X509Certificate cert = null;
                if (first) {
                    System.out.println(this.pr.getString("typeKS") + this.keyStore.getType());
                    System.out.println(this.pr.getString("providerKS") + this.keyStore.getProvider().getName());
                }
                try {
                    if (this.keyStore.containsAlias(alias)) {
                        if (this.keyStore.isCertificateEntry(alias) || this.keyStore.isKeyEntry(alias) && !verbose) {
                            try {
                                cert = (X509Certificate)this.keyStore.getCertificate(alias);
                            }
                            catch (KeyStoreException ex) {
                                this.debug.trace("admin", "KMSAdmin", "listCert", ex);
                            }
                            if (cert != null) {
                                System.out.println(this.aCertToString(this.keyStore, alias, cert, verbose));
                            } else {
                                this.debug.trace("admin", "KMSAdmin", "listCert", "not cert entry with alias " + alias);
                            }
                            break block19;
                        }
                        if (!this.keyStore.isKeyEntry(alias) || !verbose) break block19;
                        Certificate[] certs = null;
                        try {
                            certs = this.keyStore.getCertificateChain(alias);
                        }
                        catch (KeyStoreException ex) {
                            this.debug.trace("admin", "KMSAdmin", "listCert", ex);
                        }
                        if (certs != null) {
                            System.out.println(this.aCertToString(this.keyStore, alias, (X509Certificate)certs[0], verbose));
                            StringBuffer sb = new StringBuffer();
                            for (int i = 1; i < certs.length; ++i) {
                                String owner = ((X509Certificate)certs[i]).getSubjectX500Principal().getName();
                                String issuer = ((X509Certificate)certs[i]).getIssuerX500Principal().getName();
                                byte[] sig = ((X509Certificate)certs[i]).getSignature();
                                sb.append("\n" + this.pr.getString("owner") + owner);
                                sb.append("\n " + this.pr.getString("issuer") + issuer);
                                sb.append("\n" + this.pr.getString("serial") + ((X509Certificate)certs[i]).getSerialNumber().toString());
                                sb.append("\n" + this.pr.getString("valid") + ((X509Certificate)certs[i]).getNotBefore().toString() + " " + this.pr.getString("until") + ((X509Certificate)certs[i]).getNotAfter().toString());
                                sb.append("\n" + this.pr.getString("fingerprint") + ((X509Certificate)certs[i]).getSigAlgName() + "): " + this.byteToString(sig));
                            }
                            System.out.println(sb.toString());
                        }
                        break block19;
                    }
                    System.out.println(this.pr.getString("entryAlias") + alias + " " + this.pr.getString("notFound"));
                }
                catch (KeyStoreException ex) {
                    this.debug.trace("admin", "KMSAdmin", "listCert", ex);
                    String msg = ex.getLocalizedMessage();
                    if (msg != null) {
                        System.out.println(this.pr.getString("faillistcerts") + " " + msg);
                    }
                    System.out.println(this.pr.getString("faillistcerts"));
                }
            }
        }
    }

    private String aCertToString(KeyStore ks, String alias, X509Certificate cert, boolean verbose) {
        String creationDate = null;
        try {
            creationDate = ks.getCreationDate(alias).toString();
        }
        catch (KeyStoreException ex) {
            creationDate = "null";
        }
        String sigAlgName = cert.getSigAlgName();
        byte[] sig = cert.getSignature();
        String fingerPrint = this.byteToString(sig);
        StringBuffer sb = new StringBuffer();
        String entry = this.getEntryType(ks, alias);
        if (!verbose) {
            sb.append("\n" + alias + ", " + creationDate + ", " + entry);
            sb.append("\n" + this.pr.getString("fingerprint") + sigAlgName + "): " + fingerPrint);
            return sb.toString();
        }
        String owner = cert.getSubjectX500Principal().getName();
        String issuer = cert.getIssuerX500Principal().getName();
        sb.append("\n\n" + this.pr.getString("aliasName") + alias);
        sb.append("\n" + this.pr.getString("createDate") + creationDate);
        sb.append("\n" + this.pr.getString("entryType") + entry);
        sb.append("\n" + this.pr.getString("owner") + owner);
        sb.append("\n" + this.pr.getString("issuer") + issuer);
        sb.append("\n" + this.pr.getString("serial") + cert.getSerialNumber().toString());
        sb.append("\n" + this.pr.getString("valid") + cert.getNotBefore().toString() + " " + this.pr.getString("until") + cert.getNotAfter().toString());
        sb.append("\n" + this.pr.getString("fingerprint") + sigAlgName + "): " + fingerPrint);
        return sb.toString();
    }

    private String getEntryType(KeyStore ks, String alias) {
        try {
            if (ks.isCertificateEntry(alias)) {
                return "trustedCertEntry";
            }
            if (ks.isKeyEntry(alias)) {
                return "keyEntry";
            }
            return "";
        }
        catch (KeyStoreException ex) {
            return "";
        }
    }

    private String byteToString(byte[] data) {
        StringBuffer sb = new StringBuffer();
        sb.append(Integer.toHexString(data[0] & 0xFF));
        for (int i = 1; i < data.length; ++i) {
            sb.append(":" + Integer.toHexString(data[i] & 0xFF));
        }
        return sb.toString();
    }

    private KeyStore loadKeyStore(String password) throws Exception {
        String provider = (String)this.config.get("config.keystore.provider");
        String type = (String)this.config.get("config.keystore.type");
        if (type == null) {
            type = "jks";
        }
        String file = (String)this.config.get("config.keystore.file");
        if (type.compareToIgnoreCase("PKCS11IMPLKS") == 0) {
            IBMPKCS11Impl p1 = null;
            Class<?> cls = null;
            if (Security.getProviders("KeyStore.PKCS11IMPLKS") == null) {
                cls = Class.forName("com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl");
                Preferences prefs = Preferences.userNodeForPackage(cls);
                prefs.put("IBMPKCSImpl DLL", file);
                prefs.put("IBMPKCSImpl password", password);
                p1 = new IBMPKCS11Impl();
                prefs.remove("IBMPKCSImpl DLL");
                prefs.remove("IBMPKCSImpl password");
                Security.addProvider((Provider)p1);
            }
            KeyStore ks = KeyStore.getInstance(type, provider);
            if (password != null) {
                ks.load(null, password.toCharArray());
                password = null;
            } else {
                ks.load(null, null);
            }
            return ks;
        }
        KeyStore ks = KeyStore.getInstance(type, provider);
        FileInputStream fis = new FileInputStream(file);
        if (password != null) {
            ks.load(fis, password.toCharArray());
            password = null;
        } else {
            ks.load(fis, null);
        }
        return ks;
    }

    private String promptPassword() {
        PasswordMask mask = new PasswordMask();
        mask.start();
        mask.setMask(true);
        System.out.print("password:           ");
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        String pwd = null;
        try {
            pwd = br.readLine();
        }
        catch (IOException ex) {
            // empty catch block
        }
        mask.setMask(false);
        mask.setDone(true);
        while (mask.isAlive()) {
        }
        return pwd;
    }

    private void processRenDrive() {
        Set keyset = this.argsSet.keySet();
        String drivename = null;
        String newname = null;
        Iterator it = keyset.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (collator.compare(key, "-drivename") == 0) {
                drivename = (String)this.argsSet.get(key);
                continue;
            }
            if (collator.compare(key, "-newname") != 0) continue;
            newname = (String)this.argsSet.get(key);
        }
        if (drivename == null || newname == null) {
            this.invalidInput();
        }
        try {
            this.admin.renameDrive(drivename, newname);
        }
        catch (KeyManagerException ex) {
            System.out.println(ex.getMessage());
        }
    }

    private void processAddDrive() {
        Set keyset = this.argsSet.keySet();
        String drivename = null;
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator it = keyset.iterator();
        while (it.hasNext()) {
            String obj;
            String key = (String)it.next();
            if (collator.compare(key, "-drivename") == 0) {
                drivename = (String)this.argsSet.get(key);
                if (drivename == null) {
                    this.invalidInput();
                    return;
                }
                if (drivename.toCharArray().length == 12) continue;
                System.out.print(this.pr.getString("driveserial") + " ");
                this.invalidInput();
                return;
            }
            if (collator.compare(key, "-address") == 0) {
                obj = (String)this.argsSet.get(key);
                if (obj == null) continue;
                map.put("HostAddress", obj);
                continue;
            }
            if (collator.compare(key, "-alias") == 0) {
                obj = (String)this.argsSet.get(key);
                if (obj == null) continue;
                map.put("CertAlias", obj);
                continue;
            }
            if (collator.compare(key, "-rec1") == 0) {
                obj = (String)this.argsSet.get(key);
                if (obj == null) continue;
                map.put("AliasOne", obj);
                continue;
            }
            if (collator.compare(key, "-rec2") != 0 || (obj = (String)this.argsSet.get(key)) == null) continue;
            map.put("AliasTwo", obj);
        }
        if (drivename == null) {
            this.invalidInput();
        } else {
            try {
                this.admin.addDrive(drivename, map);
                if (this.audit.isOn("resource_management", "success")) {
                    ResourceMgmt_Event event = new ResourceMgmt_Event((Object)this, "create", drivename, "KMSAdmin", true);
                    this.audit.record(event);
                }
            }
            catch (KeyManagerException ex) {
                this.debug.trace("admin", "KMSAdmin", "processAddDrive", ex);
                String msg = ex.getLocalizedMessage();
                if (msg != null) {
                    System.out.println(this.pr.getString("failadddrive") + " " + msg);
                } else {
                    System.out.println(this.pr.getString("failadddrive"));
                }
                try {
                    if (this.audit.isOn("resource_management", "failure")) {
                        ResourceMgmt_Event event = new ResourceMgmt_Event((Object)this, "create", drivename, "KMSAdmin", false);
                        if (msg != null) {
                            event.setAuditMsg(msg);
                        }
                        this.audit.record(event);
                    }
                }
                catch (KeyManagerException ex2) {
                    this.debug.trace("admin", "KMSAdmin", "processAddDrive", ex2);
                }
            }
        }
    }

    private void processListDrives() {
        String msg;
        ResourceMgmt_Event event;
        Iterator it;
        List list;
        String drivename = null;
        Set keyset = this.argsSet.keySet();
        Iterator it2 = keyset.iterator();
        while (it2.hasNext()) {
            String key = (String)it2.next();
            if (collator.compare(key, "-drivename") != 0) continue;
            drivename = (String)this.argsSet.get(key);
        }
        if (drivename == null) {
            try {
                list = this.admin.listDrives();
                System.out.println(this.pr.getString("driveentries") + " " + list.size());
                it = list.iterator();
                while (it.hasNext()) {
                    System.out.println(((DriveTableEntry)it.next()).toEntryString());
                }
                if (this.audit.isOn("resource_management", "success")) {
                    event = new ResourceMgmt_Event((Object)this, "show", "drive table", "KMSAdmin", true);
                    this.audit.record(event);
                }
            }
            catch (KeyManagerException ex) {
                this.debug.trace("admin", "KMSAdmin", "processListDrives", ex);
                msg = ex.getLocalizedMessage();
                if (msg != null) {
                    System.out.println(this.pr.getString("faillistdrives") + " " + msg);
                } else {
                    System.out.println(this.pr.getString("faillistdrives"));
                }
                try {
                    if (this.audit.isOn("resource_management", "failure")) {
                        ResourceMgmt_Event event2 = new ResourceMgmt_Event((Object)this, "show", "drive table", "KMSAdmin", false);
                        if (msg != null) {
                            event2.setAuditMsg(msg);
                        }
                        this.audit.record(event2);
                    }
                }
                catch (KeyManagerException ex2) {
                    this.debug.trace("admin", "KMSAdmin", "processListDrives", ex2);
                }
            }
        } else {
            try {
                list = this.admin.listDrives(drivename, null);
                if (list.size() == 0) {
                    System.out.println(this.pr.getString("nodrive"));
                } else {
                    it = list.iterator();
                    while (it.hasNext()) {
                        System.out.println(((DriveTableEntry)it.next()).toEntryString());
                    }
                }
                if (this.audit.isOn("resource_management", "success")) {
                    event = new ResourceMgmt_Event((Object)this, "show", drivename, "KMSAdmin", true);
                    this.audit.record(event);
                }
            }
            catch (KeyManagerException ex) {
                this.debug.trace("admin", "KMSAdmin", "processListDrives", ex);
                msg = ex.getLocalizedMessage();
                if (msg != null) {
                    System.out.println(this.pr.getString("faillistdrives") + " " + msg);
                } else {
                    System.out.println(this.pr.getString("faillistdrives"));
                }
                try {
                    if (this.audit.isOn("resource_management", "failure")) {
                        ResourceMgmt_Event event3 = new ResourceMgmt_Event((Object)this, "show", drivename, "KMSAdmin", false);
                        if (msg != null) {
                            event3.setAuditMsg(msg);
                        }
                        this.audit.record(event3);
                    }
                }
                catch (KeyManagerException ex2) {
                    this.debug.trace("admin", "KMSAdmin", "processListDrives", ex2);
                }
            }
        }
    }

    private void processModDrive() {
        Set keyset = this.argsSet.keySet();
        String drivename = null;
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator it = keyset.iterator();
        while (it.hasNext()) {
            String obj;
            String key = (String)it.next();
            if (collator.compare(key, "-drivename") == 0) {
                drivename = (String)this.argsSet.get(key);
                continue;
            }
            if (collator.compare(key, "-address") == 0) {
                obj = (String)this.argsSet.get(key);
                if (obj == null) continue;
                map.put("HostAddress", obj);
                continue;
            }
            if (collator.compare(key, "-alias") == 0) {
                obj = (String)this.argsSet.get(key);
                if (obj == null) continue;
                map.put("CertAlias", obj);
                continue;
            }
            if (collator.compare(key, "-rec1") == 0) {
                obj = (String)this.argsSet.get(key);
                if (obj == null) continue;
                map.put("AliasOne", obj);
                continue;
            }
            if (collator.compare(key, "-rec2") != 0 || (obj = (String)this.argsSet.get(key)) == null) continue;
            map.put("AliasTwo", obj);
        }
        if (drivename == null) {
            this.invalidInput();
        } else {
            try {
                this.admin.modDrive(drivename, map);
                if (this.audit.isOn("resource_management", "success")) {
                    ResourceMgmt_Event event = new ResourceMgmt_Event((Object)this, "modify", drivename, "KMSAdmin", true);
                    this.audit.record(event);
                }
            }
            catch (KeyManagerException ex) {
                this.debug.trace("admin", "KMSAdmin", "processModDrive", ex);
                String msg = ex.getLocalizedMessage();
                if (msg != null) {
                    System.out.println(this.pr.getString("failmoddrive") + " " + msg);
                } else {
                    System.out.println(this.pr.getString("failmoddrive"));
                }
                try {
                    if (this.audit.isOn("resource_management", "failure")) {
                        ResourceMgmt_Event event = new ResourceMgmt_Event((Object)this, "modify", drivename, "KMSAdmin", false);
                        this.audit.record(event);
                    }
                }
                catch (KeyManagerException ex2) {
                    this.debug.trace("admin", "KMSAdmin", "processModDrive", ex2);
                }
            }
        }
    }

    private void invalidInput() {
        System.out.println("invalid input");
    }

    private void parse(String input) {
        this.argsSet = new HashMap();
        if (input == null) {
            this.command = -1;
            return;
        }
        StringTokenizer st = new StringTokenizer(input, " ");
        if (st.countTokens() <= 0) {
            this.command = -1;
            return;
        }
        this.command = this.getCommand(st.nextToken());
        String option = null;
        String arg = null;
        while (st.hasMoreTokens()) {
            arg = st.nextToken();
            if (!arg.startsWith("-")) {
                if (option == null) {
                    this.command = 1000;
                    return;
                }
                this.argsSet.put(option, arg);
                option = null;
                continue;
            }
            if (option != null) {
                this.argsSet.put(option, null);
                option = null;
            }
            if (st.hasMoreTokens()) {
                option = st.nextToken();
                if (!option.startsWith("-")) {
                    this.argsSet.put(arg, option);
                    option = null;
                    continue;
                }
                this.argsSet.put(arg, null);
                continue;
            }
            this.argsSet.put(arg, null);
        }
        if (option != null) {
            this.argsSet.put(option, null);
        }
    }

    private int getCommand(String input) {
        this.command = collator.compare(input, "adddrive") == 0 ? 0 : (collator.compare(input, "listdrives") == 0 ? 1 : (collator.compare(input, "listcerts") == 0 ? 2 : (collator.compare(input, "listconfig") == 0 ? 3 : (collator.compare(input, "moddrive") == 0 || collator.compare(input, "modifydrive") == 0 ? 4 : (collator.compare(input, "export") == 0 ? 5 : (collator.compare(input, "sync") == 0 ? 6 : (collator.compare(input, "import") == 0 ? 7 : (collator.compare(input, "rmdrive") == 0 || collator.compare(input, "removedrive") == 0 || collator.compare(input, "deletedrive") == 0 || collator.compare(input, "deldrive") == 0 ? 8 : (collator.compare(input, "renamedrive") == 0 || collator.compare(input, "rendrive") == 0 ? 9 : (collator.compare(input, "modconfig") == 0 || collator.compare(input, "modifyconfig") == 0 ? 10 : (collator.compare(input, "startkms") == 0 ? 11 : (collator.compare(input, "exit") == 0 || collator.compare(input, "quit") == 0 ? 15 : (collator.compare(input, "logout") == 0 || collator.compare(input, "logoff") == 0 ? 13 : (collator.compare(input, "help") == 0 || collator.compare(input, "?") == 0 ? 14 : (collator.compare(input, "stopkms") == 0 ? 12 : (collator.compare(input, "refresh") == 0 ? 16 : (collator.compare(input, "status") == 0 ? 17 : 1000)))))))))))))))));
        return this.command;
    }

    private void displayHelp() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.pr.getString("usage"));
        sb.append("\nadddrive -drivename <name> [-address <addr>] [-alias <alias>] [-rec1 <alias>] [-rec2 <alias>]");
        sb.append("\n\ndeldrive -drivename <name>");
        sb.append("\n" + this.pr.getString("equal") + " rmdrive " + this.pr.getString("or") + " deletedrive " + this.pr.getString("or") + " removedrive");
        sb.append("\n\nexit " + this.pr.getString("or") + " quit");
        sb.append("\n\nexport -drivetab|-config -url <url name>");
        sb.append("\n\nhelp");
        sb.append("\n" + this.pr.getString("equal") + " ?");
        sb.append("\n\nimport -merge|-rewrite -drivetab|-config -url <url name> ");
        sb.append("\n\nlistcerts [-alias <alias>] [-verbose|-v]");
        sb.append("\n\nlistconfig ");
        sb.append("\n\nlistdrives [-drivename <drive_name>]");
        sb.append("\n\nlogout");
        sb.append("\n" + this.pr.getString("equal") + " logoff");
        sb.append("\nOnly useful when LoginModule is enabled");
        sb.append("\n\nmodconfig -set -property <name> -value <value> | -unset -property <name>");
        sb.append("\n" + this.pr.getString("equal") + " modifyconfig");
        sb.append("\n\nmoddrive -drivename <name> [-address addr] [-alias alias] [-rec1 alias] [-rec2 alias]");
        sb.append("\n" + this.pr.getString("equal") + " modifydrive");
        sb.append("\n\nrefresh");
        sb.append("\n\nstartkms");
        sb.append("\n\nstatus");
        sb.append("\n\nstopkms");
        sb.append("\n\nsync -all|-config|-drivetab -ipaddr <ip address> [-merge|-rewrite]");
        System.out.println(sb.toString());
    }

    static {
        collator.setStrength(0);
        Security.addProvider((Provider)new IBMJSSEProvider2());
    }

    class ServerThread
    extends Thread {
        private String[] serverArgs;

        public ServerThread(String[] serverArgs) {
            this.serverArgs = serverArgs;
        }

        public synchronized void run() {
            try {
                KeyManagementServer.main(this.serverArgs);
                KMSAdmin.this.serverParams = KeyManagementServer.getParameters();
                KMSAdmin.this.debug = KMSAdmin.this.serverParams.getDebug();
                KMSAdmin.this.config = KMSAdmin.this.serverParams.getConfig();
                KMSAdmin.this.audit = KMSAdmin.this.serverParams.getAudit();
                KMSAdmin.this.driveTable = KMSAdmin.this.serverParams.getDriveTable();
                KMSAdmin.this.admin = new Admin(KMSAdmin.this.config, KMSAdmin.this.debug, KMSAdmin.this.audit, KMSAdmin.this.driveTable);
                KMSAdmin.this.serverState = 1;
                try {
                    if (KMSAdmin.this.audit.isOn("runtime", "success")) {
                        Runtime_Event event = new Runtime_Event((Object)this, "start", new UserInfo("KMSAdmin"), new ResourceInfo("KMS server", "application"), new AuditOutcomeType(true));
                        KMSAdmin.this.audit.record(event);
                    }
                }
                catch (KeyManagerException ex2) {
                    KMSAdmin.this.debug.trace("admin", "KMSAdmin", "processStartKMS", ex2);
                }
                System.out.println(KMSAdmin.this.pr.getString("startsv"));
            }
            catch (Exception ex) {
                KMSAdmin.this.serverState = -1;
                KMSAdmin.this.ksLoader.removeAll();
                System.out.println(KMSAdmin.this.pr.getString("failserver") + " " + ex.getLocalizedMessage());
            }
        }
    }

    class PasswordMask
    extends Thread {
        private boolean done = false;
        private boolean mask = false;

        PasswordMask() {
        }

        public void run() {
            while (!this.done) {
                if (!this.mask) continue;
                System.out.print("\b\b\b\b\b\b\b\b\b\b          ");
            }
        }

        void setDone(boolean done) {
            this.done = done;
        }

        void setMask(boolean mask) {
            this.mask = mask;
        }

        public void destroy() {
        }
    }
}

