/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.admin;

import com.ibm.keymanager.KMSDebug;
import com.ibm.keymanager.KeyManagerException;
import com.ibm.keymanager.admin.DefaultConfig;
import com.ibm.keymanager.admin.DefaultHandler;
import com.ibm.keymanager.audit.Audit;
import com.ibm.keymanager.audit.AuditOutcomeType;
import com.ibm.keymanager.audit.DataSync_Event;
import com.ibm.keymanager.audit.ResourceInfo;
import com.ibm.keymanager.config.Config;
import com.ibm.keymanager.drivetable.DriveTable;
import com.ibm.keymanager.drivetable.DriveTableEntry;
import com.ibm.keymanager.i18n.PropertyResource;
import com.ibm.keymanager.keystore.KeyStoreLoader;
import com.ibm.keymanager.transport.MessageHeader;
import com.ibm.keymanager.transport.Transport;
import com.ibm.keymanager.transport.TransportMessage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class Admin {
    private KMSDebug debug;
    private Audit audit;
    private Config config;
    private DriveTable driveTable;
    private KeyStore keyStore;
    private KeyStoreLoader ksloader;
    private PropertyResource pr = PropertyResource.getExceptionInstance();
    public static final int TAPE_DRIVE_TABLE = 0xF0F0FFD;
    public static final int CONFIG = 0xF0F0FFE;
    public static final int ACTION_REWRITE = 10;
    public static final int ACTION_MERGE = 11;
    private SSLContext context;
    private LoginContext lc;
    static final String TIMEOUT = "Admin.ssl.timeout";
    static final String PROTOCOLS = "Admin.ssl.protocols";
    static final String CIPHERSUITES = "Admin.ssl.ciphersuites";
    static final String KEYSTORE_NAME = "Admin.ssl.keystore.name";
    static final String KEYSTORE_TYPE = "Admin.ssl.keystore.type";
    static final String KEYSTORE_PASSWORD = "Admin.ssl.keystore.password";
    static final String TRUSTSTORE_NAME = "Admin.ssl.truststore.name";
    static final String TRUSTSTORE_TYPE = "Admin.ssl.truststore.type";
    static final String TRUSTSTORE_PASSWORD = "Admin.ssl.truststore.password";
    static final String LOGIN_MODULE = "Admin.loginModule";
    private ArrayList syncThreadQueue = new ArrayList(1);

    private void initContext() throws KeyManagerException {
        String protocol = this.initProp(PROTOCOLS);
        if (protocol == null) {
            protocol = "SSL_TLS";
        }
        try {
            this.context = SSLContext.getInstance(protocol, "IBMJSSE2");
            KeyManager[] kms = this.ksloader.loadKeyManagers("ListKS", null);
            TrustManager[] tms = this.ksloader.loadTrustManagers("ListKS");
            this.context.init(kms, tms, null);
        }
        catch (Exception ex) {
            this.context = null;
            String msg = ex.getLocalizedMessage();
            if (msg != null) {
                throw (KeyManagerException)new KeyManagerException(msg).initCause(ex);
            }
            throw (KeyManagerException)new KeyManagerException().initCause(ex);
        }
    }

    private String initProp(String key) {
        String value = null;
        try {
            value = (String)this.config.get(key);
        }
        catch (KeyManagerException ex) {
            // empty catch block
        }
        if (value == null) {
            try {
                value = (String)this.config.get(key.substring(key.indexOf(".") + 1));
            }
            catch (KeyManagerException keyManagerException) {
                // empty catch block
            }
        }
        return value;
    }

    public Admin() {
    }

    public Admin(Config config, KMSDebug debug, Audit audit, DriveTable driveTable) throws KeyManagerException {
        this.config = config;
        this.debug = debug;
        this.audit = audit;
        this.driveTable = driveTable;
        this.ksloader = KeyStoreLoader.getInstance(config, debug);
    }

    public Admin(Config config, KMSDebug debug, Audit audit) throws KeyManagerException {
        this.config = config;
        this.debug = debug;
        this.audit = audit;
        this.ksloader = KeyStoreLoader.getInstance(config, debug);
    }

    public void refresh() throws KeyManagerException {
        this.debug.refresh(this.config);
        this.audit.refresh(this.config);
        this.driveTable.refresh(this.config, this.audit);
    }

    public List listDrives(String driveName, Map attributes) throws KeyManagerException {
        byte[] namebytes = null;
        try {
            namebytes = driveName.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            this.debug.trace("admin", "Admin", "listDrives", ex);
            namebytes = driveName.getBytes();
        }
        return this.listDrives(namebytes, attributes);
    }

    public List listDrives(byte[] driveName, Map attributes) throws KeyManagerException {
        ArrayList<DriveTableEntry> list = new ArrayList<DriveTableEntry>();
        DriveTableEntry entry = this.driveTable.fetchDriveEntry(driveName, attributes);
        if (entry != null && !entry.isDeleted()) {
            list.add(entry);
        }
        return list;
    }

    public List listDrives() throws KeyManagerException {
        ArrayList<DriveTableEntry> list = new ArrayList<DriveTableEntry>();
        Enumeration enumeration = this.driveTable.fetchAllDriveEntries();
        while (enumeration.hasMoreElements()) {
            DriveTableEntry entry = (DriveTableEntry)enumeration.nextElement();
            if (entry.isDeleted()) continue;
            list.add(entry);
        }
        return list;
    }

    public boolean renameDrive(String old_name, String new_name) throws KeyManagerException {
        DriveTableEntry entry = null;
        try {
            entry = this.driveTable.fetchDriveEntry(old_name.getBytes("UTF-8"), null);
        }
        catch (UnsupportedEncodingException ex) {
            this.debug.trace("admin", "Admin", "renameDrive", ex);
            entry = this.driveTable.fetchDriveEntry(old_name.getBytes(), null);
        }
        if (entry != null && !entry.isDeleted()) {
            try {
                entry.setSN(new_name.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException ex) {
                this.debug.trace("admin", "Admin", "renameDrive", ex);
                entry.setSN(new_name.getBytes());
            }
            this.driveTable.saveDriveEntry(entry);
            try {
                entry = this.driveTable.fetchDriveEntry(old_name.getBytes("UTF-8"), null);
            }
            catch (UnsupportedEncodingException ex) {
                this.debug.trace("admin", "Admin", "renameDrive", ex);
                entry = null;
            }
            if (entry != null) {
                this.debug.trace("admin", "Admin", "renameDrive", "entry still exists");
                entry.setDeleted();
            }
            return true;
        }
        throw new KeyManagerException("Drive " + old_name + " not found");
    }

    public List listCerts(String alias) {
        if (this.keyStore != null) {
            ArrayList<Object> list = new ArrayList<Object>();
            try {
                if (this.keyStore.isCertificateEntry(alias)) {
                    list.add(this.keyStore.getCertificate(alias));
                } else if (this.keyStore.isKeyEntry(alias)) {
                    list.add(this.keyStore.getCertificateChain(alias));
                }
            }
            catch (KeyStoreException ex) {
                this.debug.trace("admin", "Admin", "listCerts", ex);
            }
            return list;
        }
        return null;
    }

    public List listCerts() {
        if (this.keyStore != null) {
            ArrayList<Object> list = new ArrayList<Object>();
            try {
                Enumeration<String> enumeration = this.keyStore.aliases();
                while (enumeration.hasMoreElements()) {
                    String alias = enumeration.nextElement();
                    if (this.keyStore.isCertificateEntry(alias)) {
                        list.add(this.keyStore.getCertificate(alias));
                        continue;
                    }
                    if (!this.keyStore.isKeyEntry(alias)) continue;
                    list.add(this.keyStore.getCertificateChain(alias));
                }
            }
            catch (KeyStoreException ex) {
                this.debug.trace("admin", "Admin", "listCerts", ex);
            }
            return list;
        }
        return null;
    }

    public Map listConfig() {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        Enumeration enumeration = this.config.list();
        Object key = null;
        Object value = null;
        while (enumeration.hasMoreElements()) {
            key = enumeration.nextElement();
            try {
                value = this.config.get((String)key);
            }
            catch (KeyManagerException ex) {
                value = "null";
            }
            map.put(key, value);
        }
        return map;
    }

    private String getConfig() {
        Hashtable table = new Hashtable();
        Enumeration enumeration = this.config.list();
        StringBuffer sb = new StringBuffer();
        Object key = null;
        Object value = null;
        while (enumeration.hasMoreElements()) {
            key = enumeration.nextElement();
            try {
                value = this.config.get(key);
            }
            catch (KeyManagerException ex) {
                value = "null";
            }
            sb.append("\n" + key + "=" + value);
        }
        return sb.toString();
    }

    public void addDrive(String driveName, Map attributes) throws KeyManagerException {
        try {
            DriveTableEntry existedEntry = this.driveTable.fetchDriveEntry(driveName.getBytes("UTF-8"), attributes);
            if (existedEntry != null && !existedEntry.isDeleted()) {
                throw new KeyManagerException(this.pr.getString("driveexist"));
            }
            DriveTableEntry entry = this.driveTable.createDriveEntry(null, driveName.getBytes("UTF-8"), attributes);
            this.driveTable.saveDriveEntry(entry);
        }
        catch (UnsupportedEncodingException ex) {
            this.debug.trace("admin", "Admin", "addDrive", ex);
            this.driveTable.createDriveEntry(null, driveName.getBytes(), attributes);
        }
    }

    public void modDrive(String driveName, Map attributes) throws KeyManagerException {
        try {
            this.driveTable.modifyDriveEntry(null, driveName.getBytes("UTF-8"), attributes);
        }
        catch (UnsupportedEncodingException ex) {
            this.debug.trace("admin", "Admin", "modDrive", ex);
            this.driveTable.modifyDriveEntry(null, driveName.getBytes(), attributes);
        }
    }

    public void unloadTo(int type, String uriSt) throws KeyManagerException {
        byte[] data = null;
        if (type == 0xF0F0FFD) {
            data = this.driveTable.export();
        } else if (type == 0xF0F0FFE) {
            try {
                data = this.getConfig().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                this.debug.trace("admin", "Admin", "unloadTo", ex);
                data = this.getConfig().getBytes();
            }
        }
        URI uri = null;
        try {
            this.debug.trace("admin", "Admin", "unloadTo", "unload to " + uriSt);
            uri = new URI(uriSt);
            File file = null;
            file = new File(uri);
            if (!file.exists()) {
                this.debug.trace("admin", "Admin", "unloadTo", "file does not exist, create new one");
                file.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(file);
            if (type == 0xF0F0FFD) {
                fos.write(data);
                fos.close();
            } else if (type == 0xF0F0FFE) {
                this.debug.trace("admin", "Admin", "unloadTo", "file.getAbsolute=" + file.getAbsolutePath());
                this.config.write(file.getAbsolutePath());
                fos.close();
            }
        }
        catch (Exception ex) {
            this.debug.trace("admin", "Admin", "unloadTo", ex);
            String msg = ex.getLocalizedMessage();
            if (msg != null) {
                throw (KeyManagerException)new KeyManagerException(msg).initCause(ex);
            }
            throw (KeyManagerException)new KeyManagerException().initCause(ex);
        }
    }

    public void loadFrom(int object_type, int action_type, String uriStr) throws KeyManagerException {
        block9: {
            URI uri = null;
            try {
                uri = new URI(uriStr);
                File file = new File(uri);
                if (!file.exists()) {
                    throw new IOException(this.pr.getString("file") + " " + uri + " " + this.pr.getString("noexist"));
                }
                FileInputStream fis = new FileInputStream(file);
                int size = fis.available();
                byte[] data = new byte[size];
                fis.read(data);
                if (object_type == 0xF0F0FFE) {
                    if (action_type == 10) {
                        this.config.load(file);
                        break block9;
                    }
                    if (action_type == 11) {
                        this.config.merge(file);
                        break block9;
                    }
                    throw new KeyManagerException(this.pr.getString("unaction"));
                }
                if (object_type != 0xF0F0FFD) break block9;
                if (action_type == 10) {
                    this.driveTable.overrideTable(data);
                    break block9;
                }
                if (action_type == 11) {
                    this.driveTable.mergeTable(data);
                    break block9;
                }
                throw new KeyManagerException(this.pr.getString("unaction"));
            }
            catch (Exception ex) {
                this.debug.trace("admin", "Admin", "loadFrom", ex);
                String msg = ex.getLocalizedMessage();
                if (msg != null) {
                    throw (KeyManagerException)new KeyManagerException(msg).initCause(ex);
                }
                throw (KeyManagerException)new KeyManagerException().initCause(ex);
            }
        }
    }

    public void sync(String ipAddress, int port, int target, int action) throws IOException, KeyManagerException {
        byte[] driveTableData = null;
        if ((target | 0xF0F0FFD) == 0xF0F0FFD) {
            try {
                driveTableData = this.driveTable.export();
            }
            catch (KeyManagerException ex) {
                this.debug.trace("admin", "Admin", "sync", ex);
                this.debug.trace("admin", "Admin", "sync", "set drivetable data to be null");
                driveTableData = null;
            }
        }
        byte[] configData = null;
        if ((target | 0xF0F0FFE) == 0xF0F0FFE) {
            Hashtable config = this.config.get();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = null;
            try {
                oos = new ObjectOutputStream(bos);
                oos.writeObject(config);
            }
            catch (IOException ex) {
                this.debug.trace("admin", "Admin", "sync", ex);
                oos = null;
            }
            if (oos != null) {
                configData = bos.toByteArray();
            }
        }
        if (driveTableData != null || configData != null) {
            SyncThread thread = null;
            try {
                thread = new SyncThread(driveTableData, configData, ipAddress, port, action);
            }
            catch (KeyManagerException ex) {
                this.debug.trace("admin", "Admin", "sync", ex);
                throw ex;
            }
            if (thread != null) {
                this.syncThreadQueue.add(thread);
                thread.run();
            }
        } else {
            throw new KeyManagerException(this.pr.getString("nosync"));
        }
    }

    public void sync(String ipAddress, int target, int action) throws IOException, KeyManagerException {
        StringTokenizer st = new StringTokenizer(ipAddress, ":");
        String ip = st.nextToken();
        String portSt = "443";
        if (st.hasMoreTokens()) {
            portSt = st.nextToken();
        }
        int port = 0;
        try {
            port = new Integer(portSt);
        }
        catch (NumberFormatException ex) {
            this.debug.trace("admin", "Admin", "sync", ex);
            throw new IOException(this.pr.getString("invalport") + " " + portSt);
        }
        this.sync(ip, port, target, action);
    }

    public void sync(Transport transport) throws KeyManagerException, IOException {
        this.debug.entry("admin", "Admin", "sync");
        while (true) {
            Hashtable conf;
            ObjectInputStream ois;
            ByteArrayInputStream bis;
            TransportMessage tm = null;
            try {
                tm = transport.receive();
            }
            catch (Exception ex) {
                this.debug.trace("admin", "Admin", "sync", ex);
                try {
                    transport.close();
                }
                catch (IOException ex2) {
                    this.debug.trace("admin", "Admin", "sync", ex2);
                }
                return;
            }
            this.debug.trace("admin", "Admin", "sync", "received data");
            MessageHeader mh = tm.getMessageHeader();
            byte[] msgBody = tm.getMessageBody();
            byte[] data = new byte[msgBody.length - 4];
            System.arraycopy(msgBody, 4, data, 0, data.length);
            short type = mh.getMinorType();
            this.debug.trace("admin", "Admin", "sync", "message type=" + (type & 0xFF));
            if (type == 3) {
                this.debug.trace("admin", "Admin", "sync", "merge drive table");
                this.debug.trace("admin", "Admin", "sync", data);
                this.driveTable.mergeTable(data);
                continue;
            }
            if (type == 4) {
                this.debug.trace("admin", "Admin", "sync", "rewrite drive table");
                this.debug.trace("admin", "Admin", "sync", data);
                this.driveTable.overrideTable(data);
                continue;
            }
            if (type == 1) {
                this.debug.trace("admin", "Admin", "sync", "merge config");
                this.debug.trace("admin", "Admin", "sync", data);
                try {
                    bis = new ByteArrayInputStream(data);
                    ois = new ObjectInputStream(bis);
                    conf = (Hashtable)ois.readObject();
                    this.config.sync(conf);
                }
                catch (Exception ex) {
                    this.debug.trace("admin", "Amdin", "sync", ex);
                }
                continue;
            }
            if (type != 2) continue;
            this.debug.trace("admin", "Admin", "sync", "rewrite config");
            this.debug.trace("admin", "Admin", "sync", data);
            try {
                bis = new ByteArrayInputStream(data);
                ois = new ObjectInputStream(bis);
                conf = (Hashtable)ois.readObject();
                this.config.sync(conf);
                continue;
            }
            catch (Exception ex) {
                this.debug.trace("admin", "Amdin", "sync", ex);
                continue;
            }
            break;
        }
    }

    public void removeDrive(String driveName) throws KeyManagerException {
        try {
            this.driveTable.deleteDriveEntry(driveName.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            this.debug.trace("admin", "Admin", "removeDrive", ex);
            this.driveTable.deleteDriveEntry(driveName.getBytes());
        }
    }

    public void setConfigProperty(String propertyName, String value) throws KeyManagerException {
        this.config.add(propertyName, value);
    }

    public void deleteConfigProperty(String propertyName) throws KeyManagerException {
        if (this.config.get(propertyName) == null) {
            throw new KeyManagerException(propertyName + " " + this.pr.getString("noexist"));
        }
        this.config.delete(propertyName);
    }

    public void shutdown() throws KeyManagerException {
        long endtime = new Date().getTime();
        int timeout = -1;
        if (this.driveTable != null) {
            this.driveTable.shutdown();
        }
        if (this.config != null) {
            this.config.shutdown();
        }
    }

    public boolean login(String username, char[] password) throws LoginException {
        String loginModule = null;
        try {
            loginModule = (String)this.config.get(LOGIN_MODULE);
            if (loginModule == null) {
                this.debug.trace("admin", "Admin", "login", "get login module=" + loginModule);
            }
        }
        catch (KeyManagerException ex) {
            this.debug.trace("admin", "Admin", "login", ex);
            loginModule = "default";
        }
        if (loginModule.equalsIgnoreCase("default")) {
            AppConfigurationEntry conf = new AppConfigurationEntry("com.ibm.keymanager.admin.DefaultLoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, new HashMap());
            DefaultConfig dConfig = new DefaultConfig();
            dConfig.setAppConfigurationEntry("default", conf);
            Configuration.setConfiguration(dConfig);
            this.lc = new LoginContext("default", new DefaultHandler(username, password));
            this.lc.login();
            return true;
        }
        this.lc = new LoginContext(loginModule, new DefaultHandler(username, password));
        this.lc.login();
        return true;
    }

    public void logout() throws LoginException {
        if (this.lc != null) {
            this.lc.logout();
        }
    }

    class SyncThread {
        private byte[] driveTableData;
        private byte[] configData;
        private String ipAddress;
        private int port;
        private long starttime = 0L;
        private int action;

        public SyncThread(byte[] dtData, byte[] configData, String ipAddr, int port, int action) throws KeyManagerException {
            this.driveTableData = dtData;
            this.configData = configData;
            this.ipAddress = ipAddr;
            this.port = port;
            this.action = action;
            if (Admin.this.context == null) {
                Admin.this.initContext();
            }
            this.starttime = new Date().getTime();
        }

        public void run() throws IOException {
            boolean connected = false;
            SSLSocketFactory factory = Admin.this.context.getSocketFactory();
            SSLSocket ssl_sock = null;
            InetSocketAddress inetAddr = new InetSocketAddress(this.ipAddress, this.port);
            String timeoutSt = Admin.this.initProp(Admin.TIMEOUT);
            int timeout = 60000;
            if (timeoutSt != null) {
                try {
                    timeout = new Integer(timeoutSt) * 60 * 1000;
                }
                catch (NumberFormatException ex) {
                    Admin.this.debug.trace("admin", "Admin.SyncThread", "run", ex);
                }
            }
            Admin.this.debug.trace("admin", "SyncThread", "run", "timeout=" + timeout);
            long endtime = 0L;
            boolean expired = false;
            String exception = null;
            while (!connected && !expired) {
                try {
                    ssl_sock = (SSLSocket)factory.createSocket();
                    ssl_sock.connect(inetAddr);
                    connected = true;
                }
                catch (IOException ex) {
                    exception = ex.getMessage();
                    Admin.this.debug.trace("admin", "Admin.SyncThread", "run", ex);
                }
                if (connected || (long)timeout >= (endtime = new Date().getTime()) - this.starttime) continue;
                expired = true;
            }
            Admin.this.debug.trace("admin", "SyncThread", "run", "connected");
            if (expired && !connected) {
                if (exception == null) {
                    throw new IOException("Unable to connect to remote key manager");
                }
                throw new IOException(exception);
            }
            String ciphers = Admin.this.initProp(Admin.CIPHERSUITES);
            String[] cipherSuites = null;
            if (ciphers != null) {
                String delim = ",";
                if (ciphers.indexOf(";") > 0) {
                    delim = ";";
                }
                StringTokenizer st = new StringTokenizer(ciphers, delim);
                cipherSuites = new String[st.countTokens()];
                int count = 0;
                while (st.hasMoreTokens()) {
                    cipherSuites[count++] = st.nextToken();
                }
                ssl_sock.setEnabledCipherSuites(cipherSuites);
            }
            String resourceInfo = "";
            if (this.configData != null) {
                resourceInfo = "TKMS configuration file";
            }
            if (this.driveTableData != null) {
                resourceInfo = resourceInfo + "TKMS drive table";
            }
            try {
                byte[] data;
                byte[] lengthBytes;
                int length;
                Admin.this.debug.trace("admin", "SyncThread", "run", "start handshake");
                ssl_sock.startHandshake();
                Admin.this.debug.trace("admin", "SyncThread", "run", "finish handshake");
                BufferedOutputStream os = new BufferedOutputStream(ssl_sock.getOutputStream());
                if (this.configData != null) {
                    MessageHeader mh = null;
                    if (this.action == 11) {
                        mh = new MessageHeader(1, 16, 1);
                    } else if (this.action == 10) {
                        mh = new MessageHeader(1, 16, 2);
                    }
                    length = this.configData.length;
                    lengthBytes = new byte[4];
                    for (int i = 0; i < 4; ++i) {
                        lengthBytes[i] = (byte)(length >>> (3 - i) * 8 & 0xFF);
                    }
                    TransportMessage tm = new TransportMessage(mh, lengthBytes, this.configData);
                    data = tm.getMessage();
                    os.write(data);
                    os.flush();
                    Admin.this.debug.trace("admin", "SyncThread", "run", "write config data, flush");
                    Admin.this.debug.trace("admin", "SyncThread", "run", data);
                }
                if (this.driveTableData != null) {
                    MessageHeader mh = null;
                    if (this.action == 11) {
                        mh = new MessageHeader(1, 16, 3);
                    } else if (this.action == 10) {
                        mh = new MessageHeader(1, 16, 4);
                    }
                    length = this.driveTableData.length;
                    lengthBytes = new byte[4];
                    for (int i = 0; i < 4; ++i) {
                        lengthBytes[i] = (byte)(length >>> (3 - i) * 8 & 0xFF);
                    }
                    TransportMessage tm = new TransportMessage(mh, lengthBytes, this.driveTableData);
                    data = tm.getMessage();
                    os.write(data);
                    os.flush();
                    Admin.this.debug.trace("admin", "SyncThread", "run", "write drive table data, flush");
                    Admin.this.debug.trace("admin", "SyncThread", "run", data);
                }
                os.close();
                ssl_sock.close();
                try {
                    if (Admin.this.audit.isOn("data_synchronization", "success")) {
                        DataSync_Event event = new DataSync_Event(this, resourceInfo, true);
                        Admin.this.audit.record(event);
                    }
                }
                catch (KeyManagerException ex3) {
                    Admin.this.debug.trace("admin", "Admin", "run", ex3);
                }
            }
            catch (IOException ex) {
                try {
                    ssl_sock.close();
                }
                catch (IOException ex2) {
                    Admin.this.debug.trace("admin", "Admin", "run", ex2);
                }
                Admin.this.debug.trace("admin", "Admin", "run", ex);
                try {
                    if (Admin.this.audit.isOn("data_synchronization", "failure")) {
                        DataSync_Event event = new DataSync_Event((Object)this, "reconcile", new ResourceInfo(resourceInfo), new AuditOutcomeType(false, ex.toString()));
                        String msg = ex.getMessage();
                        if (msg != null) {
                            event.setAuditMsg(msg);
                        }
                        Admin.this.audit.record(event);
                    }
                }
                catch (KeyManagerException ex3) {
                    Admin.this.debug.trace("admin", "Admin", "run", ex3);
                }
                throw ex;
            }
        }

        public long getStartTime() {
            return this.starttime;
        }
    }
}

