/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager;

import com.ibm.keymanager.KMSDebug;
import com.ibm.keymanager.KeyManagerException;
import com.ibm.keymanager.ServerParameters;
import com.ibm.keymanager.admin.Admin;
import com.ibm.keymanager.transport.Transport;
import java.io.IOException;

public class AdminProcessor
implements Runnable {
    private ServerParameters params;
    private Transport transport;
    private KMSDebug debug;

    AdminProcessor(Transport trans, ServerParameters parms) throws KeyManagerException {
        if (trans == null || parms == null) {
            throw new KeyManagerException("Null or empty request packet");
        }
        this.params = parms;
        this.transport = trans;
        this.debug = parms.getDebug();
    }

    public void run() {
        this.debug.entry("server", "AdminProcessor", "run");
        try {
            Admin admin = new Admin(this.params.getConfig(), this.params.getDebug(), this.params.getAudit(), this.params.getDriveTable());
            admin.sync(this.transport);
        }
        catch (Exception exc) {
            this.debug.trace("server", "AdminProcessor", "run", exc);
        }
    }

    void dispose() {
        try {
            this.transport.close();
        }
        catch (IOException ex) {
            this.debug.trace("server", "KMSDebug", "dispose", ex);
        }
        this.params = null;
        this.transport = null;
        this.debug = null;
    }
}

