/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.sasl;

import java.io.UnsupportedEncodingException;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

final class PlainClient
implements SaslClient {
    private boolean completed = false;
    private byte[] pw;
    private String authorizationID;
    private String authenticationID;
    private static byte SEP = 0;

    PlainClient(String authorizationID, String authenticationID, byte[] pw) throws SaslException {
        if (authenticationID == null || pw == null) {
            throw new SaslException("PLAIN: authorization ID and password must be specified");
        }
        this.authorizationID = authorizationID;
        this.authenticationID = authenticationID;
        this.pw = pw;
    }

    public String getMechanismName() {
        return "PLAIN";
    }

    public boolean hasInitialResponse() {
        return true;
    }

    public void dispose() throws SaslException {
        this.clearPassword();
    }

    public byte[] evaluateChallenge(byte[] challengeData) throws SaslException {
        if (this.completed) {
            throw new IllegalStateException("PLAIN authentication already completed");
        }
        this.completed = true;
        try {
            byte[] authz = this.authorizationID != null ? this.authorizationID.getBytes("UTF8") : null;
            byte[] auth = this.authenticationID.getBytes("UTF8");
            byte[] answer = new byte[this.pw.length + auth.length + 2 + (authz == null ? 0 : authz.length)];
            int pos = 0;
            if (authz != null) {
                System.arraycopy(authz, 0, answer, 0, authz.length);
                pos = authz.length;
            }
            answer[pos++] = SEP;
            System.arraycopy(auth, 0, answer, pos, auth.length);
            pos += auth.length;
            answer[pos++] = SEP;
            System.arraycopy(this.pw, 0, answer, pos, this.pw.length);
            this.clearPassword();
            return answer;
        }
        catch (UnsupportedEncodingException e) {
            throw new SaslException("Cannot get UTF-8 encoding of ids", e);
        }
    }

    public boolean isComplete() {
        return this.completed;
    }

    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        if (this.completed) {
            throw new SaslException("PLAIN supports neither integrity nor privacy");
        }
        throw new IllegalStateException("PLAIN authentication not completed");
    }

    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        if (this.completed) {
            throw new SaslException("PLAIN supports neither integrity nor privacy");
        }
        throw new IllegalStateException("PLAIN authentication not completed");
    }

    public Object getNegotiatedProperty(String propName) {
        if (this.completed) {
            if (propName.equals("javax.security.sasl.qop")) {
                return "auth";
            }
            return null;
        }
        throw new IllegalStateException("PLAIN authentication not completed");
    }

    private void clearPassword() {
        if (this.pw != null) {
            for (int i = 0; i < this.pw.length; ++i) {
                this.pw[i] = 0;
            }
            this.pw = null;
        }
    }

    protected void finalize() {
        this.clearPassword();
    }
}

