/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.converter.gui;

import java.awt.AWTKeyStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import sun.plugin.converter.ResourceHandler;
import sun.plugin.converter.engine.ConverterProgressEvent;
import sun.plugin.converter.engine.ConverterProgressListener;
import sun.plugin.converter.engine.PluginConverter;

public class ProgressGUI
extends JFrame
implements ActionListener,
ConverterProgressListener {
    private JButton cancelBttn;
    private JLabel processingLbl;
    private JLabel folderLbl;
    private JLabel fileLbl;
    private JLabel totalFilesLbl;
    private JLabel totalAppletsLbl;
    private JLabel totalErrorsLbl;
    private JFrame parent;
    private ProgressGUITextArea processingTxt;
    private ProgressGUITextArea folderTxt;
    private ProgressGUITextArea fileTxt;
    private ProgressGUITextArea totalFilesTxt;
    private ProgressGUITextArea totalAppletsTxt;
    private ProgressGUITextArea totalErrorsTxt;
    private ProgressGUITextArea processing2Txt;
    private ProgressGUITextArea folder2Txt;
    private ProgressGUITextArea file2Txt;
    private ProgressGUITextArea totalFiles2Txt;
    private ProgressGUITextArea totalApplets2Txt;
    private ProgressGUITextArea totalErrors2Txt;
    private PluginConverter converter;

    public ProgressGUI(PluginConverter pluginConverter, JFrame jFrame) {
        super(ResourceHandler.getMessage("progress_dialog.caption"));
        this.parent = jFrame;
        this.converter = pluginConverter;
        this.setResizable(true);
        this.majorLayout();
    }

    public void setVisible(boolean bl) {
        if (bl) {
            Dimension dimension = this.getToolkit().getScreenSize();
            this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
            this.parent.setEnabled(false);
        } else {
            this.parent.setEnabled(true);
        }
        super.setVisible(bl);
        if (bl) {
            this.converter.addConverterProgressListener(this);
            this.converter.startConversion();
        }
    }

    public void majorLayout() {
        this.processingTxt = new ProgressGUITextArea(ResourceHandler.getMessage("progress_dialog.processing"), this);
        this.processingTxt.getAccessibleContext().setAccessibleName(ResourceHandler.getMessage("progress_dialog.processing"));
        this.processing2Txt = new ProgressGUITextArea(this);
        this.folderTxt = new ProgressGUITextArea(ResourceHandler.getMessage("progress_dialog.folder"), this);
        this.folderTxt.getAccessibleContext().setAccessibleName(ResourceHandler.getMessage("progress_dialog.folder"));
        this.folder2Txt = new ProgressGUITextArea(this);
        this.fileTxt = new ProgressGUITextArea(ResourceHandler.getMessage("progress_dialog.file"), this);
        this.fileTxt.getAccessibleContext().setAccessibleName(ResourceHandler.getMessage("progress_dialog.file"));
        this.file2Txt = new ProgressGUITextArea(this);
        this.totalFilesTxt = new ProgressGUITextArea(ResourceHandler.getMessage("progress_dialog.totalfile"), this);
        this.totalFilesTxt.getAccessibleContext().setAccessibleName(ResourceHandler.getMessage("progress_dialog.totalfile"));
        this.totalFiles2Txt = new ProgressGUITextArea(this);
        this.totalAppletsTxt = new ProgressGUITextArea(ResourceHandler.getMessage("progress_dialog.totalapplet"), this);
        this.totalAppletsTxt.getAccessibleContext().setAccessibleName(ResourceHandler.getMessage("progress_dialog.totalapplet"));
        this.totalApplets2Txt = new ProgressGUITextArea(this);
        this.totalErrorsTxt = new ProgressGUITextArea(ResourceHandler.getMessage("progress_dialog.totalerror"), this);
        this.totalErrorsTxt.getAccessibleContext().setAccessibleName(ResourceHandler.getMessage("progress_dialog.totalerror"));
        this.totalErrors2Txt = new ProgressGUITextArea(this);
        this.cancelBttn = new JButton(ResourceHandler.getMessage("button.cancel"));
        this.cancelBttn.setMnemonic(ResourceHandler.getAcceleratorKey("button.cancel"));
        this.addListeners();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.getContentPane().setLayout(gridBagLayout);
        gridBagLayout.setConstraints(this.processingTxt, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        gridBagLayout.setConstraints(this.processing2Txt, new GridBagConstraints(1, 0, 0, 1, 1.0, 0.0, 10, 2, new Insets(10, 0, 0, 10), 0, 0));
        gridBagLayout.setConstraints(this.folderTxt, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        gridBagLayout.setConstraints(this.folder2Txt, new GridBagConstraints(1, 1, 0, 1, 1.0, 0.0, 10, 2, new Insets(10, 0, 0, 10), 0, 0));
        gridBagLayout.setConstraints(this.fileTxt, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        gridBagLayout.setConstraints(this.file2Txt, new GridBagConstraints(1, 2, 0, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 10), 0, 0));
        gridBagLayout.setConstraints(this.totalFilesTxt, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        gridBagLayout.setConstraints(this.totalFiles2Txt, new GridBagConstraints(2, 3, 0, 1, 1.0, 0.0, 17, 0, new Insets(10, 0, 0, 10), 0, 0));
        gridBagLayout.setConstraints(this.totalAppletsTxt, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        gridBagLayout.setConstraints(this.totalApplets2Txt, new GridBagConstraints(2, 4, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 10), 0, 0));
        gridBagLayout.setConstraints(this.totalErrorsTxt, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        gridBagLayout.setConstraints(this.totalErrors2Txt, new GridBagConstraints(2, 5, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 10), 0, 0));
        gridBagLayout.setConstraints(this.cancelBttn, new GridBagConstraints(0, 6, 0, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 10, 10), 0, 0));
        this.getContentPane().add(this.processingTxt);
        this.getContentPane().add(this.processing2Txt);
        this.getContentPane().add(this.folderTxt);
        this.getContentPane().add(this.folder2Txt);
        this.getContentPane().add(this.fileTxt);
        this.getContentPane().add(this.file2Txt);
        this.getContentPane().add(this.totalFilesTxt);
        this.getContentPane().add(this.totalFiles2Txt);
        this.getContentPane().add(this.totalAppletsTxt);
        this.getContentPane().add(this.totalApplets2Txt);
        this.getContentPane().add(this.totalErrorsTxt);
        this.getContentPane().add(this.totalErrors2Txt);
        this.getContentPane().add(this.cancelBttn);
        this.pack();
        Toolkit.getDefaultToolkit().addPropertyChangeListener("win.frame.sizingBorderWidth", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ProgressGUI.this.setSize(ProgressGUI.this.getPreferredSize());
                        if (ProgressGUI.this.isVisible()) {
                            ProgressGUI.this.setVisible(true);
                        }
                        ProgressGUI.this.pack();
                    }
                });
            }
        });
    }

    private void addListeners() {
        this.cancelBttn.addActionListener(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ProgressGUI.this.close();
            }
        });
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Component component = (Component)actionEvent.getSource();
        if (component == this.cancelBttn) {
            this.close();
        }
    }

    protected void close() {
        this.converter.stopConversion();
        this.setVisible(false);
        this.dispose();
    }

    public void converterProgressUpdate(ConverterProgressEvent converterProgressEvent) {
        this.processing2Txt.setText(converterProgressEvent.getStatusText());
        this.folder2Txt.setText(converterProgressEvent.getSourcePath());
        this.file2Txt.setText(converterProgressEvent.getCurrentFile());
        this.totalFiles2Txt.setText(String.valueOf(converterProgressEvent.getFilesProcessed()));
        this.totalApplets2Txt.setText(String.valueOf(converterProgressEvent.getAppletsFound()));
        this.totalErrors2Txt.setText(String.valueOf(converterProgressEvent.getErrorsFound()));
        this.pack();
        if (converterProgressEvent.getStatus() == -14) {
            this.folder2Txt.setText("");
            this.file2Txt.setText("");
            this.cancelBttn.setText(ResourceHandler.getMessage("button.done"));
            this.cancelBttn.setMnemonic(ResourceHandler.getAcceleratorKey("button.done"));
        } else if (converterProgressEvent.getStatus() == -15) {
            // empty if block
        }
    }

    private final class ProgressGUITextArea
    extends JTextArea {
        public ProgressGUITextArea(ProgressGUI progressGUI2) {
            this.majorLayout(progressGUI2);
        }

        public ProgressGUITextArea(String string, ProgressGUI progressGUI2) {
            super(string);
            this.majorLayout(progressGUI2);
        }

        private void majorLayout(ProgressGUI progressGUI) {
            this.setEditable(false);
            Color color = progressGUI.getBackground();
            this.setBackground(color);
            HashSet<AWTKeyStroke> hashSet = new HashSet<AWTKeyStroke>();
            hashSet.add(AWTKeyStroke.getAWTKeyStroke(9, 0));
            HashSet<AWTKeyStroke> hashSet2 = new HashSet<AWTKeyStroke>();
            hashSet2.add(AWTKeyStroke.getAWTKeyStroke(9, 64));
            this.setFocusTraversalKeys(0, hashSet);
            this.setFocusTraversalKeys(1, hashSet2);
            this.addFocusListener(new ProgressGUIListener(this));
        }
    }

    private final class ProgressGUIListener
    extends FocusAdapter {
        private JTextArea textArea;

        public ProgressGUIListener(JTextArea jTextArea) {
            this.textArea = jTextArea;
        }

        public void focusGained(FocusEvent focusEvent) {
            this.textArea.getCaret().setVisible(true);
        }
    }
}

