/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.SecureRandom;
import com.ibm.crypto.pkcs11impl.provider.Signature;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.SignatureException;
import java.security.SignatureSpi;

public final class PKCS11SSLHashingwithDSA
extends SignatureSpi {
    private Signature sig;
    private byte[] hashData;
    private int count = 0;

    public PKCS11SSLHashingwithDSA(Provider provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        this.sig = new Signature(17, provider);
        this.hashData = new byte[128];
    }

    public PKCS11SSLHashingwithDSA() throws NoSuchAlgorithmException, NoSuchProviderException {
        this(Security.getProvider("IBMPKCS11Impl"));
    }

    protected void engineSetParameter(String string, Object object) {
    }

    protected Object engineGetParameter(String string) {
        return null;
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.count = 0;
        this.sig.engineInitSign(privateKey);
    }

    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.count = 0;
        this.sig.engineInitSign(privateKey);
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.count = 0;
        this.sig.engineInitVerify(publicKey);
    }

    protected void engineInitVerify(PublicKey publicKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.count = 0;
        this.sig.engineInitVerify(publicKey);
    }

    protected void engineUpdate(byte by) {
        if (this.count + 1 > this.hashData.length) {
            byte[] byArray = new byte[this.hashData.length + 128];
            System.arraycopy(this.hashData, 0, byArray, 0, this.hashData.length);
            this.hashData = byArray;
        }
        this.hashData[this.count] = by;
        ++this.count;
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) {
        if (this.count + (n2 - n) > this.hashData.length) {
            byte[] byArray2 = new byte[this.hashData.length + 128 + (n2 - n)];
            System.arraycopy(this.hashData, 0, byArray2, 0, this.hashData.length);
            this.hashData = byArray2;
        }
        System.arraycopy(byArray, n, this.hashData, this.count, n2 - n);
        this.count += n2 - n;
    }

    protected byte[] engineSign() throws SignatureException {
        byte[] byArray = this.sig.engineSign(this.hashData, this.count);
        this.count = 0;
        try {
            byte[] byArray2 = new byte[20];
            byte[] byArray3 = new byte[20];
            System.arraycopy(byArray, 0, byArray2, 0, 20);
            System.arraycopy(byArray, 20, byArray3, 0, 20);
            DerOutputStream derOutputStream = new DerOutputStream(100);
            derOutputStream.putInteger(new BigInteger(1, byArray2));
            derOutputStream.putInteger(new BigInteger(1, byArray3));
            DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
            return derValue.toByteArray();
        }
        catch (IOException iOException) {
            throw new SignatureException("error encoding signature");
        }
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        byte[] byArray2 = new byte[40];
        try {
            DerInputStream derInputStream = new DerInputStream(byArray);
            DerValue[] derValueArray = derInputStream.getSequence(2);
            byte[] byArray3 = derValueArray[0].getInteger().toByteArray();
            byte[] byArray4 = derValueArray[1].getInteger().toByteArray();
            int n = byArray3.length;
            if (n > 20) {
                System.arraycopy(byArray3, n - 20, byArray2, 0, 20);
            } else {
                System.arraycopy(byArray3, 0, byArray2, 20 - n, n);
            }
            n = byArray4.length;
            if (n > 20) {
                System.arraycopy(byArray4, n - 20, byArray2, 20, 20);
            } else {
                System.arraycopy(byArray4, 0, byArray2, 40 - n, n);
            }
        }
        catch (IOException iOException) {
            throw new SignatureException("invalid encoding for signature :" + iOException);
        }
        boolean bl = this.sig.engineVerify(byArray2, this.hashData, this.count);
        this.count = 0;
        return bl;
    }
}

