/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.DSAPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.GeneralKey;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11DESKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11DESedeKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11DSAPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11DSAPublicKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11Key;
import com.ibm.crypto.pkcs11impl.provider.PKCS11PrivateKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11PublicKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11RSAPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11RSAPublicKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11SecretKey;
import com.ibm.crypto.pkcs11impl.provider.RSAPrivateKey;
import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CertImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathParameters;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.security.auth.callback.CallbackHandler;

public final class PKCS11KeyStore
extends KeyStoreSpi {
    private static Debug debug1 = Debug.getInstance((String)"pkcs11impl");
    private static Debug debug2 = Debug.getInstance((String)"pkcs11keystore");
    private static Debug debug = debug1 == null ? debug2 : debug1;
    private static String className = "com.ibm.crypto.pkcs11impl.provider.PKCS11KeyStore";
    private static Date returnDate = new Date(0L);
    private PKCS11Session session = null;
    private Hashtable entries = new Hashtable();
    private Provider provider;
    private String providerName = "IBMPKCS11Impl";

    public PKCS11KeyStore() {
        this.session = ((IBMPKCS11Impl)Security.getProvider(this.providerName)).getSession();
    }

    public PKCS11KeyStore(Provider provider) {
        this.session = ((IBMPKCS11Impl)provider).getSession();
        this.provider = provider;
        this.providerName = provider.getName();
    }

    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        Object v = this.entries.get(string.toLowerCase());
        if (v != null) {
            if (v instanceof PrivateKeyEntry) {
                return ((PrivateKeyEntry)v).key;
            }
            if (v instanceof SecretKeyEntry) {
                return ((SecretKeyEntry)v).key;
            }
        }
        return null;
    }

    public Certificate[] engineGetCertificateChain(String string) {
        Certificate[] certificateArray = null;
        Object v = this.entries.get(string.toLowerCase());
        if (v != null && v instanceof PrivateKeyEntry && ((PrivateKeyEntry)v).chain != null) {
            certificateArray = (Certificate[])((PrivateKeyEntry)v).chain.clone();
        }
        return certificateArray;
    }

    public Certificate engineGetCertificate(String string) {
        Certificate certificate = null;
        Object v = this.entries.get(string.toLowerCase());
        if (v != null) {
            if (v instanceof TrustedCertEntry) {
                certificate = ((TrustedCertEntry)v).cert;
            } else if (v instanceof PrivateKeyEntry && ((PrivateKeyEntry)v).chain != null) {
                certificate = ((PrivateKeyEntry)v).chain[0];
            }
        }
        return certificate;
    }

    public synchronized KeyStore.Entry engineGetEntry(String string, KeyStore.ProtectionParameter protectionParameter) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        Object v = this.entries.get(string.toLowerCase());
        if (v != null) {
            if (v instanceof PrivateKeyEntry) {
                PrivateKey privateKey = (PrivateKey)((PrivateKeyEntry)v).key;
                Certificate[] certificateArray = null;
                if (((PrivateKeyEntry)v).chain != null) {
                    certificateArray = (Certificate[])((PrivateKeyEntry)v).chain.clone();
                }
                return new KeyStore.PrivateKeyEntry(privateKey, certificateArray);
            }
            if (v instanceof SecretKeyEntry) {
                SecretKey secretKey = (SecretKey)((SecretKeyEntry)v).key;
                return new KeyStore.SecretKeyEntry(secretKey);
            }
            if (v instanceof TrustedCertEntry) {
                return new KeyStore.TrustedCertificateEntry(((TrustedCertEntry)v).cert);
            }
        }
        return null;
    }

    public synchronized void engineSetEntry(String string, KeyStore.Entry entry, KeyStore.ProtectionParameter protectionParameter) throws KeyStoreException {
        if (entry instanceof KeyStore.TrustedCertificateEntry) {
            Certificate certificate = ((KeyStore.TrustedCertificateEntry)entry).getTrustedCertificate();
            this.engineSetCertificateEntry(string, certificate);
        } else if (entry instanceof KeyStore.PrivateKeyEntry) {
            PrivateKey privateKey = ((KeyStore.PrivateKeyEntry)entry).getPrivateKey();
            Certificate[] certificateArray = ((KeyStore.PrivateKeyEntry)entry).getCertificateChain();
            char[] cArray = null;
            this.engineSetKeyEntry(string, privateKey, cArray, certificateArray);
        } else if (entry instanceof KeyStore.SecretKeyEntry) {
            KeyStore.SecretKeyEntry secretKeyEntry = (KeyStore.SecretKeyEntry)entry;
            SecretKey secretKey = secretKeyEntry.getSecretKey();
            char[] cArray = null;
            this.engineSetKeyEntry(string, secretKey, cArray, null);
        } else {
            throw new KeyStoreException(new UnsupportedOperationException("unsupported entry type: " + entry.getClass().getName()));
        }
    }

    public Date engineGetCreationDate(String string) {
        return returnDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineSetKeyEntry");
        }
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5 = null;
            if (this.engineIsCertificateEntry(string)) {
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineSetKeyEntry", "Alias exists for a certificate entry");
                    debug.exit(16384L, (Object)className, "engineSetKeyEntry");
                }
                throw new KeyStoreException("Alias exists for a certificate entry");
            }
            if (this.engineIsKeyEntry(string)) {
                object4 = null;
                object3 = this.entries.get(string.toLowerCase());
                if (object3 instanceof PrivateKeyEntry) {
                    object2 = (PrivateKeyEntry)object3;
                    object = (PKCS11PrivateKey)((PrivateKeyEntry)object2).key;
                    object4 = object.getObject();
                    this.deleteChain(object.getID());
                    if (key instanceof PKCS11PrivateKey && ((PKCS11PrivateKey)key).getObject() == object.getObject()) {
                        object4 = null;
                    }
                } else {
                    object2 = (SecretKeyEntry)object3;
                    object = (PKCS11SecretKey)((SecretKeyEntry)object2).key;
                    object4 = ((SecretKeyEntry)object2).keyObject;
                    if (key instanceof PKCS11SecretKey && ((PKCS11SecretKey)key).getObject() == object.getObject()) {
                        object4 = null;
                    }
                }
                if (object4 != null) {
                    object4.destroy();
                }
            }
            if (key instanceof PKCS11PrivateKey) {
                object4 = new PrivateKeyEntry();
                ((PrivateKeyEntry)object4).key = key;
                ((PrivateKeyEntry)object4).keyObject = ((PKCS11PrivateKey)key).getObject();
                if (!((Boolean)this.getValue(((PrivateKeyEntry)object4).keyObject, 1)).booleanValue()) {
                    object3 = this.makePrivKeyToken((PKCS11PrivateKey)key, string);
                    ((PrivateKeyEntry)object4).key = object3;
                    ((PrivateKeyEntry)object4).keyObject = object3.getObject();
                }
                ((PrivateKeyEntry)object4).chain = certificateArray != null && certificateArray[0] != null ? (Certificate[])certificateArray.clone() : null;
                this.addCertificateChain(string, ((PKCS11PrivateKey)key).getID(), ((PrivateKeyEntry)object4).chain, true);
                object5 = object4;
            } else if (key instanceof PKCS11SecretKey) {
                object4 = new SecretKeyEntry();
                ((SecretKeyEntry)object4).key = key;
                ((SecretKeyEntry)object4).keyObject = ((PKCS11SecretKey)key).getObject();
                if (!((Boolean)this.getValue(((SecretKeyEntry)object4).keyObject, 1)).booleanValue()) {
                    object3 = this.makeSecKeyToken((PKCS11SecretKey)key, string);
                    ((SecretKeyEntry)object4).key = object3;
                    ((SecretKeyEntry)object4).keyObject = object3.getObject();
                }
                object5 = object4;
            } else if (key instanceof PrivateKey) {
                block37: {
                    object4 = key.getAlgorithm();
                    object3 = null;
                    object2 = null;
                    try {
                        if (((String)object4).equalsIgnoreCase("DSA")) {
                            object2 = KeyFactory.getInstance("DSA", this.providerName);
                            object3 = (PKCS11PrivateKey)((KeyFactory)object2).translateKey(key);
                            break block37;
                        }
                        if (((String)object4).equalsIgnoreCase("RSA")) {
                            object2 = KeyFactory.getInstance("RSA", this.providerName);
                            object3 = (PKCS11PrivateKey)((KeyFactory)object2).translateKey(key);
                            break block37;
                        }
                        if (debug != null) {
                            debug.text(16384L, (Object)className, "engineSetKeyEntry", "Keystore can not handle this key algorithm: " + (String)object4);
                            debug.exit(16384L, (Object)className, "engineSetKeyEntry");
                        }
                        throw new KeyStoreException("Keystore can not handle this key algorithm: " + (String)object4);
                    }
                    catch (Exception exception) {
                        if (debug != null) {
                            debug.exception(16384L, (Object)className, "engineSetKeyEntry", (Throwable)exception);
                            debug.exit(16384L, (Object)className, "engineSetKeyEntry");
                        }
                        throw new KeyStoreException("Keystore can not handle this key: " + exception.getMessage());
                    }
                }
                object = new PrivateKeyEntry();
                ((PrivateKeyEntry)object).key = object3;
                ((PrivateKeyEntry)object).keyObject = object3.getObject();
                ((PrivateKeyEntry)object).chain = certificateArray != null && certificateArray[0] != null ? (Certificate[])certificateArray.clone() : null;
                if (((Boolean)this.getValue(((PrivateKeyEntry)object).keyObject, 1)).booleanValue()) {
                    this.addCertificateChain(string, object3.getID(), ((PrivateKeyEntry)object).chain, true);
                } else {
                    this.addCertificateChain(string, object3.getID(), ((PrivateKeyEntry)object).chain, false);
                }
                object5 = object;
            } else if (key instanceof SecretKey) {
                object4 = key.getAlgorithm();
                object3 = null;
                object2 = null;
                try {
                    if (!(((String)object4).equalsIgnoreCase("DES") || ((String)object4).equalsIgnoreCase("3DES") || ((String)object4).equalsIgnoreCase("DESede") || ((String)object4).equalsIgnoreCase("TripleDES") || ((String)object4).equalsIgnoreCase("ARCFOUR") || ((String)object4).equalsIgnoreCase("RC4") || ((String)object4).equalsIgnoreCase("Blowfish") || ((String)object4).equalsIgnoreCase("Generic") || ((String)object4).equalsIgnoreCase("AES"))) {
                        if (debug != null) {
                            debug.text(16384L, (Object)className, "engineSetKeyEntry", "Keystore can not handle this key algorithm: " + (String)object4);
                            debug.exit(16384L, (Object)className, "engineSetKeyEntry");
                        }
                        throw new KeyStoreException("Keystore can not handle this key algorithm: " + (String)object4);
                    }
                    object2 = SecretKeyFactory.getInstance((String)object4, this.providerName);
                    object3 = (PKCS11SecretKey)((SecretKeyFactory)object2).translateKey((SecretKey)key);
                }
                catch (Exception exception) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineSetKeyEntry", (Throwable)exception);
                        debug.exit(16384L, (Object)className, "engineSetKeyEntry");
                    }
                    throw new KeyStoreException("Keystore can not handle this key: " + exception.getMessage());
                }
                object = new SecretKeyEntry();
                ((SecretKeyEntry)object).key = object3;
                ((SecretKeyEntry)object).keyObject = object3.getObject();
                object5 = object;
            } else {
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineSetKeyEntry", "Invalid key type");
                    debug.exit(16384L, (Object)className, "engineSetKeyEntry");
                }
                throw new KeyStoreException("Invalid key type");
            }
            this.entries.put(string.toLowerCase(), object5);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineSetKeyEntry");
        }
    }

    private PKCS11PrivateKey makePrivKeyToken(PKCS11PrivateKey pKCS11PrivateKey, String string) throws KeyStoreException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "makePrivKeyToken", (Object)pKCS11PrivateKey, (Object)string);
        }
        PrivateKeyInfo privateKeyInfo = null;
        int[] nArray = new int[]{1, 2, 3, 257};
        Object[] objectArray = new Object[]{Boolean.TRUE, Boolean.TRUE, string, pKCS11PrivateKey.getSubject()};
        PKCS11Object pKCS11Object = null;
        try {
            pKCS11Object = pKCS11PrivateKey.getObject().copy(nArray, objectArray);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "makePrivKeyToken");
            }
        }
        catch (Exception exception) {
            PKCS11PrivateKey pKCS11PrivateKey2;
            if (debug != null) {
                debug.text(16384L, (Object)className, "makePrivKeyToken", "Create as a new key not a copy. " + exception.getMessage());
            }
            int[] nArray2 = null;
            Object[] objectArray2 = null;
            if (pKCS11PrivateKey instanceof PKCS11RSAPrivateKey) {
                pKCS11PrivateKey2 = (PKCS11RSAPrivateKey)pKCS11PrivateKey;
                int[] nArray3 = new int[]{0, 1, 2, 3, 256, 257, 258, 264, 265, 288, 291, 261, 268, 259, 296, 290, 292, 293, 294, 295};
                Object[] objectArray3 = new Object[]{PKCS11Object.PRIVATE_KEY, Boolean.TRUE, Boolean.TRUE, string, PKCS11Object.RSA, pKCS11PrivateKey2.getSubject(), pKCS11PrivateKey2.getID(), pKCS11PrivateKey2.getSign(), pKCS11PrivateKey2.getSignRecover(), pKCS11PrivateKey2.getModulus(), pKCS11PrivateKey2.getPrivateExponent(), pKCS11PrivateKey2.getDecrypt(), pKCS11PrivateKey2.getDerive(), pKCS11PrivateKey2.getSensitive(), pKCS11PrivateKey2.getCoefficient(), pKCS11PrivateKey2.getPublicExponent(), pKCS11PrivateKey2.getPrime1(), pKCS11PrivateKey2.getPrime2(), pKCS11PrivateKey2.getExponent1(), pKCS11PrivateKey2.getExponent2()};
                nArray2 = nArray3;
                objectArray2 = objectArray3;
            } else if (pKCS11PrivateKey instanceof PKCS11DSAPrivateKey) {
                pKCS11PrivateKey2 = (PKCS11DSAPrivateKey)pKCS11PrivateKey;
                int[] nArray4 = new int[]{17, 0, 1, 2, 3, 256, 257, 258, 264, 265, 306, 305, 304, 261, 268, 259};
                Object[] objectArray4 = new Object[]{pKCS11PrivateKey2.getValue().toByteArray(), PKCS11Object.PRIVATE_KEY, Boolean.TRUE, Boolean.TRUE, string, PKCS11Object.DSA, pKCS11PrivateKey2.getSubject(), pKCS11PrivateKey2.getID(), pKCS11PrivateKey2.getSign(), pKCS11PrivateKey2.getSignRecover(), pKCS11PrivateKey2.getBase(), pKCS11PrivateKey2.getSubprime(), pKCS11PrivateKey2.getPrime(), pKCS11PrivateKey2.getDecrypt(), pKCS11PrivateKey2.getDerive(), pKCS11PrivateKey2.getSensitive()};
                nArray2 = nArray4;
                objectArray2 = objectArray4;
            }
            try {
                pKCS11Object = this.session.createObject(nArray2, objectArray2);
            }
            catch (Exception exception2) {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "makePrivKeyToken", (Throwable)exception2);
                    debug.exit(16384L, (Object)className, "makePrivKeyToken");
                }
                throw new KeyStoreException(exception2.getMessage());
            }
        }
        try {
            if (pKCS11PrivateKey instanceof PKCS11RSAPrivateKey) {
                PKCS11RSAPrivateKey pKCS11RSAPrivateKey = (PKCS11RSAPrivateKey)pKCS11PrivateKey;
                privateKeyInfo = new RSAPrivateKey(this.session, pKCS11Object, pKCS11RSAPrivateKey.getID(), pKCS11RSAPrivateKey.getSubject(), string, Boolean.TRUE, pKCS11RSAPrivateKey.getSensitive(), pKCS11RSAPrivateKey.getSign(), pKCS11RSAPrivateKey.getDecrypt(), pKCS11RSAPrivateKey.getUnwrap(), pKCS11RSAPrivateKey.getExtractable(), pKCS11RSAPrivateKey.getModulus(), pKCS11RSAPrivateKey.getPublicExponent(), pKCS11RSAPrivateKey.getPrivateExponent(), pKCS11RSAPrivateKey.getPrime1(), pKCS11RSAPrivateKey.getPrime2(), pKCS11RSAPrivateKey.getExponent1(), pKCS11RSAPrivateKey.getExponent2(), pKCS11RSAPrivateKey.getCoefficient());
            } else if (pKCS11PrivateKey instanceof PKCS11DSAPrivateKey) {
                PKCS11DSAPrivateKey pKCS11DSAPrivateKey = (PKCS11DSAPrivateKey)pKCS11PrivateKey;
                privateKeyInfo = new DSAPrivateKey(this.session, pKCS11Object, string, pKCS11DSAPrivateKey.getID(), pKCS11DSAPrivateKey.getSubject(), Boolean.TRUE, pKCS11DSAPrivateKey.getSensitive(), pKCS11DSAPrivateKey.getExtractable(), pKCS11DSAPrivateKey.getPrime(), pKCS11DSAPrivateKey.getSubprime(), pKCS11DSAPrivateKey.getBase(), pKCS11DSAPrivateKey.getValue());
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "makePrivKeyToken", (Throwable)invalidKeyException);
                debug.exit(16384L, (Object)className, "makePrivKeyToken");
            }
            throw new KeyStoreException(invalidKeyException.getMessage());
        }
        pKCS11PrivateKey.getObject().destroy();
        return privateKeyInfo;
    }

    private PKCS11SecretKey makeSecKeyToken(PKCS11SecretKey pKCS11SecretKey, String string) throws KeyStoreException {
        Object object;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "makeSecKeyToken", (Object)pKCS11SecretKey, (Object)string);
        }
        int[] nArray = new int[]{1, 2, 3};
        Object[] objectArray = new Object[]{Boolean.TRUE, Boolean.TRUE, string};
        PKCS11Object pKCS11Object = null;
        try {
            pKCS11Object = pKCS11SecretKey.getObject().copy(nArray, objectArray);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "makeSecKeyToken", "Copy failed try to create token key");
            }
            try {
                Object object2;
                object = null;
                if (pKCS11SecretKey instanceof GeneralKey) {
                    object2 = (GeneralKey)pKCS11SecretKey;
                    object = ((GeneralKey)object2).getValue();
                } else if (pKCS11SecretKey instanceof PKCS11DESedeKey) {
                    object2 = (PKCS11DESedeKey)pKCS11SecretKey;
                    object = object2.getValue();
                } else if (pKCS11SecretKey instanceof PKCS11DESKey) {
                    object2 = (PKCS11DESKey)pKCS11SecretKey;
                    object = object2.getValue();
                }
                object2 = new int[]{0, 256, 258, 3, 2, 1, 259, 268, 260, 261, 262, 263, 17};
                Object[] objectArray2 = new Object[]{PKCS11Object.SECRET_KEY, pKCS11SecretKey.getKeyType(), pKCS11SecretKey.getID(), string, Boolean.TRUE, Boolean.TRUE, pKCS11SecretKey.getSensitive(), pKCS11SecretKey.getDerive(), pKCS11SecretKey.getEncrypt(), pKCS11SecretKey.getDecrypt(), pKCS11SecretKey.getWrap(), pKCS11SecretKey.getUnwrap(), object};
                pKCS11Object = this.session.createObject((int[])object2, objectArray2);
            }
            catch (PKCS11Exception pKCS11Exception) {
                if (pKCS11Object != null) {
                    pKCS11Object.destroy();
                }
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "makeSecKeyToken", (Throwable)pKCS11Exception);
                    debug.exit(16384L, (Object)className, "makeSecKeyToken");
                }
                throw new KeyStoreException(pKCS11Exception.getMessage());
            }
        }
        GeneralKey generalKey = null;
        try {
            if (pKCS11SecretKey instanceof GeneralKey) {
                object = (GeneralKey)pKCS11SecretKey;
                generalKey = new GeneralKey(this.session, pKCS11Object, ((GeneralKey)object).mechanismBuilder.getAlgorithm());
                pKCS11SecretKey.getObject().destroy();
            } else if (pKCS11SecretKey instanceof PKCS11DESKey) {
                generalKey = new GeneralKey(this.session, pKCS11Object, "DES");
                pKCS11SecretKey.getObject().destroy();
            } else if (pKCS11SecretKey instanceof PKCS11DESedeKey) {
                generalKey = new GeneralKey(this.session, pKCS11Object, "DESede");
                pKCS11SecretKey.getObject().destroy();
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "makeSecKeyToken", (Throwable)invalidKeyException);
                debug.exit(16384L, (Object)className, "makeSecKeyToken");
            }
            throw new KeyStoreException(invalidKeyException.getMessage());
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "makeSecKeyToken");
        }
        return generalKey;
    }

    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineSetKeyEntry");
            debug.text(16384L, (Object)className, "engineSetKeyEntry", "This method is not supported");
            debug.exit(16384L, (Object)className, "engineSetKeyEntry");
        }
        throw new KeyStoreException("This method is not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineSetCertificateEntry", (Object)string, (Object)certificate);
        }
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            Object object;
            Object v = this.entries.get(string.toLowerCase());
            if (v != null && (v instanceof PrivateKeyEntry || v instanceof SecretKeyEntry)) {
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineSetCertificateEntry", "Cannot overwrite key entry");
                    debug.exit(16384L, (Object)className, "engineSetCertificateEntry");
                }
                throw new KeyStoreException("Cannot overwrite key entry");
            }
            PKCS11Object pKCS11Object = null;
            if (certificate instanceof X509Certificate) {
                Object object2;
                object = null;
                byte[] byArray = null;
                try {
                    byArray = string.getBytes("8859_1");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    byArray = string.getBytes();
                }
                byte[] byArray2 = null;
                BigInteger bigInteger = null;
                DerOutputStream derOutputStream = null;
                if (byArray.length > 20) {
                    object2 = new byte[20];
                    System.arraycopy(byArray, 0, object2, 0, 20);
                    byArray = object2;
                }
                try {
                    object2 = CertificateFactory.getInstance("X509", this.providerName);
                    if (certificate instanceof X509CertImpl) {
                        X509CertImpl x509CertImpl = (X509CertImpl)certificate;
                        derOutputStream = new DerOutputStream();
                        ((X500Name)x509CertImpl.getSubjectDN()).encode(derOutputStream);
                        object = derOutputStream.toByteArray();
                        derOutputStream = new DerOutputStream();
                        ((X500Name)x509CertImpl.getIssuerDN()).encode(derOutputStream);
                        byArray2 = derOutputStream.toByteArray();
                        bigInteger = x509CertImpl.getSerialNumber();
                        pKCS11Object = this.createCertObject(string, Boolean.TRUE, x509CertImpl.getEncoded(), (byte[])object, byArray, byArray2, bigInteger);
                    }
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(certificate.getEncoded());
                    X509CertImpl x509CertImpl = (X509CertImpl)((CertificateFactory)object2).generateCertificate(byteArrayInputStream);
                    derOutputStream = new DerOutputStream();
                    ((X500Name)x509CertImpl.getSubjectDN()).encode(derOutputStream);
                    object = derOutputStream.toByteArray();
                    derOutputStream = new DerOutputStream();
                    ((X500Name)x509CertImpl.getIssuerDN()).encode(derOutputStream);
                    bigInteger = x509CertImpl.getSerialNumber();
                    pKCS11Object = this.createCertObject(string, Boolean.TRUE, x509CertImpl.getEncoded(), (byte[])object, byArray, byArray2, bigInteger);
                }
                catch (Exception exception) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineSetCertificateEntry", (Throwable)exception);
                        debug.exit(16384L, (Object)className, "engineSetCertificateEntry");
                    }
                    throw new KeyStoreException("Cannot store certificate :" + exception.getMessage());
                }
            } else {
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineSetCertificateEntry", "Unsupported certificate type. Only X509 certificate is supported");
                    debug.exit(16384L, (Object)className, "engineSetCertificateEntry");
                }
                throw new KeyStoreException("Unsupported certificate type. Only X509 certificate is supported");
            }
            object = new TrustedCertEntry();
            object.cert = certificate;
            object.certObject = pKCS11Object;
            this.entries.put(string.toLowerCase(), object);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineSetCertificateEntry");
        }
    }

    private void addCertificateChain(String string, byte[] byArray, Certificate[] certificateArray, boolean bl) throws KeyStoreException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "addCertificateChain", (Object)string, (Object)bl);
        }
        int[] nArray = new int[]{1, 0, 257, 130};
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        BigInteger bigInteger = null;
        DerOutputStream derOutputStream = null;
        X509CertImpl x509CertImpl = null;
        if (certificateArray == null) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "addCertificateChain", "cert chain is null");
                debug.exit(16384L, (Object)className, "addCertificateChain");
            }
            return;
        }
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X509", this.providerName);
            if (certificateArray[0] instanceof X509CertImpl) {
                x509CertImpl = (X509CertImpl)certificateArray[0];
                derOutputStream = new DerOutputStream();
                ((X500Name)x509CertImpl.getSubjectDN()).encode(derOutputStream);
                byArray2 = derOutputStream.toByteArray();
                derOutputStream = new DerOutputStream();
                ((X500Name)x509CertImpl.getIssuerDN()).encode(derOutputStream);
                byArray3 = derOutputStream.toByteArray();
                bigInteger = x509CertImpl.getSerialNumber();
            } else {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(certificateArray[0].getEncoded());
                x509CertImpl = (X509CertImpl)certificateFactory.generateCertificate(byteArrayInputStream);
                derOutputStream = new DerOutputStream();
                ((X500Name)x509CertImpl.getSubjectDN()).encode(derOutputStream);
                byArray2 = derOutputStream.toByteArray();
                derOutputStream = new DerOutputStream();
                ((X500Name)x509CertImpl.getIssuerDN()).encode(derOutputStream);
                bigInteger = x509CertImpl.getSerialNumber();
            }
            if (debug != null) {
                debug.text(16384L, (Object)className, "addCertificateChain", "Alias = " + string);
                debug.text(16384L, (Object)className, "addCertificateChain", "id = " + new HexDumpEncoder().encode(byArray));
            }
            this.createCertObject(string, Boolean.TRUE, x509CertImpl.getEncoded(), byArray2, byArray, byArray3, bigInteger);
            for (int i = 1; i < certificateArray.length; ++i) {
                Object[] objectArray;
                if (certificateArray[i] instanceof X509CertImpl) {
                    x509CertImpl = (X509CertImpl)certificateArray[i];
                    derOutputStream = new DerOutputStream();
                    ((X500Name)x509CertImpl.getSubjectDN()).encode(derOutputStream);
                    byArray2 = derOutputStream.toByteArray();
                    derOutputStream = new DerOutputStream();
                    ((X500Name)x509CertImpl.getIssuerDN()).encode(derOutputStream);
                    byArray3 = derOutputStream.toByteArray();
                    bigInteger = x509CertImpl.getSerialNumber();
                } else {
                    objectArray = new ByteArrayInputStream(certificateArray[i].getEncoded());
                    x509CertImpl = (X509CertImpl)certificateFactory.generateCertificate((InputStream)objectArray);
                    derOutputStream = new DerOutputStream();
                    ((X500Name)x509CertImpl.getSubjectDN()).encode(derOutputStream);
                    byArray2 = derOutputStream.toByteArray();
                    derOutputStream = new DerOutputStream();
                    ((X500Name)x509CertImpl.getIssuerDN()).encode(derOutputStream);
                    bigInteger = x509CertImpl.getSerialNumber();
                }
                objectArray = new Object[]{Boolean.TRUE, PKCS11Object.CERTIFICATE, byArray2, bigInteger.toByteArray()};
                this.session.findObjectsInit(nArray, objectArray);
                PKCS11Object pKCS11Object = this.session.findObject();
                this.session.findObjectsFinal();
                if (debug != null) {
                    debug.text(16384L, (Object)className, "addCertificateChain", "pkcs11obj = " + pKCS11Object);
                }
                if (pKCS11Object != null) continue;
                this.createCertObject(string, Boolean.TRUE, x509CertImpl.getEncoded(), byArray2, byArray, byArray3, bigInteger);
            }
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "addCertificateChain", (Throwable)exception);
                debug.exit(16384L, (Object)className, "addCertificateChain");
            }
            throw new KeyStoreException(exception.getMessage());
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "addCertificateChain");
        }
    }

    private PKCS11Object createCertObject(String string, Boolean bl, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, BigInteger bigInteger) throws KeyStoreException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "createCertObject", (Object)string, (Object)bl);
        }
        int[] nArray = new int[]{0, 1, 2, 3, 128, 258, 257, 130, 17, 129};
        Object[] objectArray = new Object[]{PKCS11Object.CERTIFICATE, bl, Boolean.FALSE, string, PKCS11Object.X_509, byArray3, byArray2, bigInteger.toByteArray(), byArray, byArray4};
        PKCS11Object pKCS11Object = null;
        try {
            pKCS11Object = this.session.createObject(nArray, objectArray);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "createCertObject", (Throwable)exception);
                debug.exit(16384L, (Object)className, "createCertObject");
            }
            throw new KeyStoreException("Cannot store certificate: " + exception.getMessage());
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "createCertObject");
        }
        return pKCS11Object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineDeleteEntry(String string) throws KeyStoreException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineDeleteEntry", (Object)string);
        }
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            if (this.engineIsKeyEntry(string)) {
                Object v = this.entries.get(string.toLowerCase());
                if (v instanceof PrivateKeyEntry) {
                    PrivateKeyEntry privateKeyEntry = (PrivateKeyEntry)v;
                    this.deleteKey((PKCS11Key)privateKeyEntry.key, PKCS11Object.PRIVATE_KEY);
                    this.deletePublicKey(privateKeyEntry.chain, (PKCS11Key)privateKeyEntry.key);
                    this.deleteChain(((PKCS11Key)privateKeyEntry.key).getID());
                } else {
                    SecretKeyEntry secretKeyEntry = (SecretKeyEntry)v;
                    this.deleteKey((PKCS11Key)secretKeyEntry.key, PKCS11Object.SECRET_KEY);
                }
            } else if (this.engineIsCertificateEntry(string)) {
                TrustedCertEntry trustedCertEntry = (TrustedCertEntry)this.entries.get(string.toLowerCase());
                trustedCertEntry.certObject.destroy();
            }
            this.entries.remove(string.toLowerCase());
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineDeleteEntry");
        }
    }

    private void deleteKey(PKCS11Key pKCS11Key, int n) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "deleteKey", (Object)pKCS11Key, (Object)n);
        }
        PKCS11Object pKCS11Object = null;
        pKCS11Key.getObject().destroy();
        int n2 = 5;
        String string = pKCS11Key.getLabel();
        byte[] byArray = pKCS11Key.getID();
        if (string == null) {
            --n2;
        }
        if (byArray == null || byArray.length == 0) {
            --n2;
        }
        int[] nArray = new int[n2];
        Object[] objectArray = new Object[n2];
        int n3 = 0;
        nArray[n3] = 1;
        objectArray[n3] = Boolean.FALSE;
        nArray[++n3] = 0;
        objectArray[n3] = n;
        nArray[++n3] = 2;
        objectArray[n3] = Boolean.FALSE;
        ++n3;
        if (string != null) {
            nArray[n3] = 3;
            objectArray[n3] = string;
            ++n3;
        }
        if (byArray != null && byArray.length > 0) {
            nArray[n3] = 258;
            objectArray[n3] = byArray;
        }
        this.session.findObjectsInit(nArray, objectArray);
        pKCS11Object = this.session.findObject();
        this.session.findObjectsFinal();
        if (pKCS11Object == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "deleteKey", (Object)"No Session object found.");
            }
            return;
        }
        pKCS11Object.destroy();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "deleteKey", (Object)"Session object found.");
        }
    }

    private void deletePublicKey(Certificate[] certificateArray, PKCS11Key pKCS11Key) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "deletePublicKey", (Object)certificateArray, (Object)pKCS11Key);
        }
        PKCS11Object pKCS11Object = null;
        int[] nArray = null;
        Object[] objectArray = null;
        if (certificateArray == null || certificateArray[0] == null) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "deletePublicKey", "No cert associated with private key.");
            }
            int[] nArray2 = new int[]{1, 256, 0, 3, 258};
            Object[] objectArray2 = new Object[]{Boolean.TRUE, pKCS11Key.getKeyType(), PKCS11Object.PUBLIC_KEY, pKCS11Key.getLabel(), pKCS11Key.getID()};
            this.session.findObjectsInit(nArray2, objectArray2);
            pKCS11Object = this.session.findObject();
            this.session.findObjectsFinal();
            if (pKCS11Object == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "deletePublicKey", (Object)"No object found.");
                }
                return;
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "deletePublicKey", (Object)("Object = " + pKCS11Object));
            }
            pKCS11Object.destroy();
            if (debug != null) {
                debug.exit(16384L, (Object)className, "deletePublicKey", (Object)"Object found.");
            }
            return;
        }
        PKCS11PublicKey pKCS11PublicKey = (PKCS11PublicKey)((X509Certificate)certificateArray[0]).getPublicKey();
        if (pKCS11PublicKey.getKeyType() == PKCS11Object.RSA) {
            PKCS11RSAPublicKey pKCS11RSAPublicKey = (PKCS11RSAPublicKey)pKCS11PublicKey;
            int[] nArray3 = new int[]{1, 256, 0, 288, 290, 3, 258};
            Object[] objectArray3 = new Object[]{Boolean.TRUE, PKCS11Object.RSA, PKCS11Object.PUBLIC_KEY, pKCS11RSAPublicKey.getModulus(), pKCS11RSAPublicKey.getPublicExponent(), pKCS11Key.getLabel(), pKCS11Key.getID()};
            nArray = nArray3;
            objectArray = objectArray3;
        } else if (pKCS11PublicKey.getKeyType() == PKCS11Object.DSA) {
            PKCS11DSAPublicKey pKCS11DSAPublicKey = (PKCS11DSAPublicKey)pKCS11PublicKey;
            int[] nArray4 = new int[]{1, 256, 0, 304, 305, 306, 17, 3, 258};
            Object[] objectArray4 = new Object[]{Boolean.TRUE, PKCS11Object.DSA, PKCS11Object.PUBLIC_KEY, pKCS11DSAPublicKey.getPrime(), pKCS11DSAPublicKey.getSubprime(), pKCS11DSAPublicKey.getBase(), pKCS11DSAPublicKey.getValue(), pKCS11Key.getLabel(), pKCS11Key.getID()};
            nArray = nArray4;
            objectArray = objectArray4;
        } else {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "deletePublicKey", (Object)"Key type not RSA or DSA");
            }
            return;
        }
        this.session.findObjectsInit(nArray, objectArray);
        pKCS11Object = this.session.findObject();
        this.session.findObjectsFinal();
        if (pKCS11Object == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "deletePublicKey", (Object)"No object found.");
            }
            return;
        }
        pKCS11Object.destroy();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "deletePublicKey", (Object)"Object found.");
        }
    }

    private void deleteChain(byte[] byArray) {
        int[] nArray = new int[]{1, 0, 258};
        int[] nArray2 = new int[]{1, 0, 257};
        int[] nArray3 = new int[]{1, 0, 129};
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        PKCS11Object pKCS11Object = null;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "deleteChain", (Object)new HexDumpEncoder().encode(byArray));
        }
        Object[] objectArray = new Object[]{Boolean.TRUE, PKCS11Object.CERTIFICATE, byArray};
        this.session.findObjectsInit(nArray, objectArray);
        pKCS11Object = this.session.findObject();
        this.session.findObjectsFinal();
        if (pKCS11Object == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "deleteChain", (Object)"Delete Cert not found.");
            }
            return;
        }
        if (debug != null) {
            debug.text(16384L, (Object)className, "deleteChain", "Delete Cert found.");
        }
        byArray2 = (byte[])this.getValue(pKCS11Object, 257);
        byArray3 = (byte[])this.getValue(pKCS11Object, 129);
        pKCS11Object.destroy();
        if (this.bytesEquals(byArray3, byArray2)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "deleteChain", (Object)"Deleted Cert self-signed.");
            }
            return;
        }
        byArray2 = byArray3;
        while (true) {
            Object[] objectArray2 = new Object[]{Boolean.TRUE, PKCS11Object.CERTIFICATE, byArray3};
            this.session.findObjectsInit(nArray2, objectArray2);
            pKCS11Object = this.session.findObject();
            this.session.findObjectsFinal();
            if (debug != null) {
                debug.text(16384L, (Object)className, "deleteChain", "Delete Chain Cert pkcs11obj = " + pKCS11Object);
            }
            if (pKCS11Object == null) {
                if (debug != null) {
                    debug.text(16384L, (Object)className, "deleteChain", "Certificate chain deletion error. Certificate not found");
                    debug.exit(16384L, (Object)className, "deleteChain");
                }
                throw new RuntimeException("Certificate chain deletion error. Certificate not found");
            }
            byArray2 = (byte[])this.getValue(pKCS11Object, 257);
            byArray3 = (byte[])this.getValue(pKCS11Object, 129);
            Object[] objectArray3 = new Object[]{Boolean.TRUE, PKCS11Object.CERTIFICATE, byArray2};
            this.session.findObjectsInit(nArray3, objectArray3);
            PKCS11Object pKCS11Object2 = this.session.findObject();
            this.session.findObjectsFinal();
            if (this.bytesEquals(byArray3, byArray2)) {
                if (debug == null) break;
                debug.text(16384L, (Object)className, "deleteChain", "Delete Chain Cert is self-signed.");
                break;
            }
            byArray2 = byArray3;
            if (debug != null) {
                debug.text(16384L, (Object)className, "deleteChain", "Delete Chain Cert delete = " + pKCS11Object2);
            }
            if (pKCS11Object2 != null) continue;
            pKCS11Object.destroy();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "deleteChain");
        }
    }

    public Enumeration engineAliases() {
        return this.entries.keys();
    }

    public boolean engineContainsAlias(String string) {
        return this.entries.containsKey(string.toLowerCase());
    }

    public int engineSize() {
        return this.entries.size();
    }

    public boolean engineIsKeyEntry(String string) {
        boolean bl = false;
        Object v = this.entries.get(string.toLowerCase());
        if (v != null && (v instanceof PrivateKeyEntry || v instanceof SecretKeyEntry)) {
            bl = true;
        }
        return bl;
    }

    public boolean engineIsCertificateEntry(String string) {
        boolean bl = false;
        Object v = this.entries.get(string.toLowerCase());
        if (v != null && v instanceof TrustedCertEntry) {
            bl = true;
        }
        return bl;
    }

    public String engineGetCertificateAlias(Certificate certificate) {
        Enumeration enumeration = this.entries.keys();
        while (enumeration.hasMoreElements()) {
            Certificate certificate2;
            String string = (String)enumeration.nextElement();
            Object v = this.entries.get(string);
            if (v instanceof TrustedCertEntry) {
                certificate2 = ((TrustedCertEntry)v).cert;
            } else {
                if (!(v instanceof PrivateKeyEntry) || ((PrivateKeyEntry)v).chain == null) continue;
                certificate2 = ((PrivateKeyEntry)v).chain[0];
            }
            if (!certificate2.equals(certificate)) continue;
            return string;
        }
        return null;
    }

    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        throw new IOException("This method is not supported");
    }

    public void engineLoad(KeyStore.LoadStoreParameter loadStoreParameter) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (loadStoreParameter == null) {
            throw new IllegalArgumentException("LoadStoreParameter must not be null");
        }
        KeyStore.ProtectionParameter protectionParameter = loadStoreParameter.getProtectionParameter();
        if (protectionParameter instanceof KeyStore.PasswordProtection) {
            char[] cArray = ((KeyStore.PasswordProtection)protectionParameter).getPassword();
            this.engineLoad(null, cArray);
        } else if (protectionParameter instanceof KeyStore.CallbackHandlerProtection) {
            CallbackHandler callbackHandler = ((KeyStore.CallbackHandlerProtection)protectionParameter).getCallbackHandler();
            Provider provider = Security.getProvider(this.providerName);
            try {
                ((IBMPKCS11Impl)provider).login(null, callbackHandler);
            }
            catch (PKCS11Exception pKCS11Exception) {
                if (pKCS11Exception.getCode() != 256) {
                    throw new IOException(pKCS11Exception.getMessage());
                }
            }
            catch (Exception exception) {
                throw new IOException(exception.getMessage());
            }
            this.engineLoad(null, null);
        } else {
            throw new IllegalArgumentException("ProtectionParameter must be aPasswordProtection or CallbackHandlerProtection");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineLoad");
        }
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            String string;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            String string2;
            int n;
            Object object5;
            CertificateFactory certificateFactory;
            Object object6;
            PKCS11Object pKCS11Object;
            block118: {
                if (cArray != null) {
                    block117: {
                        try {
                            this.session.login(false, (Object)new String(cArray));
                        }
                        catch (PKCS11Exception pKCS11Exception) {
                            if (pKCS11Exception.getCode() == 256) break block117;
                            throw new IOException(pKCS11Exception.getMessage());
                        }
                    }
                    cArray = null;
                }
                this.entries.clear();
                pKCS11Object = null;
                object6 = null;
                certificateFactory = null;
                try {
                    certificateFactory = CertificateFactory.getInstance("X509", this.providerName);
                }
                catch (Exception exception) {
                    if (debug == null) break block118;
                    exception.printStackTrace();
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "engineLoad");
                    }
                    System.exit(1);
                }
            }
            Vector<PKCS11Object> vector = new Vector<PKCS11Object>();
            Vector<PKCS11Object> vector2 = new Vector<PKCS11Object>();
            Vector<PKCS11Object> vector3 = new Vector<PKCS11Object>();
            this.session.findObjectsInit(null, null);
            while ((pKCS11Object = this.session.findObject()) != null) {
                object6 = this.getValue(pKCS11Object, 0);
                if (object6 != null && ((Integer)object6).equals(PKCS11Object.PRIVATE_KEY)) {
                    if (debug != null) {
                        debug.text(16384L, (Object)className, "engineLoad", "found PRIVATE KEY");
                    }
                    vector.add(pKCS11Object);
                    continue;
                }
                if (object6 != null && ((Integer)object6).equals(PKCS11Object.CERTIFICATE)) {
                    if (debug != null) {
                        debug.text(16384L, (Object)className, "engineLoad", "found CERTIFICATE");
                    }
                    vector3.add(pKCS11Object);
                    continue;
                }
                if (object6 == null || !((Integer)object6).equals(PKCS11Object.SECRET_KEY)) continue;
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineLoad", "found SECRET_KEY");
                }
                vector2.add(pKCS11Object);
            }
            if (debug != null) {
                debug.text(16384L, (Object)className, "engineLoad", "# privkeys=" + vector.size() + " # certs=" + vector3.size() + " # secret keys=" + vector2.size());
            }
            String string3 = "privateKey";
            int n2 = 0;
            int n3 = 0;
            if (vector.size() > 0) {
                object5 = vector.elements();
                n = 0;
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineLoad", "now find key and certs");
                }
                while (object5.hasMoreElements()) {
                    Object object7;
                    X509Certificate[] x509CertificateArray;
                    PrivateKeyInfo privateKeyInfo;
                    PKCS11Object pKCS11Object2;
                    block122: {
                        Object object8;
                        Object object9;
                        Object object10;
                        Object object11;
                        Object object12;
                        Object object13;
                        block119: {
                            pKCS11Object2 = (PKCS11Object)object5.nextElement();
                            string2 = (String)this.getValue(pKCS11Object2, 3);
                            object4 = (byte[])this.getValue(pKCS11Object2, 258);
                            object3 = (byte[])this.getValue(pKCS11Object2, 257);
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineLoad", "within the private key loop");
                            }
                            object2 = "e";
                            if (object4 == null) continue;
                            object = (Integer)this.getValue(pKCS11Object2, 256);
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineLoad", "Key Type=" + ((Integer)object).toString());
                            }
                            privateKeyInfo = null;
                            if (((Integer)object).equals(PKCS11Object.RSA)) {
                                try {
                                    if (debug != null) {
                                        debug.text(16384L, (Object)className, "engineLoad", "Constructure RSA(...) clear");
                                    }
                                    privateKeyInfo = new RSAPrivateKey(this.session, pKCS11Object2, (byte[])this.getValue(pKCS11Object2, 258), (byte[])this.getValue(pKCS11Object2, 257), (String)this.getValue(pKCS11Object2, 3), (Boolean)this.getValue(pKCS11Object2, 1), (Boolean)this.getValue(pKCS11Object2, 259), (Boolean)this.getValue(pKCS11Object2, 264), (Boolean)this.getValue(pKCS11Object2, 261), (Boolean)this.getValue(pKCS11Object2, 263), (Boolean)this.getValue(pKCS11Object2, 354), (BigInteger)this.getValue(pKCS11Object2, 288), (BigInteger)this.getValue(pKCS11Object2, 290), (BigInteger)this.getValue(pKCS11Object2, 291), (BigInteger)this.getValue(pKCS11Object2, 292), (BigInteger)this.getValue(pKCS11Object2, 293), (BigInteger)this.getValue(pKCS11Object2, 294), (BigInteger)this.getValue(pKCS11Object2, 295), (BigInteger)this.getValue(pKCS11Object2, 296));
                                }
                                catch (Exception exception) {
                                    try {
                                        if (debug != null) {
                                            debug.text(16384L, (Object)className, "engineLoad", "Constructure RSA() hardware");
                                        }
                                        privateKeyInfo = new RSAPrivateKey(this.session, pKCS11Object2, (byte[])this.getValue(pKCS11Object2, 258), (byte[])this.getValue(pKCS11Object2, 257), (String)this.getValue(pKCS11Object2, 3), (Boolean)this.getValue(pKCS11Object2, 1), (Boolean)this.getValue(pKCS11Object2, 259), (Boolean)this.getValue(pKCS11Object2, 264), (Boolean)this.getValue(pKCS11Object2, 261), (Boolean)this.getValue(pKCS11Object2, 263), (Boolean)this.getValue(pKCS11Object2, 354), (BigInteger)this.getValue(pKCS11Object2, 288), (BigInteger)this.getValue(pKCS11Object2, 290));
                                        break block119;
                                    }
                                    catch (InvalidKeyException invalidKeyException) {
                                        if (debug != null) {
                                            debug.exception(16384L, (Object)className, "engineLoad_2", (Throwable)invalidKeyException);
                                        }
                                        break block119;
                                    }
                                }
                            }
                            if (!((Integer)object).equals(PKCS11Object.DSA)) continue;
                            try {
                                if (debug != null) {
                                    debug.text(16384L, (Object)className, "engineLoad", "Constructure DSA(...) clear");
                                }
                                privateKeyInfo = new DSAPrivateKey(this.session, pKCS11Object2, (String)this.getValue(pKCS11Object2, 3), (byte[])this.getValue(pKCS11Object2, 258), (byte[])this.getValue(pKCS11Object2, 257), (Boolean)this.getValue(pKCS11Object2, 1), (Boolean)this.getValue(pKCS11Object2, 259), (Boolean)this.getValue(pKCS11Object2, 354), (BigInteger)this.getValue(pKCS11Object2, 304), (BigInteger)this.getValue(pKCS11Object2, 305), (BigInteger)this.getValue(pKCS11Object2, 306), new BigInteger(1, (byte[])this.getValue(pKCS11Object2, 17)));
                            }
                            catch (Exception exception) {
                                try {
                                    if (debug != null) {
                                        debug.text(16384L, (Object)className, "engineLoad", "Constructure DSA() hardware");
                                    }
                                    privateKeyInfo = new DSAPrivateKey(this.session, pKCS11Object2, (String)this.getValue(pKCS11Object2, 3), (byte[])this.getValue(pKCS11Object2, 258), (byte[])this.getValue(pKCS11Object2, 257), (Boolean)this.getValue(pKCS11Object2, 1), (Boolean)this.getValue(pKCS11Object2, 259), (Boolean)this.getValue(pKCS11Object2, 354));
                                }
                                catch (InvalidKeyException invalidKeyException) {
                                    if (debug == null) break block119;
                                    debug.exception(16384L, (Object)className, "engineLoad_3", (Throwable)invalidKeyException);
                                }
                            }
                        }
                        int n4 = vector3.size();
                        Enumeration enumeration = vector3.elements();
                        string = null;
                        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
                        HashSet<TrustAnchor> hashSet = new HashSet<TrustAnchor>();
                        X509Certificate x509Certificate = null;
                        X509Certificate x509Certificate2 = null;
                        x509CertificateArray = null;
                        byte[] byArray = "testmessage_a very long test message".getBytes();
                        for (int i = 0; i < n4; ++i) {
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineLoad", "going through cert objects");
                            }
                            string = (PKCS11Object)enumeration.nextElement();
                            object13 = (byte[])this.getValue((PKCS11Object)string, 258);
                            object7 = (byte[])this.getValue((PKCS11Object)string, 257);
                            object12 = (byte[])this.getValue((PKCS11Object)string, 17);
                            object11 = new ByteArrayInputStream((byte[])object12);
                            x509Certificate2 = (X509Certificate)certificateFactory.generateCertificate((InputStream)object11);
                            if (object13 != null && this.bytesEquals((byte[])object4, (byte[])object13)) {
                                block121: {
                                    block120: {
                                        object10 = x509Certificate2.getPublicKey();
                                        object9 = null;
                                        try {
                                            object9 = Signature.getInstance(privateKeyInfo.getAlgorithm(), this.providerName);
                                        }
                                        catch (Exception exception) {
                                            object9 = Signature.getInstance(privateKeyInfo.getAlgorithm());
                                            if (debug == null) break block120;
                                            debug.text(16384L, (Object)className, "engineLoad", "Error creating signature: " + exception.getMessage());
                                        }
                                    }
                                    try {
                                        ((Signature)object9).initSign((PrivateKey)privateKeyInfo);
                                        ((Signature)object9).update(byArray);
                                        object8 = ((Signature)object9).sign();
                                        ((Signature)object9).initVerify((PublicKey)object10);
                                        ((Signature)object9).update(byArray);
                                        if (((Signature)object9).verify((byte[])object8)) {
                                            x509Certificate = x509Certificate2;
                                        }
                                    }
                                    catch (Exception exception) {
                                        if (debug == null) break block121;
                                        debug.text(16384L, (Object)className, "engineLoad", "Error checking signature: " + exception.getMessage());
                                    }
                                }
                                if (debug != null) {
                                    debug.text(16384L, (Object)className, "engineLoad", "found cert at pos" + i + " # of certs now = " + arrayList.size());
                                    debug.text(16384L, (Object)className, "engineLoad", "found cert = " + x509Certificate);
                                }
                            }
                            arrayList.add(x509Certificate2);
                            hashSet.add(new TrustAnchor(x509Certificate2, null));
                        }
                        if (x509Certificate != null) {
                            try {
                                CertPathBuilder certPathBuilder = CertPathBuilder.getInstance("PKIX", "IBMCertPath");
                                object13 = new X509CertSelector();
                                if (debug != null) {
                                    debug.text(16384L, (Object)className, "engineLoad", "building certpath");
                                }
                                object7 = ((Object)x509Certificate.getSubjectDN()).toString();
                                ((X509CertSelector)object13).setSubject((String)object7);
                                if (debug != null) {
                                    debug.text(16384L, (Object)className, "engineLoad", "Subject = " + (String)object7);
                                }
                                object12 = new PKIXBuilderParameters(hashSet, (CertSelector)object13);
                                ((PKIXParameters)object12).setRevocationEnabled(false);
                                ((PKIXBuilderParameters)object12).setMaxPathLength(-1);
                                object11 = new CollectionCertStoreParameters(arrayList);
                                object10 = CertStore.getInstance("Collection", (CertStoreParameters)object11, "IBMCertPath");
                                ((PKIXParameters)object12).addCertStore((CertStore)object10);
                                try {
                                    object9 = (PKIXCertPathBuilderResult)certPathBuilder.build((CertPathParameters)object12);
                                    object8 = ((PKIXCertPathBuilderResult)object9).getCertPath();
                                    if (object8 != null) {
                                        List<? extends Certificate> list = ((CertPath)object8).getCertificates();
                                        int n5 = 0;
                                        x509CertificateArray = new X509Certificate[list.size() + 1];
                                        Iterator<? extends Certificate> iterator = list.iterator();
                                        while (iterator.hasNext()) {
                                            x509CertificateArray[n5++] = (X509Certificate)iterator.next();
                                        }
                                        x509CertificateArray[n5] = ((PKIXCertPathValidatorResult)object9).getTrustAnchor().getTrustedCert();
                                    }
                                }
                                catch (CertPathBuilderException certPathBuilderException) {
                                    if (debug != null) {
                                        debug.text(16384L, (Object)className, "engineLoad_0", "could not build CertPath for certificate " + certPathBuilderException.getMessage());
                                    }
                                    x509CertificateArray = null;
                                }
                            }
                            catch (Exception exception) {
                                if (debug == null) break block122;
                                debug.exception(16384L, (Object)className, "engineLoad_1", (Throwable)exception);
                            }
                        }
                    }
                    PrivateKeyEntry privateKeyEntry = new PrivateKeyEntry();
                    privateKeyEntry.key = privateKeyInfo;
                    privateKeyEntry.keyObject = pKCS11Object2;
                    privateKeyEntry.chain = x509CertificateArray;
                    if (debug != null) {
                        debug.text(16384L, (Object)className, "engineLoad", "Entry: \n key =" + privateKeyInfo.toString() + "\nkeyObject =" + pKCS11Object2 + "\nchain = " + x509CertificateArray + "\nLabel = " + string2);
                    }
                    if (string2 != null && string2.length() != 0) {
                        if (debug != null) {
                            debug.text(16384L, (Object)className, "engineLoad", "label != null");
                        }
                        if (!this.entries.containsKey(string2.toLowerCase())) {
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineLoad", "label empty");
                            }
                            this.entries.put(string2.toLowerCase(), privateKeyEntry);
                            if (debug == null) continue;
                            debug.text(16384L, (Object)className, "engineLoad", "PKCS11IMPLKS: put key entry[" + string2.toLowerCase() + "] to entries");
                            continue;
                        }
                        if (debug != null) {
                            debug.text(16384L, (Object)className, "engineLoad", "label not empty");
                        }
                        boolean bl = false;
                        while (!bl) {
                            object7 = string2 + "key" + n3;
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineLoad", "finding label: " + (String)object7);
                            }
                            if (this.entries.get(((String)object7).toLowerCase()) == null) {
                                this.entries.put(((String)object7).toLowerCase(), privateKeyEntry);
                                if (debug != null) {
                                    debug.text(16384L, (Object)className, "engineLoad", "PKCS11IMPLKS: put key entry[" + ((String)object7).toLowerCase() + "] to entries");
                                }
                                bl = true;
                                continue;
                            }
                            ++n3;
                        }
                        continue;
                    }
                    boolean bl = false;
                    while (!bl) {
                        object7 = string3 + n2;
                        if (!this.entries.containsKey(((String)object7).toLowerCase())) {
                            this.entries.put(((String)object7).toLowerCase(), privateKeyEntry);
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineLoad", "PKCS11IMPLKS: put key entry[" + ((String)object7).toLowerCase() + "] to entries");
                            }
                            bl = true;
                            continue;
                        }
                        ++n2;
                    }
                }
                vector.removeAllElements();
            }
            string3 = "secretKey";
            n2 = 0;
            n3 = 0;
            if (vector2.size() > 0) {
                int n6 = vector2.size();
                Enumeration enumeration = vector2.elements();
                block47: for (int i = 0; i < n6; ++i) {
                    String string4;
                    boolean bl;
                    block124: {
                        block123: {
                            string2 = null;
                            object4 = null;
                            try {
                                string2 = (PKCS11Object)enumeration.nextElement();
                                object4 = (String)this.getValue((PKCS11Object)string2, 3);
                                if (debug == null) break block123;
                                debug.text(16384L, (Object)className, "engineLoad", "sobj: " + string2);
                            }
                            catch (NoSuchElementException noSuchElementException) {
                                i = n6;
                                continue;
                            }
                        }
                        object3 = (Integer)this.getValue((PKCS11Object)string2, 256);
                        object2 = null;
                        try {
                            switch ((Integer)object3) {
                                case 19: {
                                    object2 = new GeneralKey(this.session, (PKCS11Object)string2, "DES");
                                    break block124;
                                }
                                case 21: {
                                    object2 = new GeneralKey(this.session, (PKCS11Object)string2, "DESede");
                                    break block124;
                                }
                                case 18: {
                                    object2 = new GeneralKey(this.session, (PKCS11Object)string2, "RC4");
                                    break block124;
                                }
                                case 31: {
                                    object2 = new GeneralKey(this.session, (PKCS11Object)string2, "AES");
                                    break block124;
                                }
                                case 16: {
                                    object2 = new GeneralKey(this.session, (PKCS11Object)string2, "Generic");
                                    break block124;
                                }
                                case 32: {
                                    object2 = new GeneralKey(this.session, (PKCS11Object)string2, "BLOWFISH");
                                    break block124;
                                }
                                default: {
                                    if (debug == null) continue block47;
                                    debug.text(16384L, (Object)className, "engineLoad_4", "Key Type not supported. " + (Integer)object3);
                                    break;
                                }
                            }
                            continue;
                        }
                        catch (Exception exception) {
                            if (debug == null) break block124;
                            debug.exception(16384L, (Object)className, "engineLoad_4.1", (Throwable)exception);
                        }
                    }
                    object = new SecretKeyEntry();
                    ((SecretKeyEntry)object).key = object2;
                    ((SecretKeyEntry)object).keyObject = string2;
                    if (debug != null) {
                        debug.text(16384L, (Object)className, "engineLoad", "Secret Entry: \n key =" + object2.toString() + "\nkeyObject =" + string2 + "\nLabel = " + (String)object4);
                    }
                    if (object4 != null && ((String)object4).length() != 0) {
                        if (debug != null) {
                            debug.text(16384L, (Object)className, "engineLoad", "label != null");
                        }
                        if (this.entries.get(((String)object4).toLowerCase()) == null) {
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineLoad", "label empty");
                            }
                            this.entries.put(((String)object4).toLowerCase(), object);
                            if (debug == null) continue;
                            debug.text(16384L, (Object)className, "engineLoad", "PKCS11IMPLKS: put secret key entry[" + ((String)object4).toLowerCase() + "] to entries");
                            continue;
                        }
                        if (debug != null) {
                            debug.text(16384L, (Object)className, "engineLoad", "label not empty");
                        }
                        bl = false;
                        while (!bl) {
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineLoad", "finding label");
                            }
                            if (this.entries.get((string4 = (String)object4 + "sec" + n3).toLowerCase()) == null) {
                                this.entries.put(string4.toLowerCase(), object);
                                if (debug != null) {
                                    debug.text(16384L, (Object)className, "engineLoad", "PKCS11IMPLKS: put secret key entry[" + string4.toLowerCase() + "] to entries");
                                }
                                bl = true;
                                continue;
                            }
                            ++n3;
                        }
                        continue;
                    }
                    bl = false;
                    while (!bl) {
                        string4 = string3 + n2;
                        if (!this.entries.containsKey(string4.toLowerCase())) {
                            this.entries.put(string4.toLowerCase(), object);
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineLoad", "PKCS11IMPLKS: put secret key entry[" + string4.toLowerCase() + "] to entries");
                            }
                            bl = true;
                            continue;
                        }
                        ++n2;
                    }
                }
                vector2.removeAllElements();
            }
            object5 = "cert";
            n2 = 0;
            if (vector3.size() > 0) {
                n = vector3.size();
                Enumeration enumeration = vector3.elements();
                for (int i = 0; i < n; ++i) {
                    boolean bl;
                    block126: {
                        block125: {
                            object4 = null;
                            try {
                                object4 = (PKCS11Object)enumeration.nextElement();
                                if (debug == null) break block125;
                                debug.text(16384L, (Object)className, "engineLoad", "cobj: " + object4);
                            }
                            catch (NoSuchElementException noSuchElementException) {
                                i = n;
                                continue;
                            }
                        }
                        object3 = (String)this.getValue((PKCS11Object)object4, 3);
                        object2 = (byte[])this.getValue((PKCS11Object)object4, 258);
                        object = null;
                        try {
                            object = (byte[])this.getValue((PKCS11Object)object4, 17);
                        }
                        catch (Exception exception) {
                            if (debug == null) break block126;
                            debug.text(16384L, (Object)className, "engineLoad", "tries to get cert value2");
                            exception.printStackTrace();
                        }
                    }
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
                    TrustedCertEntry trustedCertEntry = new TrustedCertEntry();
                    trustedCertEntry.cert = certificateFactory.generateCertificate(byteArrayInputStream);
                    trustedCertEntry.certObject = object4;
                    if (debug != null) {
                        debug.text(16384L, (Object)className, "engineLoad", "Trusted Cert Entry: \n cert =" + trustedCertEntry.cert.toString() + "\n CertObject =" + object4 + "\nLabel = " + (String)object3);
                    }
                    if (object3 != null && ((String)object3).length() != 0) {
                        if (debug != null) {
                            debug.text(16384L, (Object)className, "engineLoad", "label != null");
                        }
                        if (this.entries.get(((String)object3).toLowerCase()) == null) {
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineLoad", "label empty");
                            }
                            this.entries.put(((String)object3).toLowerCase(), trustedCertEntry);
                            if (debug == null) continue;
                            debug.text(16384L, (Object)className, "engineLoad", "PKCS11IMPLKS: put cert entry[" + ((String)object3).toLowerCase() + "] to entries");
                            continue;
                        }
                        if (debug != null) {
                            debug.text(16384L, (Object)className, "engineLoad", "label not empty");
                        }
                        bl = false;
                        while (!bl) {
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineLoad", "finding label");
                            }
                            if (this.entries.get((string = (String)object3 + "cert" + n3).toLowerCase()) == null) {
                                this.entries.put(string.toLowerCase(), trustedCertEntry);
                                if (debug != null) {
                                    debug.text(16384L, (Object)className, "engineLoad", "PKCS11IMPLKS: put cert entry[" + string.toLowerCase() + "] to entries");
                                }
                                bl = true;
                                continue;
                            }
                            ++n3;
                        }
                        continue;
                    }
                    bl = false;
                    while (!bl) {
                        string = (String)object5 + n2;
                        if (!this.entries.containsKey(string.toLowerCase())) {
                            this.entries.put(string.toLowerCase(), trustedCertEntry);
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineLoad", "PKCS11IMPLKS: put cert entry[" + string.toLowerCase() + "] to entries");
                            }
                            bl = true;
                            continue;
                        }
                        ++n2;
                    }
                }
                vector3.removeAllElements();
            }
            try {
                this.session.findObjectsFinal();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineLoad");
        }
    }

    private Object getValue(PKCS11Object pKCS11Object, int n) {
        Object object = null;
        try {
            object = pKCS11Object.getAttributeValue(n);
        }
        catch (Exception exception) {
            return null;
        }
        return object;
    }

    private Object[] getAttributes(PKCS11Object pKCS11Object) {
        return null;
    }

    private boolean bytesEquals(byte[] byArray, byte[] byArray2) {
        if (byArray == null && byArray2 == null) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    protected void finalize() {
    }

    class TrustedCertEntry {
        Certificate cert;
        PKCS11Object certObject;

        TrustedCertEntry() {
        }
    }

    class SecretKeyEntry {
        Key key;
        PKCS11Object keyObject;

        SecretKeyEntry() {
        }
    }

    class PrivateKeyEntry {
        Key key;
        PKCS11Object keyObject;
        Certificate[] chain;

        PrivateKeyEntry() {
        }
    }
}

