/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.CipherMechanismBuilder;
import com.ibm.crypto.pkcs11impl.provider.KeyMechanismBuilder;
import com.ibm.crypto.pkcs11impl.provider.MechanismBuilder;
import com.ibm.pkcs11.PKCS11Mechanism;
import com.ibm.pkcs11.PKCS11Object;
import java.security.AccessController;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedExceptionAction;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.NoSuchPaddingException;

class MechanismBuilderImpl
implements CipherMechanismBuilder,
KeyMechanismBuilder {
    private String type;
    private String algorithm;
    private int mechanism = 0;
    private MODES mode;
    private PADDING padding;
    private static Map<String, String> AliasesMap = new HashMap<String, String>();

    public static CipherMechanismBuilder createCipherMechanismBuilder(String string) {
        return new MechanismBuilderImpl(string, "Cipher");
    }

    public static KeyMechanismBuilder createKeyMechanismBuilder(String string) {
        return new MechanismBuilderImpl(string, "KeyFactory");
    }

    public static MechanismBuilder createMechanismBuilder(String string, String string2) {
        return new MechanismBuilderImpl(string, string2);
    }

    protected MechanismBuilderImpl(String string, String string2) {
        this.type = string2;
        this.algorithm = string;
        this.mode = MODES.ECB;
        this.padding = PADDING.NOPADDING;
    }

    public void setMode(String string) throws NoSuchAlgorithmException {
        try {
            this.mode = MODES.valueOf(string.toUpperCase());
            this.mechanism = 0;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new NoSuchAlgorithmException("Invalid Mode value: " + string);
        }
    }

    public void setPadding(String string) throws NoSuchPaddingException {
        try {
            this.padding = PADDING.valueOf(string.toUpperCase());
            this.mechanism = 0;
            if (this.padding == PADDING.PAD && this.mode == MODES.ECB) {
                throw new NoSuchPaddingException("No padding implemented for ECB mode");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new NoSuchPaddingException("Padding: " + string + " can not be verified for use. " + "Use Pad instead.");
        }
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public boolean isCompatibleOperationMode(int n, AlgorithmParameterSpec algorithmParameterSpec) {
        return this.mode != MODES.CBC || n != 2 && n != 4 || algorithmParameterSpec != null;
    }

    public boolean isIVRequired() {
        return this.mode == MODES.CBC;
    }

    public boolean isPadding() {
        return this.padding == PADDING.PAD;
    }

    public int getMechanism() {
        if (this.mechanism != 0) {
            return this.mechanism;
        }
        String string = AliasesMap.containsKey(this.algorithm) ? AliasesMap.get(this.algorithm) : this.algorithm.toUpperCase();
        StringBuilder stringBuilder = new StringBuilder(string);
        if (this.type.equalsIgnoreCase("KeyFactory")) {
            stringBuilder.append("_KEY_GEN");
        } else if (this.type.equalsIgnoreCase("Cipher") && !string.equalsIgnoreCase("RC4")) {
            stringBuilder.append('_');
            stringBuilder.append((Object)this.mode);
            if (this.padding == PADDING.PAD) {
                stringBuilder.append('_');
                stringBuilder.append((Object)this.padding);
            }
        }
        try {
            final String string2 = stringBuilder.toString();
            this.mechanism = (Integer)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IllegalAccessException, NoSuchFieldException {
                    int n = PKCS11Mechanism.class.getDeclaredField(string2).getInt(null);
                    return new Integer(n);
                }
            });
        }
        catch (Exception exception) {
            return -1;
        }
        return this.mechanism;
    }

    public Integer getKeyType() {
        try {
            final String string = AliasesMap.containsKey(this.algorithm) ? AliasesMap.get(this.algorithm) : this.algorithm.toUpperCase();
            return (Integer)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IllegalAccessException, NoSuchFieldException {
                    return PKCS11Object.class.getDeclaredField(string).get(null);
                }
            });
        }
        catch (Exception exception) {
            return new Integer(-1);
        }
    }

    public int getDefaultKeySize() {
        switch (this.getMechanism()) {
            case 288: {
                return 64;
            }
            case 305: {
                return 192;
            }
            case 272: 
            case 4224: 
            case 4240: {
                return 128;
            }
        }
        return 0;
    }

    static {
        AliasesMap.put("DESede", "DES3");
        AliasesMap.put("ARCFOUR", "RC4");
        AliasesMap.put("HmacMD5", "MD5_HMAC");
        AliasesMap.put("HmacSHA1", "SHA_1_HMAC");
        AliasesMap.put("Generic", "GENERIC_SECRET");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PADDING {
        NOPADDING,
        PAD;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MODES {
        ECB,
        CBC;

    }
}

