/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.NoSuchProviderException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Set;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarException;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

class JarVerifier {
    private static boolean debug = false;
    private Vector verifiedSignerCache = null;
    private URL jarURL;
    private JarFile jarFile;
    private boolean retrievedJarFile;

    JarVerifier(URL uRL) {
        this.jarURL = uRL;
        this.retrievedJarFile = false;
    }

    public void verify(X509Certificate[] x509CertificateArray) throws JarException, IOException {
        this.verifiedSignerCache = new Vector(2);
        try {
            this.verifyJars(this.jarURL, null, x509CertificateArray);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new JarException("Cannot verify " + this.jarURL.toString());
        }
        catch (CertificateException certificateException) {
            throw new JarException("Cannot verify " + this.jarURL.toString());
        }
        finally {
            this.verifiedSignerCache = null;
        }
    }

    public JarFile getJarFile() {
        this.retrievedJarFile = true;
        return this.jarFile;
    }

    private void verifyJars(URL uRL, Vector vector, X509Certificate[] x509CertificateArray) throws NoSuchProviderException, CertificateException, IOException {
        String string = uRL.toString();
        if (vector == null || !vector.contains(string)) {
            String string2 = this.verifySingleJar(uRL, x509CertificateArray);
            if (vector != null) {
                vector.addElement(string);
            }
            if (string2 != null) {
                if (vector == null) {
                    vector = new Vector<String>();
                    vector.addElement(string);
                }
                this.verifyManifestClassPathJars(uRL, string2, vector, x509CertificateArray);
            }
        }
    }

    private void verifyManifestClassPathJars(URL uRL, String string, Vector vector, X509Certificate[] x509CertificateArray) throws NoSuchProviderException, CertificateException, IOException {
        String[] stringArray = this.parseAttrClasspath(string);
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                URL uRL2 = new URL(uRL, stringArray[i]);
                this.verifyJars(uRL2, vector, x509CertificateArray);
            }
        }
        catch (MalformedURLException malformedURLException) {
            MalformedURLException malformedURLException2 = new MalformedURLException("The JAR file " + uRL.toString() + " contains invalid URLs in its Class-Path attribute" + ". " + malformedURLException.getMessage());
            throw malformedURLException2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String verifySingleJar(URL uRL, X509Certificate[] x509CertificateArray) throws NoSuchProviderException, CertificateException, IOException {
        final URL uRL2 = uRL.getProtocol().equalsIgnoreCase("jar") ? uRL : new URL("jar:" + uRL.toString() + "!/");
        ZipFile zipFile = null;
        boolean bl = true;
        try {
            Object object;
            Cloneable cloneable;
            try {
                zipFile = (JarFile)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        JarURLConnection jarURLConnection = (JarURLConnection)uRL2.openConnection();
                        jarURLConnection.setUseCaches(false);
                        return jarURLConnection.getJarFile();
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                SecurityException securityException = new SecurityException("Cannot verify " + uRL2.toString() + ". " + privilegedActionException.getMessage());
                throw securityException;
            }
            byte[] byArray = new byte[8192];
            Vector<JarEntry> vector = new Vector<JarEntry>();
            Enumeration<JarEntry> enumeration = ((JarFile)zipFile).entries();
            while (enumeration.hasMoreElements()) {
                int n;
                cloneable = enumeration.nextElement();
                vector.addElement((JarEntry)cloneable);
                object = ((JarFile)zipFile).getInputStream((ZipEntry)cloneable);
                while ((n = ((InputStream)object).read(byArray, 0, byArray.length)) != -1) {
                }
                ((InputStream)object).close();
            }
            if (this.jarURL.equals(uRL)) {
                this.jarFile = zipFile;
            } else {
                bl = false;
            }
            cloneable = ((JarFile)zipFile).getManifest();
            if (cloneable == null) {
                throw new JarException(uRL.toString() + " is not signed.");
            }
            object = ((JarFile)zipFile).entries();
            while (object.hasMoreElements()) {
                X509Certificate[] x509CertificateArray2;
                JarEntry jarEntry = (JarEntry)object.nextElement();
                if (jarEntry.isDirectory()) continue;
                Certificate[] certificateArray = jarEntry.getCertificates();
                if (certificateArray == null || certificateArray.length == 0) {
                    if (jarEntry.getName().startsWith("META-INF")) continue;
                    throw new JarException(uRL.toString() + " has unsigned entries - " + jarEntry.getName());
                }
                int n = 0;
                boolean bl2 = false;
                while ((x509CertificateArray2 = this.getAChain(certificateArray, n)) != null) {
                    if (this.verifiedSignerCache.contains(x509CertificateArray2[0])) {
                        bl2 = true;
                        break;
                    }
                    if (this.isTrusted(x509CertificateArray2, x509CertificateArray)) {
                        bl2 = true;
                        this.verifiedSignerCache.addElement(x509CertificateArray2[0]);
                        break;
                    }
                    n += x509CertificateArray2.length;
                }
                if (bl2) continue;
                throw new JarException(uRL.toString() + " is not signed by a" + " trusted signer.");
            }
            String string = ((Manifest)cloneable).getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
            return string;
        }
        finally {
            if (zipFile != null && !bl) {
                zipFile.close();
            }
        }
    }

    private String[] parseAttrClasspath(String string) throws JarException {
        string = string.trim();
        int n = string.indexOf(32);
        String string2 = null;
        Vector<String> vector = new Vector<String>();
        boolean bl = false;
        do {
            if (n > 0) {
                string2 = string.substring(0, n);
                string = string.substring(n + 1).trim();
                n = string.indexOf(32);
            } else {
                string2 = string;
                bl = true;
            }
            if (!string2.endsWith(".jar")) {
                throw new JarException("The provider contains un-verifiable components");
            }
            vector.addElement(string2);
        } while (!bl);
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private boolean isTrusted(X509Certificate[] x509CertificateArray, X509Certificate[] x509CertificateArray2) {
        int n;
        Serializable serializable;
        int n2;
        for (n2 = 0; n2 < x509CertificateArray.length; ++n2) {
            serializable = x509CertificateArray[n2];
            try {
                this.checkCriticalExts((X509Certificate)serializable, n2);
                continue;
            }
            catch (Exception exception) {
                if (debug) {
                    exception.printStackTrace();
                }
                return false;
            }
        }
        for (n2 = 0; n2 < x509CertificateArray.length - 1; ++n2) {
            serializable = x509CertificateArray[n2 + 1].getPublicKey();
            X509Certificate x509Certificate = x509CertificateArray[n2];
            try {
                x509Certificate.verify((PublicKey)serializable);
                continue;
            }
            catch (Exception exception) {
                return false;
            }
        }
        X509Certificate x509Certificate = x509CertificateArray[x509CertificateArray.length - 1];
        for (n = 0; n < x509CertificateArray2.length; ++n) {
            if (!((Object)x509CertificateArray2[n].getSubjectDN()).equals(x509Certificate.getSubjectDN()) || !x509CertificateArray2[n].equals(x509Certificate)) continue;
            return true;
        }
        for (n = 0; n < x509CertificateArray2.length; ++n) {
            if (!((Object)x509CertificateArray2[n].getSubjectDN()).equals(x509Certificate.getIssuerDN())) continue;
            try {
                x509Certificate.verify(x509CertificateArray2[n].getPublicKey());
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private void checkCriticalExts(X509Certificate x509Certificate, int n) throws Exception {
        Set<String> set = x509Certificate.getCriticalExtensionOIDs();
        if (set == null || set.size() == 0) {
            return;
        }
        this.checkBasicConstraints(x509Certificate, set, n);
    }

    private void checkBasicConstraints(X509Certificate x509Certificate, Set set, int n) throws Exception {
        int n2;
        if (set != null && !set.isEmpty() && set.contains(new String("2.5.29.19")) && (n2 = x509Certificate.getBasicConstraints()) >= 0 && n > 0 && n - 1 > n2) {
            throw new Exception("Violated basic constraints");
        }
    }

    private X509Certificate[] getAChain(Certificate[] certificateArray, int n) {
        int n2;
        if (n > certificateArray.length - 1) {
            return null;
        }
        for (n2 = n; n2 < certificateArray.length - 1 && ((Object)((X509Certificate)certificateArray[n2 + 1]).getSubjectDN()).equals(((X509Certificate)certificateArray[n2]).getIssuerDN()); ++n2) {
        }
        int n3 = n2 - n + 1;
        X509Certificate[] x509CertificateArray = new X509Certificate[n3];
        for (int i = 0; i < n3; ++i) {
            x509CertificateArray[i] = (X509Certificate)certificateArray[n + i];
        }
        return x509CertificateArray;
    }

    protected void finalize() throws Throwable {
        if (!this.retrievedJarFile) {
            this.jarFile.close();
        }
    }
}

