/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.module.PKCS11Principal;
import com.ibm.crypto.pkcs11impl.provider.Config;
import com.ibm.crypto.pkcs11impl.provider.JarVerifier;
import com.ibm.crypto.pkcs11impl.provider.PKCS11Key;
import com.ibm.crypto.pkcs11impl.provider.SupportedServices;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Mechanism;
import com.ibm.pkcs11.PKCS11Session;
import com.ibm.pkcs11.PKCS11Slot;
import com.ibm.pkcs11.nat.NativePKCS11;
import com.ibm.security.bootstrap.DSAPublicKeyImpl;
import com.ibm.security.bootstrap.RSAPublicKeyImpl;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.net.JarURLConnection;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.AuthProvider;
import java.security.CodeSource;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.Security;
import java.security.SecurityPermission;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.prefs.Preferences;
import java.util.zip.ZipEntry;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;

public final class IBMPKCS11Impl
extends AuthProvider {
    private static String info = "IBMPKCS11Impl Provider implements the following:\nSignature algorithms               : SHA1withDSA, SHA1withRSA, MD5withRSA, MD2withRSA \nCipher algorithms                  : AES, DES, TripleDES, Blowfish, RC4, RSA,\nKey (pair) generator               : DH, DSA, RSA, AES, Blowfish, RC4, DES, TripleDES\nMessage digest                     : MD2, MD5, SHA-1, SHA256, SHA384, SHA512\nAlgorithm parameter generator      : DH, DSA\nAlgorithm parameter                : DSA, DES, TripleDES\nKey factory                        : DH, DSA, RSA\nSecret key factory                 : AES, Blowfish, RC4, DES, TripleDES\nKey Agreement                      : DH\nCertificate                        : X.509\nSecure random                      : PKCS11DeviceRNG (IBMSecureRandom)\nKey store                          : PKCS11IMPLKS\n";
    static final boolean debug2 = false;
    private static boolean verifiedJce = false;
    private static boolean verifiedSelfIntegrity = false;
    private static X509Certificate[] trustedCaCerts = null;
    protected PKCS11Session session = null;
    private PKCS11Slot tokenSlot = null;
    private PKCS11 pkcs11 = null;
    private Config config = null;
    private static String providerName = "IBMPKCS11Impl";
    private static double providerVer = 1.5;
    private CallbackHandler callbackHand = null;
    private static HashMap<String, PKCS11> LIBS = new HashMap();
    private static final byte[][] bytesOfTrustedCaCerts = new byte[][]{{48, -126, 3, 79, 48, -126, 3, 13, -96, 3, 2, 1, 2, 2, 4, 57, 36, -91, 85, 48, 11, 6, 7, 42, -122, 72, -50, 56, 4, 3, 5, 0, 48, 96, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 24, 48, 22, 6, 3, 85, 4, 10, 19, 15, 73, 66, 77, 32, 67, 111, 114, 112, 111, 114, 97, 116, 105, 111, 110, 49, 25, 48, 23, 6, 3, 85, 4, 11, 19, 16, 73, 66, 77, 32, 67, 111, 100, 101, 32, 83, 105, 103, 110, 105, 110, 103, 49, 28, 48, 26, 6, 3, 85, 4, 3, 19, 19, 74, 67, 69, 32, 67, 111, 100, 101, 32, 83, 105, 103, 110, 105, 110, 103, 32, 67, 65, 48, 30, 23, 13, 48, 48, 48, 53, 49, 57, 48, 50, 50, 50, 49, 51, 90, 23, 13, 48, 54, 48, 53, 49, 56, 48, 50, 50, 50, 49, 51, 90, 48, 96, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 24, 48, 22, 6, 3, 85, 4, 10, 19, 15, 73, 66, 77, 32, 67, 111, 114, 112, 111, 114, 97, 116, 105, 111, 110, 49, 25, 48, 23, 6, 3, 85, 4, 11, 19, 16, 73, 66, 77, 32, 67, 111, 100, 101, 32, 83, 105, 103, 110, 105, 110, 103, 49, 28, 48, 26, 6, 3, 85, 4, 3, 19, 19, 74, 67, 69, 32, 67, 111, 100, 101, 32, 83, 105, 103, 110, 105, 110, 103, 32, 67, 65, 48, -126, 1, -72, 48, -126, 1, 44, 6, 7, 42, -122, 72, -50, 56, 4, 1, 48, -126, 1, 31, 2, -127, -127, 0, -3, 127, 83, -127, 29, 117, 18, 41, 82, -33, 74, -100, 46, -20, -28, -25, -10, 17, -73, 82, 60, -17, 68, 0, -61, 30, 63, -128, -74, 81, 38, 105, 69, 93, 64, 34, 81, -5, 89, 61, -115, 88, -6, -65, -59, -11, -70, 48, -10, -53, -101, 85, 108, -41, -127, 59, -128, 29, 52, 111, -14, 102, 96, -73, 107, -103, 80, -91, -92, -97, -97, -24, 4, 123, 16, 34, -62, 79, -69, -87, -41, -2, -73, -58, 27, -8, 59, 87, -25, -58, -88, -90, 21, 15, 4, -5, -125, -10, -45, -59, 30, -61, 2, 53, 84, 19, 90, 22, -111, 50, -10, 117, -13, -82, 43, 97, -41, 42, -17, -14, 34, 3, 25, -99, -47, 72, 1, -57, 2, 21, 0, -105, 96, 80, -113, 21, 35, 11, -52, -78, -110, -71, -126, -94, -21, -124, 11, -16, 88, 28, -11, 2, -127, -127, 0, -9, -31, -96, -123, -42, -101, 61, -34, -53, -68, -85, 92, 54, -72, 87, -71, 121, -108, -81, -69, -6, 58, -22, -126, -7, 87, 76, 11, 61, 7, -126, 103, 81, 89, 87, -114, -70, -44, 89, 79, -26, 113, 7, 16, -127, -128, -76, 73, 22, 113, 35, -24, 76, 40, 22, 19, -73, -49, 9, 50, -116, -56, -90, -31, 60, 22, 122, -117, 84, 124, -115, 40, -32, -93, -82, 30, 43, -77, -90, 117, -111, 110, -93, 127, 11, -6, 33, 53, 98, -15, -5, 98, 122, 1, 36, 59, -52, -92, -15, -66, -88, 81, -112, -119, -88, -125, -33, -31, 90, -27, -97, 6, -110, -117, 102, 94, -128, 123, 85, 37, 100, 1, 76, 59, -2, -49, 73, 42, 3, -127, -123, 0, 2, -127, -127, 0, -22, 107, 0, -57, -33, 16, 59, -71, 116, 53, -89, -31, 109, 102, -126, 77, -9, 91, 86, 113, -62, 38, 69, 39, 114, 61, 81, 16, 98, -1, -77, -36, 16, -55, -5, 81, 19, -44, -83, -117, -88, 37, 110, 93, -55, 120, -46, 91, 39, -45, 19, 65, 71, 20, 6, 124, -53, -126, 56, 94, -58, 11, 97, -96, 76, -125, 45, -108, -52, -116, 46, -124, -112, 58, -113, 66, 10, 105, 82, -45, 116, 38, 119, -92, 20, 125, 42, 113, 65, -120, -119, 119, -90, 45, 98, -102, -95, 88, -104, 109, 108, -49, -50, -88, -22, -70, -35, -24, -95, 16, 68, -116, -124, 66, -63, -72, 31, 43, -76, -68, -77, 93, 116, 96, -128, -115, 66, 84, -93, 83, 48, 81, 48, 31, 6, 3, 85, 29, 35, 4, 24, 48, 22, -128, 20, 126, 61, 77, 77, -52, 16, 89, -70, -7, -82, 66, 61, -27, -55, 87, 90, 82, 11, 126, -121, 48, 29, 6, 3, 85, 29, 14, 4, 22, 4, 20, 126, 61, 77, 77, -52, 16, 89, -70, -7, -82, 66, 61, -27, -55, 87, 90, 82, 11, 126, -121, 48, 15, 6, 3, 85, 29, 19, 1, 1, -1, 4, 5, 48, 3, 1, 1, -1, 48, 11, 6, 7, 42, -122, 72, -50, 56, 4, 3, 5, 0, 3, 47, 0, 48, 44, 2, 20, 28, -17, -10, -64, 92, -19, -109, 112, 34, -31, 75, -55, 15, -16, -99, 122, 9, -18, -122, -122, 2, 20, 18, 119, 71, 98, -62, -97, 25, 97, -36, 41, -6, -71, 73, -91, 25, -42, -91, -68, 69, 77}, {48, -126, 3, -64, 48, -126, 3, 126, -96, 3, 2, 1, 2, 2, 1, 1, 48, 11, 6, 7, 42, -122, 72, -50, 56, 4, 3, 5, 0, 48, -127, -112, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 11, 48, 9, 6, 3, 85, 4, 8, 19, 2, 67, 65, 49, 18, 48, 16, 6, 3, 85, 4, 7, 19, 9, 80, 97, 108, 111, 32, 65, 108, 116, 111, 49, 29, 48, 27, 6, 3, 85, 4, 10, 19, 20, 83, 117, 110, 32, 77, 105, 99, 114, 111, 115, 121, 115, 116, 101, 109, 115, 32, 73, 110, 99, 49, 35, 48, 33, 6, 3, 85, 4, 11, 19, 26, 74, 97, 118, 97, 32, 83, 111, 102, 116, 119, 97, 114, 101, 32, 67, 111, 100, 101, 32, 83, 105, 103, 110, 105, 110, 103, 49, 28, 48, 26, 6, 3, 85, 4, 3, 19, 19, 74, 67, 69, 32, 67, 111, 100, 101, 32, 83, 105, 103, 110, 105, 110, 103, 32, 67, 65, 48, 30, 23, 13, 48, 48, 48, 52, 49, 50, 48, 55, 48, 48, 48, 48, 90, 23, 13, 48, 54, 48, 52, 49, 50, 48, 55, 48, 48, 48, 48, 90, 48, -127, -112, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 11, 48, 9, 6, 3, 85, 4, 8, 19, 2, 67, 65, 49, 18, 48, 16, 6, 3, 85, 4, 7, 19, 9, 80, 97, 108, 111, 32, 65, 108, 116, 111, 49, 29, 48, 27, 6, 3, 85, 4, 10, 19, 20, 83, 117, 110, 32, 77, 105, 99, 114, 111, 115, 121, 115, 116, 101, 109, 115, 32, 73, 110, 99, 49, 35, 48, 33, 6, 3, 85, 4, 11, 19, 26, 74, 97, 118, 97, 32, 83, 111, 102, 116, 119, 97, 114, 101, 32, 67, 111, 100, 101, 32, 83, 105, 103, 110, 105, 110, 103, 49, 28, 48, 26, 6, 3, 85, 4, 3, 19, 19, 74, 67, 69, 32, 67, 111, 100, 101, 32, 83, 105, 103, 110, 105, 110, 103, 32, 67, 65, 48, -126, 1, -73, 48, -126, 1, 44, 6, 7, 42, -122, 72, -50, 56, 4, 1, 48, -126, 1, 31, 2, -127, -127, 0, -21, -81, 55, 4, 30, -54, 81, 30, 105, 93, -80, -14, -113, -10, -75, 73, 31, -58, -92, -103, 5, -41, 41, -65, 116, -73, 106, -11, 25, -40, 30, -28, 27, -8, 10, 1, -102, -104, -1, 112, -85, -30, 74, 86, -122, 108, 83, -77, -4, -31, -56, -127, -116, 49, -16, -60, -13, -80, -117, -26, 112, 6, -20, -9, 105, 104, -37, -125, 76, 114, 41, -119, 41, 54, 23, 92, 59, 74, 7, -96, 32, 2, 42, 70, -105, 81, 29, 112, -56, 8, 24, 11, -50, 12, 110, -101, 118, -9, 5, -29, -25, -5, -45, 97, 121, -31, 96, -102, 36, -115, 6, -107, -125, 60, 81, 32, -31, 48, -49, 56, 87, -126, -90, 26, 114, 13, -50, -45, 2, 21, 0, -124, 37, 69, -31, -70, -71, -87, 98, -85, 121, -24, 91, 48, -72, -119, 107, 27, -1, 123, 117, 2, -127, -127, 0, -85, -55, 116, 123, 116, -17, -18, 66, -75, 106, 83, 77, 59, -35, -112, 6, 114, 104, -111, 15, 11, -92, 41, 118, 46, 85, 59, -43, -82, 77, 101, 92, 126, 42, 58, 4, -90, 103, -90, -48, 113, -86, -91, -41, -73, -30, -63, 114, 13, -92, -47, -86, 30, -110, 84, 76, 32, 0, 9, -94, -80, 9, 65, 25, 51, 0, -78, -61, 92, -82, 66, -8, -79, -117, -54, 124, -106, -40, 16, 127, 55, 68, 91, -86, -52, 120, -56, -41, 114, 118, 55, 107, 64, -103, -88, 85, 102, -6, -88, 3, 30, -117, 74, 17, 2, 105, -53, 76, -72, 37, 6, 28, -96, 119, -46, -55, -84, -46, 61, -23, 10, 16, -6, 118, 112, -73, -5, -36, 3, -127, -124, 0, 2, -127, -128, 45, 9, -104, 92, -84, -72, -100, -57, -103, 126, -18, 32, 25, 42, 52, -112, -7, -41, -85, -85, -82, -35, 107, 114, -107, 13, 102, -8, -17, 39, -113, 68, -78, -19, 40, 68, -57, -2, -81, -80, -90, 39, 111, 0, 103, 69, -126, 91, 7, -88, 86, 86, 59, -46, 41, 81, 97, 94, 105, 57, -41, 46, 116, 119, 18, -49, 25, 74, -11, 45, -56, -53, 114, 97, -60, 78, 111, -6, 71, 67, 63, 20, -69, -6, -68, 24, 102, 40, -62, -39, 102, -117, 122, 45, 47, -62, 96, -110, 75, 20, -2, 88, 62, 33, 127, 104, 98, -66, 108, 72, 73, -7, -96, 75, 94, -123, -99, 25, 16, -7, 21, 69, 81, 27, 113, -44, -9, 11, -93, 102, 48, 100, 48, 17, 6, 9, 96, -122, 72, 1, -122, -8, 66, 1, 1, 4, 4, 3, 2, 0, 7, 48, 15, 6, 3, 85, 29, 19, 1, 1, -1, 4, 5, 48, 3, 1, 1, -1, 48, 31, 6, 3, 85, 29, 35, 4, 24, 48, 22, -128, 20, 101, -30, -12, -122, -55, -45, 78, -16, -111, 78, 88, -94, 106, -11, -40, 120, 90, -102, -63, -90, 48, 29, 6, 3, 85, 29, 14, 4, 22, 4, 20, 101, -30, -12, -122, -55, -45, 78, -16, -111, 78, 88, -94, 106, -11, -40, 120, 90, -102, -63, -90, 48, 11, 6, 7, 42, -122, 72, -50, 56, 4, 3, 5, 0, 3, 47, 0, 48, 44, 2, 20, 36, -97, 2, -61, -5, 49, -43, -111, 59, -7, 126, 86, 111, -106, -33, 100, 10, 4, -104, -76, 2, 20, 110, 121, -124, -89, -18, 104, -93, 2, 114, 49, 99, -37, 67, -85, 8, -20, 77, -17, 22, 58}};
    static final long serialVersionUID = -7311315630492398086L;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl";

    public IBMPKCS11Impl() {
        super(providerName, providerVer, info);
        if (debug != null) {
            System.out.println("new IBMPKCS11Impl instance");
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                IBMPKCS11Impl.this.put("Alg.Alias.Signature.DONTUSETHIS", "IBMPKCS11Impl");
                return null;
            }
        });
        this.session = null;
        Preferences preferences = Preferences.userNodeForPackage(this.getClass());
        String string = preferences.get("IBMPKCSImpl DLL", null);
        String string2 = preferences.get("IBMPKCSImpl password", null);
        try {
            if (string == null) {
                this.Init(null, null);
            } else {
                char[] cArray = null;
                if (string2 != null) {
                    cArray = new char[string2.length()];
                    string2.getChars(0, string2.length(), cArray, 0);
                }
                this.Init(string, cArray);
                for (int i = 0; i < cArray.length; ++i) {
                    cArray[i] = '\u0000';
                }
            }
        }
        catch (IOException iOException) {
            throw new PKCS11Exception(iOException.getMessage());
        }
    }

    public IBMPKCS11Impl(String string) throws Exception {
        super(providerName + Config.getProviderNameSuffix(string), providerVer, Config.getDescription(string));
        if (debug != null) {
            System.out.println("new IBMPKCS11Impl instance");
        }
        this.session = null;
        try {
            File file;
            this.Init(string, null);
            if (debug != null && (file = new File(string)).canRead()) {
                int n;
                debug.text(16384L, (Object)className, "IBMPKCS11Impl", "path and config file name: " + string);
                FileReader fileReader = new FileReader(file);
                StringWriter stringWriter = new StringWriter();
                while ((n = fileReader.read()) != -1) {
                    stringWriter.write(n);
                }
                debug.text(16384L, (Object)className, "IBMPKCS11Impl", "file contents:\n" + stringWriter.toString());
            }
        }
        catch (IOException iOException) {
            throw new PKCS11Exception(iOException.getMessage());
        }
    }

    public IBMPKCS11Impl(BufferedReader bufferedReader) throws Exception {
        super(providerName + Config.getProviderNameSuffix(bufferedReader), providerVer, Config.getDescription(bufferedReader));
        if (debug != null) {
            System.out.println("new IBMPKCS11Impl instance");
        }
        this.session = null;
        try {
            if (debug != null) {
                int n;
                bufferedReader.reset();
                StringWriter stringWriter = new StringWriter();
                while ((n = bufferedReader.read()) != -1) {
                    stringWriter.write(n);
                }
                debug.text(16384L, (Object)className, "IBMPKCS11Impl", "file contents:\n" + stringWriter.toString());
                bufferedReader.reset();
            }
            this.Init(bufferedReader);
        }
        catch (IOException iOException) {
            throw new PKCS11Exception(iOException.getMessage());
        }
    }

    protected PKCS11Session getSession() {
        return this.session;
    }

    protected Config getConfig() {
        return this.config;
    }

    public void removeSession() {
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
    }

    public void Init(BufferedReader bufferedReader) throws IOException {
        PKCS11Slot[] pKCS11SlotArray = null;
        Object var3_3 = null;
        String string = null;
        String string2 = null;
        boolean bl = false;
        int n = 0;
        try {
            this.config = new Config(bufferedReader);
        }
        catch (Exception exception) {
            throw new IOException("Error parsing config file: " + exception.getMessage());
        }
        string = this.config.getLibraryName();
        if (string.toLowerCase().endsWith(".dll")) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "Init", "win fileName = " + string);
            }
            string = string.substring(0, string.length() - 4);
        } else if (string.toLowerCase().endsWith(".so")) {
            File file;
            String string3;
            if (debug != null) {
                debug.text(16384L, (Object)className, "Init", "Unix fileName = " + string);
            }
            if ((string3 = (file = new File(string)).getName()) != null && string3.toLowerCase().startsWith("lib")) {
                string = file.getParent() + File.separator + string3.substring(3);
            }
            if (debug != null) {
                debug.text(16384L, (Object)className, "Init", "Unix fileName2 = " + string);
            }
            if (string.toLowerCase().endsWith(".so")) {
                string = string.substring(0, string.length() - 3);
            }
        }
        string2 = this.config.getTokenLabel();
        if (string2 == null) {
            n = this.config.getSlotIndex();
        }
        if (debug != null) {
            debug.text(16384L, (Object)className, "Init", "fileName = " + string);
        }
        try {
            this.pkcs11 = LIBS.get(string);
            if (this.pkcs11 == null) {
                this.pkcs11 = new NativePKCS11(string);
                this.pkcs11.libInitialize();
                LIBS.put(string, this.pkcs11);
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new IOException("Invalid dll name : " + string);
        }
        if (debug != null) {
            System.out.println("P5");
        }
        pKCS11SlotArray = this.pkcs11.getSlotList(true);
        if (string2 != null) {
            boolean bl2 = false;
            for (int i = 0; i < pKCS11SlotArray.length; ++i) {
                String string4 = pKCS11SlotArray[i].getTokenInfo().label();
                if (!string2.equals(string4)) continue;
                n = i;
                bl2 = true;
                break;
            }
            if (!bl2) {
                throw new IOException("Invalid Token Label : " + string2);
            }
        }
        if (n < 0 || n > pKCS11SlotArray.length - 1) {
            throw new IOException("Invalid slot number : " + n);
        }
        this.tokenSlot = pKCS11SlotArray[n];
        if (debug != null) {
            debug.text(16384L, (Object)className, "Init", "Slot Info:" + this.tokenSlot.getInfo().toString());
            debug.text(16384L, (Object)className, "Init", "Token Info:" + this.tokenSlot.getTokenInfo().toString());
        }
        try {
            this.session = this.tokenSlot.openSession(6, null, null);
        }
        catch (PKCS11Exception pKCS11Exception) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "Init", "Creation of read write session failed:" + pKCS11Exception.getMessage());
            }
            if (pKCS11Exception.getCode() == 226) {
                this.session = this.tokenSlot.openSession(4, null, null);
            }
            throw new IOException(pKCS11Exception.getMessage());
        }
        int[] nArray = null;
        if (this.session != null) {
            nArray = this.session.getSlot().getMechanismList();
            if (debug != null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < nArray.length; ++i) {
                    arrayList.add(PKCS11Mechanism.typeToString((int)nArray[i]));
                }
                debug.text(16384L, (Object)className, "Init", "Mechanisms: " + arrayList.toString());
            }
        }
        final IBMPKCS11Impl iBMPKCS11Impl = this;
        if (this.config == null) {
            if (this.session != null) {
                Config config = new Config((String)null);
                final SupportedServices[] supportedServicesArray = config.getSupportedServices(nArray);
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        for (int i = 0; i < supportedServicesArray.length; ++i) {
                            IBMPKCS11Impl.this.putService(new PKCS11ImplService(IBMPKCS11Impl.this.session, iBMPKCS11Impl, supportedServicesArray[i].getType(), supportedServicesArray[i].getAlgorithm(), supportedServicesArray[i].getClassName(), supportedServicesArray[i].getAlaises(), supportedServicesArray[i].getMechanism()));
                        }
                        return null;
                    }
                });
            }
        } else {
            final SupportedServices[] supportedServicesArray = this.config.getSupportedServices(nArray);
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    for (int i = 0; i < supportedServicesArray.length; ++i) {
                        IBMPKCS11Impl.this.putService(new PKCS11ImplService(IBMPKCS11Impl.this.session, iBMPKCS11Impl, supportedServicesArray[i].getType(), supportedServicesArray[i].getAlgorithm(), supportedServicesArray[i].getClassName(), supportedServicesArray[i].getAlaises(), supportedServicesArray[i].getMechanism()));
                    }
                    return null;
                }
            });
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "Init");
        }
    }

    /*
     * Unable to fully structure code
     */
    public void Init(String var1_1, char[] var2_2) throws IOException {
        block69: {
            var3_3 = null;
            var4_4 = null;
            var5_5 = null;
            var6_6 = null;
            var7_7 = var2_2;
            var8_8 = 0;
            var9_9 = 0;
            if (IBMPKCS11Impl.debug != null) {
                IBMPKCS11Impl.debug.entry(16384L, (Object)IBMPKCS11Impl.className, "Init", (Object)var1_1, (Object)var2_2);
            }
            if (this.session == null) {
                if (var1_1 == null) {
                    var10_10 = AccessController.getContext();
                    try {
                        block70: {
                            var11_19 = Subject.getSubject((AccessControlContext)var10_10);
                            var12_23 = null;
                            var13_27 = null;
                            if (var11_19 == null) break block69;
                            try {
                                var14_28 = Class.forName("com.ibm.crypto.pkcs11impl.module.PKCS11Principal");
                                var13_27 = var11_19.getPrincipals(var14_28);
                            }
                            catch (Exception var14_29) {
                                if (IBMPKCS11Impl.debug == null) break block70;
                                IBMPKCS11Impl.debug.text(16384L, (Object)IBMPKCS11Impl.className, "Init", "Got unexpected exception 1: " + var14_29.getMessage());
                            }
                        }
                        if (var13_27.size() != 0) {
                            var14_28 = var13_27.iterator();
                            var12_23 = (PKCS11Principal)var14_28.next();
                            this.session = var12_23.getSession();
                        }
                        break block69;
                    }
                    catch (NullPointerException var11_20) {
                        if (IBMPKCS11Impl.debug != null) {
                            IBMPKCS11Impl.debug.text(16384L, (Object)IBMPKCS11Impl.className, "Init", "ACC is null: " + var11_20.getMessage());
                        }
                        break block69;
                    }
                }
                var4_4 = var1_1.trim();
                if (var4_4.toLowerCase().indexOf(".dll") >= 0 || var4_4.toLowerCase().indexOf(".so") >= 0) {
                    if (var4_4.toLowerCase().indexOf(".dll") < 0) {
                        if (IBMPKCS11Impl.debug != null) {
                            System.out.println("a unix lib:" + var4_4);
                        }
                        var8_8 = var4_4.toLowerCase().indexOf(".so:") + 3;
                        if (IBMPKCS11Impl.debug != null) {
                            System.out.println("findex=" + var8_8);
                        }
                        if (var8_8 > 2) {
                            var5_5 = var4_4.substring(0, var8_8);
                            try {
                                if (IBMPKCS11Impl.debug != null) {
                                    System.out.println("substring=" + var4_4.substring(var8_8 + 1, var4_4.length()));
                                }
                                var9_9 = Integer.valueOf(var4_4.substring(var8_8 + 1, var4_4.length()));
                                if (IBMPKCS11Impl.debug == null) ** GOTO lbl70
                                System.out.println("slotIndex=" + var9_9);
                            }
                            catch (NumberFormatException var10_11) {
                                if (IBMPKCS11Impl.debug != null) {
                                    var10_11.printStackTrace();
                                }
                                throw new IOException("Invalid slot number");
                            }
                        } else {
                            var8_8 = var4_4.toLowerCase().indexOf(".so64:") + 3;
                            if (var8_8 > 2) {
                                var5_5 = var4_4.substring(0, var8_8 += 2);
                                try {
                                    if (IBMPKCS11Impl.debug != null) {
                                        System.out.println("substring=" + var4_4.substring(var8_8 + 1, var4_4.length()));
                                    }
                                    var9_9 = Integer.valueOf(var4_4.substring(var8_8 + 1, var4_4.length()));
                                    if (IBMPKCS11Impl.debug == null) ** GOTO lbl70
                                    System.out.println("slotIndex=" + var9_9);
                                }
                                catch (NumberFormatException var10_12) {
                                    throw new IOException("Invalid slot number");
                                }
                            } else {
                                var5_5 = var4_4;
                            }
                        }
lbl70:
                        // 5 sources

                        var10_13 = new File(var5_5);
                        var11_21 = var10_13.getName();
                        if (var11_21 != null && var11_21.toLowerCase().startsWith("lib")) {
                            var5_5 = var10_13.getParent() + File.separator + var11_21.substring(3);
                        }
                        if (var5_5.toLowerCase().endsWith(".so")) {
                            var5_5 = var5_5.substring(0, var5_5.length() - 3);
                        }
                    } else {
                        if (IBMPKCS11Impl.debug != null) {
                            System.out.println("P4");
                        }
                        if (IBMPKCS11Impl.debug != null) {
                            IBMPKCS11Impl.debug.text(16384L, (Object)IBMPKCS11Impl.className, "Init", "dllName: " + var4_4);
                        }
                        if ((var8_8 = var4_4.toLowerCase().indexOf(".dll:") + 4) > 3) {
                            var5_5 = var4_4.substring(0, var8_8);
                            if (IBMPKCS11Impl.debug != null) {
                                IBMPKCS11Impl.debug.text(16384L, (Object)IBMPKCS11Impl.className, "Init", "fileName: " + var5_5);
                                IBMPKCS11Impl.debug.text(16384L, (Object)IBMPKCS11Impl.className, "Init", "findex: " + var8_8);
                            }
                            try {
                                var9_9 = Integer.valueOf(var4_4.substring(var8_8 + 1, var4_4.length()));
                                if (IBMPKCS11Impl.debug == null) ** GOTO lbl94
                                IBMPKCS11Impl.debug.text(16384L, (Object)IBMPKCS11Impl.className, "Init", "slotIndex=" + var9_9);
                            }
                            catch (NumberFormatException var10_14) {
                                throw new IOException("Invalid slot number");
                            }
                        } else {
                            var5_5 = var4_4;
                        }
lbl94:
                        // 3 sources

                        if (var5_5.toLowerCase().endsWith(".dll")) {
                            var5_5 = var5_5.substring(0, var5_5.length() - 4);
                        }
                    }
                } else {
                    try {
                        this.config = new Config(var1_1);
                    }
                    catch (Exception var10_15) {
                        throw new IOException("Error parsing config file: " + var10_15.getMessage());
                    }
                    var5_5 = this.config.getLibraryName();
                    if (var5_5.toLowerCase().endsWith(".dll")) {
                        if (IBMPKCS11Impl.debug != null) {
                            IBMPKCS11Impl.debug.text(16384L, (Object)IBMPKCS11Impl.className, "Init", "win fileName = " + var5_5);
                        }
                        var5_5 = var5_5.substring(0, var5_5.length() - 4);
                    } else if (var5_5.toLowerCase().endsWith(".so")) {
                        if (IBMPKCS11Impl.debug != null) {
                            IBMPKCS11Impl.debug.text(16384L, (Object)IBMPKCS11Impl.className, "Init", "Unix fileName = " + var5_5);
                        }
                        if ((var11_21 = (var10_13 = new File(var5_5)).getName()) != null && var11_21.toLowerCase().startsWith("lib")) {
                            var5_5 = var10_13.getParent() + File.separator + var11_21.substring(3);
                        }
                        if (IBMPKCS11Impl.debug != null) {
                            IBMPKCS11Impl.debug.text(16384L, (Object)IBMPKCS11Impl.className, "Init", "Unix fileName2 = " + var5_5);
                        }
                        if (var5_5.toLowerCase().endsWith(".so")) {
                            var5_5 = var5_5.substring(0, var5_5.length() - 3);
                        }
                    }
                    var6_6 = this.config.getTokenLabel();
                    if (var6_6 == null) {
                        var9_9 = this.config.getSlotIndex();
                    }
                }
                if (IBMPKCS11Impl.debug != null) {
                    IBMPKCS11Impl.debug.text(16384L, (Object)IBMPKCS11Impl.className, "Init", "fileName = " + var5_5);
                }
                try {
                    this.pkcs11 = IBMPKCS11Impl.LIBS.get(var5_5);
                    if (this.pkcs11 == null) {
                        this.pkcs11 = new NativePKCS11(var5_5);
                        this.pkcs11.libInitialize();
                        IBMPKCS11Impl.LIBS.put(var5_5, this.pkcs11);
                    }
                }
                catch (PKCS11Exception var10_16) {
                    throw new IOException("Invalid dll name : " + var5_5);
                }
                if (IBMPKCS11Impl.debug != null) {
                    System.out.println("P5");
                }
                var3_3 = this.pkcs11.getSlotList(true);
                if (var6_6 != null) {
                    var10_17 = false;
                    for (var11_22 = 0; var11_22 < var3_3.length; ++var11_22) {
                        var12_23 = var3_3[var11_22].getTokenInfo().label();
                        if (!var6_6.equals(var12_23)) continue;
                        var9_9 = var11_22;
                        var10_17 = true;
                        break;
                    }
                    if (!var10_17) {
                        throw new IOException("Invalid Token Label : " + var6_6);
                    }
                }
                if (var9_9 < 0 || var9_9 > var3_3.length - 1) {
                    throw new IOException("Invalid slot number : " + var9_9);
                }
                this.tokenSlot = var3_3[var9_9];
                if (IBMPKCS11Impl.debug != null) {
                    IBMPKCS11Impl.debug.text(16384L, (Object)IBMPKCS11Impl.className, "Init", "Slot Info:" + this.tokenSlot.getInfo().toString());
                    IBMPKCS11Impl.debug.text(16384L, (Object)IBMPKCS11Impl.className, "Init", "Token Info:" + this.tokenSlot.getTokenInfo().toString());
                }
                try {
                    this.session = this.tokenSlot.openSession(6, null, null);
                }
                catch (PKCS11Exception var10_18) {
                    if (IBMPKCS11Impl.debug != null) {
                        IBMPKCS11Impl.debug.text(16384L, (Object)IBMPKCS11Impl.className, "Init", "Creation of read write session failed:" + var10_18.getMessage());
                    }
                    if (var10_18.getCode() == 226) {
                        this.session = this.tokenSlot.openSession(4, null, null);
                    }
                    throw new IOException(var10_18.getMessage());
                }
                if (var7_7 != null) {
                    this.session.login(false, (Object)new String(var7_7));
                }
            }
        }
        var10_10 = null;
        if (this.session != null) {
            var10_10 = this.session.getSlot().getMechanismList();
            if (IBMPKCS11Impl.debug != null) {
                var11_19 = new ArrayList<E>();
                for (var12_24 = 0; var12_24 < ((Object)var10_10).length; ++var12_24) {
                    var11_19.add(PKCS11Mechanism.typeToString((int)var10_10[var12_24]));
                }
                IBMPKCS11Impl.debug.text(16384L, (Object)IBMPKCS11Impl.className, "Init", "Mechanisms: " + var11_19.toString());
            }
        }
        var11_19 = this;
        if (this.config == null) {
            if (this.session != null) {
                var12_25 = new Config((String)null);
                var13_27 = var12_25.getSupportedServices((int[])var10_10);
                AccessController.doPrivileged(new PrivilegedAction((Provider)var11_19){
                    final /* synthetic */ Provider val$pkcs11impl;
                    {
                        this.val$pkcs11impl = provider;
                    }

                    public Object run() {
                        for (int i = 0; i < var13_27.length; ++i) {
                            IBMPKCS11Impl.this.putService(new PKCS11ImplService(IBMPKCS11Impl.this.session, this.val$pkcs11impl, var13_27[i].getType(), var13_27[i].getAlgorithm(), var13_27[i].getClassName(), var13_27[i].getAlaises(), var13_27[i].getMechanism()));
                        }
                        return null;
                    }
                });
            }
        } else {
            var12_26 = this.config.getSupportedServices((int[])var10_10);
            AccessController.doPrivileged(new PrivilegedAction((Provider)var11_19){
                final /* synthetic */ Provider val$pkcs11impl;
                {
                    this.val$pkcs11impl = provider;
                }

                public Object run() {
                    for (int i = 0; i < var12_26.length; ++i) {
                        IBMPKCS11Impl.this.putService(new PKCS11ImplService(IBMPKCS11Impl.this.session, this.val$pkcs11impl, var12_26[i].getType(), var12_26[i].getAlgorithm(), var12_26[i].getClassName(), var12_26[i].getAlaises(), var12_26[i].getMechanism()));
                    }
                    return null;
                }
            });
        }
        if (IBMPKCS11Impl.debug != null) {
            IBMPKCS11Impl.debug.exit(16384L, (Object)IBMPKCS11Impl.className, "Init");
        }
    }

    public void login(Subject subject, CallbackHandler callbackHandler) throws LoginException {
        char[] cArray;
        SecurityManager securityManager;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "login", (Object)subject, (Object)callbackHandler);
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "login", "checking login permission");
            }
            securityManager.checkPermission(new SecurityPermission("authProvider." + this.getName()));
        }
        CallbackHandler callbackHandler2 = null;
        callbackHandler2 = callbackHandler == null ? this.getCallbackHandler() : callbackHandler;
        Callback[] callbackArray = new Callback[]{new PasswordCallback("password: ", false)};
        try {
            callbackHandler2.handle(callbackArray);
            char[] cArray2 = ((PasswordCallback)callbackArray[0]).getPassword();
            cArray = new char[cArray2.length];
            System.arraycopy(cArray2, 0, cArray, 0, cArray2.length);
            ((PasswordCallback)callbackArray[0]).clearPassword();
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "login", (Throwable)iOException);
            }
            throw new LoginException(iOException.toString());
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "login", (Throwable)unsupportedCallbackException);
            }
            throw new LoginException("Error: " + unsupportedCallbackException.getCallback().toString() + " not available to get PIN from the user");
        }
        try {
            this.session.login(false, (Object)new String(cArray));
        }
        catch (PKCS11Exception pKCS11Exception) {
            if (pKCS11Exception.getCode() == 256) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "login", (Object)"user already logged in");
                }
                return;
            }
            if (debug != null) {
                debug.exception(16384L, (Object)className, "login", (Throwable)pKCS11Exception);
            }
            throw new LoginException("PKCS11 error code = " + pKCS11Exception.getCode());
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "login");
        }
    }

    public void logout() throws LoginException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (debug != null) {
                System.out.println("checking login permission");
            }
            securityManager.checkPermission(new SecurityPermission("authProvider." + this.getName()));
        }
        try {
            this.session.logout();
            if (debug != null) {
                System.out.println("logout succeeded");
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            if (pKCS11Exception.getCode() == 257) {
                if (debug != null) {
                    System.out.println("user already logged in");
                }
                return;
            }
            throw new LoginException("PKCS11 error code = " + pKCS11Exception.getCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCallbackHandler(CallbackHandler callbackHandler) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (debug != null) {
                System.out.println("checking login permission");
            }
            securityManager.checkPermission(new SecurityPermission("authProvider." + this.getName()));
        }
        CallbackHandler callbackHandler2 = this.callbackHand;
        synchronized (callbackHandler2) {
            this.callbackHand = callbackHandler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CallbackHandler getCallbackHandler() {
        CallbackHandler callbackHandler = this.callbackHand;
        synchronized (callbackHandler) {
            if (this.callbackHand != null) {
                return this.callbackHand;
            }
            try {
                CallbackHandler callbackHandler2;
                if (debug != null) {
                    System.out.println("getting default callback handler");
                }
                this.callbackHand = callbackHandler2 = (CallbackHandler)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        String string = Security.getProperty("auth.login.defaultCallbackHandler");
                        if (string == null || string.length() == 0) {
                            if (debug != null) {
                                System.out.println("no default handler set");
                            }
                            return null;
                        }
                        Class<?> clazz = Class.forName(string, true, Thread.currentThread().getContextClassLoader());
                        return clazz.newInstance();
                    }
                });
                return this.callbackHand;
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (debug != null) {
                    System.out.println("Unable to load default callback handler");
                    privilegedActionException.printStackTrace();
                }
            }
        }
        return null;
    }

    static final void verifyJceJar() {
        if (verifiedJce) {
            return;
        }
        String string = System.getProperty("java.version");
        if (string.compareTo("1.4") >= 0) {
            verifiedJce = true;
            return;
        }
        IBMPKCS11Impl.doVerifyJceJar();
    }

    private static final synchronized void doVerifyJceJar() {
        Object object;
        Object object2;
        if (verifiedJce) {
            return;
        }
        URL uRL = null;
        try {
            object2 = IBMPKCS11Impl.class;
            object = ((Class)object2).getClassLoader();
            URL uRL2 = (URL)AccessController.doPrivileged(new PrivilegedAction((ClassLoader)object){
                final /* synthetic */ ClassLoader val$cl;
                {
                    this.val$cl = classLoader;
                }

                public Object run() {
                    return this.val$cl.getResource("javax/crypto/Cipher.class");
                }
            });
            if (uRL2 == null) {
                throw new SecurityException("Cannot get the JCE framework URL. Check that IBMPKCS11Impl can read the JCE framework");
            }
            int n = IBMPKCS11Impl.indexOfBang(uRL2.toString());
            if (n == -1) {
                throw new SecurityException("The JCE framework is invalid");
            }
            uRL = new URL(uRL2.toString().substring(0, n + 1));
            int n2 = 4;
            URL uRL3 = new URL(uRL2.toString().substring(n2, n - 1));
            if (!uRL3.getProtocol().equalsIgnoreCase("file")) {
                throw new SecurityException("JCE should be deployed as an installed extension");
            }
        }
        catch (IOException iOException) {
            throw new SecurityException("The provider IBMPKCS11Impl cannot authenticate JCE framework" + iOException);
        }
        try {
            object = uRL;
            object2 = (JarFile)AccessController.doPrivileged(new PrivilegedExceptionAction((URL)object){
                final /* synthetic */ URL val$url;
                {
                    this.val$url = uRL;
                }

                public Object run() throws Exception {
                    return ((JarURLConnection)this.val$url.openConnection()).getJarFile();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new SecurityException("Cannot authenticate JCE framework " + privilegedActionException);
        }
        try {
            IBMPKCS11Impl.verifySingleJarFile((JarFile)object2);
        }
        catch (Exception exception) {
            throw new SecurityException("Cannot authenticate JCE framework " + exception);
        }
        verifiedJce = true;
    }

    private static void verifySingleJarFile(JarFile jarFile) throws IOException, CertificateException {
        Object object;
        Cloneable cloneable;
        Vector<Manifest> vector = new Vector<Manifest>();
        byte[] byArray = new byte[8192];
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            int n;
            cloneable = enumeration.nextElement();
            vector.addElement((Manifest)cloneable);
            object = jarFile.getInputStream((ZipEntry)cloneable);
            while ((n = ((InputStream)object).read(byArray, 0, byArray.length)) != -1) {
            }
            ((InputStream)object).close();
        }
        cloneable = jarFile.getManifest();
        if (cloneable == null) {
            throw new SecurityException("The JCE framework is not signed");
        }
        trustedCaCerts = IBMPKCS11Impl.setupTrustedCaCerts();
        object = new Vector(2);
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            JarEntry jarEntry = (JarEntry)enumeration2.nextElement();
            if (jarEntry.isDirectory()) continue;
            Certificate[] certificateArray = jarEntry.getCertificates();
            if (certificateArray == null || certificateArray.length == 0) {
                if (jarEntry.getName().startsWith("META-INF")) continue;
                throw new SecurityException("The JCE framework has unsigned class files.");
            }
            Certificate[] certificateArray2 = IBMPKCS11Impl.getChainRoots(certificateArray);
            boolean bl = false;
            for (int i = 0; i < certificateArray2.length; ++i) {
                if (((Vector)object).contains((X509Certificate)certificateArray2[i])) {
                    bl = true;
                    break;
                }
                if (!IBMPKCS11Impl.isTrusted((X509Certificate)certificateArray2[i])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            throw new SecurityException("JCE framework is not signed by a trusted signer");
        }
    }

    private static boolean isTrusted(X509Certificate x509Certificate) {
        int n;
        for (n = 0; n < trustedCaCerts.length; ++n) {
            if (!((Object)x509Certificate.getSubjectDN()).equals(trustedCaCerts[n].getSubjectDN()) || !x509Certificate.equals(trustedCaCerts[n])) continue;
            return true;
        }
        for (n = 0; n < trustedCaCerts.length; ++n) {
            if (!((Object)x509Certificate.getIssuerDN()).equals(trustedCaCerts[n].getSubjectDN())) continue;
            try {
                x509Certificate.verify(trustedCaCerts[n].getPublicKey());
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private static Certificate[] getChainRoots(Certificate[] certificateArray) {
        Vector<Certificate> vector = new Vector<Certificate>(3);
        for (int i = 0; i < certificateArray.length - 1; ++i) {
            if (((Object)((X509Certificate)certificateArray[i + 1]).getSubjectDN()).equals(((X509Certificate)certificateArray[i]).getIssuerDN())) continue;
            vector.addElement(certificateArray[i]);
        }
        vector.addElement(certificateArray[certificateArray.length - 1]);
        Object[] objectArray = new Certificate[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private static X509Certificate[] setupTrustedCaCerts() throws IOException, CertificateException {
        int n = bytesOfTrustedCaCerts.length;
        X509Certificate[] x509CertificateArray = new X509Certificate[n];
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        for (int i = 0; i < n; ++i) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytesOfTrustedCaCerts[i]);
            x509CertificateArray[i] = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
            byteArrayInputStream.close();
        }
        return x509CertificateArray;
    }

    private static int indexOfBang(String string) {
        int n = string.lastIndexOf(".jar!/");
        if (n > 0) {
            return n + 5;
        }
        return -1;
    }

    static final boolean verifySelfIntegrity(Class clazz) {
        if (verifiedSelfIntegrity) {
            return true;
        }
        return IBMPKCS11Impl.doSelfVerification(clazz);
    }

    private static final synchronized boolean doSelfVerification(Class clazz) {
        Class clazz2;
        URL uRL;
        if (verifiedSelfIntegrity) {
            return true;
        }
        if (trustedCaCerts == null) {
            try {
                trustedCaCerts = IBMPKCS11Impl.setupTrustedCaCerts();
            }
            catch (Exception exception) {
                return false;
            }
        }
        if ((uRL = (URL)AccessController.doPrivileged(new PrivilegedAction(clazz2 = clazz){
            final /* synthetic */ Class val$cc;
            {
                this.val$cc = clazz;
            }

            public Object run() {
                CodeSource codeSource = this.val$cc.getProtectionDomain().getCodeSource();
                return codeSource.getLocation();
            }
        })) == null) {
            return false;
        }
        JarVerifier jarVerifier = new JarVerifier(uRL);
        try {
            jarVerifier.verify(trustedCaCerts);
        }
        catch (Exception exception) {
            return false;
        }
        verifiedSelfIntegrity = true;
        return true;
    }

    private static Certificate[] getSignerCertificates(Class clazz) {
        final Class clazz2 = clazz;
        return (Certificate[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                CodeSource codeSource = clazz2.getProtectionDomain().getCodeSource();
                return codeSource.getCertificates();
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PKCS11ImplService
    extends Provider.Service {
        private final PKCS11Session session;
        private final int mechanism;
        private final Provider provider;
        private final String algorithm;
        private final boolean isSunOS;

        PKCS11ImplService(PKCS11Session pKCS11Session, Provider provider, String string, String string2, String string3, String[] stringArray, int n) {
            super(provider, string, string2, string3, PKCS11ImplService.toList(stringArray), null);
            this.session = pKCS11Session;
            this.provider = provider;
            this.algorithm = string2;
            this.mechanism = n;
            String string4 = System.getProperty("os.name");
            this.isSunOS = string4.equals("SunOS");
        }

        private static List<String> toList(String[] stringArray) {
            return stringArray == null ? null : Arrays.asList(stringArray);
        }

        @Override
        public Object newInstance(Object object) throws NoSuchAlgorithmException {
            try {
                String string = this.getAlgorithm();
                String string2 = this.getType();
                String string3 = this.getClassName();
                try {
                    Class<?> clazz = Class.forName(string3);
                    Constructor<?>[] constructorArray = clazz.getConstructors();
                    if (constructorArray.length == 1 && constructorArray[0].getParameterTypes().length == 2) {
                        return constructorArray[0].newInstance(this.provider, string);
                    }
                    Class[] classArray = new Class[]{Class.forName("java.security.Provider")};
                    Constructor<?> constructor = clazz.getConstructor(classArray);
                    return constructor.newInstance(this.provider);
                }
                catch (Exception exception) {
                    throw new NoSuchAlgorithmException(exception);
                }
            }
            catch (PKCS11Exception pKCS11Exception) {
                throw new NoSuchAlgorithmException(pKCS11Exception);
            }
        }

        @Override
        public boolean supportsParameter(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof Key)) {
                throw new InvalidParameterException("Parameter must be a Key");
            }
            String string = this.getAlgorithm();
            String string2 = this.getType();
            Key key = (Key)object;
            String string3 = key.getAlgorithm();
            if ((string2.equals("Cipher") || string2.equals("Signature") || string2.equals("KeyAgreement")) && key instanceof PrivateKey && !(key instanceof PKCS11Key) && ((IBMPKCS11Impl)this.provider).getConfig() != null && ((IBMPKCS11Impl)this.provider).getConfig().getPublicKeyImportOnly()) {
                return false;
            }
            if (string2.equals("Cipher") && this.algorithm.startsWith("RSA") || string2.equals("Signature") && (this.algorithm.endsWith("RSA") || this.algorithm.startsWith("RSA"))) {
                if (!string3.equals("RSA")) {
                    return false;
                }
                if (!this.isSunOS && key instanceof RSAPublicKeyImpl) {
                    return true;
                }
                return this.isLocalKey(key) || !(key instanceof PKCS11Key) && (key instanceof RSAPrivateKey || key instanceof RSAPublicKey);
            }
            if (string2 == "Signature" && this.algorithm.endsWith("DSA")) {
                if (!string3.equals("DSA")) {
                    return false;
                }
                if (!this.isSunOS && key instanceof DSAPublicKeyImpl) {
                    return true;
                }
                boolean bl = this.isLocalKey(key) || !(key instanceof PKCS11Key) && (key instanceof DSAPrivateKey || key instanceof DSAPublicKey);
                return bl;
            }
            if (string2 == "Cipher" || string2 == "Mac") {
                return this.isLocalKey(key) || !(key instanceof PKCS11Key) && "RAW".equals(key.getFormat());
            }
            if (string2 == "KeyAgreement") {
                if (!string3.equals("DH")) {
                    return false;
                }
                return this.isLocalKey(key) || !(key instanceof PKCS11Key) && (key instanceof DHPrivateKey || key instanceof DHPublicKey);
            }
            if (debug != null) {
                debug.text(16384L, (Object)className, "IBMPKCS11Impl", "PKCS11 error: " + string2 + ", " + this.algorithm);
            }
            return false;
        }

        private boolean isLocalKey(Key key) {
            return key instanceof PKCS11Key && ((PKCS11Key)key).getSession() == this.session;
        }

        @Override
        public String toString() {
            return super.toString() + "\n" + "session = " + this.session + "\n" + "provider = " + this.provider + "\n" + "algorithm = " + this.algorithm + "\n" + "mechanism =" + this.mechanism;
        }
    }
}

