/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Signature;
import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;

final class GeneralSignature
extends SignatureSpi {
    private Signature sig;
    private int mechanism = 0;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.GeneralSignature";

    public GeneralSignature(Provider provider, String string) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "GeneralSignature");
        }
        if (string.equalsIgnoreCase("MD2withRSA")) {
            this.mechanism = 4;
        } else if (string.equalsIgnoreCase("MD5withRSA")) {
            this.mechanism = 5;
        } else if (string.equalsIgnoreCase("SHA1withRSA")) {
            this.mechanism = 6;
        } else if (string.equalsIgnoreCase("SHA256withRSA")) {
            this.mechanism = 64;
        } else if (string.equalsIgnoreCase("SHA384withRSA")) {
            this.mechanism = 65;
        } else if (string.equalsIgnoreCase("SHA512withRSA")) {
            this.mechanism = 66;
        } else if (string.equalsIgnoreCase("SHA1withDSA")) {
            this.mechanism = 18;
        } else {
            System.out.println("Algo = " + string);
        }
        this.sig = new Signature(this.mechanism, provider);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "GeneralSignature");
        }
    }

    protected void engineSetParameter(String string, Object object) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineSetParameter");
            debug.exit(16384L, (Object)className, "engineSetParameter");
        }
    }

    protected Object engineGetParameter(String string) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineGetParameter", (Object)string);
            debug.exit(16384L, (Object)className, "engineGetParameter");
        }
        return null;
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineInitSign", (Object)privateKey);
        }
        this.sig.engineInitSign(privateKey);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineInitSign");
        }
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineInitVerify", (Object)publicKey);
        }
        this.sig.engineInitVerify(publicKey);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineInitVerify");
        }
    }

    protected void engineUpdate(byte by) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineUpdate", (Object)by);
        }
        byte[] byArray = new byte[]{by};
        this.sig.engineUpdate(byArray, 0, 1);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineUpdate");
        }
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineUpdate", (Object)byArray, (Object)new Integer(n2));
        }
        this.sig.engineUpdate(byArray, n, n2);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineUpdate");
        }
    }

    protected byte[] engineSign() throws SignatureException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineSign");
        }
        byte[] byArray = this.sig.engineSign();
        if (this.mechanism == 18) {
            try {
                byte[] byArray2 = new byte[20];
                byte[] byArray3 = new byte[20];
                System.arraycopy(byArray, 0, byArray2, 0, 20);
                System.arraycopy(byArray, 20, byArray3, 0, byArray.length - 20);
                DerOutputStream derOutputStream = new DerOutputStream(100);
                derOutputStream.putInteger(new BigInteger(1, byArray2));
                derOutputStream.putInteger(new BigInteger(1, byArray3));
                DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineSign", "Signature = " + new HexDumpEncoder().encode(byArray));
                    debug.text(16384L, (Object)className, "engineSign", "Encoded Sign len = " + derValue.toByteArray().length);
                    debug.text(16384L, (Object)className, "engineSign", "Sign len = " + byArray.length);
                    debug.exit(16384L, (Object)className, "engineSign");
                }
                return derValue.toByteArray();
            }
            catch (IOException iOException) {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "engineSign", (Throwable)iOException);
                    debug.exit(16384L, (Object)className, "engineSign");
                }
                throw new SignatureException("error encoding signature");
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineSign");
        }
        return byArray;
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineVerify", (Object)byArray);
            debug.exit(16384L, (Object)className, "engineVerify");
        }
        return this.sig.engineVerify(byArray);
    }
}

