/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Hash;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import java.security.DigestException;
import java.security.MessageDigestSpi;
import java.security.Provider;

public final class GeneralHashing
extends MessageDigestSpi
implements Cloneable {
    private static final int MD2_LENGTH = 16;
    private static final int MD5_LENGTH = 16;
    private static final int SHA_LENGTH = 20;
    private static final int SHA2_LENGTH = 32;
    private static final int SHA3_LENGTH = 48;
    private static final int SHA5_LENGTH = 64;
    private Hash hash;
    private int mechanism;

    public GeneralHashing(Provider provider, String string) {
        if (string.equalsIgnoreCase("MD2")) {
            this.mechanism = 512;
        } else if (string.equalsIgnoreCase("MD5")) {
            this.mechanism = 528;
        } else if (string.equalsIgnoreCase("SHA")) {
            this.mechanism = 544;
        } else if (string.equalsIgnoreCase("SHA_256")) {
            this.mechanism = 592;
        } else if (string.equalsIgnoreCase("SHA_384")) {
            this.mechanism = 608;
        } else if (string.equalsIgnoreCase("SHA_512")) {
            this.mechanism = 624;
        } else {
            System.out.println("Algo = " + string);
        }
        this.init(provider);
    }

    private GeneralHashing(GeneralHashing generalHashing) {
        this.hash = (Hash)generalHashing.hash.clone();
        this.mechanism = generalHashing.mechanism;
    }

    public void init(Provider provider) {
        this.hash = new Hash(this.mechanism, ((IBMPKCS11Impl)provider).getSession());
    }

    protected void engineReset() {
        this.hash.engineReset();
    }

    protected int engineGetDigestLength() {
        int n = 0;
        switch (this.mechanism) {
            case 512: {
                n = 16;
                break;
            }
            case 528: {
                n = 16;
                break;
            }
            case 544: {
                n = 20;
                break;
            }
            case 592: {
                n = 32;
                break;
            }
            case 608: {
                n = 48;
                break;
            }
            case 624: {
                n = 64;
            }
        }
        return n;
    }

    protected synchronized void engineUpdate(byte by) {
        byte[] byArray = new byte[]{by};
        this.engineUpdate(byArray, 0, 1);
    }

    protected synchronized void engineUpdate(byte[] byArray, int n, int n2) {
        this.hash.engineUpdate(byArray, n, n2);
    }

    protected byte[] engineDigest() {
        byte[] byArray = this.hash.engineDigest();
        return byArray;
    }

    protected int engineDigest(byte[] byArray, int n, int n2) throws DigestException {
        int n3 = this.hash.engineDigest(byArray, n, n2);
        return n3;
    }

    public Object clone() {
        GeneralHashing generalHashing = null;
        try {
            generalHashing = (GeneralHashing)super.clone();
            generalHashing.hash = (Hash)this.hash.clone();
            return generalHashing;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return generalHashing;
        }
    }
}

