/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Config;
import com.ibm.crypto.pkcs11impl.provider.DSAParameterGenerator;
import com.ibm.crypto.pkcs11impl.provider.DSAPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.DSAPublicKey;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11DSAKeyPairParameterSpec;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import java.math.BigInteger;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public final class DSAPKCS11KeyPairGenerator
extends KeyPairGeneratorSpi {
    private Provider provider = null;
    private int keySize = 512;
    private PKCS11Session session = null;
    private Config config = null;
    private byte[] id = null;
    private byte[] subject = null;
    private String label = null;
    private Boolean isToken = new Boolean(false);
    private Boolean isSensitive = new Boolean(false);
    private Boolean extractable = null;
    private DSAParameterSpec dsaparams = null;
    private boolean paramsUsed = false;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.DSAPKCS11KeyPairGenerator";

    public DSAPKCS11KeyPairGenerator(Provider provider) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "DSAPKCS11KeyPairGenerator", (Object)"Provider");
        }
        this.session = ((IBMPKCS11Impl)provider).getSession();
        this.config = ((IBMPKCS11Impl)provider).getConfig();
        this.provider = provider;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "DSAPKCS11KeyPairGenerator", (Object)"Provider");
        }
    }

    public DSAPKCS11KeyPairGenerator() {
        this(Security.getProvider("IBMPKCS11Impl"));
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "initialize", (Object)algorithmParameterSpec, (Object)secureRandom);
        }
        if (algorithmParameterSpec == null || !(algorithmParameterSpec instanceof PKCS11DSAKeyPairParameterSpec)) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "initialize", "PKCS11 DSA KeyPair Parameters must be specified");
            }
            throw new InvalidAlgorithmParameterException("PKCS11 DSA KeyPair Parameters must be specified");
        }
        PKCS11DSAKeyPairParameterSpec pKCS11DSAKeyPairParameterSpec = (PKCS11DSAKeyPairParameterSpec)algorithmParameterSpec;
        this.keySize = pKCS11DSAKeyPairParameterSpec.getKeySize();
        if (pKCS11DSAKeyPairParameterSpec.getKeyID() != null) {
            try {
                this.id = pKCS11DSAKeyPairParameterSpec.getKeyID().getBytes("8859_1");
            }
            catch (Exception exception) {
                this.id = pKCS11DSAKeyPairParameterSpec.getKeyID().getBytes();
            }
        }
        if (pKCS11DSAKeyPairParameterSpec.getSubject() != null) {
            try {
                this.subject = pKCS11DSAKeyPairParameterSpec.getSubject().getBytes("8859_1");
            }
            catch (Exception exception) {
                this.subject = pKCS11DSAKeyPairParameterSpec.getSubject().getBytes();
            }
        }
        this.label = pKCS11DSAKeyPairParameterSpec.getLabel();
        this.isSensitive = pKCS11DSAKeyPairParameterSpec.getSensitive();
        this.isToken = pKCS11DSAKeyPairParameterSpec.getToken();
        this.extractable = pKCS11DSAKeyPairParameterSpec.getExtractable();
        this.dsaparams = (DSAParameterSpec)pKCS11DSAKeyPairParameterSpec.getParams();
        this.paramsUsed = true;
        if (this.dsaparams == null) {
            this.generateParameters();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "initialize");
        }
    }

    public void initialize(int n, SecureRandom secureRandom) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "initialize", (Object)(" " + n), (Object)secureRandom);
        }
        if (n < 512) {
            throw new InvalidParameterException("DSA Key size must be at least 512 bit");
        }
        if (n > 1024 || (n & 0x3F) != 0) {
            throw new InvalidParameterException("Key size must be a multiple of 64 and at most 1024 bit");
        }
        this.keySize = n;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "initialize");
        }
    }

    public void initialize(int n) {
        this.initialize(n, null);
    }

    public KeyPair generateKeyPair() {
        KeyPair keyPair;
        block46: {
            Integer n6;
            Object object2;
            Object object3;
            if (debug != null) {
                debug.entry(16384L, (Object)className, "generateKeyPair");
            }
            PKCS11Object[] pKCS11ObjectArray = null;
            keyPair = null;
            DSAPublicKey dSAPublicKey = null;
            DSAPrivateKey dSAPrivateKey = null;
            int n2 = 8;
            int n3 = 7;
            int n4 = 0;
            HashMap<Integer, Object> hashMap = null;
            Set<Integer> set = null;
            Boolean bl = this.isToken;
            Boolean bl2 = this.isToken;
            if (this.dsaparams == null) {
                this.generateParameters();
            }
            if (this.isSensitive == null) {
                --n3;
            }
            if (bl == null) {
                --n2;
            }
            if (bl2 == null) {
                --n3;
            }
            if (this.extractable == null) {
                --n3;
            }
            if (this.config != null) {
                hashMap = this.config.getAttributes("GENERATE", PKCS11Object.PUBLIC_KEY, PKCS11Object.DSA);
                set = hashMap.keySet();
                object3 = set.iterator();
                block16: while (object3.hasNext()) {
                    object2 = (Integer)object3.next();
                    switch ((Integer)object2) {
                        case 1: {
                            if (this.paramsUsed) continue block16;
                            if (bl == null) {
                                ++n2;
                            }
                            bl = (Boolean)hashMap.get(object2);
                            continue block16;
                        }
                        case 266: {
                            continue block16;
                        }
                    }
                    ++n2;
                }
            }
            object3 = new int[n2];
            object2 = new Object[n2];
            boolean bl3 = true;
            if (bl != null) {
                object3[n4] = 1;
                object2[n4++] = bl;
            }
            object3[n4] = 258;
            object2[n4++] = this.id;
            object3[n4] = 257;
            object2[n4++] = this.subject;
            object3[n4] = 3;
            object2[n4++] = this.label;
            if (set != null) {
                for (Integer object4 : set) {
                    if (object4 == 1) continue;
                    if (object4 == 266) {
                        bl3 = false;
                    }
                    object3[n4] = object4;
                    object2[n4++] = hashMap.get(object4);
                }
            }
            if (bl3) {
                object3[n4] = 266;
                object2[n4++] = Boolean.TRUE;
            }
            object3[n4] = 304;
            object2[n4++] = this.dsaparams.getP();
            object3[n4] = 305;
            object2[n4++] = this.dsaparams.getQ();
            object3[n4] = 306;
            object2[n4] = this.dsaparams.getG();
            if (this.config != null) {
                hashMap = this.config.getAttributes("GENERATE", PKCS11Object.PRIVATE_KEY, PKCS11Object.DSA);
                set = hashMap.keySet();
                block18: for (Integer n5 : set) {
                    switch (n5) {
                        case 1: {
                            if (this.paramsUsed) continue block18;
                            if (bl2 == null) {
                                ++n3;
                            }
                            bl2 = (Boolean)hashMap.get(n5);
                            continue block18;
                        }
                        case 259: {
                            if (this.paramsUsed) continue block18;
                            if (this.isSensitive == null) {
                                ++n3;
                            }
                            this.isSensitive = (Boolean)hashMap.get(n5);
                            continue block18;
                        }
                        case 354: {
                            if (this.paramsUsed) continue block18;
                            if (this.extractable == null) {
                                ++n3;
                            }
                            this.extractable = (Boolean)hashMap.get(n5);
                            continue block18;
                        }
                        case 264: {
                            continue block18;
                        }
                    }
                    ++n3;
                }
            }
            Iterator<Integer> iterator = (Iterator<Integer>)new int[n3];
            Object[] objectArray = new Object[n3];
            n4 = 0;
            boolean bl4 = true;
            if (bl2 != null) {
                iterator[n4] = (Iterator<Integer>)true;
                objectArray[n4++] = bl2;
            }
            iterator[n4] = (Iterator<Integer>)258;
            objectArray[n4++] = this.id;
            iterator[n4] = (Iterator<Integer>)257;
            objectArray[n4++] = this.subject;
            iterator[n4] = (Iterator<Integer>)3;
            objectArray[n4++] = this.label;
            if (this.isSensitive != null) {
                iterator[n4] = (Iterator<Integer>)259;
                objectArray[n4++] = this.isSensitive;
            }
            if (this.extractable != null) {
                iterator[n4] = (Iterator<Integer>)354;
                objectArray[n4] = this.extractable;
            }
            if (set != null) {
                for (Integer n6 : set) {
                    if (n6 == 1 || n6 == 259 || n6 == 354) continue;
                    if (n6 == 264) {
                        bl4 = false;
                    }
                    iterator[n4] = (Iterator<Integer>)((Object)n6);
                    objectArray[n4++] = hashMap.get(n6);
                }
            }
            if (bl4) {
                iterator[n4] = (Iterator<Integer>)264;
                objectArray[n4++] = Boolean.TRUE;
            }
            try {
                pKCS11ObjectArray = this.session.generateKeyPair(16, null, (int[])object3, (Object[])object2, iterator, objectArray);
            }
            catch (Exception exception) {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "generateKeyPair_1", (Throwable)exception);
                }
                throw new RuntimeException(exception.getMessage());
            }
            PKCS11Object[] pKCS11ObjectArray2 = this.orderObjects(pKCS11ObjectArray);
            n6 = pKCS11ObjectArray2[0];
            PKCS11Object pKCS11Object = pKCS11ObjectArray2[1];
            try {
                dSAPublicKey = new DSAPublicKey(this.session, (PKCS11Object)n6, this.id, this.subject, this.label, this.isToken, (BigInteger)this.getValue((PKCS11Object)n6, 304), (BigInteger)this.getValue((PKCS11Object)n6, 305), (BigInteger)this.getValue((PKCS11Object)n6, 306), new BigInteger(1, (byte[])this.getValue((PKCS11Object)n6, 17)));
                if (this.isSensitive.booleanValue()) {
                    dSAPrivateKey = new DSAPrivateKey(this.session, pKCS11Object, this.label, this.id, this.subject, this.isToken, this.isSensitive, this.extractable);
                } else {
                    try {
                        dSAPrivateKey = new DSAPrivateKey(this.session, pKCS11Object, this.label, this.id, this.subject, this.isToken, this.isSensitive, this.extractable, (BigInteger)this.getValue(pKCS11Object, 304), (BigInteger)this.getValue(pKCS11Object, 305), (BigInteger)this.getValue(pKCS11Object, 306), new BigInteger(1, (byte[])this.getValue(pKCS11Object, 17)));
                    }
                    catch (Exception exception) {
                        dSAPrivateKey = new DSAPrivateKey(this.session, pKCS11Object, this.label, this.id, this.subject, this.isToken, this.isSensitive, this.extractable);
                    }
                }
                keyPair = new KeyPair(dSAPublicKey, dSAPrivateKey);
            }
            catch (Exception exception) {
                keyPair = null;
                if (debug == null) break block46;
                debug.exception(16384L, (Object)className, "generateKeyPair_2", (Throwable)exception);
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "generateKeyPair");
        }
        return keyPair;
    }

    private void generateParameters() {
        SecureRandom secureRandom;
        AlgorithmParameterGenerator algorithmParameterGenerator;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "generateParameters");
        }
        switch (this.keySize) {
            case 512: {
                this.dsaparams = new DSAParameterSpec(DSAParameterGenerator.p_512, DSAParameterGenerator.q_512, DSAParameterGenerator.g_512);
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "generateParameters", (Object)this.dsaparams);
                }
                return;
            }
            case 768: {
                this.dsaparams = new DSAParameterSpec(DSAParameterGenerator.p_768, DSAParameterGenerator.q_768, DSAParameterGenerator.g_768);
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "generateParameters", (Object)this.dsaparams);
                }
                return;
            }
            case 1024: {
                this.dsaparams = new DSAParameterSpec(DSAParameterGenerator.p_1024, DSAParameterGenerator.q_1024, DSAParameterGenerator.g_1024);
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "generateParameters", (Object)this.dsaparams);
                }
                return;
            }
        }
        try {
            algorithmParameterGenerator = AlgorithmParameterGenerator.getInstance("DSA", this.provider);
            secureRandom = SecureRandom.getInstance("IBMSecureRandom", this.provider);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "generateParameters_1", (Throwable)noSuchAlgorithmException);
            }
            throw new RuntimeException(noSuchAlgorithmException.getMessage());
        }
        algorithmParameterGenerator.init(this.keySize, secureRandom);
        AlgorithmParameters algorithmParameters = algorithmParameterGenerator.generateParameters();
        try {
            this.dsaparams = algorithmParameters.getParameterSpec(DSAParameterSpec.class);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "generateParameters_3", (Throwable)invalidParameterSpecException);
            }
            throw new Error();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "generateParameters");
        }
    }

    private PKCS11Object[] orderObjects(PKCS11Object[] pKCS11ObjectArray) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "orderObjects");
        }
        Integer n = (Integer)this.getValue(pKCS11ObjectArray[0], 0);
        Integer n2 = (Integer)this.getValue(pKCS11ObjectArray[1], 0);
        PKCS11Object pKCS11Object = null;
        PKCS11Object pKCS11Object2 = null;
        if (n.equals(PKCS11Object.PUBLIC_KEY) && n2.equals(PKCS11Object.PRIVATE_KEY)) {
            pKCS11Object2 = pKCS11ObjectArray[0];
            pKCS11Object = pKCS11ObjectArray[1];
        } else if (n.equals(PKCS11Object.PRIVATE_KEY) && n2.equals(PKCS11Object.PUBLIC_KEY)) {
            pKCS11Object2 = pKCS11ObjectArray[1];
            pKCS11Object = pKCS11ObjectArray[0];
        } else {
            if (debug != null) {
                debug.text(16384L, (Object)className, "orderObjects", "Token returns invalid objects");
            }
            throw new RuntimeException("Token returns invalid objects");
        }
        pKCS11ObjectArray[0] = pKCS11Object2;
        pKCS11ObjectArray[1] = pKCS11Object;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "orderObjects");
        }
        return pKCS11ObjectArray;
    }

    private Object getValue(PKCS11Object pKCS11Object, int n) {
        Object object;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getValue", (Object)pKCS11Object, (Object)new Integer(n));
        }
        try {
            object = pKCS11Object.getAttributeValue(n);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "getValue", exception.getMessage());
            }
            object = null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getValue");
        }
        return object;
    }
}

