/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Config;
import com.ibm.crypto.pkcs11impl.provider.PKCS11PrivateKey;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.spec.DHParameterSpec;

class DHPKCS11PrivateKey
implements PKCS11PrivateKey,
DHPrivateKey,
Serializable {
    private static final long serialVersionUID = 3258417222417265719L;
    private static final BigInteger PKCS8_VERSION = BigInteger.valueOf(0L);
    private BigInteger x = null;
    private byte[] key = null;
    private byte[] encodedKey = null;
    private BigInteger p = null;
    private BigInteger g = null;
    private int l = 0;
    private int[] DH_data = new int[]{1, 2, 840, 113549, 1, 3, 1};
    private PKCS11Object p11Object = null;

    public DHPKCS11PrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, PKCS11Session pKCS11Session, Config config) throws InvalidKeyException {
        this.x = bigInteger;
        this.l = this.x.bitLength();
        this.p = bigInteger2;
        this.g = bigInteger3;
        try {
            this.key = new DerValue(2, this.x.toByteArray()).toByteArray();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException("Cannot produce ASN.1 encoding for the private key");
        }
        this.importPrivateKeyIntoToken(pKCS11Session, config);
    }

    public DHPKCS11PrivateKey(PKCS11Object pKCS11Object) throws InvalidKeyException {
        this.p11Object = pKCS11Object;
        try {
            this.x = new BigInteger(1, (byte[])this.getAttrValue(this.p11Object, 17));
            this.l = this.x.bitLength();
            this.p = (BigInteger)this.getAttrValue(this.p11Object, 304);
            this.g = (BigInteger)this.getAttrValue(this.p11Object, 306);
            this.key = new DerValue(2, this.x.toByteArray()).toByteArray();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException("Cannot produce ASN.1 encoding");
        }
    }

    public DHPKCS11PrivateKey(byte[] byArray, PKCS11Session pKCS11Session, Config config) throws InvalidKeyException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            DerValue derValue = new DerValue((InputStream)byteArrayInputStream);
            if (derValue.getTag() != 48) {
                throw new InvalidKeyException("Key not a SEQUENCE");
            }
            BigInteger bigInteger = derValue.getData().getInteger();
            if (!bigInteger.equals(PKCS8_VERSION)) {
                throw new IOException("version mismatch: (supported: " + PKCS8_VERSION + ", parsed: " + bigInteger);
            }
            DerValue derValue2 = derValue.getData().getDerValue();
            if (derValue2.getTag() != 48) {
                throw new InvalidKeyException("AlgId is not a SEQUENCE");
            }
            DerInputStream derInputStream = derValue2.toDerInputStream();
            ObjectIdentifier objectIdentifier = derInputStream.getOID();
            if (derInputStream.available() == 0) {
                throw new InvalidKeyException("Parameters missing");
            }
            if (!objectIdentifier.equals(ObjectIdentifier.newInternal((int[])this.DH_data))) {
                throw new InvalidKeyException("AlgorithID is not PKCS DH");
            }
            DerValue derValue3 = derInputStream.getDerValue();
            if (derValue3.getTag() == 5) {
                throw new InvalidKeyException("Null parameters");
            }
            if (derValue3.getTag() != 48) {
                throw new InvalidKeyException("Parameters not a SEQUENCE");
            }
            derValue3.getData().reset();
            this.p = derValue3.getData().getInteger();
            this.g = derValue3.getData().getInteger();
            if (derValue3.getData().available() != 0) {
                this.l = derValue3.getData().getInteger().intValue();
            }
            if (derValue3.getData().available() != 0) {
                throw new InvalidKeyException("Extra parameter data");
            }
            this.key = derValue.getData().getOctetString();
            this.parseKeyBits();
            this.encodedKey = (byte[])byArray.clone();
            this.importPrivateKeyIntoToken(pKCS11Session, config);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidKeyException("Private-value length too big");
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException.toString());
        }
    }

    private void importPrivateKeyIntoToken(PKCS11Session pKCS11Session, Config config) {
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        hashMap.put(0, PKCS11Object.PRIVATE_KEY);
        hashMap.put(256, PKCS11Object.DH);
        hashMap.put(268, Boolean.TRUE);
        hashMap.put(304, this.p);
        hashMap.put(306, this.g);
        hashMap.put(17, this.x.toByteArray());
        hashMap.put(352, this.l);
        hashMap.putAll(config.getAttributes("IMPORT", PKCS11Object.PRIVATE_KEY, PKCS11Object.DH));
        int[] nArray = new int[hashMap.size()];
        Object[] objectArray = new Object[hashMap.size()];
        Iterator iterator = hashMap.entrySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            nArray[n] = (Integer)entry.getKey();
            objectArray[n++] = entry.getValue();
        }
        this.p11Object = pKCS11Session.createObject(nArray, objectArray);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("IBMPKCS11 Diffie-Hellman Private Key:\nx:\n" + this.x.toString() + "\n" + "p:\n" + this.p.toString() + "\n" + "g:\n" + this.g.toString());
        return stringBuffer.toString();
    }

    public String getAlgorithm() {
        return "DH";
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public byte[] getEncoded() {
        if (this.encodedKey == null) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                derOutputStream.putInteger(PKCS8_VERSION);
                DerOutputStream derOutputStream2 = new DerOutputStream();
                derOutputStream2.putOID(new ObjectIdentifier(this.DH_data));
                DerOutputStream derOutputStream3 = new DerOutputStream();
                derOutputStream3.putInteger(this.p);
                derOutputStream3.putInteger(this.g);
                if (this.l != 0) {
                    derOutputStream3.putInteger(BigInteger.valueOf(this.l));
                }
                DerValue derValue = new DerValue(48, derOutputStream3.toByteArray());
                derOutputStream2.putDerValue(derValue);
                derOutputStream.write((byte)48, derOutputStream2);
                derOutputStream.putOctetString(this.key);
                DerOutputStream derOutputStream4 = new DerOutputStream();
                derOutputStream4.write((byte)48, derOutputStream);
                this.encodedKey = derOutputStream4.toByteArray();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return (byte[])this.encodedKey.clone();
    }

    public BigInteger getX() {
        return this.x;
    }

    public DHParameterSpec getParams() {
        return new DHParameterSpec(this.p, this.g, this.l);
    }

    private void parseKeyBits() throws InvalidKeyException {
        try {
            DerInputStream derInputStream = new DerInputStream(this.key);
            this.x = derInputStream.getInteger();
            this.l = this.x.bitLength();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException.toString());
        }
    }

    public byte[] getSubject() {
        return null;
    }

    public Boolean getSensitive() {
        return (Boolean)this.getAttrValue(this.p11Object, 259);
    }

    public Boolean getSecondaryAuth() {
        return (Boolean)this.getAttrValue(this.p11Object, 512);
    }

    public Integer getAuthPinFlags() {
        return (Integer)this.getAttrValue(this.p11Object, 513);
    }

    public Boolean getDecrypt() {
        return (Boolean)this.getAttrValue(this.p11Object, 261);
    }

    public Boolean getSign() {
        return (Boolean)this.getAttrValue(this.p11Object, 264);
    }

    public Boolean getSignRecover() {
        return (Boolean)this.getAttrValue(this.p11Object, 265);
    }

    public Boolean getUnwrap() {
        return (Boolean)this.getAttrValue(this.p11Object, 263);
    }

    public Boolean getExtractable() {
        return (Boolean)this.getAttrValue(this.p11Object, 354);
    }

    public Boolean getAlwaysSensitive() {
        return (Boolean)this.getAttrValue(this.p11Object, 357);
    }

    public Boolean getNeverExtractable() {
        return (Boolean)this.getAttrValue(this.p11Object, 356);
    }

    public PKCS11Session getSession() {
        return this.p11Object.getSession();
    }

    public PKCS11Object getObject() {
        return this.p11Object;
    }

    public Boolean getToken() {
        return (Boolean)this.getAttrValue(this.p11Object, 1);
    }

    public Boolean getPrivate() {
        return (Boolean)this.getAttrValue(this.p11Object, 2);
    }

    public String getLabel() {
        return null;
    }

    public Boolean getModifiable() {
        return (Boolean)this.getAttrValue(this.p11Object, 368);
    }

    public Integer getKeyType() {
        return PKCS11Object.DH;
    }

    public byte[] getID() {
        return (byte[])this.getAttrValue(this.p11Object, 258);
    }

    public Date getStartDate() {
        return null;
    }

    public Date getEndDate() {
        return null;
    }

    public Boolean getDerive() {
        return (Boolean)this.getAttrValue(this.p11Object, 268);
    }

    public Boolean getLocal() {
        return (Boolean)this.getAttrValue(this.p11Object, 355);
    }

    private Object getAttrValue(PKCS11Object pKCS11Object, int n) {
        Object object;
        try {
            object = pKCS11Object.getAttributeValue(n);
        }
        catch (Exception exception) {
            object = null;
        }
        return object;
    }
}

