/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Config;
import com.ibm.crypto.pkcs11impl.provider.DHPKCS11PrivateKey;
import com.ibm.crypto.pkcs11impl.provider.DHPKCS11PublicKey;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.HashMap;
import java.util.Iterator;
import javax.crypto.spec.DHParameterSpec;

public final class DHPKCS11KeyPairGenerator
extends KeyPairGeneratorSpi {
    private PKCS11Session session = null;
    private DHParameterSpec dhparamSpec = null;
    private Provider provider = null;
    private SecureRandom random = null;
    private Config config = null;

    public DHPKCS11KeyPairGenerator(Provider provider) {
        IBMPKCS11Impl.verifyJceJar();
        this.session = ((IBMPKCS11Impl)provider).getSession();
        this.config = ((IBMPKCS11Impl)provider).getConfig();
        this.provider = provider;
    }

    public void initialize(int n, SecureRandom secureRandom) {
        if (n < 512 || n > 1024 || n % 64 != 0) {
            throw new InvalidParameterException("Keysize must be multiple of 64, and can only range from 512 to 1024 (inclusive)");
        }
        this.random = secureRandom;
        try {
            AlgorithmParameterGenerator algorithmParameterGenerator = AlgorithmParameterGenerator.getInstance("DH", this.provider);
            algorithmParameterGenerator.init(n);
            AlgorithmParameters algorithmParameters = algorithmParameterGenerator.generateParameters();
            this.dhparamSpec = algorithmParameters.getParameterSpec(DHParameterSpec.class);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InvalidParameterException(noSuchAlgorithmException.getMessage());
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidParameterException(invalidParameterSpecException.getMessage());
        }
    }

    public KeyPair generateKeyPair() {
        KeyPair keyPair = null;
        try {
            PKCS11Object[] pKCS11ObjectArray;
            Object object;
            HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
            hashMap.put(304, this.dhparamSpec.getP());
            hashMap.put(306, this.dhparamSpec.getG());
            if (this.config != null) {
                hashMap.putAll(this.config.getAttributes("GENERATE", PKCS11Object.PUBLIC_KEY, PKCS11Object.DH));
            }
            HashMap<Integer, Object> hashMap2 = new HashMap<Integer, Object>();
            hashMap2.put(268, Boolean.TRUE);
            hashMap2.put(352, this.dhparamSpec.getL());
            if (this.config != null) {
                hashMap2.putAll(this.config.getAttributes("GENERATE", PKCS11Object.PRIVATE_KEY, PKCS11Object.DH));
            }
            int[] nArray = new int[hashMap.size()];
            Object[] objectArray = new Object[hashMap.size()];
            Iterator iterator = hashMap.entrySet().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                object = iterator.next();
                nArray[n] = (Integer)object.getKey();
                objectArray[n++] = object.getValue();
            }
            object = new int[hashMap2.size()];
            Object[] objectArray2 = new Object[hashMap2.size()];
            iterator = hashMap2.entrySet().iterator();
            n = 0;
            while (iterator.hasNext()) {
                pKCS11ObjectArray = iterator.next();
                object[n] = (Integer)pKCS11ObjectArray.getKey();
                objectArray2[n++] = pKCS11ObjectArray.getValue();
            }
            this.session.seedRandom(this.random.generateSeed(16), 0, 16);
            pKCS11ObjectArray = this.session.generateKeyPair(32, null, nArray, objectArray, (int[])object, objectArray2);
            DHPKCS11PublicKey dHPKCS11PublicKey = new DHPKCS11PublicKey(pKCS11ObjectArray[0]);
            DHPKCS11PrivateKey dHPKCS11PrivateKey = new DHPKCS11PrivateKey(pKCS11ObjectArray[1]);
            keyPair = new KeyPair(dHPKCS11PublicKey, dHPKCS11PrivateKey);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new RuntimeException(invalidKeyException.getMessage());
        }
        return keyPair;
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec == null || !(algorithmParameterSpec instanceof DHParameterSpec)) {
            throw new InvalidAlgorithmParameterException("DHParameterSpec must be specified");
        }
        this.dhparamSpec = (DHParameterSpec)algorithmParameterSpec;
        this.random = secureRandom;
    }
}

