/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.AttributesItem;
import com.ibm.crypto.pkcs11impl.provider.ConfigParsingException;
import com.ibm.crypto.pkcs11impl.provider.Item;
import com.ibm.crypto.pkcs11impl.provider.ListItem;
import com.ibm.crypto.pkcs11impl.provider.SimpleItem;
import com.ibm.crypto.pkcs11impl.provider.SupportedServices;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Mechanism;
import com.ibm.pkcs11.PKCS11Object;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.security.ProviderException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Config {
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String LIBRARY = "library";
    private static final String SLOT = "slot";
    private static final String SLOT_LIST_INDEX = "slotlistindex";
    private static final String MECHANISMS = "mechanisms";
    private static final String ENABLED_MECHANISMS = "enabledmechanisms";
    private static final String DISABLED_MECHANISMS = "disabledmechanisms";
    private static final String ATTRIBUTES = "attributes";
    private static final String COMPATIBILITY = "compatibility";
    private static final String TOKENLABEL = "tokenlabel";
    private static final String PUBLICKEYIMPORTONLY = "publickeyimportonly";
    private static final HashMap<String, Integer> OPERATIONS = new HashMap();
    private static final HashMap<String, Integer> KEYTYPE = new HashMap();
    private static final HashMap<String, Integer> ALGORITHMS = new HashMap();
    private static final Integer des_secret_key = new Integer(531);
    private static final AttributesItem des_secret_class = new AttributesItem(des_secret_key);
    private static final Integer des3_secret_key = new Integer(1043);
    private static final AttributesItem des3_secret_class = new AttributesItem(des3_secret_key);
    private static final Integer dsa_private_key = new Integer(75);
    private static final AttributesItem dsa_private_class = new AttributesItem(dsa_private_key);
    private static final Integer dsa_public_key = new Integer(71);
    private static final AttributesItem dsa_public_class = new AttributesItem(dsa_public_key);
    private static final Integer rsa_private_key = new Integer(43);
    private static final AttributesItem rsa_private_class = new AttributesItem(rsa_private_key);
    private static final Integer rsa_public_key = new Integer(39);
    private static final AttributesItem rsa_public_class = new AttributesItem(rsa_public_key);
    private static Debug debug = Debug.getInstance((String)"config");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.Config";
    private static String info = "IBMPKCS11Impl Provider implements the following:\nSignature algorithms               : SHA1withDSA, SHA1withRSA, MD5withRSA, MD2withRSA \nCipher algorithms                  : AES, DES, TripleDES, RSA,\nKey (pair) generator               : AES, DSA, RSA, DES, TripleDES\nMessage digest                     : MD2, MD5, SHA-1\nAlgorithm parameter generator      : DSA\nAlgorithm parameter                : AES, DSA, DES, TripleDES\nKey factory                        : DSA, RSA\nSecret key factory                 : AES, DES, TripleDES\nCertificate                        : X.509\nSecure random                      : PKCS11DeviceRNG (IBMSecureRandom)\nKey store                          : PKCS11IMPLKS\n";
    private HashMap<String, Item> configMap = new HashMap();
    private Map<Integer, AttributesItem> attributesMap = new LinkedHashMap<Integer, AttributesItem>();

    Config(String string) {
        if (debug != null) {
            System.out.println("new Config instance");
        }
        this.configMap.put(NAME, null);
        this.configMap.put(LIBRARY, null);
        this.configMap.put(DESCRIPTION, null);
        this.configMap.put(SLOT, null);
        this.configMap.put(MECHANISMS, null);
        if (string != null) {
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(string));
            }
            catch (IOException iOException) {
                if (debug != null) {
                    System.out.println(iOException.getMessage());
                }
                throw new RuntimeException(iOException.getMessage());
            }
            this.parse(bufferedReader);
        }
    }

    Config(BufferedReader bufferedReader) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "Config", (Object)bufferedReader);
        }
        this.configMap.put(NAME, null);
        this.configMap.put(LIBRARY, null);
        this.configMap.put(DESCRIPTION, null);
        this.configMap.put(SLOT, null);
        this.configMap.put(MECHANISMS, null);
        if (bufferedReader != null) {
            this.parse(bufferedReader);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "Config");
        }
    }

    private void parse(BufferedReader bufferedReader) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "parse", (Object)bufferedReader);
        }
        try {
            String string;
            int n = 0;
            while ((string = bufferedReader.readLine()) != null) {
                string = string.trim();
                ++n;
                if (string.startsWith("#") || string.length() <= 0) continue;
                if (string.toLowerCase().startsWith(LIBRARY)) {
                    this.processSimpleItem(string);
                    continue;
                }
                if (string.toLowerCase().startsWith(NAME)) {
                    this.processSimpleItem(string);
                    continue;
                }
                if (string.toLowerCase().startsWith(DESCRIPTION)) {
                    this.processSimpleItem(string);
                    continue;
                }
                if (string.toLowerCase().startsWith(SLOT)) {
                    this.processSlot(string);
                    continue;
                }
                if (string.toLowerCase().startsWith(PUBLICKEYIMPORTONLY)) {
                    this.processPublicKeyImportOnly(string);
                    continue;
                }
                if (string.toLowerCase().startsWith(TOKENLABEL)) {
                    this.processTokenLabel(string);
                    continue;
                }
                if (string.toLowerCase().startsWith(ENABLED_MECHANISMS)) {
                    n = this.processMechanism(ENABLED_MECHANISMS, string, bufferedReader, n);
                    continue;
                }
                if (string.toLowerCase().startsWith(DISABLED_MECHANISMS)) {
                    n = this.processMechanism(DISABLED_MECHANISMS, string, bufferedReader, n);
                    continue;
                }
                if (string.toLowerCase().startsWith(ATTRIBUTES)) {
                    n = this.processAttributes(string, bufferedReader, n);
                    continue;
                }
                String string2 = "Unexpected attribute found, please check your config file at line " + n + ": \"" + string.trim() + "\"";
                if (debug != null) {
                    System.out.println(string2);
                }
                throw new ConfigParsingException(string2);
            }
            bufferedReader.close();
            if (this.configMap.get(NAME) == null || this.configMap.get(LIBRARY) == null) {
                String string3 = "You must specify a provider name and library in your config file.";
                if (debug != null) {
                    System.out.println(string3);
                }
                throw new ConfigParsingException(string3);
            }
        }
        catch (IOException iOException) {
            if (debug != null) {
                System.out.println(iOException.getMessage());
            }
            throw new RuntimeException(iOException.getMessage());
        }
        catch (ConfigParsingException configParsingException) {
            if (debug != null) {
                System.out.println(configParsingException.getMessage());
            }
            throw new RuntimeException(configParsingException.getMessage());
        }
    }

    private int processAttributes(String string, BufferedReader bufferedReader, int n) throws IOException, ConfigParsingException {
        if (string.indexOf(40) == -1) {
            String string2 = string.split("=")[1].trim();
            if (!string2.equalsIgnoreCase(COMPATIBILITY)) {
                String string3 = "Unexpected attributes value found at line " + n + ": \"" + string2 + "\".  Please see the PKCS#11 Specification for " + "valid format.";
                if (debug != null) {
                    System.out.println(string3);
                }
                throw new ConfigParsingException(string3);
            }
            this.attributesMap.put(des_secret_key, des_secret_class);
            this.attributesMap.put(des3_secret_key, des3_secret_class);
            this.attributesMap.put(dsa_private_key, dsa_private_class);
            this.attributesMap.put(dsa_public_key, dsa_public_class);
            this.attributesMap.put(rsa_private_key, rsa_private_class);
            this.attributesMap.put(rsa_public_key, rsa_public_class);
        } else {
            StringBuffer stringBuffer = new StringBuffer(string);
            while (!string.endsWith("}")) {
                string = bufferedReader.readLine();
                if (string == null) {
                    throw new ConfigParsingException("Invalid attribute " + stringBuffer);
                }
                string = string.trim();
                ++n;
                if (string.startsWith("#") || string.length() <= 0) continue;
                stringBuffer.append(string);
                stringBuffer.append(' ');
            }
            if (stringBuffer.indexOf("(") < 0 || stringBuffer.indexOf(")") < 0) {
                throw new ConfigParsingException("Missing \"(\" or \")\" in: " + stringBuffer);
            }
            if (stringBuffer.indexOf("=") <= stringBuffer.indexOf(")") || stringBuffer.indexOf("=") >= stringBuffer.indexOf("{")) {
                throw new ConfigParsingException("Missing \"=\" in: " + stringBuffer);
            }
            String string4 = stringBuffer.substring(stringBuffer.indexOf("(") + 1, stringBuffer.indexOf(")"));
            String string5 = stringBuffer.substring(stringBuffer.indexOf("{") + 1, stringBuffer.indexOf("}")).trim();
            String[] stringArray = string4.split(",");
            if (stringArray.length != 3) {
                String string6 = "Attributes have incorrect format, please check your config file: " + stringBuffer;
                if (debug != null) {
                    System.out.println(string6);
                }
                throw new ConfigParsingException(string6);
            }
            String string7 = stringArray[0].trim().toUpperCase();
            String string8 = stringArray[1].trim().toUpperCase();
            String string9 = stringArray[2].trim().toUpperCase();
            AttributesItem attributesItem = new AttributesItem(this.getIntRepresentation(string7, string8, string9));
            StringTokenizer stringTokenizer = new StringTokenizer(string5, " \t\n\r\f=");
            if (stringTokenizer.countTokens() % 2 != 0) {
                throw new ConfigParsingException("Wrong attributes format " + stringBuffer);
            }
            while (stringTokenizer.hasMoreTokens()) {
                String string10;
                String string11 = stringTokenizer.nextToken();
                if (!string11.toUpperCase().startsWith("CKA_")) {
                    string10 = "Unexpected attribute name found: " + string11 + ". Names must be CKA_xxx constants from the PKCS#11 specification.";
                    if (debug != null) {
                        System.out.println(string10);
                    }
                    throw new ConfigParsingException(string10);
                }
                string10 = stringTokenizer.nextToken();
                Object object = null;
                try {
                    object = string10.equalsIgnoreCase("true") || string10.equalsIgnoreCase("false") ? new Boolean(string10) : (string10.equalsIgnoreCase("null") ? null : Integer.decode(string10));
                }
                catch (NumberFormatException numberFormatException) {
                    String string12 = "Unexpected format found : " + string11 + " = " + string10 + ".\nPlease comment out any " + "empty attribute options and specify values as either boolean, integer " + "in either decimal or hexadecimal form, or as the word null.";
                    if (debug != null) {
                        System.out.println(string12);
                    }
                    throw new ConfigParsingException(string12);
                }
                string11 = string11.substring(4);
                try {
                    Integer n2 = (Integer)PKCS11Object.class.getField(string11).get(null);
                    attributesItem.addItem(n2, object);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    String string13 = "Unexpected attribute name found: " + string11 + ". Names must be CKA_xxx constants from the PKCS#11 specification.";
                    if (debug != null) {
                        System.out.println(string13);
                    }
                    throw new ConfigParsingException(string13);
                }
                catch (Exception exception) {
                    throw new ConfigParsingException(exception.getMessage());
                }
            }
            this.attributesMap.put((Integer)attributesItem.getName(), attributesItem);
        }
        return n;
    }

    private Integer getIntRepresentation(String string, String string2, String string3) throws ConfigParsingException {
        Integer n = OPERATIONS.get(string);
        if (n == null) {
            String string4 = "Valid values for operation are generate, import or * to match keys created using either a generate or a create operation.";
            if (debug != null) {
                System.out.println(string4);
            }
            throw new ConfigParsingException(string4);
        }
        Integer n2 = KEYTYPE.get(string2);
        if (n2 == null) {
            String string5 = "Valid values for keytype are CKO_PUBLIC_KEY, CKO_PRIVATE_KEY, CKO_SECRET_KEY or * to match any type of key.";
            if (debug != null) {
                System.out.println(string5);
            }
            throw new ConfigParsingException(string5);
        }
        Integer n3 = ALGORITHMS.get(string3);
        if (n3 == null) {
            String string6 = "Unexpected key algorithm found: " + string3 + ". Algorithms must be CKK_xxx constants " + "from the PKCS#11 specification or a * " + "to match any algorithm.";
            if (debug != null) {
                System.out.println(string6);
            }
            throw new ConfigParsingException(string6);
        }
        return new Integer(n | n2 | n3);
    }

    private void processSimpleItem(String string) {
        String[] stringArray = string.split("=");
        SimpleItem simpleItem = new SimpleItem(stringArray[0].trim().toLowerCase(), stringArray[1].trim());
        this.configMap.put((String)simpleItem.getName(), simpleItem);
    }

    private void processSlot(String string) throws ConfigParsingException {
        if (this.configMap.get(SLOT) == null && this.configMap.get(TOKENLABEL) == null) {
            if (string.toLowerCase().startsWith(SLOT_LIST_INDEX)) {
                StringBuffer stringBuffer = new StringBuffer(SLOT);
                stringBuffer.append('=');
                stringBuffer.append(string.split("=")[1]);
                string = stringBuffer.toString();
            }
        } else {
            String string2 = "slot, slotListIndex and tokenlabe are mutually exclusive, only provide one at the same time.  Please check your config file.";
            if (debug != null) {
                System.out.println(string2);
            }
            throw new ConfigParsingException(string2);
        }
        this.processSimpleItem(string);
    }

    private void processPublicKeyImportOnly(String string) throws ConfigParsingException {
        String[] stringArray = string.split("=");
        if (!stringArray[1].trim().equalsIgnoreCase("true") && !stringArray[1].trim().equalsIgnoreCase("false")) {
            String string2 = "Unexpected format found : " + stringArray[0] + " = " + stringArray[1] + ".\nPlease specify values as boolean (true, false)";
            if (debug != null) {
                System.out.println(string2);
            }
            throw new ConfigParsingException(string2);
        }
        SimpleItem simpleItem = new SimpleItem(stringArray[0].trim().toLowerCase(), stringArray[1].trim().toLowerCase());
        this.configMap.put((String)simpleItem.getName(), simpleItem);
    }

    private void processTokenLabel(String string) throws ConfigParsingException {
        if (this.configMap.get(SLOT) != null) {
            String string2 = "You cannot provide slot or slotListIndex at the same time with token label. Please check your config file.";
            if (debug != null) {
                System.out.println(string2);
            }
            throw new ConfigParsingException(string2);
        }
        this.processSimpleItem(string);
    }

    private int processMechanism(String string, String string2, BufferedReader bufferedReader, int n) throws ConfigParsingException, IOException {
        if (this.configMap.get(MECHANISMS) != null) {
            String string3 = "You cannot provide both enabled and disabled mechanisms at the same time.  Please check your config file.";
            if (debug != null) {
                System.out.println(string3);
            }
            throw new ConfigParsingException(string3);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        stringBuffer.append(" ");
        while (!string2.endsWith("}") && (string2 = bufferedReader.readLine().trim()) != null) {
            ++n;
            if (string2.startsWith("#") || string2.length() <= 0) continue;
            stringBuffer.append(string2);
            stringBuffer.append(" ");
        }
        if (string2 == null) {
            String string4 = "Cannot parse the config file in its current format.Please check that mechanisms are declared with '{' and '}' arround the value.";
            if (debug != null) {
                System.out.println(string4);
            }
            throw new ConfigParsingException(string4);
        }
        if (stringBuffer.indexOf("=") < 0) {
            throw new ConfigParsingException("Missing \"=\" in: " + stringBuffer);
        }
        String string5 = stringBuffer.substring(stringBuffer.indexOf("{") + 1, stringBuffer.indexOf("}"));
        if (string5 != null && string5.length() > 0) {
            ListItem listItem = new ListItem(string);
            StringTokenizer stringTokenizer = new StringTokenizer(string5);
            while (stringTokenizer.hasMoreTokens()) {
                Object object;
                String string6 = stringTokenizer.nextToken();
                if (string6.startsWith("CKM_")) {
                    string6 = string6.substring(4);
                    try {
                        object = (Integer)PKCS11Mechanism.class.getField(string6).get(null);
                        listItem.addItem((Integer)object);
                        continue;
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        String string7 = "Unexpected mechanism found: " + string6 + ". " + "Mechanisms must be CKM_xxx and " + "be supported by both the IBMPKCS11Impl " + "provider and PKCS#11 token.";
                        if (debug != null) {
                            System.out.println(string7);
                        }
                        throw new ConfigParsingException(string7);
                    }
                    catch (Exception exception) {
                        if (debug == null) continue;
                        debug.text(16384L, (Object)className, "processMechanism", exception.getMessage());
                        continue;
                    }
                }
                object = "Unexpected mechanism found: " + string6 + ". " + "Mechanisms must be CKM_xxx and " + "be supported by both the IBMPKCS11Impl " + "provider and PKCS#11 token.";
                if (debug != null) {
                    System.out.println((String)object);
                }
                throw new ConfigParsingException((String)object);
            }
            this.configMap.put(MECHANISMS, listItem);
        }
        return n;
    }

    public static String getProviderNameSuffix(String string) throws ProviderException {
        String string2 = null;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            string2 = Config.getProviderNameSuffix(bufferedReader);
        }
        catch (Exception exception) {
            String string3 = "Error reading config file: " + string + " while trying to retrieve name.";
            if (debug != null) {
                System.out.println(string3);
            }
            throw new ProviderException(string3);
        }
        return string2;
    }

    public static String getProviderNameSuffix(BufferedReader bufferedReader) throws ProviderException {
        String string = null;
        try {
            bufferedReader.mark(2000);
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (!(string2 = string2.trim()).toLowerCase().startsWith(NAME)) continue;
                String[] stringArray = string2.split("=");
                string = stringArray[1].trim();
                break;
            }
            bufferedReader.reset();
        }
        catch (IOException iOException) {
            String string3 = "Error reading config file:  while trying to retrieve name.";
            if (debug != null) {
                System.out.println(string3);
            }
            throw new ProviderException(string3);
        }
        return "-" + string;
    }

    public static String getDescription(String string) throws ProviderException {
        String string2 = null;
        if (string == null) {
            string2 = info;
        } else {
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
                string2 = Config.getDescription(bufferedReader);
            }
            catch (Exception exception) {
                String string3 = "Error reading config file: " + string + " while trying to retrieve description.";
                if (debug != null) {
                    System.out.println(string3);
                }
                throw new ProviderException(string3);
            }
        }
        return string2;
    }

    public static String getDescription(BufferedReader bufferedReader) throws ProviderException {
        String string = null;
        if (bufferedReader == null) {
            string = info;
        } else {
            try {
                bufferedReader.mark(2000);
                String string2 = null;
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (!(string2 = string2.trim()).toLowerCase().startsWith(DESCRIPTION)) continue;
                    String[] stringArray = string2.split("=");
                    string = stringArray[1].trim();
                    break;
                }
                bufferedReader.reset();
            }
            catch (IOException iOException) {
                String string3 = "Error reading config file:  while trying to retrieve description.";
                if (debug != null) {
                    System.out.println(string3);
                }
                throw new ProviderException(string3);
            }
        }
        return string;
    }

    public String getLibraryName() {
        String string = null;
        Item item = this.configMap.get(LIBRARY);
        if (item != null) {
            string = (String)item.getValue();
        }
        return string;
    }

    public String getProviderNameSuffix() {
        String string = null;
        Item item = this.configMap.get(NAME);
        if (item != null) {
            string = "-" + (String)item.getValue();
        }
        return string;
    }

    public String getDescription() {
        String string = info;
        Item item = this.configMap.get(DESCRIPTION);
        if (item != null) {
            string = (String)item.getValue();
        }
        return string;
    }

    public int getSlotIndex() {
        int n = 0;
        Item item = this.configMap.get(SLOT);
        if (item != null) {
            n = new Integer((String)item.getValue());
        }
        return n;
    }

    public String getTokenLabel() {
        String string = null;
        Item item = this.configMap.get(TOKENLABEL);
        if (item != null) {
            string = (String)item.getValue();
        }
        return string;
    }

    public boolean getPublicKeyImportOnly() {
        boolean bl = false;
        Item item = this.configMap.get(PUBLICKEYIMPORTONLY);
        if (item != null) {
            bl = new Boolean((String)item.getValue());
        }
        return bl;
    }

    public ArrayList<Integer> getEnabledMechanisms() {
        return this.getMechanisms(true);
    }

    public ArrayList<Integer> getDisabledMechanisms() {
        return this.getMechanisms(false);
    }

    private ArrayList<Integer> getMechanisms(boolean bl) {
        ArrayList arrayList = null;
        Item item = this.configMap.get(MECHANISMS);
        if (item != null && (item.getName().equals(ENABLED_MECHANISMS) && bl || item.getName().equals(DISABLED_MECHANISMS) && !bl)) {
            arrayList = (ArrayList)item.getValue();
        }
        return arrayList;
    }

    public HashMap<Integer, Object> getAttributes(String string, Integer n, Integer n2) {
        HashMap hashMap = new HashMap();
        HashMap<Integer, Object> hashMap2 = new HashMap<Integer, Object>();
        String string2 = string == null ? "*" : string.toUpperCase();
        String string3 = n == null ? "*" : PKCS11Object.classToString((Integer)n);
        String string4 = n2 == null ? "*" : PKCS11Object.keyToString((Integer)n2);
        Integer n3 = OPERATIONS.get(string2);
        Integer n4 = KEYTYPE.get(string3);
        Integer n5 = ALGORITHMS.get(string4);
        if (n3 == null || n4 == null || n5 == null) {
            throw new RuntimeException("Invalid arguments: " + string2 + "," + string3 + "," + string4);
        }
        int n6 = n3 | n4 | n5;
        for (Map.Entry<Integer, AttributesItem> entry : this.attributesMap.entrySet()) {
            int n7 = entry.getKey();
            if (n6 != (n6 & n7)) continue;
            hashMap = (HashMap)entry.getValue().getValue();
            for (Map.Entry entry2 : hashMap.entrySet()) {
                hashMap2.put((Integer)entry2.getKey(), entry2.getValue());
            }
        }
        return hashMap2;
    }

    public SupportedServices[] getSupportedServices(int[] nArray) {
        AbstractCollection abstractCollection;
        AbstractCollection abstractCollection2 = this.convertToArrayList(nArray);
        ListItem listItem = (ListItem)this.configMap.get(MECHANISMS);
        if (listItem != null) {
            abstractCollection = (ArrayList)listItem.getValue();
            if (listItem.getName().equals(ENABLED_MECHANISMS)) {
                Iterator iterator = ((ArrayList)abstractCollection).iterator();
                while (iterator.hasNext()) {
                    if (abstractCollection2.contains(iterator.next())) continue;
                    iterator.remove();
                }
                abstractCollection2 = abstractCollection;
            } else {
                Iterator<Integer> iterator = abstractCollection2.iterator();
                while (iterator.hasNext()) {
                    if (!((ArrayList)abstractCollection).contains(iterator.next())) continue;
                    iterator.remove();
                }
            }
        }
        abstractCollection = this.getSupportedServicesList((ArrayList<Integer>)abstractCollection2);
        return ((HashSet)abstractCollection).toArray(new SupportedServices[0]);
    }

    private HashSet<SupportedServices> getSupportedServicesList(ArrayList<Integer> arrayList) {
        HashSet<SupportedServices> hashSet = new HashSet<SupportedServices>();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        String[] stringArray = null;
        for (Integer n : arrayList) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "Init", "Mechanism: " + n.toString());
            }
            switch (n) {
                case 17: {
                    bl = true;
                    stringArray = null;
                    hashSet.add(new SupportedServices("Signature", "DSAforSSL", "com.ibm.crypto.pkcs11impl.provider.PKCS11SSLHashingwithDSA", stringArray, n));
                    break;
                }
                case 6: {
                    bl9 = true;
                    stringArray = new String[]{"PKCS11SHA1withRSA", "SHA-1withRSA", "SHA-1/RSA", "SHA1/RSA", "SHA/RSA", "SHAwithRSA", "RSA", "OID.1.3.14.3.2.26", "1.3.14.3.2.26", "OID.1.2.840.113549.1.1.5", "1.2.840.113549.1.1.5"};
                    hashSet.add(new SupportedServices("Signature", "SHA1withRSA", "com.ibm.crypto.pkcs11impl.provider.GeneralSignature", stringArray, n));
                    break;
                }
                case 64: {
                    bl9 = true;
                    stringArray = new String[]{"SHA256withRSA", "SHA2withRSA", "SHA-256withRSA", "SHA-256/RSA", "SHA256/RSA", "OID.1.2.840.113549.1.1.11", "1.2.840.113549.1.1.11"};
                    hashSet.add(new SupportedServices("Signature", "SHA256withRSA", "com.ibm.crypto.pkcs11impl.provider.GeneralSignature", stringArray, n));
                    break;
                }
                case 65: {
                    bl9 = true;
                    stringArray = new String[]{"SHA384withRSA", "SHA3withRSA", "SHA-384withRSA", "SHA-384/RSA", "SHA384/RSA", "OID.1.2.840.113549.1.1.12", "1.2.840.113549.1.1.12"};
                    hashSet.add(new SupportedServices("Signature", "SHA384withRSA", "com.ibm.crypto.pkcs11impl.provider.GeneralSignature", stringArray, n));
                    break;
                }
                case 66: {
                    bl9 = true;
                    stringArray = new String[]{"SHA5withRSA", "SHA512withRSA", "SHA-512withRSA", "SHA-512/RSA", "SHA512/RSA", "OID.1.2.840.113549.1.1.13", "1.2.840.113549.1.1.13"};
                    hashSet.add(new SupportedServices("Signature", "SHA512withRSA", "com.ibm.crypto.pkcs11impl.provider.GeneralSignature", stringArray, n));
                    break;
                }
                case 4: {
                    bl7 = true;
                    stringArray = new String[]{"PKCS11MD2withRSA", "MD2/RSA", "OID.1.2.840.113549.1.1.2", "1.2.840.113549.1.1.2", "OID.1.3.14.3.2.24", "1.3.14.3.2.24"};
                    hashSet.add(new SupportedServices("Signature", "MD2withRSA", "com.ibm.crypto.pkcs11impl.provider.GeneralSignature", stringArray, n));
                    break;
                }
                case 5: {
                    bl8 = true;
                    stringArray = new String[]{"PKCS11MD5withRSA", "MD5/RSA", "OID.1.2.840.113549.1.1.4", "1.2.840.113549.1.1.4", "OID.1.3.14.3.2.25", "1.3.14.3.2.25"};
                    hashSet.add(new SupportedServices("Signature", "MD5withRSA", "com.ibm.crypto.pkcs11impl.provider.GeneralSignature", stringArray, n));
                    break;
                }
                case 18: {
                    bl6 = true;
                    stringArray = new String[]{"PKCS11SHA1withDSA", "SHA-1withDSA", "SHA-1/DSA", "SHA1/DSA", "SHA/DSA", "SHAwithDSA", "DSAwithSHA1", "DSA", "DSS", "OID.1.3.14.3.2.13", "1.3.14.3.2.13", "OID.1.2.840.10040.4.3", "1.2.840.10040.4.3", "OID.1.3.14.3.2.27", "1.3.14.3.2.27"};
                    hashSet.add(new SupportedServices("Signature", "SHA1withDSA", "com.ibm.crypto.pkcs11impl.provider.GeneralSignature", stringArray, n));
                    break;
                }
                case 289: 
                case 290: 
                case 293: {
                    stringArray = null;
                    hashSet.add(new SupportedServices("Cipher", "DES", "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11Cipher", stringArray, n));
                    break;
                }
                case 306: 
                case 307: 
                case 310: {
                    stringArray = new String[]{"TripleDES", "3DES"};
                    hashSet.add(new SupportedServices("Cipher", "DESede", "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11Cipher", stringArray, n));
                    break;
                }
                case 4225: 
                case 4226: 
                case 4229: {
                    stringArray = null;
                    hashSet.add(new SupportedServices("Cipher", "AES", "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11Cipher", stringArray, n));
                    break;
                }
                case 4241: {
                    stringArray = null;
                    hashSet.add(new SupportedServices("Cipher", "Blowfish", "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11Cipher", stringArray, n));
                    break;
                }
                case 273: {
                    stringArray = new String[]{"ARCFOUR"};
                    hashSet.add(new SupportedServices("Cipher", "RC4", "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11Cipher", stringArray, n));
                    break;
                }
                case 288: {
                    stringArray = null;
                    hashSet.add(new SupportedServices("KeyGenerator", "DES", "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11KeyGenerator", stringArray, n));
                    hashSet.add(new SupportedServices("AlgorithmParameters", "DES", "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11Parameters", stringArray, n));
                    hashSet.add(new SupportedServices("SecretKeyFactory", "DES", "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11KeyFactory", stringArray, n));
                    break;
                }
                case 272: {
                    stringArray = new String[]{"ARCFOUR"};
                    hashSet.add(new SupportedServices("KeyGenerator", "RC4", "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11KeyGenerator", stringArray, n));
                    hashSet.add(new SupportedServices("SecretKeyFactory", "RC4", "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11KeyFactory", stringArray, n));
                    break;
                }
                case 305: {
                    stringArray = new String[]{"TripleDES", "3DES"};
                    hashSet.add(new SupportedServices("KeyGenerator", "DESede", "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11KeyGenerator", stringArray, n));
                    hashSet.add(new SupportedServices("AlgorithmParameters", "DESede", "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11Parameters", stringArray, n));
                    hashSet.add(new SupportedServices("SecretKeyFactory", "DESede", "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11KeyFactory", stringArray, n));
                    break;
                }
                case 4224: {
                    stringArray = null;
                    hashSet.add(new SupportedServices("KeyGenerator", "AES", "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11KeyGenerator", stringArray, n));
                    stringArray = null;
                    hashSet.add(new SupportedServices("AlgorithmParameters", "AES", "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11Parameters", stringArray, n));
                    stringArray = null;
                    hashSet.add(new SupportedServices("SecretKeyFactory", "AES", "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11KeyFactory", stringArray, n));
                    break;
                }
                case 4240: {
                    stringArray = null;
                    hashSet.add(new SupportedServices("KeyGenerator", "Blowfish", "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11KeyGenerator", stringArray, n));
                    stringArray = null;
                    hashSet.add(new SupportedServices("AlgorithmParameters", "Blowfish", "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11Parameters", stringArray, n));
                    stringArray = null;
                    hashSet.add(new SupportedServices("SecretKeyFactory", "Blowfish", "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11KeyFactory", stringArray, n));
                    break;
                }
                case 848: {
                    stringArray = null;
                    hashSet.add(new SupportedServices("KeyGenerator", "Generic", "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11KeyGenerator", stringArray, n));
                    stringArray = null;
                    hashSet.add(new SupportedServices("SecretKeyFactory", "Generic", "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11KeyFactory", stringArray, n));
                    break;
                }
                case 16: {
                    stringArray = new String[]{"OID.1.2.840.10040.4.1", "1.2.840.10040.4.1", "OID.1.3.14.3.2.12", "1.3.14.3.2.12"};
                    hashSet.add(new SupportedServices("KeyPairGenerator", "DSA", "com.ibm.crypto.pkcs11impl.provider.DSAPKCS11KeyPairGenerator", stringArray, n));
                    stringArray = null;
                    hashSet.add(new SupportedServices("AlgorithmParameterGenerator", "DSA", "com.ibm.crypto.pkcs11impl.provider.DSAParameterGenerator", stringArray, n));
                    stringArray = new String[]{"1.3.14.3.2.12", "1.2.840.10040.4.1"};
                    hashSet.add(new SupportedServices("AlgorithmParameters", "DSA", "com.ibm.crypto.pkcs11impl.provider.DSAParameters", stringArray, n));
                    stringArray = new String[]{"OID.1.3.14.3.2.12", "1.3.14.3.2.12", "OID.1.2.840.10040.4.1", "1.2.840.10040.4.1"};
                    hashSet.add(new SupportedServices("KeyFactory", "DSA", "com.ibm.crypto.pkcs11impl.provider.DSAPKCS11KeyFactory", stringArray, n));
                    break;
                }
                case 33: {
                    stringArray = new String[]{"OID.1.2.840.113549.1.3.1", "1.2.840.113549.1.3.1"};
                    hashSet.add(new SupportedServices("KeyAgreement", "DH", "com.ibm.crypto.pkcs11impl.provider.DHPKCS11KeyAgreement", stringArray, n));
                    stringArray = null;
                    hashSet.add(new SupportedServices("KeyFactory", "DH", "com.ibm.crypto.pkcs11impl.provider.DHPKCS11KeyFactory", stringArray, n));
                    break;
                }
                case 32: {
                    stringArray = null;
                    hashSet.add(new SupportedServices("KeyPairGenerator", "DH", "com.ibm.crypto.pkcs11impl.provider.DHPKCS11KeyPairGenerator", stringArray, n));
                }
                case 8193: {
                    stringArray = null;
                    hashSet.add(new SupportedServices("AlgorithmParameterGenerator", "DH", "com.ibm.crypto.pkcs11impl.provider.DHPKCS11ParameterGenerator", stringArray, n));
                    hashSet.add(new SupportedServices("AlgorithmParameters", "DH", "com.ibm.crypto.pkcs11impl.provider.DHPKCS11Parameters", stringArray, n));
                }
                case 0: {
                    stringArray = new String[]{"OID.1.2.5.8.1.1", "1.2.5.8.1.1"};
                    hashSet.add(new SupportedServices("KeyPairGenerator", "RSA", "com.ibm.crypto.pkcs11impl.provider.RSAPKCS11KeyPairGenerator", stringArray, n));
                    stringArray = new String[]{"OID.1.2.5.8.1.1", "1.2.5.8.1.1", "OID.1.2.840.113549.1.1.1", "1.2.840.113549.1.1.1"};
                    hashSet.add(new SupportedServices("KeyFactory", "RSA", "com.ibm.crypto.pkcs11impl.provider.RSAPKCS11KeyFactory", stringArray, n));
                    break;
                }
                case 512: {
                    bl3 = true;
                    stringArray = null;
                    hashSet.add(new SupportedServices("MessageDigest", "MD2", "com.ibm.crypto.pkcs11impl.provider.GeneralHashing", stringArray, n));
                    break;
                }
                case 528: {
                    bl4 = true;
                    stringArray = null;
                    hashSet.add(new SupportedServices("MessageDigest", "MD5", "com.ibm.crypto.pkcs11impl.provider.GeneralHashing", stringArray, n));
                    break;
                }
                case 544: {
                    bl5 = true;
                    stringArray = new String[]{"SHA-1", "SHA1"};
                    hashSet.add(new SupportedServices("MessageDigest", "SHA", "com.ibm.crypto.pkcs11impl.provider.GeneralHashing", stringArray, n));
                    break;
                }
                case 592: {
                    bl5 = true;
                    stringArray = new String[]{"SHA-2", "SHA-256", "SHA256"};
                    hashSet.add(new SupportedServices("MessageDigest", "SHA-256", "com.ibm.crypto.pkcs11impl.provider.GeneralHashing", stringArray, n));
                    break;
                }
                case 608: {
                    bl5 = true;
                    stringArray = new String[]{"SHA-3", "SHA-384", "SHA384"};
                    hashSet.add(new SupportedServices("MessageDigest", "SHA-384", "com.ibm.crypto.pkcs11impl.provider.GeneralHashing", stringArray, n));
                    break;
                }
                case 624: {
                    bl5 = true;
                    stringArray = new String[]{"SHA-5", "SHA-512", "SHA512"};
                    hashSet.add(new SupportedServices("MessageDigest", "SHA-512", "com.ibm.crypto.pkcs11impl.provider.GeneralHashing", stringArray, n));
                    break;
                }
                case 529: {
                    stringArray = null;
                    hashSet.add(new SupportedServices("Mac", "HmacMD5", "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11Hmac", stringArray, n));
                    break;
                }
                case 545: {
                    stringArray = new String[]{"HmacSHA-1"};
                    hashSet.add(new SupportedServices("Mac", "HmacSHA1", "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11Hmac", stringArray, n));
                    break;
                }
                case 593: {
                    stringArray = null;
                    hashSet.add(new SupportedServices("Mac", "HmacSHA256", "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11Hmac", stringArray, n));
                    break;
                }
                case 609: {
                    stringArray = null;
                    hashSet.add(new SupportedServices("Mac", "HmacSHA384", "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11Hmac", stringArray, n));
                    break;
                }
                case 625: {
                    stringArray = null;
                    hashSet.add(new SupportedServices("Mac", "HmacSHA512", "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11Hmac", stringArray, n));
                    break;
                }
                case 1: {
                    bl2 = true;
                    stringArray = null;
                    hashSet.add(new SupportedServices("Signature", "RSAforSSL", "com.ibm.crypto.pkcs11impl.provider.PKCS11SSLHashingwithRSA", stringArray, n));
                    break;
                }
                case 3: {
                    stringArray = new String[]{"RSAforSSL", "RSA/SSL/PKCS1Padding"};
                    hashSet.add(new SupportedServices("Cipher", "RSA", "com.ibm.crypto.pkcs11impl.provider.RSACipher", stringArray, n));
                }
            }
        }
        if (!bl7 && bl2 && bl3) {
            stringArray = new String[]{"PKCS11MD2withRSA", "MD2/RSA", "OID.1.2.840.113549.1.1.2", "1.2.840.113549.1.1.2", "OID.1.3.14.3.2.24", "1.3.14.3.2.24"};
            hashSet.add(new SupportedServices("Signature", "MD2withRSA", "com.ibm.crypto.pkcs11impl.provider.GeneralSignatureSingleRSA", stringArray, 4));
        }
        if (!bl8 && bl2 && bl4) {
            stringArray = new String[]{"PKCS11MD5withRSA", "MD5/RSA", "OID.1.2.840.113549.1.1.4", "1.2.840.113549.1.1.4", "OID.1.3.14.3.2.25", "1.3.14.3.2.25"};
            hashSet.add(new SupportedServices("Signature", "MD5withRSA", "com.ibm.crypto.pkcs11impl.provider.GeneralSignatureSingleRSA", stringArray, 5));
        }
        if (!bl9 && bl2 && bl5) {
            stringArray = new String[]{"PKCS11SHA1withRSA", "SHA-1withRSA", "SHA-1/RSA", "SHA1/RSA", "SHA/RSA", "SHAwithRSA", "RSA", "OID.1.3.14.3.2.26", "1.3.14.3.2.26", "OID.1.2.840.113549.1.1.5", "1.2.840.113549.1.1.5"};
            hashSet.add(new SupportedServices("Signature", "SHA1withRSA", "com.ibm.crypto.pkcs11impl.provider.GeneralSignatureSingleRSA", stringArray, 6));
        }
        if (!bl6 && bl && bl5) {
            stringArray = new String[]{"PKCS11SHA1withDSA", "SHA-1withDSA", "SHA-1/DSA", "SHA1/DSA", "SHA/DSA", "SHAwithDSA", "DSAwithSHA1", "DSA", "DSS", "OID.1.3.14.3.2.13", "1.3.14.3.2.13", "OID.1.2.840.10040.4.3", "1.2.840.10040.4.3", "OID.1.3.14.3.2.27", "1.3.14.3.2.27"};
            hashSet.add(new SupportedServices("Signature", "SHA1withDSA", "com.ibm.crypto.pkcs11impl.provider.PKCS11SHA1withDSASingle", stringArray, 17));
        }
        stringArray = new String[]{"PKCS11DeviceRNG"};
        hashSet.add(new SupportedServices("SecureRandom", "IBMSecureRandom", "com.ibm.crypto.pkcs11impl.provider.SecureRandom", stringArray, -1));
        stringArray = new String[]{"X.509"};
        hashSet.add(new SupportedServices("CertificateFactory", "X509", "com.ibm.crypto.pkcs11impl.provider.X509Factory", stringArray, -1));
        stringArray = null;
        hashSet.add(new SupportedServices("KeyStore", "PKCS11IMPLKS", "com.ibm.crypto.pkcs11impl.provider.PKCS11KeyStore", stringArray, -1));
        return hashSet;
    }

    private ArrayList<Integer> convertToArrayList(int[] nArray) {
        int n = nArray.length;
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(new Integer(nArray[i]));
        }
        return arrayList;
    }

    public static void main(String[] stringArray) {
        try {
            Object object;
            int n;
            String string = Config.getProviderNameSuffix(stringArray[0]);
            String string2 = Config.getDescription(stringArray[0]);
            System.out.println("Testing the static methods");
            System.out.println(string + " " + string2);
            System.out.println("****************************");
            System.out.println("Testing the object methods");
            Config config = new Config(stringArray[0]);
            System.out.println("library = " + config.getLibraryName());
            System.out.println("name = " + config.getProviderNameSuffix());
            System.out.println("description = " + config.getDescription());
            System.out.println("tokenlabel = " + config.getTokenLabel());
            System.out.println("slot = " + config.getSlotIndex());
            ArrayList<Integer> arrayList = config.getDisabledMechanisms();
            if (arrayList != null) {
                System.out.print("disabledMechanisms = ");
                for (n = 0; n < arrayList.size(); ++n) {
                    object = PKCS11Mechanism.typeToString((int)arrayList.get(n));
                    System.out.print((String)object + ", ");
                }
                System.out.println("");
            }
            if ((arrayList = config.getEnabledMechanisms()) != null) {
                System.out.print("enabledMechanisms = ");
                for (n = 0; n < arrayList.size(); ++n) {
                    object = PKCS11Mechanism.typeToString((int)arrayList.get(n));
                    System.out.print((String)object + ", ");
                }
                System.out.println("");
            }
            HashMap<Integer, Object> hashMap = config.getAttributes("GENERATE", PKCS11Object.SECRET_KEY, PKCS11Object.AES);
            System.out.print("Attributes = ");
            for (Map.Entry supportedServicesArray2 : hashMap.entrySet()) {
                String i = PKCS11Object.typeToString((int)((Integer)supportedServicesArray2.getKey()));
                System.out.print(i + " = " + supportedServicesArray2.getValue() + ", ");
            }
            System.out.println();
            System.out.println();
            System.out.println("Testing SupportedServices:");
            object = new int[]{0, 3, 5, 307, 306, 305, 528};
            SupportedServices[] supportedServicesArray = config.getSupportedServices((int[])object);
            for (int i = 0; i < supportedServicesArray.length; ++i) {
                System.out.println("Service[" + i + "]:");
                System.out.println("Type:" + supportedServicesArray[i].getType());
                System.out.println("Algorithm:" + supportedServicesArray[i].getAlgorithm());
                System.out.println("ClassName:" + supportedServicesArray[i].getClassName());
                System.out.println("Alaises:" + supportedServicesArray[i].getAlaises());
                System.out.println();
            }
            System.out.println("\n. . . done");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        OPERATIONS.put("GENERATE", new Integer(1));
        OPERATIONS.put("IMPORT", new Integer(2));
        OPERATIONS.put("*", new Integer(3));
        KEYTYPE.put("CKO_PUBLIC_KEY", new Integer(4));
        KEYTYPE.put("PUBLIC_KEY", new Integer(4));
        KEYTYPE.put("CKO_PRIVATE_KEY", new Integer(8));
        KEYTYPE.put("PRIVATE_KEY", new Integer(8));
        KEYTYPE.put("CKO_SECRET_KEY", new Integer(16));
        KEYTYPE.put("SECRET_KEY", new Integer(16));
        KEYTYPE.put("*", new Integer(28));
        ALGORITHMS.put("CKK_RSA", new Integer(32));
        ALGORITHMS.put("RSA", new Integer(32));
        ALGORITHMS.put("CKK_DSA", new Integer(64));
        ALGORITHMS.put("DSA", new Integer(64));
        ALGORITHMS.put("CKK_DH", new Integer(128));
        ALGORITHMS.put("DH", new Integer(128));
        ALGORITHMS.put("CKK_AES", new Integer(256));
        ALGORITHMS.put("AES", new Integer(256));
        ALGORITHMS.put("CKK_DES", new Integer(512));
        ALGORITHMS.put("DES", new Integer(512));
        ALGORITHMS.put("CKK_DES3", new Integer(1024));
        ALGORITHMS.put("DES3", new Integer(1024));
        ALGORITHMS.put("CKK_RC4", new Integer(2048));
        ALGORITHMS.put("RC4", new Integer(2048));
        ALGORITHMS.put("CKK_BLOWFISH", new Integer(4096));
        ALGORITHMS.put("BLOWFISH", new Integer(4096));
        ALGORITHMS.put("CKK_GENERIC_SECRET", new Integer(8192));
        ALGORITHMS.put("GENERIC_SECRET", new Integer(8192));
        ALGORITHMS.put("*", new Integer(-32));
        des_secret_class.addItem(1, Boolean.FALSE);
        des_secret_class.addItem(259, Boolean.FALSE);
        des_secret_class.addItem(260, Boolean.TRUE);
        des_secret_class.addItem(261, Boolean.TRUE);
        des_secret_class.addItem(262, Boolean.FALSE);
        des_secret_class.addItem(263, Boolean.FALSE);
        des3_secret_class.addItem(1, Boolean.FALSE);
        des3_secret_class.addItem(259, Boolean.FALSE);
        des3_secret_class.addItem(260, Boolean.TRUE);
        des3_secret_class.addItem(261, Boolean.TRUE);
        des3_secret_class.addItem(262, Boolean.FALSE);
        des3_secret_class.addItem(263, Boolean.FALSE);
        dsa_private_class.addItem(2, Boolean.TRUE);
        dsa_private_class.addItem(1, Boolean.FALSE);
        dsa_private_class.addItem(259, Boolean.FALSE);
        dsa_private_class.addItem(264, Boolean.TRUE);
        dsa_public_class.addItem(2, Boolean.FALSE);
        dsa_public_class.addItem(1, Boolean.FALSE);
        dsa_public_class.addItem(266, Boolean.TRUE);
        rsa_private_class.addItem(2, Boolean.TRUE);
        rsa_private_class.addItem(1, Boolean.FALSE);
        rsa_private_class.addItem(259, Boolean.FALSE);
        rsa_private_class.addItem(261, Boolean.TRUE);
        rsa_private_class.addItem(263, Boolean.TRUE);
        rsa_private_class.addItem(264, Boolean.TRUE);
        rsa_public_class.addItem(2, Boolean.FALSE);
        rsa_public_class.addItem(1, Boolean.FALSE);
        rsa_public_class.addItem(266, Boolean.TRUE);
        rsa_public_class.addItem(260, Boolean.TRUE);
        rsa_public_class.addItem(262, Boolean.TRUE);
    }
}

