/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.module;

import com.ibm.crypto.pkcs11impl.module.PKCS11Principal;
import com.ibm.pkcs11.PKCS11;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Session;
import com.ibm.pkcs11.PKCS11Slot;
import com.ibm.pkcs11.nat.NativePKCS11;
import java.io.File;
import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class PKCS11LoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private boolean debug = false;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private PKCS11Principal principal;
    private PKCS11Session session = null;
    private PKCS11 pkcs11 = null;
    private PKCS11Slot tokenSlot = null;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = map;
        this.options = map2;
        this.debug = "true".equalsIgnoreCase((String)map2.get("debug"));
    }

    /*
     * Unable to fully structure code
     */
    public boolean login() throws LoginException {
        var1_1 = null;
        var2_2 = 0;
        var5_3 = 0;
        var6_4 = null;
        this.succeeded = false;
        if (this.callbackHandler == null) {
            throw new FailedLoginException("callbackHandler is required for the PKCS11 Login Module.");
        }
        var7_5 = new Callback[]{new TextInputCallback("PKCS11 DLL name: "), new PasswordCallback("password: ", false)};
        try {
            this.callbackHandler.handle((Callback[])var7_5);
            var1_1 = ((TextInputCallback)var7_5[0]).getText();
            var8_12 = ((PasswordCallback)var7_5[1]).getPassword();
            var4_15 = new char[((char[])var8_12).length];
            System.arraycopy(var8_12, 0, var4_15, 0, ((char[])var8_12).length);
            ((PasswordCallback)var7_5[1]).clearPassword();
        }
        catch (IOException var8_13) {
            throw new LoginException(var8_13.toString());
        }
        catch (UnsupportedCallbackException var8_14) {
            throw new LoginException("Error: " + var8_14.getCallback().toString() + " not available to garner authentication " + "information from the user");
        }
        if (this.debug) {
            System.out.println("DLL name: " + var1_1);
        }
        if (var1_1.toLowerCase().indexOf(".dll") < 0) {
            if (var1_1.toLowerCase().indexOf(".so") < 0) {
                if (this.debug) {
                    System.out.println("fullFileName=" + var1_1);
                    System.out.println("fullFileName.toLowerCase().indexOf()=" + var1_1.toLowerCase().indexOf(".so"));
                }
                throw new LoginException("Invalid library name");
            }
            if (this.debug) {
                System.out.println("a unix lib:" + var1_1);
            }
            var2_2 = var1_1.toLowerCase().indexOf(".so:") + 3;
            if (this.debug) {
                System.out.println("findex=" + var2_2);
            }
            if (var2_2 > 2) {
                var3_16 = var1_1.substring(0, var2_2);
                try {
                    if (this.debug) {
                        System.out.println("substring=" + var1_1.substring(var2_2 + 1, var1_1.length()));
                    }
                    var5_3 = Integer.valueOf(var1_1.substring(var2_2 + 1, var1_1.length()));
                    if (!this.debug) ** GOTO lbl60
                    System.out.println("slotIndex=" + var5_3);
                }
                catch (NumberFormatException var7_6) {
                    if (this.debug) {
                        var7_6.printStackTrace();
                    }
                    throw new LoginException("Invalid slot number");
                }
            } else {
                var2_2 = var1_1.toLowerCase().indexOf(".so64:") + 3;
                if (var2_2 > 2) {
                    var3_16 = var1_1.substring(0, var2_2 += 2);
                    try {
                        if (this.debug) {
                            System.out.println("substring=" + var1_1.substring(var2_2 + 1, var1_1.length()));
                        }
                        var5_3 = Integer.valueOf(var1_1.substring(var2_2 + 1, var1_1.length()));
                        if (!this.debug) ** GOTO lbl60
                        System.out.println("slotIndex=" + var5_3);
                    }
                    catch (NumberFormatException var7_7) {
                        throw new LoginException("Invalid slot number");
                    }
                } else {
                    var3_16 = var1_1;
                }
            }
lbl60:
            // 5 sources

            var7_5 = new File(var3_16);
            var8_12 = var7_5.getName();
            if (var8_12 != null && var8_12.toLowerCase().startsWith("lib")) {
                var3_16 = var7_5.getParent() + File.separator + var8_12.substring(3);
            }
            if (var3_16.toLowerCase().endsWith(".so")) {
                var3_16 = var3_16.substring(0, var3_16.length() - 3);
            }
        } else {
            if (this.debug) {
                System.out.println("P4");
            }
            if ((var2_2 = var1_1.toLowerCase().indexOf(".dll:") + 4) > 3) {
                var3_16 = var1_1.substring(0, var2_2);
                try {
                    var5_3 = Integer.valueOf(var1_1.substring(var2_2 + 1, var1_1.length()));
                }
                catch (NumberFormatException var7_8) {
                    throw new LoginException("Invalid slot number");
                }
            } else {
                var3_16 = var1_1;
            }
            if (var3_16.toLowerCase().endsWith(".dll")) {
                var3_16 = var3_16.substring(0, var3_16.length() - 4);
            }
        }
        try {
            this.pkcs11 = new NativePKCS11(var3_16);
        }
        catch (PKCS11Exception var7_9) {
            throw new LoginException("Invalid dll name : " + var3_16);
        }
        if (this.debug) {
            System.out.println("P5");
        }
        this.pkcs11.libInitialize();
        try {
            this.pkcs11.libInitialize();
        }
        catch (PKCS11Exception var7_10) {
            // empty catch block
        }
        var6_4 = this.pkcs11.getSlotList(true);
        if (var5_3 < 0 || var5_3 > var6_4.length - 1) {
            throw new LoginException("Invalid slot number : " + var5_3);
        }
        this.tokenSlot = var6_4[var5_3];
        try {
            this.session = this.tokenSlot.openSession(6, null, null);
        }
        catch (PKCS11Exception var7_11) {
            if (var7_11.getCode() == 226) {
                this.session = this.tokenSlot.openSession(4, null, null);
            }
            throw new LoginException(var7_11.getMessage());
        }
        if (var4_15 == null) {
            this.session.login(false, null);
        } else {
            this.session.login(false, (Object)new String(var4_15));
        }
        this.principal = new PKCS11Principal(var1_1, this.session);
        this.succeeded = true;
        return this.succeeded;
    }

    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            if (this.debug) {
                System.out.println("\t\t[PKCS11LoginModule]: did not add any Principals to Subject because own authentication failed.");
            }
            return false;
        }
        if (this.subject.isReadOnly()) {
            throw new LoginException("Subject is ReadOnly");
        }
        Set<Principal> set = this.subject.getPrincipals();
        if (!set.contains(this.principal)) {
            set.add(this.principal);
            if (this.debug) {
                System.out.println("\t\t[PKCS11LoginModule]: added PKCS11Principal");
            }
        }
        this.commitSucceeded = true;
        return true;
    }

    public boolean abort() throws LoginException {
        if (this.debug) {
            System.out.println("\t\t[PKCS11LoginModule]: aborted authentication attempt");
        }
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.principal = null;
            this.succeeded = false;
            this.session.close();
            this.tokenSlot.closeAllSessions();
            this.pkcs11.libFinalize();
        } else {
            this.logout();
        }
        return this.succeeded;
    }

    public boolean logout() throws LoginException {
        if (this.subject.isReadOnly()) {
            throw new LoginException("Subject is ReadOnly");
        }
        Set<Principal> set = this.subject.getPrincipals();
        set.remove(this.principal);
        this.succeeded = false;
        this.commitSucceeded = false;
        this.principal = null;
        this.session = null;
        this.tokenSlot.closeAllSessions();
        this.pkcs11.libFinalize();
        if (this.debug) {
            System.out.println("\t\t[PKCS11LoginModule] completed logout processing");
        }
        return true;
    }
}

