/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11.provider;

import com.ibm.misc.BASE64Decoder;
import com.ibm.security.pkcs7.Content;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.SignedData;
import com.ibm.security.x509.X509CRLImpl;
import com.ibm.security.x509.X509CertImpl;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactorySpi;
import java.security.cert.X509CRL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class X509Factory
extends CertificateFactorySpi {
    public static final String BEGIN_CERT = "-----BEGIN CERTIFICATE-----";
    public static final String END_CERT = "-----END CERTIFICATE-----";
    private static int defaultExpectedLineLength = 80;
    private static char[] endBoundary = new char[]{'-', '-', '-', '-', '-', 'E', 'N', 'D'};

    private byte[] base64_to_binary(InputStream inputStream) throws IOException {
        long l = 0L;
        inputStream.mark(inputStream.available());
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader((InputStream)bufferedInputStream, "8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            inputStreamReader = new InputStreamReader(bufferedInputStream);
        }
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String string = this.readLine(bufferedReader);
        if (string == null || !string.startsWith("-----BEGIN")) {
            throw new IOException("Unsupported encoding");
        }
        l += (long)string.length();
        StringBuffer stringBuffer = new StringBuffer();
        while ((string = this.readLine(bufferedReader)) != null && !string.startsWith("-----END")) {
            stringBuffer.append(string);
        }
        if (string == null) {
            throw new IOException("Unsupported encoding");
        }
        l += (long)string.length();
        inputStream.reset();
        inputStream.skip(l += (long)stringBuffer.length());
        BASE64Decoder bASE64Decoder = new BASE64Decoder();
        return bASE64Decoder.decodeBuffer(stringBuffer.toString());
    }

    public CRL engineGenerateCRL(InputStream inputStream) throws CRLException {
        if (inputStream == null) {
            throw new CRLException("Missing input stream");
        }
        try {
            byte[] byArray;
            if (!inputStream.markSupported()) {
                byArray = this.getTotalBytes(new BufferedInputStream(inputStream));
                inputStream = new ByteArrayInputStream(byArray);
            }
            if (this.isBase64(inputStream)) {
                byArray = this.base64_to_binary(inputStream);
                return new X509CRLImpl(byArray);
            }
            return new X509CRLImpl(inputStream);
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.getMessage());
        }
    }

    public Collection engineGenerateCRLs(InputStream inputStream) throws CRLException {
        if (inputStream == null) {
            throw new CRLException("Missing input stream");
        }
        try {
            byte[] byArray;
            if (!inputStream.markSupported()) {
                byArray = this.getTotalBytes(new BufferedInputStream(inputStream));
                inputStream = new ByteArrayInputStream(byArray);
            }
            if (this.isBase64(inputStream)) {
                byArray = this.base64_to_binary(inputStream);
                return this.parseX509orPKCS7CRL(new ByteArrayInputStream(byArray));
            }
            return this.parseX509orPKCS7CRL(inputStream);
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.getMessage());
        }
    }

    public Certificate engineGenerateCertificate(InputStream inputStream) throws CertificateException {
        if (inputStream == null) {
            throw new CertificateException("Missing input stream");
        }
        try {
            byte[] byArray;
            if (!inputStream.markSupported()) {
                byArray = this.getTotalBytes(new BufferedInputStream(inputStream));
                inputStream = new ByteArrayInputStream(byArray);
            }
            if (this.isBase64(inputStream)) {
                byArray = this.base64_to_binary(inputStream);
                return new X509CertImpl(byArray);
            }
            return new X509CertImpl(inputStream);
        }
        catch (IOException iOException) {
            throw new CertificateException(iOException.getMessage());
        }
    }

    public Collection engineGenerateCertificates(InputStream inputStream) throws CertificateException {
        if (inputStream == null) {
            throw new CertificateException("Missing input stream");
        }
        try {
            byte[] byArray;
            if (!inputStream.markSupported()) {
                byArray = this.getTotalBytes(new BufferedInputStream(inputStream));
                inputStream = new ByteArrayInputStream(byArray);
            }
            if (this.isBase64(inputStream)) {
                byArray = this.base64_to_binary(inputStream);
                return this.parseX509orPKCS7Cert(new ByteArrayInputStream(byArray));
            }
            return this.parseX509orPKCS7Cert(inputStream);
        }
        catch (IOException iOException) {
            throw new CertificateException(iOException.getMessage());
        }
    }

    private byte[] getTotalBytes(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[8192];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
        byteArrayOutputStream.reset();
        while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private boolean isBase64(InputStream inputStream) throws IOException {
        if (inputStream.available() >= 10) {
            inputStream.mark(10);
            int n = inputStream.read();
            int n2 = inputStream.read();
            int n3 = inputStream.read();
            int n4 = inputStream.read();
            int n5 = inputStream.read();
            int n6 = inputStream.read();
            int n7 = inputStream.read();
            int n8 = inputStream.read();
            int n9 = inputStream.read();
            int n10 = inputStream.read();
            inputStream.reset();
            return n == 45 && n2 == 45 && n3 == 45 && n4 == 45 && n5 == 45 && n6 == 66 && n7 == 69 && n8 == 71 && n9 == 73 && n10 == 78;
        }
        return false;
    }

    private Collection parseX509orPKCS7CRL(InputStream inputStream) throws CRLException {
        try {
            inputStream.mark(inputStream.available());
            X509CRLImpl x509CRLImpl = new X509CRLImpl(inputStream);
            return Arrays.asList(x509CRLImpl);
        }
        catch (CRLException cRLException) {
            try {
                inputStream.reset();
                byte[] byArray = new byte[inputStream.available()];
                inputStream.read(byArray);
                SignedData signedData = new SignedData(byArray);
                X509CRL[] x509CRLArray = (X509CRL[])signedData.getCRLs();
                if (x509CRLArray != null) {
                    return Arrays.asList(x509CRLArray);
                }
                return new ArrayList(0);
            }
            catch (IOException iOException) {
                throw new CRLException(iOException.getMessage());
            }
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.getMessage());
        }
    }

    private Collection parseX509orPKCS7Cert(InputStream inputStream) throws CertificateException {
        try {
            inputStream.mark(inputStream.available());
            X509CertImpl x509CertImpl = new X509CertImpl(inputStream);
            return Arrays.asList(x509CertImpl);
        }
        catch (CertificateException certificateException) {
            try {
                inputStream.reset();
                byte[] byArray = new byte[inputStream.available()];
                inputStream.read(byArray);
                SignedData signedData = new SignedData(byArray);
                Certificate[] certificateArray = signedData.getCertificates();
                if (certificateArray != null) {
                    return Arrays.asList(certificateArray);
                }
                return new ArrayList(0);
            }
            catch (IOException iOException) {
                try {
                    inputStream.reset();
                    byte[] byArray = new byte[inputStream.available()];
                    inputStream.read(byArray);
                    ContentInfo contentInfo = new ContentInfo(byArray);
                    Content content = contentInfo.getContent();
                    if (!(content instanceof SignedData)) {
                        throw new IOException("Invalid PKCS7 type. SignedData expected.");
                    }
                    Certificate[] certificateArray = ((SignedData)content).getCertificates();
                    if (certificateArray != null) {
                        return Arrays.asList(certificateArray);
                    }
                    return new ArrayList(0);
                }
                catch (IOException iOException2) {
                    throw new CertificateException(iOException.getMessage());
                }
            }
        }
        catch (IOException iOException) {
            throw new CertificateException(iOException.getMessage());
        }
    }

    private String readLine(BufferedReader bufferedReader) throws IOException {
        int n;
        int n2 = 0;
        boolean bl = true;
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer(defaultExpectedLineLength);
        do {
            n = bufferedReader.read();
            if (bl && n2 < endBoundary.length) {
                boolean bl3 = bl = (char)n == endBoundary[n2++];
            }
            if (!bl2) {
                bl2 = bl && n2 == endBoundary.length;
            }
            stringBuffer.append((char)n);
        } while (n != -1 && n != 10 && n != 13);
        if (!bl2 && n == -1) {
            return null;
        }
        if (n == 13) {
            bufferedReader.mark(1);
            int n3 = bufferedReader.read();
            if (n3 == 10) {
                stringBuffer.append((char)n);
            } else {
                bufferedReader.reset();
            }
        }
        return stringBuffer.toString();
    }
}

