/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.jaxp;

import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import org.apache.xpath.XPath;
import org.apache.xpath.jaxp.XPathExpressionImpl;
import org.apache.xpath.jaxp.XPathPrefixResolver;
import org.apache.xpath.res.XPATHMessages;
import org.xml.sax.InputSource;

public class XPathImpl
implements javax.xml.xpath.XPath {
    private XPathVariableResolver m_origVariableResolver = null;
    private XPathFunctionResolver m_origFunctionResolver = null;
    private XPathVariableResolver m_variableResolver = null;
    private XPathFunctionResolver m_functionResolver = null;
    private NamespaceContext m_namespaceContext = null;
    private boolean m_allowNullFcnPrefix = false;
    private boolean m_isSecureProcessing = false;

    protected XPathImpl(XPathFunctionResolver functionResolver, XPathVariableResolver variableResolver, boolean isSecureProcessing, boolean allowNullFcnPrefix) {
        this.m_origFunctionResolver = this.m_functionResolver = functionResolver;
        this.m_origVariableResolver = this.m_variableResolver = variableResolver;
        this.m_isSecureProcessing = isSecureProcessing;
        this.m_allowNullFcnPrefix = allowNullFcnPrefix;
    }

    public XPathVariableResolver getXPathVariableResolver() {
        return this.m_variableResolver;
    }

    public void setXPathVariableResolver(XPathVariableResolver resolver2) {
        if (resolver2 == null) {
            throw new NullPointerException(XPATHMessages.createXPATHMessage("ER_NULL_XPATH_VARIABLE_RESOLVER", null));
        }
        this.m_variableResolver = resolver2;
    }

    public XPathFunctionResolver getXPathFunctionResolver() {
        return this.m_functionResolver;
    }

    public void setXPathFunctionResolver(XPathFunctionResolver resolver2) {
        if (resolver2 == null) {
            throw new NullPointerException(XPATHMessages.createXPATHMessage("ER_NULL_XPATH_FUNCTION_RESOLVER", null));
        }
        this.m_functionResolver = resolver2;
    }

    public NamespaceContext getNamespaceContext() {
        return this.m_namespaceContext;
    }

    public void setNamespaceContext(NamespaceContext nsContext) {
        if (nsContext == null) {
            throw new NullPointerException(XPATHMessages.createXPATHMessage("ER_NULL_NAMESPACE_CONTEXT", null));
        }
        this.m_namespaceContext = nsContext;
    }

    public void reset() {
        this.m_variableResolver = this.m_origVariableResolver;
        this.m_functionResolver = this.m_origFunctionResolver;
    }

    public XPathExpression compile(String expression) throws XPathExpressionException {
        if (expression == null) {
            throw new NullPointerException(XPATHMessages.createXPATHMessage("ER_NULL_XPATH_EXPRESSION", null));
        }
        XPathPrefixResolver prefixResolver = new XPathPrefixResolver(this.m_namespaceContext);
        try {
            XPath xpath = new XPath(expression, prefixResolver, this.m_functionResolver, this.m_variableResolver, this.m_isSecureProcessing, this.m_allowNullFcnPrefix);
            return new XPathExpressionImpl(xpath, prefixResolver, this.m_isSecureProcessing);
        }
        catch (TransformerException te) {
            Throwable containedException = te.getException();
            if (containedException instanceof XPathExpressionException) {
                throw (XPathExpressionException)containedException;
            }
            throw new XPathExpressionException(te);
        }
    }

    public String evaluate(String expression, Object item) throws XPathExpressionException {
        return (String)this.evaluate(expression, item, XPathConstants.STRING);
    }

    public Object evaluate(String expression, Object item, QName returnType) throws XPathExpressionException {
        XPathExpression xpathExpr = this.compile(expression);
        return xpathExpr.evaluate(item, returnType);
    }

    public String evaluate(String expression, InputSource source) throws XPathExpressionException {
        return (String)this.evaluate(expression, source, XPathConstants.STRING);
    }

    public Object evaluate(String expression, InputSource source, QName returnType) throws XPathExpressionException {
        XPathExpression xpathExpr = this.compile(expression);
        return xpathExpr.evaluate(source, returnType);
    }
}

