/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.jaxp.datatype;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.apache.xerces.jaxp.datatype.DateTimeUtil;
import org.apache.xerces.jaxp.datatype.DurationImpl;
import org.apache.xerces.util.DatatypeMessageFormatter;

class XMLGregorianCalendarImpl
extends XMLGregorianCalendar {
    private static final BigInteger MAX_INT = new BigInteger("1000000000");
    private static final BigDecimal MILLI_MULT = new BigDecimal("1000");
    private BigInteger eon;
    private int year = Integer.MIN_VALUE;
    private int month = Integer.MIN_VALUE;
    private int day = Integer.MIN_VALUE;
    private int hour = Integer.MIN_VALUE;
    private int minute = Integer.MIN_VALUE;
    private int second = Integer.MIN_VALUE;
    private BigDecimal fracSeconds;
    private int timezone = Integer.MIN_VALUE;
    private BigInteger orig_eon;
    private int orig_year = Integer.MIN_VALUE;
    private int orig_month = Integer.MIN_VALUE;
    private int orig_day = Integer.MIN_VALUE;
    private int orig_hour = Integer.MIN_VALUE;
    private int orig_minute = Integer.MIN_VALUE;
    private int orig_second = Integer.MIN_VALUE;
    private BigDecimal orig_fracSeconds;
    private int orig_timezone = Integer.MIN_VALUE;
    private static final int YEAR = 2000;
    private static final int MONTH = 1;
    private static final int DAY = 1;
    private static final BigDecimal ZERO = new BigDecimal(0.0);
    private static final BigInteger I_ZERO = ZERO.toBigInteger();
    private static final BigDecimal ONE = new BigDecimal(1.0);
    private static final BigInteger I_ONE = ONE.toBigInteger();
    private static final BigInteger THIRTEEN = BigInteger.valueOf(13L);

    public XMLGregorianCalendarImpl() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public XMLGregorianCalendarImpl(String string) {
        int n;
        if (string == null) {
            throw new NullPointerException(DatatypeMessageFormatter.formatMessage(null, "CannotBeNull", new Object[]{"String"}));
        }
        int n2 = string.length();
        if (n2 <= 3) throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidLexicalValue", new Object[]{string}));
        if (string.charAt(0) == '-' && string.charAt(1) == '-') {
            if (string.charAt(2) == '-') {
                if (n2 < 5) throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string, "gDay"}));
                this.setDay(DateTimeUtil.parseInt(string, 3, 5));
                if (n2 > 5) {
                    this.parseTimeZone(string, 5, n2);
                }
                this.save();
                if (this.isValid()) return;
                throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string, "gDay"}));
            }
            this.setMonth(DateTimeUtil.parseInt(string, 2, 4));
            if (n2 == 4) {
                this.save();
                if (this.isValid()) return;
                throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string, "gMonth"}));
            }
            if (string.charAt(4) == '+' || string.charAt(4) == 'Z') {
                this.parseTimeZone(string, 4, n2);
                this.save();
                if (this.isValid()) return;
                throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string, "gMonth"}));
            }
            if (string.charAt(4) != '-' || n2 < 6) throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string, "gMonth/gMonthDay"}));
            int n3 = 5;
            if (string.charAt(n3) == '-') {
                ++n3;
                if (n2 == 6) {
                    this.save();
                    if (this.isValid()) return;
                    throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string, "gMonth"}));
                }
                if (string.charAt(n3) == '-' || string.charAt(n3) == '+' || string.charAt(n3) == 'Z') {
                    this.parseTimeZone(string, n3, n2);
                    if (this.isValid()) return;
                    throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string, "gMonth"}));
                }
            }
            if (n3 + 2 > n2) throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string, "gMonth/gMonthDay"}));
            int n4 = DateTimeUtil.parseInt(string, n3, n3 + 2);
            int n5 = n3 - 1;
            if (n3 + 2 == n2 || string.charAt(n3 + 2) != ':') {
                this.setDay(n4);
                if (n3 + 2 == n2) {
                    this.save();
                    if (this.isValid()) return;
                    throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string, "gMonthDay"}));
                }
                n5 = n3 + 2;
            }
            this.parseTimeZone(string, n5, n2);
            this.save();
            if (this.isValid()) return;
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string, "gMonth"}));
        }
        if (string.charAt(2) == ':') {
            this.getTime(string, 0, n2);
            this.save();
            if (this.isValid()) return;
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string, "time"}));
        }
        int n6 = DateTimeUtil.indexOf(string, 1, n2, '-');
        if (n6 != -1) {
            this.setYearAfterCheck(string, n6);
            if (n6 + 2 >= n2) throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string, "gYear"}));
            n = DateTimeUtil.parseInt(string, ++n6, n6 + 2);
            if (n6 + 2 == n2) {
                this.setMonth(n);
                this.save();
                if (this.isValid()) return;
                throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string, "gYearMonth"}));
            }
            if (string.charAt(n6 + 2) == ':') {
                this.parseTimeZone(string, n6 - 1, n2);
                this.save();
                if (this.isValid()) return;
                throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string, "gYearMonth"}));
            }
            if (string.charAt(n6 + 2) != '-' && string.charAt(n6 + 2) != '+' && string.charAt(n6 + 2) != 'Z') {
                throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string, "gYear/gYearMonth/date/datetime"}));
            }
        } else {
            n6 = DateTimeUtil.indexOf(string, 1, n2, '+');
            if (n6 == -1) {
                n6 = DateTimeUtil.indexOf(string, 1, n2, 'Z');
            }
            this.setYearAfterCheck(string, n6 != -1 ? n6 : n2);
            if (n6 != -1) {
                this.parseTimeZone(string, n6, n2);
            }
            this.save();
            if (this.isValid()) return;
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string, "gYear"}));
        }
        this.setMonth(n);
        if ((n6 += 2) >= n2) return;
        if (string.charAt(n6) == '-' && n6 + 2 < n2) {
            n = DateTimeUtil.parseInt(string, ++n6, n6 + 2);
            if (n6 + 2 < n2) {
                if (string.charAt(n6 + 2) == ':') {
                    this.parseTimeZone(string, n6 - 1, n2);
                    this.save();
                    if (this.isValid()) return;
                    throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidLexicalValue", new Object[]{string}));
                }
                if (string.charAt(n6 + 2) == 'T') {
                    this.setDay(n);
                    this.getTime(string, n6 + 3, n2);
                    this.save();
                    if (this.isValid()) return;
                    throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string, "datetime"}));
                }
                if (string.charAt(n6 + 2) != '-' && string.charAt(n6 + 2) != '+' && string.charAt(n6 + 2) != 'Z') throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidLexicalValue", new Object[]{string}));
                this.setDay(n);
                this.parseTimeZone(string, n6 + 2, n2);
                this.save();
                if (this.isValid()) return;
                throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string, "datetime"}));
            }
            this.setDay(n);
            this.save();
            if (this.isValid()) return;
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string, "date"}));
        }
        if ((string.charAt(n6) != '+' || n6 + 6 != n2) && (string.charAt(n6) != 'Z' || n6 + 1 != n2)) throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidLexicalValue", new Object[]{string}));
        this.parseTimeZone(string, n6, n2);
        this.save();
        if (this.isValid()) return;
        throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidLexicalValue", new Object[]{string}));
    }

    private void setYearAfterCheck(String string, int n) {
        int n2 = 0;
        if (string.charAt(0) == '-') {
            ++n2;
        }
        if (string.charAt(n2) == '0' && n - n2 > 4) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "NoLeadingZeros", new Object[]{string}));
        }
        if (n - n2 < 4) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidYearSyntax", new Object[]{string}));
        }
        try {
            this.setYear(new BigInteger(string.substring(0, n)));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(numberFormatException.getMessage());
        }
    }

    public XMLGregorianCalendarImpl(GregorianCalendar gregorianCalendar) {
        this.setYear(gregorianCalendar.get(0) == 0 ? -gregorianCalendar.get(1) : gregorianCalendar.get(1));
        this.setMonth(gregorianCalendar.get(2) + 1);
        this.setDay(gregorianCalendar.get(5));
        this.setTime(gregorianCalendar.get(9) == 0 ? gregorianCalendar.get(10) : 12 + gregorianCalendar.get(10), gregorianCalendar.get(12), gregorianCalendar.get(13), gregorianCalendar.get(14));
        this.setTimezone((gregorianCalendar.get(15) + gregorianCalendar.get(16)) / 60000);
        this.save();
    }

    public XMLGregorianCalendarImpl(BigInteger bigInteger, int n, int n2, int n3, int n4, int n5, BigDecimal bigDecimal, int n6) {
        this.setYear(bigInteger);
        this.setMonth(n);
        this.setDay(n2);
        this.setHour(n3);
        this.setMinute(n4);
        this.setSecond(n5);
        this.setFractionalSecond(bigDecimal);
        this.setTimezone(n6);
        this.save();
    }

    public XMLGregorianCalendarImpl(int n, int n2, int n3, int n4, int n5, int n6, BigDecimal bigDecimal, int n7) {
        this.setYear(n);
        this.setMonth(n2);
        this.setDay(n3);
        this.setHour(n4);
        this.setMinute(n5);
        this.setSecond(n6);
        this.setFractionalSecond(bigDecimal);
        this.setTimezone(this.timezone);
        this.save();
    }

    private void save() {
        this.orig_eon = this.eon;
        this.orig_year = this.year;
        this.orig_month = this.month;
        this.orig_day = this.day;
        this.orig_hour = this.hour;
        this.orig_minute = this.minute;
        this.orig_second = this.second;
        this.orig_fracSeconds = this.fracSeconds;
        this.orig_timezone = this.timezone;
    }

    private void getTime(String string, int n, int n2) throws RuntimeException {
        int n3 = n + 2;
        this.setHour(DateTimeUtil.parseInt(string, n, n3));
        if (n3 >= n2) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidTimeValue", new Object[]{string}));
        }
        if (string.charAt(n3++) != ':') {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidTimeZoneValue", new Object[]{string}));
        }
        n = n3;
        this.setMinute(DateTimeUtil.parseInt(string, n, n3 += 2));
        if (n3 >= n2) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidTimeValue", new Object[]{string}));
        }
        if (string.charAt(n3++) != ':') {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidTimeZoneValue", new Object[]{string}));
        }
        int n4 = this.findUTCSign(string, n, n2);
        n = n3;
        n3 = n4 < 0 ? n2 : n4;
        int n5 = DateTimeUtil.indexOf(string, n, n3, '.');
        this.setSecond(DateTimeUtil.parseInt(string, n, n5 != -1 ? n5 : n3));
        if (n5 != -1) {
            try {
                this.setFractionalSecond(new BigDecimal(string.substring(n5, n3)));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidTimeValue", new Object[]{string}));
            }
        }
        if (n4 > 0) {
            this.getTimeZone(string, n4, n2);
        }
    }

    private void parseTimeZone(String string, int n, int n2) throws RuntimeException {
        if (n < n2) {
            int n3 = this.findUTCSign(string, n, n2);
            if (n3 < 0) {
                throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidTimeZoneValue", new Object[]{string}));
            }
            this.getTimeZone(string, n3, n2);
        }
    }

    private int findUTCSign(String string, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            char c = string.charAt(n3);
            if (c == 'Z' || c == '+' || c == '-') {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    private void getTimeZone(String string, int n, int n2) throws RuntimeException {
        int n3;
        int n4;
        if (string.charAt(n) == 'Z') {
            if (n2 > ++n) {
                throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidTimeZoneValue", new Object[]{string}));
            }
            this.setTimezone(0);
            return;
        }
        if (n <= n2 - 6) {
            int n5 = string.charAt(n) == '-' ? -1 : 1;
            int n6 = ++n + 2;
            n4 = n5 * DateTimeUtil.parseInt(string, n, n6);
            if (string.charAt(n6++) != ':') {
                throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidTimeZoneValue", new Object[]{string}));
            }
            n3 = n5 * DateTimeUtil.parseInt(string, n6, n6 + 2);
            if (n6 + 2 != n2) {
                throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidTimeZoneValue", new Object[]{string}));
            }
        } else {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidTimeZoneValue", new Object[]{string}));
        }
        this.setTimezone(n4 * 60 + n3);
    }

    public void clear() {
        this.eon = null;
        this.year = Integer.MIN_VALUE;
        this.month = Integer.MIN_VALUE;
        this.day = Integer.MIN_VALUE;
        this.hour = Integer.MIN_VALUE;
        this.minute = Integer.MIN_VALUE;
        this.second = Integer.MIN_VALUE;
        this.fracSeconds = null;
        this.timezone = Integer.MIN_VALUE;
    }

    public void reset() {
        this.eon = this.orig_eon;
        this.year = this.orig_year;
        this.month = this.orig_month;
        this.day = this.orig_day;
        this.hour = this.orig_hour;
        this.minute = this.orig_minute;
        this.second = this.orig_second;
        this.fracSeconds = this.orig_fracSeconds;
        this.timezone = this.orig_timezone;
    }

    public void setYear(BigInteger bigInteger) {
        if (bigInteger == null) {
            this.eon = null;
            this.year = Integer.MIN_VALUE;
            return;
        }
        if (bigInteger.compareTo(MAX_INT) >= 0 || bigInteger.compareTo(MAX_INT.negate()) <= 0) {
            BigInteger bigInteger2 = bigInteger.remainder(MAX_INT);
            this.eon = bigInteger.subtract(bigInteger2);
            this.year = bigInteger2.intValue();
        } else {
            this.eon = null;
            this.year = bigInteger.intValue();
        }
    }

    public void setYear(int n) {
        if (n == Integer.MIN_VALUE) {
            this.year = n;
            this.eon = null;
            return;
        }
        if (n < MAX_INT.intValue() && n > MAX_INT.negate().intValue()) {
            this.eon = null;
            this.year = n;
        } else {
            this.setYear(BigInteger.valueOf(n));
        }
    }

    private int maxDaysInMonthFor(BigInteger bigInteger, int n) {
        if (n == 4 || n == 6 || n == 9 || n == 11) {
            return 30;
        }
        if (n == 2) {
            if (XMLGregorianCalendarImpl.isLeapYear(bigInteger)) {
                return 29;
            }
            return 28;
        }
        return 31;
    }

    private static final boolean isLeapYear(BigInteger bigInteger) {
        return bigInteger.mod(BigInteger.valueOf(4L)).equals(BigInteger.ZERO) && (!bigInteger.mod(BigInteger.valueOf(100L)).equals(BigInteger.ZERO) || bigInteger.mod(BigInteger.valueOf(400L)).equals(BigInteger.ZERO));
    }

    public void setMonth(int n) {
        if (n == Integer.MIN_VALUE) {
            this.month = n;
            return;
        }
        if (n <= 0 || n > 12) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidValueSet", new Object[]{"month", "1", "12", String.valueOf(n)}));
        }
        this.month = n;
    }

    public void setDay(int n) {
        if (n == Integer.MIN_VALUE) {
            this.day = n;
            return;
        }
        if (n < 1 || n > 31) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidValueSet", new Object[]{"day", "1", "31", String.valueOf(n)}));
        }
        this.day = n;
    }

    public void setTimezone(int n) {
        if (n < -840 && n != Integer.MIN_VALUE || n > 840) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidValueSet", new Object[]{"offset", "-840", "840", String.valueOf(n)}));
        }
        this.timezone = n;
    }

    public void setHour(int n) {
        if (n == Integer.MIN_VALUE) {
            this.hour = n;
            return;
        }
        if (n < 0 || n >= 24) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidValueSet", new Object[]{"hour", "0", "24", String.valueOf(n)}));
        }
        this.hour = n;
    }

    public void setMinute(int n) {
        if (n == Integer.MIN_VALUE) {
            this.minute = n;
            return;
        }
        if (n < 0 || n > 59) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidValueSet", new Object[]{"minute", "0", "59", String.valueOf(n)}));
        }
        this.minute = n;
    }

    public void setSecond(int n) {
        if (n == Integer.MIN_VALUE) {
            this.second = n;
            return;
        }
        if (n < 0 || n > 60) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidValueSet", new Object[]{"second", "0", "60", String.valueOf(n)}));
        }
        this.second = n;
    }

    public void setMillisecond(int n) {
        if (n == Integer.MIN_VALUE) {
            this.fracSeconds = null;
            return;
        }
        if (n < 0 || n > 999) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidValueSet", new Object[]{"millisecond", "0", "1000", String.valueOf(n)}));
        }
        this.fracSeconds = new BigDecimal(String.valueOf((double)n / 1000.0));
    }

    public void setFractionalSecond(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            this.fracSeconds = null;
            return;
        }
        if (bigDecimal.compareTo(ZERO) < 0 || bigDecimal.compareTo(ONE) > 0) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidValueSet", new Object[]{"fractional", "0.0", "1.0", bigDecimal}));
        }
        this.fracSeconds = bigDecimal;
    }

    public BigInteger getEon() {
        return this.eon;
    }

    public int getYear() {
        return this.year;
    }

    public BigInteger getEonAndYear() {
        if (this.eon != null || this.year != Integer.MIN_VALUE) {
            BigInteger bigInteger = this.eon != null ? this.eon : BigInteger.ZERO;
            return bigInteger.add(this.year != Integer.MIN_VALUE ? BigInteger.valueOf(this.year) : BigInteger.ZERO);
        }
        return null;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public int getTimezone() {
        return this.timezone;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    public BigDecimal getFractionalSecond() {
        return this.fracSeconds;
    }

    public int compare(XMLGregorianCalendar xMLGregorianCalendar) {
        QName qName = null;
        QName qName2 = null;
        try {
            qName = xMLGregorianCalendar.getXMLSchemaType();
            qName2 = this.getXMLSchemaType();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (!(qName == qName2 || qName != null && qName2 != null && qName.equals(qName2))) {
            return 2;
        }
        XMLGregorianCalendar xMLGregorianCalendar2 = this.normalize();
        XMLGregorianCalendar xMLGregorianCalendar3 = xMLGregorianCalendar.normalize();
        if (xMLGregorianCalendar2.getTimezone() == xMLGregorianCalendar3.getTimezone()) {
            return this.compareOrder(xMLGregorianCalendar2, xMLGregorianCalendar3);
        }
        XMLGregorianCalendar xMLGregorianCalendar4 = new XMLGregorianCalendarImpl();
        if (xMLGregorianCalendar2.getTimezone() == 0) {
            xMLGregorianCalendar4 = (XMLGregorianCalendar)xMLGregorianCalendar3.clone();
            xMLGregorianCalendar4.setTimezone(840);
            int n = this.compareOrder(xMLGregorianCalendar2, xMLGregorianCalendar4.normalize());
            if (n == -1) {
                return n;
            }
            xMLGregorianCalendar4 = (XMLGregorianCalendar)xMLGregorianCalendar3.clone();
            xMLGregorianCalendar4.setTimezone(-840);
            int n2 = this.compareOrder(xMLGregorianCalendar2, xMLGregorianCalendar4.normalize());
            if (n2 == 1) {
                return n2;
            }
            return 2;
        }
        if (xMLGregorianCalendar3.getTimezone() == 0) {
            xMLGregorianCalendar4 = (XMLGregorianCalendar)xMLGregorianCalendar2.clone();
            xMLGregorianCalendar4.setTimezone(-840);
            int n = this.compareOrder(xMLGregorianCalendar4.normalize(), xMLGregorianCalendar3);
            if (n == -1) {
                return n;
            }
            xMLGregorianCalendar4 = (XMLGregorianCalendar)xMLGregorianCalendar2.clone();
            xMLGregorianCalendar4.setTimezone(840);
            int n3 = this.compareOrder(xMLGregorianCalendar4.normalize(), xMLGregorianCalendar3);
            if (n3 == 1) {
                return n3;
            }
            return 2;
        }
        return 2;
    }

    private int compareOrder(XMLGregorianCalendar xMLGregorianCalendar, XMLGregorianCalendar xMLGregorianCalendar2) {
        BigDecimal bigDecimal;
        int n;
        BigInteger bigInteger;
        BigInteger bigInteger2 = xMLGregorianCalendar.getEonAndYear();
        if (bigInteger2 != (bigInteger = xMLGregorianCalendar2.getEonAndYear())) {
            if (bigInteger2 == null || bigInteger == null) {
                return 2;
            }
            n = bigInteger2.compareTo(bigInteger);
            if (n != 0) {
                if (n == 1) {
                    return 1;
                }
                return -1;
            }
        }
        if ((n = this.checkValue(xMLGregorianCalendar.getMonth(), xMLGregorianCalendar2.getMonth())) != 0) {
            return n;
        }
        n = this.checkValue(xMLGregorianCalendar.getDay(), xMLGregorianCalendar2.getDay());
        if (n != 0) {
            return n;
        }
        n = this.checkValue(xMLGregorianCalendar.getHour(), xMLGregorianCalendar2.getHour());
        if (n != 0) {
            return n;
        }
        n = this.checkValue(xMLGregorianCalendar.getMinute(), xMLGregorianCalendar2.getMinute());
        if (n != 0) {
            return n;
        }
        n = this.checkValue(xMLGregorianCalendar.getSecond(), xMLGregorianCalendar2.getSecond());
        if (n != 0) {
            return n;
        }
        BigDecimal bigDecimal2 = xMLGregorianCalendar.getFractionalSecond();
        if (bigDecimal2 == (bigDecimal = xMLGregorianCalendar2.getFractionalSecond())) {
            return 0;
        }
        n = (bigDecimal2 == null ? ZERO : bigDecimal2).compareTo(bigDecimal == null ? ZERO : bigDecimal);
        if (n == 0) {
            return 0;
        }
        if (n == 1) {
            return 1;
        }
        return -1;
    }

    private int checkValue(int n, int n2) {
        if (n == n2) {
            return 0;
        }
        if (n == Integer.MIN_VALUE || n2 == Integer.MIN_VALUE) {
            return 2;
        }
        if (n < n2) {
            return -1;
        }
        return 1;
    }

    public XMLGregorianCalendar normalize() {
        XMLGregorianCalendarImpl xMLGregorianCalendarImpl = this;
        if (this.timezone != Integer.MIN_VALUE && this.timezone != 0) {
            xMLGregorianCalendarImpl = (XMLGregorianCalendarImpl)this.clone();
            BigInteger bigInteger = ZERO.toBigInteger();
            xMLGregorianCalendarImpl.add(new DurationImpl(this.timezone > 0 ? -1 : 1, bigInteger, bigInteger, bigInteger, bigInteger, this.timezone > 0 ? BigInteger.valueOf(this.timezone) : BigInteger.valueOf(-this.timezone), ZERO));
            xMLGregorianCalendarImpl.timezone = 0;
        }
        return xMLGregorianCalendarImpl;
    }

    public String toXMLFormat() {
        QName qName = this.getXMLSchemaType();
        StringBuffer stringBuffer = new StringBuffer();
        if (qName == null) {
            stringBuffer.append("0001-01-01T00:00:00Z");
        } else if (qName == DatatypeConstants.GYEAR) {
            stringBuffer.append(this.eon == null ? (this.year < 0 ? "-" : "") + (this.year > -10 && this.year < 10 ? "000" : (this.year > -100 && this.year < 100 ? "00" : (this.year > -1000 && this.year < 1000 ? "0" : ""))) : "");
            stringBuffer.append(this.getEonAndYear().abs().toString());
        } else if (qName == DatatypeConstants.GMONTH) {
            stringBuffer.append("--");
            stringBuffer.append(this.month < 10 ? "0" : "");
            stringBuffer.append(String.valueOf(this.month));
            stringBuffer.append("--");
        } else if (qName == DatatypeConstants.GDAY) {
            stringBuffer.append("---");
            stringBuffer.append(this.day < 10 ? "0" : "");
            stringBuffer.append(String.valueOf(this.day));
        } else if (qName == DatatypeConstants.GYEARMONTH) {
            stringBuffer.append(this.eon == null ? (this.year < 0 ? "-" : "") + (this.year > -10 && this.year < 10 ? "000" : (this.year > -100 && this.year < 100 ? "00" : (this.year > -1000 && this.year < 1000 ? "0" : ""))) : "");
            stringBuffer.append(this.getEonAndYear().abs().toString());
            stringBuffer.append("-");
            stringBuffer.append(this.month < 10 ? "0" : "");
            stringBuffer.append(String.valueOf(this.month));
        } else if (qName == DatatypeConstants.GMONTHDAY) {
            stringBuffer.append("--");
            stringBuffer.append(this.month < 10 ? "0" : "");
            stringBuffer.append(String.valueOf(this.month));
            stringBuffer.append("-");
            stringBuffer.append(this.day < 10 ? "0" : "");
            stringBuffer.append(String.valueOf(this.day));
        } else if (qName == DatatypeConstants.DATE) {
            stringBuffer.append(this.eon == null ? (this.year < 0 ? "-" : "") + (this.year > -10 && this.year < 10 ? "000" : (this.year > -100 && this.year < 100 ? "00" : (this.year > -1000 && this.year < 1000 ? "0" : ""))) : "");
            stringBuffer.append(this.getEonAndYear().abs().toString());
            stringBuffer.append("-");
            stringBuffer.append(this.month < 10 ? "0" : "");
            stringBuffer.append(String.valueOf(this.month));
            stringBuffer.append("-");
            stringBuffer.append(this.day < 10 ? "0" : "");
            stringBuffer.append(String.valueOf(this.day));
        } else if (qName == DatatypeConstants.TIME) {
            stringBuffer.append(this.hour < 10 ? "0" : "");
            stringBuffer.append(String.valueOf(this.hour));
            stringBuffer.append(":");
            stringBuffer.append(this.minute < 10 ? "0" : "");
            stringBuffer.append(String.valueOf(this.minute));
            stringBuffer.append(":");
            stringBuffer.append(this.second < 10 ? "0" : "");
            stringBuffer.append(String.valueOf(this.second));
            stringBuffer.append(this.fracSeconds != null ? this.toString(this.fracSeconds) : "");
        } else if (qName == DatatypeConstants.DATETIME) {
            stringBuffer.append(this.eon == null ? (this.year < 0 ? "-" : "") + (this.year > -10 && this.year < 10 ? "000" : (this.year > -100 && this.year < 100 ? "00" : (this.year > -1000 && this.year < 1000 ? "0" : ""))) : "");
            stringBuffer.append(this.getEonAndYear().abs().toString());
            stringBuffer.append("-");
            stringBuffer.append(this.month < 10 ? "0" : "");
            stringBuffer.append(String.valueOf(this.month));
            stringBuffer.append("-");
            stringBuffer.append(this.day < 10 ? "0" : "");
            stringBuffer.append(String.valueOf(this.day));
            stringBuffer.append("T");
            stringBuffer.append(this.hour < 10 ? "0" : "");
            stringBuffer.append(String.valueOf(this.hour));
            stringBuffer.append(":");
            stringBuffer.append(this.minute < 10 ? "0" : "");
            stringBuffer.append(String.valueOf(this.minute));
            stringBuffer.append(":");
            stringBuffer.append(this.second < 10 ? "0" : "");
            stringBuffer.append(String.valueOf(this.second));
            stringBuffer.append(this.fracSeconds != null ? this.toString(this.fracSeconds).substring(1) : "");
        }
        return this.getTimezoneString(stringBuffer);
    }

    private String getTimezoneString(StringBuffer stringBuffer) {
        if (this.timezone != Integer.MIN_VALUE) {
            if (this.timezone != 0) {
                int n = this.timezone < 0 ? -1 : 1;
                int n2 = this.timezone / 60 * n;
                int n3 = this.timezone % 60 * n;
                stringBuffer.append(n == -1 ? (char)'-' : '+');
                stringBuffer.append(n2 < 10 ? "0" : "");
                stringBuffer.append(n2);
                stringBuffer.append(":");
                stringBuffer.append(n3 < 10 ? "0" : "");
                stringBuffer.append(n3);
                return stringBuffer.toString();
            }
            stringBuffer.append("Z");
            return stringBuffer.toString();
        }
        return stringBuffer.toString();
    }

    public QName getXMLSchemaType() {
        boolean bl;
        boolean bl2 = this.hour != Integer.MIN_VALUE;
        boolean bl3 = this.minute != Integer.MIN_VALUE;
        boolean bl4 = bl = this.second != Integer.MIN_VALUE;
        if (bl2 && bl3 && bl) {
            if (this.year != Integer.MIN_VALUE && this.month != Integer.MIN_VALUE && this.day != Integer.MIN_VALUE) {
                return DatatypeConstants.DATETIME;
            }
            if (this.year == Integer.MIN_VALUE && this.month == Integer.MIN_VALUE && this.day == Integer.MIN_VALUE) {
                return DatatypeConstants.TIME;
            }
        } else if (!(bl2 || bl3 || bl)) {
            boolean bl5;
            boolean bl6 = this.year != Integer.MIN_VALUE;
            boolean bl7 = this.month != Integer.MIN_VALUE;
            boolean bl8 = bl5 = this.day != Integer.MIN_VALUE;
            if (bl6) {
                if (bl7 && bl5) {
                    return DatatypeConstants.DATE;
                }
                if (bl7 && !bl5) {
                    return DatatypeConstants.GYEARMONTH;
                }
                if (!bl7 && !bl5) {
                    return DatatypeConstants.GYEAR;
                }
            } else {
                if (bl7) {
                    if (bl5) {
                        return DatatypeConstants.GMONTHDAY;
                    }
                    return DatatypeConstants.GMONTH;
                }
                if (bl5) {
                    return DatatypeConstants.GDAY;
                }
            }
        }
        throw new IllegalStateException(DatatypeMessageFormatter.formatMessage(null, "InvalidFieldsSet", new Object[]{this.year != Integer.MIN_VALUE ? String.valueOf(this.year) : "FIELD_UNDEFINED", this.month != Integer.MIN_VALUE ? String.valueOf(this.month) : "FIELD_UNDEFINED", this.day != Integer.MIN_VALUE ? String.valueOf(this.day) : "FIELD_UNDEFINED", this.hour != Integer.MIN_VALUE ? String.valueOf(this.hour) : "FIELD_UNDEFINED", this.minute != Integer.MIN_VALUE ? String.valueOf(this.minute) : "FIELD_UNDEFINED", this.second != Integer.MIN_VALUE ? String.valueOf(this.second) : "FIELD_UNDEFINED", this.fracSeconds != null ? this.fracSeconds.toString() : "FIELD_UNDEFINED", this.timezone != Integer.MIN_VALUE ? String.valueOf(this.timezone) : "FIELD_UNDEFINED"}));
    }

    public boolean isValid() {
        BigInteger bigInteger = this.getEonAndYear();
        if (this.month != Integer.MIN_VALUE && this.day != Integer.MIN_VALUE ? this.day > this.maxDaysInMonthFor(bigInteger != null ? bigInteger : BigInteger.valueOf(2000L), this.month) : this.day != Integer.MIN_VALUE && this.day > this.maxDaysInMonthFor(bigInteger != null ? bigInteger : BigInteger.valueOf(2000L), 1)) {
            return false;
        }
        if (this.hour == 24 && (this.minute != 0 || this.second != 0)) {
            return false;
        }
        if (this.eon == null && this.year == 0) {
            return false;
        }
        if (bigInteger != null && bigInteger.compareTo(BigInteger.ZERO) == 0) {
            return false;
        }
        return this.fracSeconds == null || this.second != Integer.MIN_VALUE;
    }

    public void add(Duration duration) {
        boolean[] blArray = new boolean[]{this.eon == null, this.year == Integer.MIN_VALUE, this.month == Integer.MIN_VALUE, this.day == Integer.MIN_VALUE, this.hour == Integer.MIN_VALUE, this.minute == Integer.MIN_VALUE, this.second == Integer.MIN_VALUE, this.fracSeconds == null};
        int n = duration.getSign();
        BigInteger bigInteger = (BigInteger)duration.getField(DatatypeConstants.MONTHS);
        BigInteger bigInteger2 = BigInteger.valueOf(this.month != Integer.MIN_VALUE ? (long)this.month : 1L).add(bigInteger != null ? (n == -1 ? bigInteger.negate() : bigInteger) : I_ZERO);
        this.month = DateTimeUtil.modulo(bigInteger2, I_ONE, THIRTEEN).intValue();
        BigInteger bigInteger3 = DateTimeUtil.fQuotient(bigInteger2, I_ONE, THIRTEEN);
        BigInteger bigInteger4 = this.getEonAndYear();
        BigInteger bigInteger5 = (BigInteger)duration.getField(DatatypeConstants.YEARS);
        this.setYear((bigInteger4 != null ? bigInteger4 : I_ZERO).add(bigInteger5 != null ? (n == -1 ? bigInteger5.negate() : bigInteger5) : I_ZERO).add(bigInteger3));
        BigDecimal bigDecimal = duration.isSet(DatatypeConstants.SECONDS) ? (n == -1 ? ((BigDecimal)duration.getField(DatatypeConstants.SECONDS)).negate() : (BigDecimal)duration.getField(DatatypeConstants.SECONDS)) : ZERO;
        BigDecimal bigDecimal2 = bigDecimal.setScale(0, 2);
        int n2 = (this.second != Integer.MIN_VALUE ? this.second : 0) + bigDecimal2.intValue();
        this.fracSeconds = this.fracSeconds != null ? (n > 0 ? this.fracSeconds.subtract(bigDecimal.subtract(bigDecimal2)) : this.fracSeconds.add(bigDecimal.subtract(bigDecimal2))) : bigDecimal.subtract(bigDecimal2);
        int n3 = DateTimeUtil.fQuotient(n2, 60);
        this.second = DateTimeUtil.mod(n2, 60, n3);
        n2 = (this.minute != Integer.MIN_VALUE ? this.minute : 0) + n * duration.getMinutes() + n3;
        n3 = DateTimeUtil.fQuotient(n2, 60);
        this.minute = DateTimeUtil.mod(n2, 60, n3);
        n2 = (this.hour != Integer.MIN_VALUE ? this.hour : 0) + n * duration.getHours() + n3;
        n3 = DateTimeUtil.fQuotient(n2, 24);
        this.hour = DateTimeUtil.mod(n2, 24, n3);
        this.day = (this.day != Integer.MIN_VALUE ? this.day : 1) + n * duration.getDays() + n3;
        while (true) {
            int n4 = this.eon != null ? this.maxDaysInMonthFor(this.eon.add(this.year != Integer.MIN_VALUE ? BigInteger.valueOf(this.year) : BigInteger.valueOf(2000L)), this.month != Integer.MIN_VALUE ? this.month : 1) : (n2 = DateTimeUtil.maxDayInMonthFor(this.year != Integer.MIN_VALUE ? this.year : 2000, this.month != Integer.MIN_VALUE ? this.month : 1));
            if (this.month < 1) {
                this.month += 12;
                BigInteger bigInteger6 = this.getEonAndYear();
                if (bigInteger6 != null) {
                    this.setYear(bigInteger6.subtract(I_ONE));
                    continue;
                }
                this.setYear(-1);
                continue;
            }
            if (this.month > 12) {
                this.month -= 12;
                BigInteger bigInteger7 = this.getEonAndYear();
                if (bigInteger7 != null) {
                    this.setYear(bigInteger7.add(I_ONE));
                    continue;
                }
                this.setYear(1);
                continue;
            }
            if (this.day < 1) {
                this.day += this.eon != null ? this.maxDaysInMonthFor(this.eon.add(this.year != Integer.MIN_VALUE ? BigInteger.valueOf(this.year) : BigInteger.valueOf(2000L)), (this.month != Integer.MIN_VALUE ? this.month : 1) - 1) : DateTimeUtil.maxDayInMonthFor(this.year != Integer.MIN_VALUE ? this.year : 2000, (this.month != Integer.MIN_VALUE ? this.month : 1) - 1);
                n3 = -1;
            } else if (this.day > n2) {
                this.day -= n2;
                n3 = 1;
            } else {
                if (this.hour < 0) {
                    this.hour += 24;
                    --this.day;
                    continue;
                }
                if (this.hour > 24) {
                    this.hour -= 24;
                    ++this.day;
                    continue;
                }
                if (this.minute < 0) {
                    this.minute += 60;
                    --this.hour;
                    continue;
                }
                if (this.minute > 60) {
                    this.minute -= 60;
                    ++this.hour;
                    continue;
                }
                if (this.second < 0) {
                    this.second += 60;
                    --this.minute;
                    continue;
                }
                if (this.second > 60) {
                    this.second -= 60;
                    ++this.minute;
                    continue;
                }
                if (this.fracSeconds.compareTo(ZERO) == -1) {
                    this.fracSeconds = this.fracSeconds.add(ONE);
                    --this.second;
                    continue;
                }
                if (this.fracSeconds.compareTo(ONE) != 1) break;
                this.fracSeconds = this.fracSeconds.subtract(ONE);
                ++this.second;
                continue;
            }
            n2 = this.month + n3;
            this.month = DateTimeUtil.modulo(n2, 1, 13);
            int n5 = DateTimeUtil.fQuotient(n2, 1, 13);
            this.setYear(this.year + n5);
        }
        if (blArray[0] && blArray[1]) {
            this.eon = null;
            this.year = Integer.MIN_VALUE;
        }
        if (blArray[2]) {
            this.month = Integer.MIN_VALUE;
        }
        if (blArray[3]) {
            this.day = Integer.MIN_VALUE;
        }
        if (blArray[4]) {
            this.hour = Integer.MIN_VALUE;
        }
        if (blArray[5]) {
            this.minute = Integer.MIN_VALUE;
        }
        if (blArray[6] && blArray[7]) {
            this.second = Integer.MIN_VALUE;
            this.fracSeconds = null;
        }
    }

    public GregorianCalendar toGregorianCalendar() {
        return this.toGregorianCalendar(null, null, null);
    }

    public GregorianCalendar toGregorianCalendar(TimeZone timeZone, Locale locale, XMLGregorianCalendar xMLGregorianCalendar) {
        BigInteger bigInteger;
        boolean bl;
        boolean bl2 = bl = xMLGregorianCalendar != null;
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone != null ? timeZone : this.getTimeZone(bl ? xMLGregorianCalendar.getTimezone() : Integer.MIN_VALUE), locale != null ? locale : Locale.getDefault());
        gregorianCalendar.clear();
        gregorianCalendar.setGregorianChange(new Date(Long.MIN_VALUE));
        BigInteger bigInteger2 = this.getEonAndYear();
        if (bigInteger2 != null) {
            gregorianCalendar.set(0, bigInteger2.signum() == -1 ? 0 : 1);
            gregorianCalendar.set(1, bigInteger2.abs().intValue());
        } else if (bl && (bigInteger = xMLGregorianCalendar.getEonAndYear()) != null) {
            gregorianCalendar.set(0, bigInteger.signum() == -1 ? 0 : 1);
            gregorianCalendar.set(1, bigInteger.abs().intValue());
        }
        if (this.month != Integer.MIN_VALUE) {
            gregorianCalendar.set(2, this.month - 1);
        } else if (bl) {
            gregorianCalendar.set(2, xMLGregorianCalendar.getMonth() - 1);
        }
        if (this.day != Integer.MIN_VALUE) {
            gregorianCalendar.set(5, this.day);
        } else if (bl) {
            gregorianCalendar.set(5, xMLGregorianCalendar.getDay());
        }
        if (this.hour != Integer.MIN_VALUE) {
            gregorianCalendar.set(11, this.hour);
        } else if (bl) {
            gregorianCalendar.set(11, xMLGregorianCalendar.getHour());
        }
        if (this.minute != Integer.MIN_VALUE) {
            gregorianCalendar.set(12, this.minute);
        } else if (bl) {
            gregorianCalendar.set(12, xMLGregorianCalendar.getMinute());
        }
        if (this.second != Integer.MIN_VALUE) {
            gregorianCalendar.set(13, this.second);
        } else if (bl) {
            gregorianCalendar.set(13, xMLGregorianCalendar.getSecond());
        }
        if (this.fracSeconds != null) {
            gregorianCalendar.set(14, this.getMillisecond());
        } else if (bl) {
            gregorianCalendar.set(14, xMLGregorianCalendar.getMillisecond());
        }
        return gregorianCalendar;
    }

    public TimeZone getTimeZone(int n) {
        int n2;
        int n3 = n2 = this.timezone != Integer.MIN_VALUE ? this.timezone : n;
        if (n2 == Integer.MIN_VALUE) {
            return TimeZone.getDefault();
        }
        int n4 = n2 / 60;
        int n5 = n2 % 60;
        StringBuffer stringBuffer = new StringBuffer(9);
        stringBuffer.append("GMT");
        stringBuffer.append(n2 > 0 ? (char)'+' : '-');
        stringBuffer.append(n4 < 10 ? "0" : "");
        stringBuffer.append(n4);
        stringBuffer.append(':');
        stringBuffer.append(n5 < 10 ? "0" : "");
        stringBuffer.append(n5);
        return TimeZone.getTimeZone(stringBuffer.toString());
    }

    public Object clone() {
        XMLGregorianCalendarImpl xMLGregorianCalendarImpl = new XMLGregorianCalendarImpl();
        xMLGregorianCalendarImpl.eon = this.eon != null ? new BigInteger(this.eon.toString()) : null;
        xMLGregorianCalendarImpl.year = this.year;
        xMLGregorianCalendarImpl.month = this.month;
        xMLGregorianCalendarImpl.day = this.day;
        xMLGregorianCalendarImpl.hour = this.hour;
        xMLGregorianCalendarImpl.minute = this.minute;
        xMLGregorianCalendarImpl.second = this.second;
        xMLGregorianCalendarImpl.fracSeconds = this.fracSeconds != null ? new BigDecimal(this.fracSeconds.toString()) : null;
        xMLGregorianCalendarImpl.timezone = this.timezone;
        xMLGregorianCalendarImpl.orig_eon = this.orig_eon != null ? new BigInteger(this.orig_eon.toString()) : null;
        xMLGregorianCalendarImpl.orig_year = this.orig_year;
        xMLGregorianCalendarImpl.orig_month = this.orig_month;
        xMLGregorianCalendarImpl.orig_day = this.orig_day;
        xMLGregorianCalendarImpl.orig_hour = this.orig_hour;
        xMLGregorianCalendarImpl.orig_minute = this.orig_minute;
        xMLGregorianCalendarImpl.orig_second = this.orig_second;
        xMLGregorianCalendarImpl.orig_fracSeconds = this.orig_fracSeconds != null ? new BigDecimal(this.orig_fracSeconds.toString()) : null;
        xMLGregorianCalendarImpl.orig_timezone = this.orig_timezone;
        return xMLGregorianCalendarImpl;
    }

    private String toString(BigDecimal bigDecimal) {
        StringBuffer stringBuffer;
        String string = bigDecimal.unscaledValue().toString();
        int n = bigDecimal.scale();
        if (n == 0) {
            return string;
        }
        int n2 = string.length() - n;
        if (n2 == 0) {
            return "0." + string;
        }
        if (n2 > 0) {
            stringBuffer = new StringBuffer(string);
            stringBuffer.insert(n2, '.');
        } else {
            stringBuffer = new StringBuffer(3 - n2 + string.length());
            stringBuffer.append("0.");
            int n3 = 0;
            while (n3 < -n2) {
                stringBuffer.append('0');
                ++n3;
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

