/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.jaxp.datatype;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.apache.xerces.jaxp.datatype.DateTimeUtil;
import org.apache.xerces.jaxp.datatype.XMLGregorianCalendarImpl;
import org.apache.xerces.util.DatatypeMessageFormatter;

class DurationImpl
extends Duration {
    private int sign = 0;
    private BigInteger years = null;
    private BigInteger months = null;
    private BigInteger days = null;
    private BigInteger hours = null;
    private BigInteger minutes = null;
    private BigDecimal seconds = null;
    private static final int PROPERTY_COUNT = 6;
    private static final XMLGregorianCalendar[] SAVED_CAL = new XMLGregorianCalendar[]{new XMLGregorianCalendarImpl("1696-09-01T00:00:00Z"), new XMLGregorianCalendarImpl("1697-02-01T00:00:00Z"), new XMLGregorianCalendarImpl("1903-03-01T00:00:00Z"), new XMLGregorianCalendarImpl("1903-07-01T00:00:00Z")};
    private static final BigDecimal ZERO = new BigDecimal(0.0);
    private static final BigDecimal ONE = new BigDecimal(1.0);
    private static final BigInteger I_ONE = ONE.toBigInteger();
    private static final BigInteger I_ZERO = ZERO.toBigInteger();
    private static final BigInteger TWELVE = BigInteger.valueOf(12L);
    private static final BigDecimal SIXTY = BigDecimal.valueOf(60L);
    private static final BigInteger I_SIXTY = SIXTY.toBigInteger();
    private static final BigInteger TWENTY_FOUR = BigInteger.valueOf(24L);
    private static final BigInteger THIRTEEN = BigInteger.valueOf(13L);
    private static final BigDecimal[] FIELD_MAXVALUES = new BigDecimal[]{ONE, new BigDecimal(12.0), ZERO, new BigDecimal(24.0), new BigDecimal(60.0), new BigDecimal(60.0)};
    private static final DatatypeConstants.Field[] FIELDS = new DatatypeConstants.Field[]{DatatypeConstants.YEARS, DatatypeConstants.MONTHS, DatatypeConstants.DAYS, DatatypeConstants.HOURS, DatatypeConstants.MINUTES, DatatypeConstants.SECONDS};

    private DurationImpl() {
    }

    public DurationImpl(String string, QName qName) throws NullPointerException, IllegalArgumentException, UnsupportedOperationException {
        this.parse(string, qName);
    }

    public DurationImpl(int n, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigDecimal bigDecimal) {
        this.sign = n;
        if (bigInteger != null && bigInteger.signum() == -1) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "YearsCannotBeNegative", new Object[]{bigInteger}));
        }
        this.years = bigInteger;
        if (bigInteger2 != null && bigInteger2.signum() == -1) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "MonthsCannotBeNegative", new Object[]{bigInteger2}));
        }
        this.months = bigInteger2;
        if (bigInteger3 != null && bigInteger3.signum() == -1) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "DaysCannotBeNegative", new Object[]{bigInteger3}));
        }
        this.days = bigInteger3;
        if (bigInteger4 != null && bigInteger4.signum() == -1) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "HoursCannotBeNegative", new Object[]{bigInteger4}));
        }
        this.hours = bigInteger4;
        if (bigInteger5 != null && bigInteger5.signum() == -1) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "MinutesCannotBeNegative", new Object[]{bigInteger5}));
        }
        this.minutes = bigInteger5;
        if (bigDecimal != null && bigDecimal.signum() == -1) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "SecondsCannotBeNegative", new Object[]{bigDecimal}));
        }
        this.seconds = bigDecimal;
    }

    public DurationImpl(long l) {
        boolean bl = false;
        if (l == 0L) {
            this.sign = 0;
            return;
        }
        if (l < 0L) {
            this.sign = -1;
            if (l == Long.MIN_VALUE) {
                ++l;
                bl = true;
            }
            l *= -1L;
        } else {
            this.sign = 1;
        }
        this.years = null;
        this.months = null;
        long l2 = l / 86400000L;
        this.days = BigInteger.valueOf(l2);
        l -= l2 * 86400000L;
        l2 = l / 3600000L;
        this.hours = BigInteger.valueOf(l2);
        l -= l2 * 3600000L;
        l2 = l / 60000L;
        this.minutes = BigInteger.valueOf(l2);
        this.seconds = new BigDecimal(String.valueOf((double)(l -= l2 * 60000L) / 1000.0)).add(bl ? ONE : ZERO);
    }

    public DurationImpl(boolean bl, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigDecimal bigDecimal) throws UnsupportedOperationException, IllegalArgumentException {
        if (bigInteger != null && bigInteger.signum() == -1) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "YearsCannotBeNegative", new Object[]{bigInteger}));
        }
        this.years = bigInteger;
        if (bigInteger2 != null && bigInteger2.signum() == -1) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "MonthsCannotBeNegative", new Object[]{bigInteger2}));
        }
        this.months = bigInteger2;
        if (bigInteger3 != null && bigInteger3.signum() == -1) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "DaysCannotBeNegative", new Object[]{bigInteger3}));
        }
        this.days = bigInteger3;
        if (bigInteger4 != null && bigInteger4.signum() == -1) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "HoursCannotBeNegative", new Object[]{bigInteger4}));
        }
        this.hours = bigInteger4;
        if (bigInteger5 != null && bigInteger5.signum() == -1) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "MinutesCannotBeNegative", new Object[]{bigInteger5}));
        }
        this.minutes = bigInteger5;
        if (bigDecimal != null && bigDecimal.signum() == -1) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "SecondsCannotBeNegative", new Object[]{bigDecimal}));
        }
        this.seconds = bigDecimal;
        this.sign = !(bigInteger != null && bigInteger.signum() != 0 || bigInteger2 != null && bigInteger2.signum() != 0 || bigInteger3 != null && bigInteger3.signum() != 0 || bigInteger4 != null && bigInteger4.signum() != 0 || bigInteger5 != null && bigInteger5.signum() != 0 || bigDecimal != null && bigDecimal.signum() != 0) ? 0 : (bl ? 1 : -1);
    }

    public int getSign() {
        return this.sign;
    }

    public Number getField(DatatypeConstants.Field field) throws NullPointerException, IllegalArgumentException {
        if (field == null) {
            throw new NullPointerException(DatatypeMessageFormatter.formatMessage(null, "CannotBeNull", new Object[]{"Field"}));
        }
        if (field == DatatypeConstants.YEARS) {
            return this.years;
        }
        if (field == DatatypeConstants.MONTHS) {
            return this.months;
        }
        if (field == DatatypeConstants.DAYS) {
            return this.days;
        }
        if (field == DatatypeConstants.HOURS) {
            return this.hours;
        }
        if (field == DatatypeConstants.MINUTES) {
            return this.minutes;
        }
        if (field == DatatypeConstants.SECONDS) {
            return this.seconds;
        }
        throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidValue", new Object[]{"field", field}));
    }

    public boolean isSet(DatatypeConstants.Field field) throws NullPointerException, IllegalArgumentException {
        if (field == null) {
            throw new NullPointerException(DatatypeMessageFormatter.formatMessage(null, "CannotBeNull", new Object[]{"Field"}));
        }
        if (field == DatatypeConstants.YEARS) {
            return this.years != null;
        }
        if (field == DatatypeConstants.MONTHS) {
            return this.months != null;
        }
        if (field == DatatypeConstants.DAYS) {
            return this.days != null;
        }
        if (field == DatatypeConstants.HOURS) {
            return this.hours != null;
        }
        if (field == DatatypeConstants.MINUTES) {
            return this.minutes != null;
        }
        if (field == DatatypeConstants.SECONDS) {
            return this.seconds != null;
        }
        throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidValue", new Object[]{"field", field}));
    }

    public Duration add(Duration duration) {
        DurationImpl durationImpl = new DurationImpl();
        return this.addDuration(this, duration, durationImpl);
    }

    public void addTo(Calendar calendar) {
        calendar.add(1, this.sign * this.getYears());
        calendar.add(2, this.sign * this.getMonths());
        calendar.add(5, this.sign * this.getDays());
        calendar.add(10, this.sign * this.getHours());
        calendar.add(12, this.sign * this.getMinutes());
        calendar.add(13, this.sign * this.getSeconds());
        calendar.add(14, this.seconds != null ? (int)((float)this.sign * this.seconds.subtract(this.seconds.setScale(0, 1)).floatValue() * 1000.0f) : 0);
    }

    public Duration multiply(BigDecimal bigDecimal) {
        int n = bigDecimal.signum();
        BigDecimal bigDecimal2 = bigDecimal.abs();
        BigDecimal[] bigDecimalArray = this.createBigDecimalArray();
        BigDecimal[] bigDecimalArray2 = new BigDecimal[6];
        BigDecimal bigDecimal3 = ZERO;
        int n2 = 0;
        while (n2 < 6) {
            BigDecimal bigDecimal4 = bigDecimalArray[n2].multiply(bigDecimal2).add(bigDecimal3.multiply(FIELD_MAXVALUES[n2]));
            bigDecimalArray2[n2] = bigDecimal4.setScale(0, 1);
            bigDecimal3 = bigDecimal4.subtract(bigDecimalArray2[n2]);
            if (bigDecimal3.signum() != 0 && FIELDS[n2] == DatatypeConstants.MONTHS) {
                throw new IllegalStateException();
            }
            ++n2;
        }
        return new DurationImpl(this.sign * n >= 0, this.years != null ? bigDecimalArray2[0].toBigInteger() : (bigDecimalArray2[0].signum() != 0 ? bigDecimalArray2[0].toBigInteger() : null), this.months != null ? bigDecimalArray2[1].toBigInteger() : (bigDecimalArray2[1].signum() != 0 ? bigDecimalArray2[1].toBigInteger() : null), this.days != null ? bigDecimalArray2[2].toBigInteger() : (bigDecimalArray2[2].signum() != 0 ? bigDecimalArray2[2].toBigInteger() : null), this.hours != null ? bigDecimalArray2[3].toBigInteger() : (bigDecimalArray2[3].signum() != 0 ? bigDecimalArray2[3].toBigInteger() : null), this.minutes != null ? bigDecimalArray2[4].toBigInteger() : (bigDecimalArray2[4].signum() != 0 ? bigDecimalArray2[4].toBigInteger() : null), this.seconds != null ? bigDecimalArray2[5] : (bigDecimalArray2[5].signum() != 0 ? bigDecimalArray2[5] : null));
    }

    private BigDecimal[] createBigDecimalArray() {
        BigDecimal[] bigDecimalArray = new BigDecimal[]{this.years != null ? new BigDecimal(this.years) : ZERO, this.months != null ? new BigDecimal(this.months) : ZERO, this.days != null ? new BigDecimal(this.days) : ZERO, this.hours != null ? new BigDecimal(this.hours) : ZERO, this.minutes != null ? new BigDecimal(this.minutes) : ZERO, this.seconds != null ? this.seconds : ZERO};
        return bigDecimalArray;
    }

    public Duration negate() {
        return new DurationImpl(-1 * this.sign, this.years, this.months, this.days, this.hours, this.minutes, this.seconds);
    }

    public Duration normalizeWith(Calendar calendar) {
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.add(1, this.sign * this.getYears());
        calendar2.add(2, this.sign * this.getMonths());
        calendar2.add(5, this.sign * this.getDays());
        long l = calendar2.getTime().getTime() - calendar.getTime().getTime();
        int n = (int)(l / 86400000L);
        int n2 = 1;
        if (n == 0 && this.hours.signum() == 0 && this.minutes.signum() == 0 && this.seconds.signum() == 0) {
            n2 = 0;
        } else if (n < 0) {
            n2 = -1;
        }
        return new DurationImpl(n2, null, null, BigInteger.valueOf(n).abs(), this.hours, this.minutes, this.seconds);
    }

    public int compare(Duration duration) {
        return this.compareDates(this, duration);
    }

    public int hashCode() {
        GregorianCalendar gregorianCalendar = SAVED_CAL[0].toGregorianCalendar();
        this.addTo(gregorianCalendar);
        return (int)gregorianCalendar.getTime().getTime();
    }

    private void parse(String string, QName qName) throws IllegalArgumentException {
        char c;
        int n = string.length();
        int n2 = 0;
        if ((c = string.charAt(n2++)) != 'P' && c != '-') {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "ParseDuration1", new Object[]{string}));
        }
        int n3 = this.sign = c == '-' ? -1 : 1;
        if (c == '-' && string.charAt(n2++) != 'P') {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "ParseDuration2", new Object[]{string}));
        }
        boolean bl = false;
        int n4 = DateTimeUtil.indexOf(string, n2, n, 'T');
        if (n4 == -1) {
            n4 = n;
        } else if (qName == DatatypeConstants.DURATION_YEARMONTH) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidYearMonthDuration", new Object[]{string}));
        }
        int n5 = DateTimeUtil.indexOf(string, n2, n4, 'Y');
        if (n5 != -1) {
            if (qName == DatatypeConstants.DURATION_DAYTIME) {
                throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDayTimeDuration", new Object[]{string}));
            }
            try {
                this.years = new BigInteger(string.substring(n2, n5));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(numberFormatException.getMessage());
            }
            if (this.years.signum() == -1) {
                throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "YearsCannotBeNegative", new Object[]{string}));
            }
            n2 = n5 + 1;
            bl = true;
        }
        if ((n5 = DateTimeUtil.indexOf(string, n2, n4, 'M')) != -1) {
            if (qName == DatatypeConstants.DURATION_DAYTIME) {
                throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDayTimeDuration", new Object[]{string}));
            }
            try {
                this.months = new BigInteger(string.substring(n2, n5));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(numberFormatException.getMessage());
            }
            if (this.months.signum() == -1) {
                throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "MonthsCannotBeNegative", new Object[]{string}));
            }
            n2 = n5 + 1;
            bl = true;
        }
        if ((n5 = DateTimeUtil.indexOf(string, n2, n4, 'D')) != -1) {
            if (qName == DatatypeConstants.DURATION_YEARMONTH) {
                throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidYearMonthDuration", new Object[]{string}));
            }
            try {
                this.days = new BigInteger(string.substring(n2, n5));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(numberFormatException.getMessage());
            }
            if (this.days.signum() == -1) {
                throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "DaysCannotBeNegative", new Object[]{string}));
            }
            n2 = n5 + 1;
            bl = true;
        }
        if (n == n4 && n2 != n) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "IllegalLexicalValue", new Object[]{string}));
        }
        if (n != n4) {
            if ((n5 = DateTimeUtil.indexOf(string, ++n2, n, 'H')) != -1) {
                try {
                    this.hours = new BigInteger(string.substring(n2, n5));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException(numberFormatException.getMessage());
                }
                if (this.hours.signum() == -1) {
                    throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "HoursCannotBeNegative", new Object[]{string}));
                }
                n2 = n5 + 1;
                bl = true;
            }
            if ((n5 = DateTimeUtil.indexOf(string, n2, n, 'M')) != -1) {
                try {
                    this.minutes = new BigInteger(string.substring(n2, n5));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException(numberFormatException.getMessage());
                }
                if (this.minutes.signum() == -1) {
                    throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "MinutesCannotBeNegative", new Object[]{string}));
                }
                n2 = n5 + 1;
                bl = true;
            }
            if ((n5 = DateTimeUtil.indexOf(string, n2, n, 'S')) != -1) {
                try {
                    this.seconds = new BigDecimal(string.substring(n2, n5));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException(numberFormatException.getMessage());
                }
                if (this.seconds.signum() == -1) {
                    throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "SecondsCannotBeNegative", new Object[]{string}));
                }
                n2 = n5 + 1;
                bl = true;
            }
            if (n2 != n || string.charAt(--n2) == 'T') {
                throw new IllegalArgumentException();
            }
        }
        if (!bl) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "IllegalLexicalValue", new Object[]{string}));
        }
        if (!(this.years != null && this.years.signum() != 0 || this.months != null && this.months.signum() != 0 || this.days != null && this.days.signum() != 0 || this.hours != null && this.hours.signum() != 0 || this.minutes != null && this.minutes.signum() != 0 || this.seconds != null && this.seconds.signum() != 0)) {
            this.sign = 0;
        }
    }

    private DurationImpl addDuration(DurationImpl durationImpl, Duration duration, DurationImpl durationImpl2) throws IllegalStateException {
        boolean bl;
        BigInteger bigInteger;
        BigInteger bigInteger2;
        Number number;
        Number number2;
        BigInteger bigInteger3;
        this.reset(durationImpl2);
        int n = 0;
        int n2 = durationImpl.sign;
        int n3 = duration.getSign();
        BigInteger bigInteger4 = null;
        if (durationImpl.months != null || duration.isSet(DatatypeConstants.MONTHS)) {
            bigInteger3 = (BigInteger)duration.getField(DatatypeConstants.MONTHS);
            bigInteger4 = (durationImpl.months != null ? (n2 == -1 ? durationImpl.months.negate() : durationImpl.months) : I_ZERO).add(bigInteger3 != null ? (n3 == -1 ? bigInteger3.negate() : bigInteger3) : I_ZERO);
        }
        bigInteger3 = null;
        if (durationImpl.years != null || duration.isSet(DatatypeConstants.YEARS)) {
            number2 = (BigInteger)duration.getField(DatatypeConstants.YEARS);
            bigInteger3 = (durationImpl.years != null ? (n2 == -1 ? durationImpl.years.negate() : durationImpl.years) : I_ZERO).add((BigInteger)(number2 != null ? (n3 == -1 ? ((BigInteger)number2).negate() : number2) : I_ZERO));
        }
        number2 = null;
        if (durationImpl.seconds != null || duration.isSet(DatatypeConstants.SECONDS)) {
            number = (BigDecimal)duration.getField(DatatypeConstants.SECONDS);
            number2 = (durationImpl.seconds != null ? (n2 == -1 ? durationImpl.seconds.negate() : durationImpl.seconds) : ZERO).add((BigDecimal)(number != null ? (n3 == -1 ? ((BigDecimal)number).negate() : number) : ZERO));
        }
        number = null;
        if (durationImpl.minutes != null || duration.isSet(DatatypeConstants.MINUTES)) {
            bigInteger2 = (BigInteger)duration.getField(DatatypeConstants.MINUTES);
            number = (durationImpl.minutes != null ? (n2 == -1 ? durationImpl.minutes.negate() : durationImpl.minutes) : I_ZERO).add(bigInteger2 != null ? (n3 == -1 ? bigInteger2.negate() : bigInteger2) : I_ZERO);
        }
        bigInteger2 = null;
        if (durationImpl.hours != null || duration.isSet(DatatypeConstants.HOURS)) {
            bigInteger = (BigInteger)duration.getField(DatatypeConstants.HOURS);
            bigInteger2 = (durationImpl.hours != null ? (n2 == -1 ? durationImpl.hours.negate() : durationImpl.hours) : I_ZERO).add(bigInteger != null ? (n3 == -1 ? bigInteger.negate() : bigInteger) : I_ZERO);
        }
        bigInteger = null;
        if (durationImpl.days != null || duration.isSet(DatatypeConstants.DAYS)) {
            BigInteger bigInteger5 = (BigInteger)duration.getField(DatatypeConstants.DAYS);
            bigInteger = (durationImpl.days != null ? (n2 == -1 ? durationImpl.days.negate() : durationImpl.days) : I_ZERO).add(bigInteger5 != null ? (n3 == -1 ? bigInteger5.negate() : bigInteger5) : I_ZERO);
        }
        do {
            int n4;
            bl = false;
            int n5 = n4 = bigInteger3 != null && bigInteger3.signum() != 0 ? bigInteger.signum() : 0;
            if (bigInteger4 != null) {
                if (n4 > 0 && bigInteger4.signum() == -1) {
                    bl = true;
                    while (bigInteger4.signum() == -1) {
                        bigInteger3 = bigInteger3 != null ? bigInteger3.subtract(I_ONE) : I_ONE.negate();
                        bigInteger4 = bigInteger4.add(TWELVE);
                    }
                } else if (n4 < 0 && bigInteger4.compareTo(I_ZERO) == 1) {
                    bl = true;
                    while (bigInteger4.compareTo(I_ZERO) == 1) {
                        bigInteger3 = bigInteger3 != null ? bigInteger3.add(I_ONE) : I_ONE;
                        bigInteger4 = bigInteger4.subtract(TWELVE);
                    }
                }
                if (bigInteger4.signum() != 0) {
                    n4 = bigInteger4.signum();
                }
            }
            if (bigInteger != null && bigInteger.signum() != 0) {
                n4 = bigInteger.signum();
            }
            if (bigInteger2 != null) {
                if (n4 > 0 && bigInteger2.signum() == -1) {
                    bl = true;
                    while (bigInteger2.signum() == -1) {
                        bigInteger = bigInteger != null ? bigInteger.subtract(I_ONE) : I_ONE.negate();
                        bigInteger2 = bigInteger2.add(TWENTY_FOUR);
                    }
                } else if (n4 < 0 && bigInteger2.compareTo(I_ZERO) == 1) {
                    bl = true;
                    while (bigInteger2.compareTo(I_ZERO) == 1) {
                        bigInteger = bigInteger != null ? bigInteger.add(I_ONE) : I_ONE;
                        bigInteger2 = bigInteger2.subtract(TWENTY_FOUR);
                    }
                }
                if (bigInteger2.signum() != 0) {
                    n4 = bigInteger2.signum();
                }
            }
            if (number != null) {
                if (n4 > 0 && ((BigInteger)number).signum() == -1) {
                    bl = true;
                    while (((BigInteger)number).signum() == -1) {
                        bigInteger2 = bigInteger2 != null ? bigInteger2.subtract(I_ONE) : I_ONE.negate();
                        number = ((BigInteger)number).add(I_SIXTY);
                    }
                } else if (n4 < 0 && ((BigInteger)number).compareTo(I_ZERO) == 1) {
                    bl = true;
                    while (((BigInteger)number).compareTo(I_ZERO) == 1) {
                        bigInteger2 = bigInteger2.add(I_ONE);
                        number = ((BigInteger)number).subtract(I_SIXTY);
                    }
                }
                if (((BigInteger)number).signum() != 0) {
                    n4 = ((BigInteger)number).signum();
                }
            }
            if (number2 == null) continue;
            if (n4 > 0 && ((BigDecimal)number2).compareTo(ZERO) == -1) {
                bl = true;
                while (((BigDecimal)number2).compareTo(ZERO) == -1) {
                    number = number != null ? ((BigInteger)number).subtract(I_ONE) : I_ONE.negate();
                    number2 = ((BigDecimal)number2).add(SIXTY);
                }
            } else if (n4 < 0 && ((BigDecimal)number2).compareTo(ZERO) == 1) {
                bl = true;
                while (((BigDecimal)number2).compareTo(ZERO) == 1) {
                    number = ((BigInteger)number).add(I_ONE);
                    number2 = ((BigDecimal)number2).subtract(SIXTY);
                }
            }
            if (((BigDecimal)number2).signum() == 0) continue;
            n4 = ((BigDecimal)number2).signum();
        } while (bl);
        if (bigInteger3 != null && bigInteger3.signum() == 1 || bigInteger4 != null && bigInteger4.signum() == 1 || bigInteger != null && bigInteger.signum() == 1 || bigInteger2 != null && bigInteger2.signum() == 1 || number != null && ((BigInteger)number).signum() == 1 || number2 != null && ((BigDecimal)number2).signum() == 1) {
            if (bigInteger3 != null && bigInteger3.signum() == -1 || bigInteger4 != null && bigInteger4.signum() == -1 || bigInteger != null && bigInteger.signum() == -1 || bigInteger2 != null && bigInteger2.signum() == -1 || number != null && ((BigInteger)number).signum() == -1 || number2 != null && ((BigDecimal)number2).signum() == -1) {
                throw new IllegalStateException();
            }
            n = 1;
        } else if (bigInteger3 != null && bigInteger3.signum() == -1 || bigInteger4 != null && bigInteger4.signum() == -1 || bigInteger != null && bigInteger.signum() == -1 || bigInteger2 != null && bigInteger2.signum() == -1 || number != null && ((BigInteger)number).signum() == -1 || number2 != null && ((BigDecimal)number2).signum() == -1) {
            n = -1;
        }
        durationImpl2.sign = n;
        durationImpl2.years = bigInteger3 != null ? bigInteger3.abs() : null;
        durationImpl2.months = bigInteger4 != null ? bigInteger4.abs() : null;
        durationImpl2.days = bigInteger != null ? bigInteger.abs() : null;
        durationImpl2.hours = this.hours != null ? bigInteger2.abs() : null;
        durationImpl2.minutes = this.minutes != null ? ((BigInteger)number).abs() : null;
        durationImpl2.seconds = number2 != null ? ((BigDecimal)number2).abs() : null;
        return durationImpl2;
    }

    private void reset(DurationImpl durationImpl) {
        durationImpl.years = null;
        durationImpl.months = null;
        durationImpl.days = null;
        durationImpl.hours = null;
        durationImpl.minutes = null;
        durationImpl.seconds = null;
        durationImpl.sign = 0;
    }

    private int compareDates(DurationImpl durationImpl, Duration duration) {
        int n = 2;
        int n2 = 2;
        n = this.compareOrder(durationImpl, duration);
        if (n == 0) {
            return 0;
        }
        XMLGregorianCalendar xMLGregorianCalendar = (XMLGregorianCalendar)SAVED_CAL[0].clone();
        XMLGregorianCalendar xMLGregorianCalendar2 = (XMLGregorianCalendar)SAVED_CAL[0].clone();
        xMLGregorianCalendar.add(durationImpl);
        xMLGregorianCalendar2.add(duration);
        n = xMLGregorianCalendar.compare(xMLGregorianCalendar2);
        if (n == 2) {
            return 2;
        }
        xMLGregorianCalendar = (XMLGregorianCalendar)SAVED_CAL[1].clone();
        xMLGregorianCalendar2 = (XMLGregorianCalendar)SAVED_CAL[1].clone();
        xMLGregorianCalendar.add(durationImpl);
        xMLGregorianCalendar2.add(duration);
        n2 = xMLGregorianCalendar.compare(xMLGregorianCalendar2);
        n = this.compareResults(n, n2);
        if (n == 2) {
            return 2;
        }
        xMLGregorianCalendar = (XMLGregorianCalendar)SAVED_CAL[2].clone();
        xMLGregorianCalendar2 = (XMLGregorianCalendar)SAVED_CAL[2].clone();
        xMLGregorianCalendar.add(durationImpl);
        xMLGregorianCalendar2.add(duration);
        n2 = xMLGregorianCalendar.compare(xMLGregorianCalendar2);
        n = this.compareResults(n, n2);
        if (n == 2) {
            return 2;
        }
        xMLGregorianCalendar = (XMLGregorianCalendar)SAVED_CAL[3].clone();
        xMLGregorianCalendar2 = (XMLGregorianCalendar)SAVED_CAL[3].clone();
        xMLGregorianCalendar.add(durationImpl);
        xMLGregorianCalendar2.add(duration);
        n2 = xMLGregorianCalendar.compare(xMLGregorianCalendar2);
        n = this.compareResults(n, n2);
        return n;
    }

    private int compareResults(int n, int n2) {
        if (n2 == 2) {
            return 2;
        }
        if (n != n2) {
            return 2;
        }
        return n;
    }

    private int compareOrder(Duration duration, Duration duration2) {
        BigDecimal bigDecimal;
        boolean bl = true;
        int n = duration.getSign();
        int n2 = duration2.getSign();
        if (n == 0 && n2 == 0) {
            return 0;
        }
        if (n == -1 && n2 == -1) {
            bl = false;
        } else {
            if (n == 1 && n2 == -1) {
                return 1;
            }
            if (n == -1 && n2 == 1) {
                return -1;
            }
        }
        BigInteger bigInteger = duration.isSet(DatatypeConstants.YEARS) ? (BigInteger)duration.getField(DatatypeConstants.YEARS) : I_ZERO;
        BigInteger bigInteger2 = duration2.isSet(DatatypeConstants.YEARS) ? (BigInteger)duration2.getField(DatatypeConstants.YEARS) : I_ZERO;
        int n3 = bigInteger.compareTo(bigInteger2);
        if (n3 == -1) {
            return bl ? -1 : 1;
        }
        if (n3 == 1) {
            return bl ? 1 : -1;
        }
        bigInteger = duration.isSet(DatatypeConstants.MONTHS) ? (BigInteger)duration.getField(DatatypeConstants.MONTHS) : I_ZERO;
        n3 = bigInteger.compareTo(bigInteger2 = duration2.isSet(DatatypeConstants.MONTHS) ? (BigInteger)duration2.getField(DatatypeConstants.MONTHS) : I_ZERO);
        if (n3 == -1) {
            return bl ? -1 : 1;
        }
        if (n3 == 1) {
            return bl ? 1 : -1;
        }
        bigInteger = duration.isSet(DatatypeConstants.DAYS) ? (BigInteger)duration.getField(DatatypeConstants.DAYS) : I_ZERO;
        n3 = bigInteger.compareTo(bigInteger2 = duration2.isSet(DatatypeConstants.DAYS) ? (BigInteger)duration2.getField(DatatypeConstants.DAYS) : I_ZERO);
        if (n3 == -1) {
            return bl ? -1 : 1;
        }
        if (n3 == 1) {
            return bl ? 1 : -1;
        }
        bigInteger = duration.isSet(DatatypeConstants.HOURS) ? (BigInteger)duration.getField(DatatypeConstants.HOURS) : I_ZERO;
        n3 = bigInteger.compareTo(bigInteger2 = duration2.isSet(DatatypeConstants.HOURS) ? (BigInteger)duration2.getField(DatatypeConstants.HOURS) : I_ZERO);
        if (n3 == -1) {
            return bl ? -1 : 1;
        }
        if (n3 == 1) {
            return bl ? 1 : -1;
        }
        bigInteger = duration.isSet(DatatypeConstants.MINUTES) ? (BigInteger)duration.getField(DatatypeConstants.MINUTES) : I_ZERO;
        n3 = bigInteger.compareTo(bigInteger2 = duration2.isSet(DatatypeConstants.MINUTES) ? (BigInteger)duration2.getField(DatatypeConstants.MINUTES) : I_ZERO);
        if (n3 == -1) {
            return bl ? -1 : 1;
        }
        if (n3 == 1) {
            return bl ? 1 : -1;
        }
        BigDecimal bigDecimal2 = duration.isSet(DatatypeConstants.SECONDS) ? (BigDecimal)duration.getField(DatatypeConstants.SECONDS) : ZERO;
        n3 = bigDecimal2.compareTo(bigDecimal = duration2.isSet(DatatypeConstants.SECONDS) ? (BigDecimal)duration2.getField(DatatypeConstants.SECONDS) : ZERO);
        if (n3 == -1) {
            return bl ? -1 : 1;
        }
        if (n3 == 1) {
            return bl ? 1 : -1;
        }
        return 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(30);
        if (this.sign == -1) {
            stringBuffer.append('-');
        }
        stringBuffer.append('P');
        if (this.years != null) {
            stringBuffer.append(this.years);
            stringBuffer.append('Y');
        }
        if (this.months != null) {
            stringBuffer.append(this.months);
            stringBuffer.append('M');
        }
        if (this.days != null) {
            stringBuffer.append(this.days);
            stringBuffer.append('D');
        }
        if (this.hours != null || this.minutes != null || this.seconds != null) {
            stringBuffer.append('T');
            if (this.hours != null) {
                stringBuffer.append(this.hours);
                stringBuffer.append('H');
            }
            if (this.minutes != null) {
                stringBuffer.append(this.minutes);
                stringBuffer.append('M');
            }
            if (this.seconds != null) {
                stringBuffer.append(this.toString(this.seconds));
                stringBuffer.append('S');
            }
        }
        return stringBuffer.toString();
    }

    private String toString(BigDecimal bigDecimal) {
        StringBuffer stringBuffer;
        String string = bigDecimal.unscaledValue().toString();
        int n = bigDecimal.scale();
        if (n == 0) {
            return string;
        }
        int n2 = string.length() - n;
        if (n2 == 0) {
            return "0." + string;
        }
        if (n2 > 0) {
            stringBuffer = new StringBuffer(string);
            stringBuffer.insert(n2, '.');
        } else {
            stringBuffer = new StringBuffer(3 - n2 + string.length());
            stringBuffer.append("0.");
            int n3 = 0;
            while (n3 < -n2) {
                stringBuffer.append('0');
                ++n3;
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

