/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.jaxp;

import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import org.apache.xerces.jaxp.DocumentBuilderImpl;
import org.apache.xerces.parsers.DOMParser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class DocumentBuilderFactoryImpl
extends DocumentBuilderFactory {
    private Hashtable attributes;
    private Hashtable features;
    private Schema fSchema = null;
    private boolean fXInclude = false;
    private boolean fSecureProcess = false;
    private boolean doNotSetSchemaLanguageProperty = true;

    public DocumentBuilder newDocumentBuilder() throws ParserConfigurationException {
        if (this.getAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource") != null && this.fSchema != null || this.getAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage") != null && this.fSchema != null) {
            throw new ParserConfigurationException("schemaSource and/or schemaLanguage properties should not be used in conjunction with a Schema object!");
        }
        try {
            return new DocumentBuilderImpl(this, this.attributes, this.fSecureProcess, !this.doNotSetSchemaLanguageProperty);
        }
        catch (SAXException sAXException) {
            throw new ParserConfigurationException(sAXException.getMessage());
        }
    }

    public void setAttribute(String string, Object object) throws IllegalArgumentException {
        if (object == null) {
            if (this.attributes != null) {
                this.attributes.remove(string);
            }
            return;
        }
        if (this.attributes == null) {
            this.attributes = new Hashtable();
        }
        this.attributes.put(string, object);
        try {
            new DocumentBuilderImpl(this, this.attributes, this.doNotSetSchemaLanguageProperty);
        }
        catch (Exception exception) {
            this.attributes.remove(string);
            throw new IllegalArgumentException(exception.getMessage());
        }
    }

    public Object getAttribute(String string) throws IllegalArgumentException {
        DOMParser dOMParser;
        if (this.attributes != null && (dOMParser = (DOMParser)this.attributes.get(string)) != null) {
            return dOMParser;
        }
        dOMParser = null;
        try {
            dOMParser = new DocumentBuilderImpl(this, this.attributes, this.doNotSetSchemaLanguageProperty).getDOMParser();
            return dOMParser.getProperty(string);
        }
        catch (SAXException sAXException) {
            try {
                boolean bl = dOMParser.getFeature(string);
                return bl ? Boolean.TRUE : Boolean.FALSE;
            }
            catch (SAXException sAXException2) {
                throw new IllegalArgumentException(sAXException.getMessage());
            }
        }
    }

    public void setFeature(String string, boolean bl) throws ParserConfigurationException {
        if (string == null) {
            throw new NullPointerException("DocumentBuilderFactory: setFeatures(String name, boolean value) received null name parameter!");
        }
        if (string.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            this.fSecureProcess = bl;
            return;
        }
        if (this.features == null) {
            this.features = new Hashtable();
        }
        Boolean bl2 = new Boolean(bl);
        Object v = this.features.get(string);
        this.features.put(string, bl2);
        try {
            this.setAttribute(string, bl2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (v == null) {
                this.features.remove(string);
            } else {
                this.features.put(string, v);
            }
            throw new ParserConfigurationException(illegalArgumentException.getMessage());
        }
    }

    public boolean getFeature(String string) throws ParserConfigurationException {
        Object v;
        if (string == null) {
            throw new NullPointerException();
        }
        if (string.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            return this.fSecureProcess;
        }
        if (this.features != null && (v = this.features.get(string)) != null) {
            return (Boolean)v;
        }
        try {
            return new DocumentBuilderImpl(this, this.attributes, this.doNotSetSchemaLanguageProperty).getDOMParser().getFeature(string);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            throw new ParserConfigurationException(sAXNotRecognizedException.getMessage());
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            throw new ParserConfigurationException(sAXNotSupportedException.getMessage());
        }
    }

    public Schema getSchema() {
        return this.fSchema;
    }

    public void setSchema(Schema schema) {
        this.fSchema = schema;
    }

    public void setXIncludeAware(boolean bl) {
        this.fXInclude = bl;
    }

    public boolean isXIncludeAware() {
        return this.fXInclude;
    }
}

