/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.b2b.util.entity;

import com.ibm.xml.b2b.util.ByteArrayStringBuffer;
import com.ibm.xml.b2b.util.EncodingSupport;
import com.ibm.xml.b2b.util.XMLString;
import com.ibm.xml.b2b.util.XMLStringBuffer;
import com.ibm.xml.b2b.util.entity.ByteArrayParsedEntity;
import com.ibm.xml.b2b.util.entity.EntityInputSource;
import com.ibm.xml.b2b.util.entity.ParsedEntity;
import com.ibm.xml.b2b.util.entity.ParsedEntityFactory;
import com.ibm.xml.b2b.util.entity.ParsedEntityRecognizer;
import java.io.InputStream;
import java.io.Reader;

public final class ByteArrayParsedEntityFactory
extends ParsedEntityRecognizer
implements ParsedEntityFactory {
    private static final int FREE_ENTITY_COUNT = 8;
    private int fFreeEntityCount;
    private ParsedEntity[] fFreeEntities = new ParsedEntity[8];
    private ParsedEntity fEntityContent;
    private EntityInputSource fStringSource;

    public ByteArrayParsedEntityFactory(boolean bl) {
        super(bl);
    }

    public void reset(boolean bl) {
        super.reset(bl);
        if (!bl) {
            while (this.fFreeEntityCount > 0) {
                --this.fFreeEntityCount;
                this.fFreeEntities[this.fFreeEntityCount] = null;
            }
            if (this.fStringSource != null) {
                this.fStringSource = null;
            }
        }
    }

    public ParsedEntity createParsedEntity(EntityInputSource entityInputSource, boolean bl) {
        this.fEntityContent = this.fFreeEntityCount > 0 ? this.fFreeEntities[--this.fFreeEntityCount] : new ByteArrayParsedEntity(this);
        this.fEntityContent.clear();
        if (!super.setSource(entityInputSource, bl, true)) {
            return null;
        }
        return this.fEntityContent;
    }

    public ParsedEntity createParsedEntity(XMLString xMLString) {
        if (this.fStringSource == null) {
            this.fStringSource = new EntityInputSource();
        }
        this.fStringSource.setContent(xMLString);
        this.fEntityContent = this.fFreeEntityCount > 0 ? this.fFreeEntities[--this.fFreeEntityCount] : new ByteArrayParsedEntity(this);
        this.fEntityContent.clear();
        if (!super.setSource(this.fStringSource, false, false)) {
            return null;
        }
        return this.fEntityContent;
    }

    public void releaseParsedEntity(ParsedEntity parsedEntity) {
        super.releaseBytes(parsedEntity.bytes);
        if (this.fFreeEntityCount < 8) {
            this.fFreeEntities[this.fFreeEntityCount++] = parsedEntity;
        }
    }

    public XMLStringBuffer createStringBuffer() {
        return new ByteArrayStringBuffer();
    }

    protected XMLString getEntityContent() {
        return this.fEntityContent;
    }

    protected boolean setCharacterStreamSource(Reader reader) {
        return super.convertCharacterStreamToUTF8(reader);
    }

    protected boolean setByteStreamSource(InputStream inputStream, EncodingSupport encodingSupport) {
        if (encodingSupport.isASCIITransparent()) {
            return super.readByteStream(inputStream, encodingSupport, true);
        }
        return super.convertByteStreamToUTF8(inputStream, encodingSupport, true);
    }

    protected boolean setByteArraySource(byte[] byArray, int n, int n2, EncodingSupport encodingSupport) {
        if (encodingSupport.isASCIITransparent()) {
            this.fEntityContent.setValues(byArray, n, n2, encodingSupport);
            return true;
        }
        return super.convertBytesToUTF8(byArray, n, n2, encodingSupport);
    }

    protected boolean setCharArraySource(char[] cArray, int n, int n2) {
        return super.convertCharactersToUTF8(cArray, n, n2);
    }

    protected boolean setStringSource(String string) {
        return super.convertStringToUTF8(string);
    }

    protected boolean readUTF8ByteStream(InputStream inputStream, EncodingSupport encodingSupport) {
        return super.readByteStream(inputStream, encodingSupport, false);
    }

    protected boolean readUCSByteStreamWithBOM(InputStream inputStream, EncodingSupport encodingSupport) {
        return super.convertByteStreamToUTF8(inputStream, encodingSupport, false);
    }

    protected boolean readLatinByteStream(InputStream inputStream, EncodingSupport encodingSupport) {
        if (encodingSupport.isASCIITransparent()) {
            return super.readByteStream(inputStream, encodingSupport, false);
        }
        return super.convertByteStreamToUTF8(inputStream, encodingSupport, false);
    }

    protected boolean readEBCDICByteStream(InputStream inputStream, EncodingSupport encodingSupport) {
        return super.convertByteStreamToUTF8(inputStream, encodingSupport, false);
    }

    protected boolean readUCSByteStream(InputStream inputStream, EncodingSupport encodingSupport) {
        return super.convertByteStreamToUTF8(inputStream, encodingSupport, true);
    }

    protected boolean readCharacterStream(Reader reader) {
        return super.convertCharacterStreamToUTF8(reader);
    }
}

