/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdDSA;
import com.ibm.security.x509.X509Key;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.interfaces.DSAParams;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;

final class DSAPublicKey
extends X509Key
implements java.security.interfaces.DSAPublicKey,
Serializable {
    static final long serialVersionUID = -2034453286688059956L;
    private BigInteger y;
    private static String[] z;

    public DSAPublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) throws InvalidKeyException {
        this.y = bigInteger;
        this.algid = new AlgIdDSA(bigInteger2, bigInteger3, bigInteger4);
        try {
            this.key = new DerValue(2, bigInteger.toByteArray()).toByteArray();
            this.encode();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[1] + iOException.getMessage());
        }
    }

    public DSAPublicKey(byte[] byArray) throws InvalidKeyException {
        this.decode(byArray);
    }

    public BigInteger getY() {
        return this.y;
    }

    public DSAParams getParams() {
        try {
            if (this.algid instanceof DSAParams) {
                return (DSAParams)this.algid;
            }
            AlgorithmParameters algorithmParameters = this.algid.getAlgParameters();
            if (algorithmParameters == null) {
                return null;
            }
            DSAParameterSpec dSAParameterSpec = algorithmParameters.getParameterSpec(DSAParameterSpec.class);
            return dSAParameterSpec;
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            return null;
        }
    }

    protected void parseKeyBits() throws InvalidKeyException {
        try {
            DerInputStream derInputStream = new DerInputStream(this.key);
            this.y = derInputStream.getInteger();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[2] + iOException.getMessage());
        }
    }

    public String toString() {
        return z[0] + this.y.toString() + "\n";
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block29: {
            int n2;
            int n3;
            block28: {
                char[] cArray2;
                Object var0;
                block27: {
                    int n4;
                    block26: {
                        char[] cArray3;
                        block25: {
                            int n5;
                            block24: {
                                stringArray = new String[3];
                                var0 = null;
                                char[] cArray4 = "\u001e\u0016\u0013\u0002D\u0012t\u001a\u001bFw\u0004+*k>7~\u0003b.nT".toCharArray();
                                cArray3 = cArray4;
                                n5 = cArray4.length;
                                n3 = 0;
                                if (!true) break block24;
                                n5 = n5;
                                if (n5 <= n3) break block25;
                            }
                            do {
                                int n6;
                                cArray3 = cArray3;
                                int n7 = n3;
                                char c2 = cArray3[n7];
                                switch (n3 % 5) {
                                    case 0: {
                                        n6 = 87;
                                        break;
                                    }
                                    case 1: {
                                        n6 = 84;
                                        break;
                                    }
                                    case 2: {
                                        n6 = 94;
                                        break;
                                    }
                                    case 3: {
                                        n6 = 72;
                                        break;
                                    }
                                    default: {
                                        n6 = 7;
                                    }
                                }
                                cArray3[n7] = (char)(c2 ^ n6);
                                ++n3;
                                n5 = n5;
                            } while (n5 > n3);
                        }
                        stringArray[0] = new String(cArray3).intern();
                        var0 = null;
                        char[] cArray5 = "4;+,'9;*hC\u0012\u0006~-i4;:-'.n~".toCharArray();
                        cArray2 = cArray5;
                        n4 = cArray5.length;
                        n3 = 0;
                        if (!true) break block26;
                        n4 = n4;
                        if (n4 <= n3) break block27;
                    }
                    do {
                        int n8;
                        cArray2 = cArray2;
                        int n9 = n3;
                        char c3 = cArray2[n9];
                        switch (n3 % 5) {
                            case 0: {
                                n8 = 87;
                                break;
                            }
                            case 1: {
                                n8 = 84;
                                break;
                            }
                            case 2: {
                                n8 = 94;
                                break;
                            }
                            case 3: {
                                n8 = 72;
                                break;
                            }
                            default: {
                                n8 = 7;
                            }
                        }
                        cArray2[n9] = (char)(c3 ^ n8);
                        ++n3;
                        n4 = n4;
                    } while (n4 > n3);
                }
                stringArray[1] = new String(cArray2).intern();
                var0 = null;
                char[] cArray6 = "\u001e:()k>0~#b.n~1'!52=b]".toCharArray();
                cArray = cArray6;
                n2 = cArray6.length;
                n3 = 0;
                if (!true) break block28;
                n2 = n2;
                if (n2 <= n3) break block29;
            }
            do {
                int n10;
                cArray = cArray;
                int n11 = n3;
                char c4 = cArray[n11];
                switch (n3 % 5) {
                    case 0: {
                        n10 = 87;
                        break;
                    }
                    case 1: {
                        n10 = 84;
                        break;
                    }
                    case 2: {
                        n10 = 94;
                        break;
                    }
                    case 3: {
                        n10 = 72;
                        break;
                    }
                    default: {
                        n10 = 7;
                    }
                }
                cArray[n11] = (char)(c4 ^ n10);
                ++n3;
                n2 = n2;
            } while (n2 > n3);
        }
        stringArray[2] = new String(cArray).intern();
        z = stringArray;
    }
}

