/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.jnl;

import com.sun.deploy.config.Config;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.deploy.util.URLUtil;
import com.sun.deploy.xml.BadTokenException;
import com.sun.deploy.xml.XMLEncoding;
import com.sun.deploy.xml.XMLNode;
import com.sun.deploy.xml.XMLParser;
import com.sun.javaws.Globals;
import com.sun.javaws.exceptions.BadFieldException;
import com.sun.javaws.exceptions.JNLParseException;
import com.sun.javaws.exceptions.MissingFieldException;
import com.sun.javaws.jnl.AppletDesc;
import com.sun.javaws.jnl.ApplicationDesc;
import com.sun.javaws.jnl.AssociationDesc;
import com.sun.javaws.jnl.ExtDownloadDesc;
import com.sun.javaws.jnl.ExtensionDesc;
import com.sun.javaws.jnl.IconDesc;
import com.sun.javaws.jnl.InformationDesc;
import com.sun.javaws.jnl.InstallerDesc;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.JREDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.jnl.LibraryDesc;
import com.sun.javaws.jnl.PackageDesc;
import com.sun.javaws.jnl.PropertyDesc;
import com.sun.javaws.jnl.RContentDesc;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.jnl.ShortcutDesc;
import com.sun.javaws.jnl.XMLUtils;
import com.sun.javaws.util.GeneralUtil;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;

public class XMLFormat {
    public static LaunchDesc parse(byte[] byArray) throws IOException, BadFieldException, MissingFieldException, JNLParseException {
        int n;
        XMLNode xMLNode;
        String string;
        try {
            string = XMLEncoding.decodeXML((byte[])byArray);
        }
        catch (Exception exception) {
            throw new JNLParseException(null, exception, "exception determining encoding of jnlp file", 0);
        }
        try {
            xMLNode = new XMLParser(string).parse();
        }
        catch (BadTokenException badTokenException) {
            throw new JNLParseException(string, (Exception)((Object)badTokenException), "wrong kind of token found", badTokenException.getLine());
        }
        catch (Exception exception) {
            throw new JNLParseException(string, exception, "exception parsing jnlp file", 0);
        }
        InformationDesc informationDesc = null;
        ResourcesDesc resourcesDesc = null;
        ApplicationDesc applicationDesc = null;
        AppletDesc appletDesc = null;
        LibraryDesc libraryDesc = null;
        InstallerDesc installerDesc = null;
        String string2 = null;
        if (xMLNode.getName().equals("player") || xMLNode.getName().equals("viewer")) {
            String string3 = XMLUtils.getAttribute(xMLNode, null, "tab");
            return LaunchDescFactory.buildInternalLaunchDesc(xMLNode.getName(), string, string3);
        }
        if (!xMLNode.getName().equals("jnlp")) {
            throw new MissingFieldException(string, "<jnlp>");
        }
        String string4 = XMLUtils.getAttribute(xMLNode, "", "spec", "1.0+");
        String string5 = XMLUtils.getAttribute(xMLNode, "", "version");
        URL uRL = URLUtil.asPathURL((URL)XMLUtils.getAttributeURL(string, xMLNode, "", "codebase"));
        URL uRL2 = XMLUtils.getAttributeURL(string, uRL, xMLNode, "", "href");
        int n2 = 0;
        if (XMLUtils.isElementPath(xMLNode, "<security><all-permissions>")) {
            n2 = 1;
        } else if (XMLUtils.isElementPath(xMLNode, "<security><j2ee-application-client-permissions>")) {
            n2 = 2;
        }
        if (XMLUtils.isElementPath(xMLNode, "<application-desc>")) {
            n = 1;
            applicationDesc = XMLFormat.buildApplicationDesc(string, xMLNode);
        } else if (XMLUtils.isElementPath(xMLNode, "<component-desc>")) {
            n = 3;
            libraryDesc = XMLFormat.buildLibraryDesc(string, xMLNode);
        } else if (XMLUtils.isElementPath(xMLNode, "<installer-desc>")) {
            n = 4;
            installerDesc = XMLFormat.buildInstallerDesc(string, uRL, xMLNode);
        } else if (XMLUtils.isElementPath(xMLNode, "<applet-desc>")) {
            n = 2;
            appletDesc = XMLFormat.buildAppletDesc(string, uRL, xMLNode);
        } else {
            throw new MissingFieldException(string, "<jnlp>(<application-desc>|<applet-desc>|<installer-desc>|<component-desc>)");
        }
        informationDesc = XMLFormat.buildInformationDesc(string, uRL, xMLNode);
        resourcesDesc = XMLFormat.buildResourcesDesc(string, uRL, xMLNode, false);
        LaunchDesc launchDesc = new LaunchDesc(string4, uRL, uRL2, string5, informationDesc, n2, resourcesDesc, n, applicationDesc, appletDesc, libraryDesc, installerDesc, string2, string, byArray);
        Trace.println((String)("returning LaunchDesc from XMLFormat.parse():\n" + launchDesc), (TraceLevel)TraceLevel.TEMP);
        return launchDesc;
    }

    private static InformationDesc combineInformationDesc(InformationDesc informationDesc, InformationDesc informationDesc2) {
        if (informationDesc == null) {
            return informationDesc2;
        }
        if (informationDesc2 == null) {
            return informationDesc;
        }
        String string = informationDesc.getTitle() != null ? informationDesc.getTitle() : informationDesc2.getTitle();
        String string2 = informationDesc.getVendor() != null ? informationDesc.getVendor() : informationDesc2.getVendor();
        URL uRL = informationDesc.getHome() != null ? informationDesc.getHome() : informationDesc2.getHome();
        String[] stringArray = new String[4];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = informationDesc.getDescription(i) != null ? informationDesc.getDescription(i) : informationDesc2.getDescription(i);
        }
        ArrayList<IconDesc> arrayList = new ArrayList<IconDesc>();
        if (informationDesc2.getIcons() != null) {
            arrayList.addAll(Arrays.asList(informationDesc2.getIcons()));
        }
        if (informationDesc.getIcons() != null) {
            arrayList.addAll(Arrays.asList(informationDesc.getIcons()));
        }
        IconDesc[] iconDescArray = new IconDesc[arrayList.size()];
        iconDescArray = arrayList.toArray(iconDescArray);
        boolean bl = informationDesc.supportsOfflineOperation() || informationDesc2.supportsOfflineOperation();
        ShortcutDesc shortcutDesc = informationDesc.getShortcut() != null ? informationDesc.getShortcut() : informationDesc2.getShortcut();
        AssociationDesc[] associationDescArray = (AssociationDesc[])XMLFormat.addArrays(informationDesc.getAssociations(), informationDesc2.getAssociations());
        RContentDesc[] rContentDescArray = (RContentDesc[])XMLFormat.addArrays(informationDesc.getRelatedContent(), informationDesc2.getRelatedContent());
        return new InformationDesc(string, string2, uRL, stringArray, iconDescArray, shortcutDesc, rContentDescArray, associationDescArray, bl);
    }

    private static InformationDesc buildInformationDesc(final String string, final URL uRL, XMLNode xMLNode) throws MissingFieldException, BadFieldException {
        final ArrayList arrayList = new ArrayList();
        XMLUtils.visitElements(xMLNode, "<information>", new XMLUtils.ElementVisitor(){

            public void visitElement(XMLNode xMLNode) throws BadFieldException, MissingFieldException {
                String[] stringArray = GeneralUtil.getStringList(XMLUtils.getAttribute(xMLNode, "", "locale"));
                String[] stringArray2 = GeneralUtil.getStringList(XMLUtils.getAttribute(xMLNode, "", "os", null));
                String[] stringArray3 = GeneralUtil.getStringList(XMLUtils.getAttribute(xMLNode, "", "arch", null));
                String[] stringArray4 = GeneralUtil.getStringList(XMLUtils.getAttribute(xMLNode, "", "locale", null));
                String[] stringArray5 = GeneralUtil.getStringList(XMLUtils.getAttribute(xMLNode, "", "platform", null));
                if (GeneralUtil.prefixMatchStringList(stringArray2, Config.getOSName()) && GeneralUtil.prefixMatchStringList(stringArray3, Config.getOSArch()) && GeneralUtil.prefixMatchStringList(stringArray5, Config.getOSPlatform()) && XMLFormat.matchDefaultLocale(stringArray4)) {
                    String string3 = XMLUtils.getElementContents(xMLNode, "<title>");
                    String string2 = XMLUtils.getElementContents(xMLNode, "<vendor>");
                    URL uRL2 = XMLUtils.getAttributeURL(string, uRL, xMLNode, "<homepage>", "href");
                    String[] stringArray6 = new String[4];
                    stringArray6[0] = XMLUtils.getElementContentsWithAttribute(xMLNode, "<description>", "kind", "", null);
                    stringArray6[2] = XMLUtils.getElementContentsWithAttribute(xMLNode, "<description>", "kind", "one-line", null);
                    stringArray6[1] = XMLUtils.getElementContentsWithAttribute(xMLNode, "<description>", "kind", "short", null);
                    stringArray6[3] = XMLUtils.getElementContentsWithAttribute(xMLNode, "<description>", "kind", "tooltip", null);
                    IconDesc[] iconDescArray = XMLFormat.getIconDescs(string, uRL, xMLNode);
                    ShortcutDesc shortcutDesc = XMLFormat.getShortcutDesc(xMLNode);
                    RContentDesc[] rContentDescArray = XMLFormat.getRContentDescs(string, uRL, xMLNode);
                    AssociationDesc[] associationDescArray = XMLFormat.getAssociationDesc(string, xMLNode);
                    arrayList.add(new InformationDesc(string3, string2, uRL2, stringArray6, iconDescArray, shortcutDesc, rContentDescArray, associationDescArray, XMLUtils.isElementPath(xMLNode, "<offline-allowed>")));
                }
            }
        });
        InformationDesc informationDesc = new InformationDesc(null, null, null, null, null, null, null, null, false);
        for (int i = 0; i < arrayList.size(); ++i) {
            InformationDesc informationDesc2 = (InformationDesc)arrayList.get(i);
            informationDesc = XMLFormat.combineInformationDesc(informationDesc2, informationDesc);
        }
        if (informationDesc.getTitle() == null) {
            throw new MissingFieldException(string, "<jnlp><information><title>");
        }
        if (informationDesc.getVendor() == null) {
            throw new MissingFieldException(string, "<jnlp><information><vendor>");
        }
        return informationDesc;
    }

    private static Object[] addArrays(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == null) {
            return objectArray2;
        }
        if (objectArray2 == null) {
            return objectArray;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < objectArray.length) {
            arrayList.add(objectArray[n++]);
        }
        n = 0;
        while (n < objectArray2.length) {
            arrayList.add(objectArray2[n++]);
        }
        return arrayList.toArray(objectArray);
    }

    public static boolean matchDefaultLocale(String[] stringArray) {
        return GeneralUtil.matchLocale(stringArray, Globals.getDefaultLocale());
    }

    static final ResourcesDesc buildResourcesDesc(final String string, final URL uRL, XMLNode xMLNode, final boolean bl) throws MissingFieldException, BadFieldException {
        final ResourcesDesc resourcesDesc = new ResourcesDesc();
        XMLUtils.visitElements(xMLNode, "<resources>", new XMLUtils.ElementVisitor(){

            public void visitElement(XMLNode xMLNode) throws MissingFieldException, BadFieldException {
                String[] stringArray = GeneralUtil.getStringList(XMLUtils.getAttribute(xMLNode, "", "os", null));
                String[] stringArray2 = GeneralUtil.getStringList(XMLUtils.getAttribute(xMLNode, "", "arch", null));
                String[] stringArray3 = GeneralUtil.getStringList(XMLUtils.getAttribute(xMLNode, "", "locale", null));
                if (GeneralUtil.prefixMatchStringList(stringArray, Config.getOSName()) && GeneralUtil.prefixMatchStringList(stringArray2, Config.getOSArch()) && XMLFormat.matchDefaultLocale(stringArray3)) {
                    XMLUtils.visitChildrenElements(xMLNode, new XMLUtils.ElementVisitor(){

                        public void visitElement(XMLNode xMLNode) throws MissingFieldException, BadFieldException {
                            XMLFormat.handleResourceElement(string, uRL, xMLNode, resourcesDesc, bl);
                        }
                    });
                }
            }
        });
        return resourcesDesc.isEmpty() ? null : resourcesDesc;
    }

    private static IconDesc[] getIconDescs(final String string, final URL uRL, XMLNode xMLNode) throws MissingFieldException, BadFieldException {
        final ArrayList arrayList = new ArrayList();
        XMLUtils.visitElements(xMLNode, "<icon>", new XMLUtils.ElementVisitor(){

            public void visitElement(XMLNode xMLNode) throws MissingFieldException, BadFieldException {
                String string3 = XMLUtils.getAttribute(xMLNode, "", "kind", "");
                URL uRL2 = XMLUtils.getRequiredURL(string, uRL, xMLNode, "", "href");
                String string2 = XMLUtils.getAttribute(xMLNode, "", "version", null);
                int n = XMLUtils.getIntAttribute(string, xMLNode, "", "height", 0);
                int n2 = XMLUtils.getIntAttribute(string, xMLNode, "", "width", 0);
                int n3 = XMLUtils.getIntAttribute(string, xMLNode, "", "depth", 0);
                int n4 = 0;
                if (string3.equals("selected")) {
                    n4 = 1;
                } else if (string3.equals("disabled")) {
                    n4 = 2;
                } else if (string3.equals("rollover")) {
                    n4 = 3;
                } else if (string3.equals("splash")) {
                    n4 = 4;
                }
                arrayList.add(new IconDesc(uRL2, string2, n, n2, n3, n4));
            }
        });
        return arrayList.toArray(new IconDesc[arrayList.size()]);
    }

    private static ShortcutDesc getShortcutDesc(XMLNode xMLNode) throws MissingFieldException, BadFieldException {
        final ArrayList arrayList = new ArrayList();
        XMLUtils.visitElements(xMLNode, "<shortcut>", new XMLUtils.ElementVisitor(){

            public void visitElement(XMLNode xMLNode) throws MissingFieldException, BadFieldException {
                String string = XMLUtils.getAttribute(xMLNode, "", "online", "true");
                boolean bl = string.equalsIgnoreCase("true");
                boolean bl2 = XMLUtils.isElementPath(xMLNode, "<desktop>");
                boolean bl3 = XMLUtils.isElementPath(xMLNode, "<menu>");
                String string2 = XMLUtils.getAttribute(xMLNode, "<menu>", "submenu");
                arrayList.add(new ShortcutDesc(bl, bl2, bl3, string2));
            }
        });
        if (arrayList.size() > 0) {
            return (ShortcutDesc)arrayList.get(0);
        }
        return null;
    }

    private static AssociationDesc[] getAssociationDesc(final String string, XMLNode xMLNode) throws MissingFieldException, BadFieldException {
        final ArrayList arrayList = new ArrayList();
        XMLUtils.visitElements(xMLNode, "<association>", new XMLUtils.ElementVisitor(){

            public void visitElement(XMLNode xMLNode) throws MissingFieldException, BadFieldException {
                String string3 = XMLUtils.getRequiredAttribute(string, xMLNode, "", "extensions");
                String string2 = XMLUtils.getRequiredAttribute(string, xMLNode, "", "mime-type");
                arrayList.add(new AssociationDesc(string3, string2));
            }
        });
        return arrayList.toArray(new AssociationDesc[arrayList.size()]);
    }

    private static RContentDesc[] getRContentDescs(final String string, final URL uRL, XMLNode xMLNode) throws MissingFieldException, BadFieldException {
        final ArrayList arrayList = new ArrayList();
        XMLUtils.visitElements(xMLNode, "<related-content>", new XMLUtils.ElementVisitor(){

            public void visitElement(XMLNode xMLNode) throws MissingFieldException, BadFieldException {
                URL uRL3 = XMLUtils.getRequiredURL(string, uRL, xMLNode, "", "href");
                String string3 = XMLUtils.getElementContents(xMLNode, "<title>");
                String string2 = XMLUtils.getElementContents(xMLNode, "<description>");
                URL uRL2 = XMLUtils.getAttributeURL(string, uRL, xMLNode, "<icon>", "href");
                arrayList.add(new RContentDesc(uRL3, string3, string2, uRL2));
            }
        });
        return arrayList.toArray(new RContentDesc[arrayList.size()]);
    }

    private static void handleResourceElement(String string, URL uRL, XMLNode xMLNode, ResourcesDesc resourcesDesc, boolean bl) throws MissingFieldException, BadFieldException {
        String string2 = xMLNode.getName();
        if (string2.equals("jar") || string2.equals("nativelib")) {
            URL uRL2 = XMLUtils.getRequiredURL(string, uRL, xMLNode, "", "href");
            String string3 = XMLUtils.getAttribute(xMLNode, "", "version", null);
            String string4 = XMLUtils.getAttribute(xMLNode, "", "download");
            String string5 = XMLUtils.getAttribute(xMLNode, "", "main");
            String string6 = XMLUtils.getAttribute(xMLNode, "", "part");
            int n = XMLUtils.getIntAttribute(string, xMLNode, "", "size", 0);
            boolean bl2 = string2.equals("nativelib");
            boolean bl3 = false;
            boolean bl4 = false;
            if ("lazy".equalsIgnoreCase(string4)) {
                bl3 = true;
            }
            if ("true".equalsIgnoreCase(string5)) {
                bl4 = true;
            }
            JARDesc jARDesc = new JARDesc(uRL2, string3, bl3, bl4, bl2, string6, n, resourcesDesc);
            resourcesDesc.addResource(jARDesc);
        } else if (string2.equals("property")) {
            String string7 = XMLUtils.getRequiredAttribute(string, xMLNode, "", "name");
            String string8 = XMLUtils.getRequiredAttributeEmptyOK(string, xMLNode, "", "value");
            resourcesDesc.addResource(new PropertyDesc(string7, string8));
        } else if (string2.equals("package")) {
            String string9 = XMLUtils.getRequiredAttribute(string, xMLNode, "", "name");
            String string10 = XMLUtils.getRequiredAttribute(string, xMLNode, "", "part");
            String string11 = XMLUtils.getAttribute(xMLNode, "", "recursive", "false");
            boolean bl5 = "true".equals(string11);
            resourcesDesc.addResource(new PackageDesc(string9, string10, bl5));
        } else if (string2.equals("extension")) {
            String string12 = XMLUtils.getAttribute(xMLNode, "", "name");
            URL uRL3 = XMLUtils.getRequiredURL(string, uRL, xMLNode, "", "href");
            String string13 = XMLUtils.getAttribute(xMLNode, "", "version", null);
            ExtDownloadDesc[] extDownloadDescArray = XMLFormat.getExtDownloadDescs(string, xMLNode);
            resourcesDesc.addResource(new ExtensionDesc(string12, uRL3, string13, extDownloadDescArray));
        } else if (string2.equals("j2se") && !bl) {
            String string14 = XMLUtils.getRequiredAttribute(string, xMLNode, "", "version");
            URL uRL4 = XMLUtils.getAttributeURL(string, uRL, xMLNode, "", "href");
            String string15 = XMLUtils.getAttribute(xMLNode, "", "initial-heap-size");
            String string16 = XMLUtils.getAttribute(xMLNode, "", "max-heap-size");
            String string17 = XMLUtils.getAttribute(xMLNode, "", "java-vm-args");
            long l = -1L;
            long l2 = -1L;
            l = GeneralUtil.heapValToLong(string15);
            l2 = GeneralUtil.heapValToLong(string16);
            ResourcesDesc resourcesDesc2 = XMLFormat.buildResourcesDesc(string, uRL, xMLNode, true);
            JREDesc jREDesc = new JREDesc(string14, l, l2, string17, uRL4, resourcesDesc2);
            resourcesDesc.addResource(jREDesc);
        }
    }

    private static ExtDownloadDesc[] getExtDownloadDescs(final String string, XMLNode xMLNode) throws BadFieldException, MissingFieldException {
        final ArrayList arrayList = new ArrayList();
        XMLUtils.visitElements(xMLNode, "<ext-download>", new XMLUtils.ElementVisitor(){

            public void visitElement(XMLNode xMLNode) throws MissingFieldException {
                String string4 = XMLUtils.getRequiredAttribute(string, xMLNode, "", "ext-part");
                String string2 = XMLUtils.getAttribute(xMLNode, "", "part");
                String string3 = XMLUtils.getAttribute(xMLNode, "", "download", "eager");
                boolean bl = "lazy".equals(string3);
                arrayList.add(new ExtDownloadDesc(string4, string2, bl));
            }
        });
        ExtDownloadDesc[] extDownloadDescArray = new ExtDownloadDesc[arrayList.size()];
        return arrayList.toArray(extDownloadDescArray);
    }

    private static ApplicationDesc buildApplicationDesc(final String string, XMLNode xMLNode) throws MissingFieldException, BadFieldException {
        String string2 = XMLUtils.getAttribute(xMLNode, "<application-desc>", "main-class");
        final ArrayList arrayList = new ArrayList();
        XMLUtils.visitElements(xMLNode, "<application-desc><argument>", new XMLUtils.ElementVisitor(){

            public void visitElement(XMLNode xMLNode) throws MissingFieldException, BadFieldException {
                String string2 = XMLUtils.getElementContents(xMLNode, "", null);
                if (string2 == null) {
                    throw new BadFieldException(string, XMLUtils.getPathString(xMLNode), "");
                }
                arrayList.add(string2);
            }
        });
        String[] stringArray = new String[arrayList.size()];
        stringArray = arrayList.toArray(stringArray);
        return new ApplicationDesc(string2, stringArray);
    }

    private static LibraryDesc buildLibraryDesc(String string, XMLNode xMLNode) throws MissingFieldException, BadFieldException {
        String string2 = XMLUtils.getAttribute(xMLNode, "<component-desc>", "unique-id");
        return new LibraryDesc(string2);
    }

    private static InstallerDesc buildInstallerDesc(String string, URL uRL, XMLNode xMLNode) throws MissingFieldException, BadFieldException {
        String string2 = XMLUtils.getAttribute(xMLNode, "<installer-desc>", "main-class");
        return new InstallerDesc(string2);
    }

    private static AppletDesc buildAppletDesc(final String string, URL uRL, XMLNode xMLNode) throws MissingFieldException, BadFieldException {
        String string2 = XMLUtils.getRequiredAttribute(string, xMLNode, "<applet-desc>", "main-class");
        String string3 = XMLUtils.getRequiredAttribute(string, xMLNode, "<applet-desc>", "name");
        URL uRL2 = XMLUtils.getAttributeURL(string, uRL, xMLNode, "<applet-desc>", "documentbase");
        int n = XMLUtils.getRequiredIntAttribute(string, xMLNode, "<applet-desc>", "width");
        int n2 = XMLUtils.getRequiredIntAttribute(string, xMLNode, "<applet-desc>", "height");
        if (n <= 0) {
            throw new BadFieldException(string, XMLUtils.getPathString(xMLNode) + "<applet-desc>width", new Integer(n).toString());
        }
        if (n2 <= 0) {
            throw new BadFieldException(string, XMLUtils.getPathString(xMLNode) + "<applet-desc>height", new Integer(n2).toString());
        }
        final Properties properties = new Properties();
        XMLUtils.visitElements(xMLNode, "<applet-desc><param>", new XMLUtils.ElementVisitor(){

            public void visitElement(XMLNode xMLNode) throws MissingFieldException, BadFieldException {
                String string3 = XMLUtils.getRequiredAttribute(string, xMLNode, "", "name");
                String string2 = XMLUtils.getRequiredAttributeEmptyOK(string, xMLNode, "", "value");
                properties.setProperty(string3, string2);
            }
        });
        return new AppletDesc(string3, string2, uRL2, n, n2, properties);
    }
}

