/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.jras.pdjlog.jlog.mgr;

import com.tivoli.pd.jras.pdjlog.jlog.IConstants;
import com.tivoli.pd.jras.pdjlog.jlog.LogIOException;
import com.tivoli.pd.jras.pdjlog.jlog.LogUtil;
import com.tivoli.pd.jras.pdjlog.jlog.MessageCatalog;
import com.tivoli.pd.jras.pdjlog.jlog.mgr.BaseGroup;
import com.tivoli.pd.jras.pdjlog.jlog.mgr.Config;
import com.tivoli.pd.jras.pdjlog.jlog.mgr.DataStore;
import com.tivoli.pd.jras.pdjlog.jlog.mgr.Group;
import com.tivoli.pd.jras.pdjlog.jlog.mgr.LogManager;
import com.tivoli.pd.jutil.o;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;

public class PropertyDataStore
extends DataStore
implements IConstants {
    private final String d = "$Id: @(#)73  1.2 src/com/tivoli/pd/jras/pdjlog/jlog/mgr/PropertyDataStore.java, pd.jras, am600, 050110a 04/02/23 17:57:29 @(#) $";
    private static final String e = "(C) Copyright IBM Corp. 1998.";
    private Properties f;

    public PropertyDataStore(Properties properties) {
        this.setPropertyDataStore(properties);
    }

    public PropertyDataStore(String string) throws LogIOException {
        this(new Properties());
        try {
            this.setPropertyDataStore(this.loadProperties(string));
        }
        catch (Exception exception) {
            throw new LogIOException(LogUtil.getLogMessage("ERR_PROP_IO", string));
        }
    }

    public Properties getPropertyDataStore() {
        return this.f;
    }

    public void setPropertyDataStore(Properties properties) {
        this.f = properties;
    }

    public BaseGroup restoreConfig() throws LogIOException {
        int n2 = LogManager.i;
        BaseGroup baseGroup = new BaseGroup();
        this.a("loggers", baseGroup);
        this.a("handlers", baseGroup);
        this.a("formatters", baseGroup);
        this.a("filters", baseGroup);
        this.a(baseGroup);
        String string = this.f.getProperty("defaultMessageLogger");
        if (string != null) {
            baseGroup.setDefaultMessageLogger(string);
        }
        if ((string = this.f.getProperty("defaultTraceLogger")) != null) {
            baseGroup.setDefaultTraceLogger(string);
        }
        if (n2 != 0) {
            o.h = !o.h;
        }
        return baseGroup;
    }

    public void saveConfig(BaseGroup baseGroup) throws LogIOException {
    }

    private void a(String string, BaseGroup baseGroup) throws LogIOException {
        block8: {
            int n2 = LogManager.i;
            String string2 = this.f.getProperty(string);
            if (string2 == null) break block8;
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            while (stringTokenizer.hasMoreElements()) {
                block9: {
                    String string3 = stringTokenizer.nextToken();
                    if (string3 == null) break block9;
                    string3 = "/" + string3.replace('.', '/') + ".properties";
                    try {
                        Group group;
                        Config config;
                        block11: {
                            String string4;
                            block10: {
                                config = new Config(this.loadProperties(string3));
                                string4 = config.getProperty("group");
                                if (string4 != null && !string4.equals("")) break block10;
                                group = baseGroup;
                                if (n2 == 0) break block11;
                            }
                            if ((group = baseGroup.getGroup(string4)) == null) {
                                group = new Group(string4);
                                baseGroup.addGroup(group);
                            }
                        }
                        group.addConfig(config);
                    }
                    catch (IOException iOException) {
                        throw new LogIOException(LogUtil.getLogMessage("ERR_PROP_IO", string3));
                    }
                    catch (NullPointerException nullPointerException) {
                        throw new LogIOException(LogUtil.getLogMessage("ERR_PROP_NOT_FOUND", string3));
                    }
                }
                if (n2 == 0) continue;
            }
        }
    }

    public Properties loadProperties(String string) throws IOException {
        Properties properties = new Properties();
        ClassLoader classLoader = MessageCatalog.getClassLoader();
        BufferedInputStream bufferedInputStream = classLoader == null ? new BufferedInputStream(this.getClass().getResourceAsStream(string)) : new BufferedInputStream(classLoader.getClass().getResourceAsStream(string));
        properties.load(bufferedInputStream);
        bufferedInputStream.close();
        return properties;
    }

    protected void a(BaseGroup baseGroup) {
        this.a(baseGroup, baseGroup);
        Enumeration enumeration = baseGroup.getGroups();
        while (enumeration.hasMoreElements()) {
            Group group = (Group)enumeration.nextElement();
            this.a(group, baseGroup);
        }
    }

    private void a(Group group, BaseGroup baseGroup) {
        Enumeration enumeration = group.getConfigs();
        while (enumeration.hasMoreElements()) {
            Config config = (Config)enumeration.nextElement();
            String string = (String)config.get("parent");
            if (string == null) continue;
            Config config2 = group.getConfig(string);
            if (config2 == null) {
                config2 = baseGroup.getConfig(string);
            }
            if (config2 != null) {
                config.setParent(config2);
                continue;
            }
            LogUtil.errorMsg(LogUtil.getLogMessage("ERR_MISSING_PARENT", (String)config.get("name"), string));
        }
    }
}

