/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.jras.pdjlog.jlog;

import com.tivoli.pd.jras.pdjlog.jlog.FileHandler;
import com.tivoli.pd.jras.pdjlog.jlog.IFormatter;
import com.tivoli.pd.jras.pdjlog.jlog.ILogRecord;
import com.tivoli.pd.jras.pdjlog.jlog.LogObject;
import com.tivoli.pd.jras.pdjlog.jlog.LogUtil;
import com.tivoli.pd.jras.pdjlog.jlog.NestedException;
import java.io.File;
import java.io.FilenameFilter;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class MultiFileHandler
extends FileHandler {
    private final String R = "$Id: @(#)54  1.2 src/com/tivoli/pd/jras/pdjlog/jlog/MultiFileHandler.java, pd.jras, am600, 050110a 04/02/23 17:57:31 @(#) $";
    private static final String S = "(C) Copyright IBM Corp. 1999.";
    static final long serialVersionUID = -4264888327332730757L;
    public static final int DEFAULT_FILES = 3;
    public static final int DEFAULT_FILE_SIZE = 512;
    protected transient long T;
    private int U;
    private long V;
    protected String W;
    protected String X;
    protected String Y;

    public MultiFileHandler() {
    }

    public MultiFileHandler(String string) {
        super(string);
    }

    public MultiFileHandler(String string, String string2) {
        super(string, string2);
    }

    public MultiFileHandler(String string, String string2, String string3) {
        super(string, string2, string3);
    }

    public MultiFileHandler(String string, String string2, String string3, String string4) {
        super(string, string2, string3, string4);
    }

    public void init() {
        super.init();
        this.T = 0L;
        this.setMaxFiles(3);
        this.setMaxFileSize(512);
        this.W = null;
        this.X = null;
        this.Y = null;
    }

    public Properties getConfig() {
        Properties properties = super.getConfig();
        properties.put("maxFiles", new Integer(this.getMaxFiles()).toString());
        properties.put("maxFileSize", new Integer(this.getMaxFileSize()).toString());
        return properties;
    }

    public void setConfig(Properties properties) {
        super.setConfig(properties);
        String string = properties.getProperty("maxFiles");
        if (string != null) {
            this.setMaxFiles(new Integer(string));
        }
        if ((string = properties.getProperty("maxFileSize")) != null) {
            this.setMaxFileSize(new Integer(string));
        }
    }

    public void setFileName(String string) throws AccessControlException {
        block2: {
            block3: {
                if (string == null) break block2;
                super.setFileName(string);
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) break block3;
                this.d();
                if (!LogObject.j) break block2;
            }
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    MultiFileHandler.this.d();
                    return null;
                }
            });
        }
    }

    private void d() {
        block7: {
            int n2;
            String string;
            block6: {
                String string2 = this.getFileName();
                string = new File(string2).getAbsolutePath();
                File file = new File(string);
                this.X = file.getParent();
                if (this.X != null && !this.X.endsWith(File.separator)) {
                    this.X = this.X + File.separator;
                }
                if ((n2 = (string = file.getName()).lastIndexOf(46)) != -1) break block6;
                this.W = string;
                if (!LogObject.j) break block7;
            }
            this.W = string.substring(0, n2);
            this.Y = string.substring(n2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.X != null) {
            stringBuffer.append(this.X);
        }
        stringBuffer.append(this.W + "1");
        if (this.Y != null) {
            stringBuffer.append(this.Y);
        }
        this.P = stringBuffer.toString();
    }

    public String getNumberedFileName(int n2) {
        String string;
        block5: {
            block4: {
                if (this.getFileName() != null && n2 >= 1 && n2 <= this.getMaxFiles()) break block4;
                string = null;
                if (!LogObject.j) break block5;
            }
            string = this.X + this.W + n2;
            if (this.Y != null) {
                string = string + this.Y;
            }
        }
        return string;
    }

    public int getMaxFiles() {
        return this.U;
    }

    public void setMaxFiles(int n2) {
        if (n2 >= 0) {
            this.U = n2;
        }
    }

    public int getMaxFileSize() {
        return (int)(this.V / 1024L);
    }

    public void setMaxFileSize(int n2) {
        if (n2 > 0) {
            this.V = n2 * 1024;
        }
    }

    protected void b() throws NestedException {
        if (!this.u || this.T >= this.V) {
            this.closeDevice();
            if (this.T >= this.V) {
                Vector vector = this.a(this.X);
                vector = this.b(vector, this.X);
                this.a(vector, this.X);
            }
            super.b();
            this.T = new File(this.getFileName()).length();
        }
    }

    protected Vector a(String string) {
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                boolean bl2;
                block5: {
                    bl2 = false;
                    int n2 = MultiFileHandler.this.getMaxFiles();
                    try {
                        int n3;
                        int n4 = MultiFileHandler.this.W.length();
                        if (MultiFileHandler.this.Y == null) {
                            if (!string.startsWith(MultiFileHandler.this.W) || (n3 = Integer.parseInt(string.substring(n4))) < 1 || n2 != 0 && n3 > n2) break block5;
                            bl2 = true;
                            if (!LogObject.j) break block5;
                        }
                        if (string.startsWith(MultiFileHandler.this.W) && string.endsWith(MultiFileHandler.this.Y) && (n3 = Integer.parseInt(string.substring(n4, string.indexOf(MultiFileHandler.this.Y)))) >= 1 && (n2 == 0 || n3 <= n2)) {
                            bl2 = true;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                return bl2;
            }
        };
        Vector<String> vector = new Vector<String>();
        String[] stringArray = file.list(filenameFilter);
        if (stringArray != null) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                vector.addElement(stringArray[i2]);
                if (!LogObject.j) continue;
            }
        }
        return this.a(vector);
    }

    protected void a(Vector vector, String string) {
        boolean bl2 = LogObject.j;
        int n2 = vector.size() + 1;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string2;
            String string3;
            block4: {
                block3: {
                    string3 = (String)enumeration.nextElement();
                    if (this.Y != null) break block3;
                    string2 = this.W + n2;
                    if (!bl2) break block4;
                }
                string2 = this.W + n2 + this.Y;
            }
            File file = new File(string + string3);
            File file2 = new File(string + string2);
            file.renameTo(file2);
            --n2;
            if (!bl2) continue;
        }
    }

    protected Vector a(Vector vector) {
        boolean bl2 = LogObject.j;
        int n2 = this.W.length();
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            String string = (String)vector.elementAt(i2);
            for (int i3 = i2 + 1; i3 < vector.size(); ++i3) {
                int n3;
                int n4;
                String string2;
                block5: {
                    block4: {
                        string2 = (String)vector.elementAt(i3);
                        if (this.Y != null) break block4;
                        n4 = Integer.parseInt(string.substring(n2));
                        n3 = Integer.parseInt(string2.substring(n2));
                        if (!bl2) break block5;
                    }
                    n4 = Integer.parseInt(string.substring(n2, string.indexOf(this.Y)));
                    n3 = Integer.parseInt(string2.substring(n2, string2.indexOf(this.Y)));
                }
                if (n4 >= n3) continue;
                vector.setElementAt(string2, i2);
                vector.setElementAt(string, i3);
                string = string2;
                if (!bl2) continue;
            }
            if (!bl2) continue;
        }
        return vector;
    }

    protected Vector b(Vector vector, String string) {
        int n2 = this.getMaxFiles();
        if (n2 > 0) {
            while (vector.size() >= n2) {
                File file = new File(string + (String)vector.firstElement());
                file.delete();
                vector.removeElement(vector.firstElement());
                if (!LogObject.j) continue;
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void b(ILogRecord iLogRecord) throws NestedException {
        this.openDevice();
        Object object = this.D;
        synchronized (object) {
            IFormatter iFormatter;
            if (this.u && (iFormatter = this.e(iLogRecord)) != null) {
                String string = iFormatter.format(iLogRecord);
                this.T += (long)string.length();
                this.H.println(string);
                if (this.H.checkError()) {
                    this.closeDevice();
                    throw new NestedException(LogUtil.getLogMessage("ERR_WRITE_MSG", this.getName()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteLog() throws AccessControlException {
        block6: {
            Object object = this.D;
            synchronized (object) {
                block5: {
                    this.closeDevice();
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) break block5;
                    this.e();
                    if (!LogObject.j) break block6;
                }
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        MultiFileHandler.this.e();
                        return null;
                    }
                });
            }
        }
    }

    private void e() {
        if (this.getFileName() != null) {
            Enumeration enumeration = this.a(this.X).elements();
            while (enumeration.hasMoreElements()) {
                File file = new File(this.X + (String)enumeration.nextElement());
                if (file.exists() && !file.delete()) {
                    LogUtil.errorMsg(LogUtil.getLogMessage("ERR_DELETE_FILE", file.getName()));
                }
                if (!LogObject.j) continue;
            }
        }
    }

    public String toString() {
        String string = super.toString();
        return string + ", files=" + this.getMaxFiles() + ", fileSize=" + this.getMaxFileSize();
    }
}

