/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;

class TimeCmd
implements Command {
    TimeCmd() {
    }

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length < 2 || argv.length > 3) {
            throw new TclNumArgsException(interp, 1, argv, "script ?count?");
        }
        int count = argv.length == 2 ? 1 : TclInteger.get(interp, argv[2]);
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < count; ++i) {
            interp.eval(argv[1], 0);
        }
        long endTime = System.currentTimeMillis();
        int uSecs = (int)((endTime - startTime) * 1000L / (long)count);
        if (uSecs == 1) {
            interp.setResult(TclString.newInstance("1 microsecond per iteration"));
        } else {
            interp.setResult(TclString.newInstance(uSecs + " microseconds per iteration"));
        }
    }
}

