/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclObject;
import tcl.lang.Util;

public class TclBoolean
implements InternalRep {
    private boolean value;

    private TclBoolean(boolean b) {
        this.value = b;
    }

    private TclBoolean(Interp interp, String str) throws TclException {
        this.value = Util.getBoolean(interp, str);
    }

    public InternalRep duplicate() {
        return new TclBoolean(this.value);
    }

    public void dispose() {
    }

    public String toString() {
        if (this.value) {
            return "1";
        }
        return "0";
    }

    public static TclObject newInstance(boolean b) {
        return new TclObject(new TclBoolean(b));
    }

    private static void setBooleanFromAny(Interp interp, TclObject tobj) throws TclException {
        InternalRep rep = tobj.getInternalRep();
        if (!(rep instanceof TclBoolean)) {
            if (rep instanceof TclInteger) {
                int i = TclInteger.get(interp, tobj);
                tobj.setInternalRep(new TclBoolean(i != 0));
            } else {
                tobj.setInternalRep(new TclBoolean(interp, tobj.toString()));
            }
        }
    }

    public static boolean get(Interp interp, TclObject tobj) throws TclException {
        TclBoolean.setBooleanFromAny(interp, tobj);
        TclBoolean tbool = (TclBoolean)tobj.getInternalRep();
        return tbool.value;
    }
}

