/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.StrtodResult;
import tcl.lang.StrtoulResult;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.Util;

class ScanCmd
implements Command {
    ScanCmd() {
    }

    /*
     * Enabled aggressive block sorting
     */
    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length < 3) {
            throw new TclNumArgsException(interp, 1, argv, "string format ?varName varName ...?");
        }
        char[] scanArr = argv[1].toString().toCharArray();
        char[] frmtArr = argv[2].toString().toCharArray();
        int numUnMatched = 0;
        int numMatched = 0;
        int base = 0;
        int width = 0;
        int frmtIndex = 0;
        int scanIndex = 0;
        boolean scanOK = true;
        boolean scanArrDone = false;
        int argIndex = 3;
        frmtIndex = this.skipWhiteSpace(frmtArr, frmtIndex);
        while (true) {
            boolean discardFlag;
            block61: {
                int endIndex;
                int startIndex;
                block58: {
                    char[] tempArr;
                    boolean charMatchFound;
                    int i;
                    StrtoulResult strul;
                    boolean cont;
                    int negateScan;
                    boolean widthFlag;
                    block60: {
                        block59: {
                            if (frmtIndex >= frmtArr.length) break block59;
                            widthFlag = false;
                            discardFlag = false;
                            negateScan = 1;
                            cont = true;
                            if (frmtArr[frmtIndex] == '%') {
                                ScanCmd.checkOverFlow(interp, frmtArr, ++frmtIndex);
                                if (frmtArr[frmtIndex] == '%') {
                                    ++frmtIndex;
                                    ++scanIndex;
                                    continue;
                                }
                                if (frmtArr[frmtIndex] == '*') {
                                    discardFlag = true;
                                    ScanCmd.checkOverFlow(interp, frmtArr, ++frmtIndex);
                                }
                                break block60;
                            } else {
                                if (scanIndex < scanArr.length && scanArr[scanIndex] == frmtArr[frmtIndex]) {
                                    ++scanIndex;
                                    ++frmtIndex;
                                    continue;
                                }
                                ++frmtIndex;
                                continue;
                            }
                        }
                        if (numMatched + numUnMatched != argv.length - 3) {
                            ScanCmd.errorDiffVars(interp);
                        }
                        interp.setResult(TclInteger.newInstance(numMatched));
                        return;
                    }
                    while (cont) {
                        cont = false;
                        switch (frmtArr[frmtIndex]) {
                            case 'L': 
                            case 'h': 
                            case 'l': {
                                ++frmtIndex;
                                cont = true;
                                break;
                            }
                            default: {
                                if (!Character.isDigit(frmtArr[frmtIndex])) break;
                                strul = Util.strtoul(new String(frmtArr), frmtIndex, base);
                                frmtIndex = strul.index;
                                width = (int)strul.value;
                                widthFlag = true;
                                cont = true;
                            }
                        }
                        ScanCmd.checkOverFlow(interp, frmtArr, frmtIndex);
                    }
                    char ch = frmtArr[frmtIndex];
                    if (ch != 'c' && ch != '[' && !scanArrDone) {
                        scanIndex = this.skipWhiteSpace(scanArr, scanIndex);
                    }
                    if (scanIndex >= scanArr.length) {
                        scanArrDone = true;
                    }
                    if (scanIndex < scanArr.length && ch != 'c' && ch != '[') {
                        if (scanArr[scanIndex] == '-') {
                            negateScan = -1;
                            ++scanIndex;
                            --width;
                        } else if (scanArr[scanIndex] == '+') {
                            ++scanIndex;
                            --width;
                        }
                        if (widthFlag && width + scanIndex > scanArr.length) {
                            width = scanArr.length - scanIndex;
                        }
                    }
                    if (scanIndex >= scanArr.length) {
                        scanArrDone = true;
                    }
                    strul = null;
                    StrtodResult strd = null;
                    switch (ch) {
                        case 'd': 
                        case 'o': 
                        case 'x': {
                            if (scanArrDone) break block61;
                            base = ch == 'd' ? 10 : (ch == 'o' ? 8 : 16);
                            strul = widthFlag ? Util.strtoul(new String(scanArr, 0, width + scanIndex), scanIndex, base) : Util.strtoul(new String(scanArr), scanIndex, base);
                            if (strul.errno != 0) {
                                scanOK = false;
                                break block61;
                            } else {
                                scanIndex = strul.index;
                                if (!discardFlag) {
                                    i = (int)strul.value * negateScan;
                                    ScanCmd.testAndSetVar(interp, argv, argIndex++, TclInteger.newInstance(i));
                                }
                            }
                            break block61;
                        }
                        case 'c': {
                            if (widthFlag) {
                                ScanCmd.errorCharFieldWidth(interp);
                            }
                            if (!discardFlag && !scanArrDone) {
                                ScanCmd.testAndSetVar(interp, argv, argIndex++, TclInteger.newInstance(scanArr[scanIndex++]));
                            }
                            break block61;
                        }
                        case 's': {
                            int tempIndex;
                            if (!scanArrDone) {
                                tempIndex = scanIndex;
                                if (!widthFlag) {
                                    width = scanArr.length;
                                }
                                for (i = 0; scanIndex < scanArr.length && i < width && (ch = scanArr[scanIndex]) != ' ' && ch != '\n' && ch != '\r' && ch != '\t' && ch != '\f'; ++scanIndex, ++i) {
                                }
                                if (!discardFlag) {
                                    String str = new String(scanArr, tempIndex, scanIndex - tempIndex);
                                    ScanCmd.testAndSetVar(interp, argv, argIndex++, TclString.newInstance(str));
                                }
                            }
                            break block61;
                        }
                        case 'e': 
                        case 'f': 
                        case 'g': {
                            if (scanArrDone) break block61;
                            strd = widthFlag ? Util.strtod(new String(scanArr, 0, width + scanIndex), scanIndex) : Util.strtod(new String(scanArr), scanIndex);
                            if (strd.errno != 0) {
                                scanOK = false;
                                break block61;
                            } else {
                                scanIndex = strd.index;
                                if (!discardFlag) {
                                    double d = strd.value * (double)negateScan;
                                    ScanCmd.testAndSetVar(interp, argv, argIndex++, TclDouble.newInstance(d));
                                }
                            }
                            break block61;
                        }
                        case '[': {
                            charMatchFound = false;
                            boolean charNotMatch = false;
                            String unmatched = "unmatched [ in format string";
                            if (++frmtIndex >= frmtArr.length) {
                                throw new TclException(interp, unmatched);
                            }
                            if (frmtArr[frmtIndex] == '^') {
                                charNotMatch = true;
                                frmtIndex += 2;
                            } else {
                                ++frmtIndex;
                            }
                            int tempIndex = frmtIndex - 1;
                            if (frmtIndex >= frmtArr.length) {
                                throw new TclException(interp, unmatched);
                            }
                            while (frmtArr[frmtIndex] != ']') {
                                if (++frmtIndex < frmtArr.length) continue;
                                throw new TclException(interp, unmatched);
                            }
                            tempArr = new String(frmtArr, tempIndex, frmtIndex - tempIndex).toCharArray();
                            startIndex = scanIndex;
                            if (charNotMatch) break;
                            charMatchFound = true;
                            while (scanOK && charMatchFound) {
                                if (scanIndex >= scanArr.length) {
                                    scanOK = false;
                                    break block58;
                                } else {
                                    charMatchFound = false;
                                    for (i = 0; i < tempArr.length; ++i) {
                                        if (tempArr[i] != scanArr[scanIndex]) continue;
                                        charMatchFound = true;
                                        break;
                                    }
                                    if (!widthFlag || scanIndex - startIndex < width) {
                                        if (!charMatchFound) continue;
                                        ++scanIndex;
                                        continue;
                                    }
                                }
                                break block58;
                            }
                            break block58;
                        }
                        default: {
                            ScanCmd.errorBadField(interp, ch);
                            break block61;
                        }
                    }
                    while (scanOK && !charMatchFound) {
                        if (scanIndex >= scanArr.length) {
                            scanOK = false;
                            break;
                        }
                        for (i = 0; i < tempArr.length; ++i) {
                            if (tempArr[i] != scanArr[scanIndex]) continue;
                            charMatchFound = true;
                            break;
                        }
                        if (widthFlag && scanIndex - startIndex >= width) break;
                        if (charMatchFound) continue;
                        ++scanIndex;
                    }
                }
                if ((endIndex = scanIndex - startIndex) <= 0) {
                    scanOK = false;
                } else if (!discardFlag) {
                    String str = new String(scanArr, startIndex, endIndex);
                    ScanCmd.testAndSetVar(interp, argv, argIndex++, TclString.newInstance(str));
                }
            }
            if (scanOK && !discardFlag && !scanArrDone) {
                ++numMatched;
            } else if (!(!scanArrDone && scanOK || discardFlag)) {
                ++numUnMatched;
            }
            ++frmtIndex;
        }
    }

    private int skipWhiteSpace(char[] arr, int index) {
        boolean cont;
        do {
            if (index >= arr.length) {
                return index;
            }
            cont = false;
            switch (arr[index]) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    cont = true;
                    ++index;
                }
            }
        } while (cont);
        return index;
    }

    private static void testAndSetVar(Interp interp, TclObject[] argv, int argIndex, TclObject tobj) throws TclException {
        if (argIndex < argv.length) {
            try {
                interp.setVar(argv[argIndex].toString(), tobj, 0);
            }
            catch (TclException e) {
                throw new TclException(interp, "couldn't set variable \"" + argv[argIndex].toString() + "\"");
            }
        } else {
            ScanCmd.errorDiffVars(interp);
        }
    }

    private static final void checkOverFlow(Interp interp, char[] arr, int index) throws TclException {
        if (index >= arr.length || index < 0) {
            throw new TclException(interp, "\"%n$\" argument index out of range");
        }
    }

    private static final void errorDiffVars(Interp interp) throws TclException {
        throw new TclException(interp, "different numbers of variable names and field specifiers");
    }

    private static final void errorBadField(Interp interp, char fieldSpecifier) throws TclException {
        throw new TclException(interp, "bad scan conversion character \"" + fieldSpecifier + "\"");
    }

    private static final void errorCharFieldWidth(Interp interp) throws TclException {
        throw new TclException(interp, "field width may not be specified in %c conversion");
    }
}

