/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import sunlabs.brazil.util.regexp.Regexp;
import sunlabs.brazil.util.regexp.Regsub;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRegexp;
import tcl.lang.TclString;

class RegsubCmd
implements Command {
    private static final String[] validOpts = new String[]{"-all", "-nocase", "--"};
    private static final int OPT_ALL = 0;
    private static final int OPT_NOCASE = 1;
    private static final int OPT_LAST = 2;

    RegsubCmd() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        boolean all = false;
        boolean nocase = false;
        try {
            String result;
            int i = 1;
            block9: while (argv[i].toString().startsWith("-")) {
                int index = TclIndex.get(interp, argv[i], validOpts, "switch", 0);
                ++i;
                switch (index) {
                    case 0: {
                        all = true;
                        break;
                    }
                    case 1: {
                        nocase = true;
                        break;
                    }
                    case 2: {
                        break block9;
                    }
                }
            }
            TclObject exp = argv[i++];
            String string = argv[i++].toString();
            String subSpec = argv[i++].toString();
            String varName = argv[i++].toString();
            if (i != argv.length) {
                throw new IndexOutOfBoundsException();
            }
            Regexp r = TclRegexp.compile(interp, exp, nocase);
            int count = 0;
            if (!all) {
                result = r.sub(string, subSpec);
                if (result == null) {
                    result = string;
                } else {
                    ++count;
                }
            } else {
                StringBuffer sb = new StringBuffer();
                Regsub s = new Regsub(r, string);
                while (s.nextMatch()) {
                    ++count;
                    sb.append(s.skipped());
                    Regexp.applySubspec(s, subSpec, sb);
                }
                sb.append(s.rest());
                result = sb.toString();
            }
            TclObject obj = TclString.newInstance(result);
            try {
                interp.setVar(varName, obj, 0);
            }
            catch (TclException e) {
                throw new TclException(interp, "couldn't set variable \"" + varName + "\"");
            }
            interp.setResult(count);
            return;
        }
        catch (IndexOutOfBoundsException e) {
            throw new TclNumArgsException(interp, 1, argv, "?switches? exp string subSpec varName");
        }
    }
}

