/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.IOException;
import tcl.lang.Channel;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclByteArray;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclInteger;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;

class ReadCmd
implements Command {
    ReadCmd() {
    }

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        Channel chan;
        int i = 1;
        int toRead = 0;
        boolean readAll = true;
        boolean noNewline = false;
        if (argv.length != 2 && argv.length != 3) {
            this.errorWrongNumArgs(interp, argv[0].toString());
        }
        if (argv[i].toString().equals("-nonewline")) {
            noNewline = true;
            ++i;
        }
        if (i == argv.length) {
            this.errorWrongNumArgs(interp, argv[0].toString());
        }
        if ((chan = TclIO.getChannel(interp, argv[i].toString())) == null) {
            throw new TclException(interp, "can not find channel named \"" + argv[i].toString() + "\"");
        }
        if (++i < argv.length) {
            String arg = argv[i].toString();
            if (Character.isDigit(arg.charAt(0))) {
                toRead = TclInteger.get(interp, argv[i]);
                readAll = false;
            } else if (arg.equals("nonewline")) {
                noNewline = true;
            } else {
                throw new TclException(interp, "bad argument \"" + arg + "\": should be \"nonewline\"");
            }
        }
        try {
            TclObject result = chan.getEncoding() == null ? TclByteArray.newInstance() : TclString.newInstance(new StringBuffer(64));
            if (readAll) {
                int charactersRead = chan.read(interp, result, 1, 0);
                if (noNewline) {
                    String inStr = result.toString();
                    if (charactersRead > 0 && inStr.charAt(charactersRead - 1) == '\n') {
                        interp.setResult(inStr.substring(0, charactersRead - 1));
                        return;
                    }
                }
            } else {
                int charactersRead = chan.read(interp, result, 3, toRead);
            }
            interp.setResult(result);
        }
        catch (IOException e) {
            throw new TclRuntimeError("ReadCmd.cmdProc() Error: IOException when reading " + chan.getChanName());
        }
    }

    private void errorWrongNumArgs(Interp interp, String cmd) throws TclException {
        throw new TclException(interp, "wrong # args: should be \"read channelId ?numChars?\" or \"read ?-nonewline? channelId\"");
    }
}

