/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.beans.EventSetDescriptor;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import tcl.lang.BeanEvent;
import tcl.lang.Interp;
import tcl.lang.ReflectException;
import tcl.lang.ReflectObject;
import tcl.lang.TclBoolean;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;

public class EventAdaptor {
    private boolean initialized = false;
    Interp interp;
    Object source;
    Hashtable callbacks;
    Throwable exception;
    EventSetDescriptor eventDesc;

    void init(Interp i, Object src, EventSetDescriptor desc) throws TclException {
        this.interp = i;
        this.callbacks = new Hashtable();
        this.eventDesc = desc;
        this.source = src;
        Method method2 = this.eventDesc.getAddListenerMethod();
        if (method2 != null) {
            Object[] args = new Object[]{this};
            try {
                method2.invoke(this.source, args);
            }
            catch (Exception e) {
                throw new ReflectException(i, (Throwable)e);
            }
        }
        this.initialized = true;
    }

    void setCallback(String eventName, TclObject command) {
        this.check();
        TclObject oldCmd = (TclObject)this.callbacks.get(eventName);
        if (oldCmd != null) {
            this.callbacks.remove(eventName);
        }
        TclObject str = TclString.newInstance(command.toString());
        this.callbacks.put(eventName, str);
    }

    int deleteCallback(String eventName) throws TclException {
        int size;
        this.check();
        TclObject oldCmd = (TclObject)this.callbacks.get(eventName);
        if (oldCmd != null) {
            this.callbacks.remove(eventName);
        }
        if ((size = this.callbacks.size()) == 0) {
            try {
                Method method2 = this.eventDesc.getRemoveListenerMethod();
                if (method2 != null) {
                    Object[] args = new Object[]{this};
                    method2.invoke(this.source, args);
                }
            }
            catch (Exception e) {
                throw new ReflectException(this.interp, (Throwable)e);
            }
            finally {
                this.initialized = false;
                this.callbacks = null;
                this.eventDesc = null;
                this.interp = null;
                this.source = null;
            }
        }
        return size;
    }

    TclObject getCallback(String eventName) {
        this.check();
        return (TclObject)this.callbacks.get(eventName);
    }

    void getHandledEvents(TclObject list) {
        this.check();
        try {
            String interfaceName = this.eventDesc.getListenerType().getName();
            Enumeration e = this.callbacks.keys();
            while (e.hasMoreElements()) {
                String eventName = (String)e.nextElement();
                TclList.append(null, list, TclString.newInstance(interfaceName + "." + eventName));
            }
        }
        catch (TclException e) {
            throw new TclRuntimeError("unexpected TclException: " + e);
        }
    }

    public final void _processEvent(Object[] params, String eventName) throws Throwable {
        this.check();
        this.exception = null;
        TclObject cmd = (TclObject)this.callbacks.get(eventName);
        if (cmd != null) {
            Class<?>[] paramTypes = null;
            Method[] methods = this.eventDesc.getListenerType().getMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equals(eventName)) continue;
                paramTypes = methods[i].getParameterTypes();
                break;
            }
            BeanEvent evt = new BeanEvent(this.interp, paramTypes, params, cmd);
            this.interp.getNotifier().queueEvent(evt, 0);
            evt.sync();
            this.exception = evt.exception;
            if (this.exception != null) {
                throw this.exception;
            }
        }
    }

    private final void check() {
        if (!this.initialized) {
            throw new TclRuntimeError("EventAdaptor not initialized");
        }
    }

    public final void _wrongException() throws Error, RuntimeException {
        if (this.exception instanceof Error) {
            throw (Error)this.exception;
        }
        if (this.exception instanceof RuntimeException) {
            throw (RuntimeException)this.exception;
        }
        if (!(this.exception instanceof TclException)) {
            this.interp.setResult("unexpected exception: " + this.exception);
        }
        this.interp.addErrorInfo("\n    (command bound to event)");
        this.interp.backgroundError();
    }

    public final boolean _return_boolean() {
        if (this.exception != null) {
            return false;
        }
        TclObject result = this.interp.getResult();
        try {
            return TclBoolean.get(this.interp, result);
        }
        catch (TclException e) {
            this.interp.addErrorInfo("\n    (attempting to return boolean from binding)");
            this.interp.backgroundError();
            return false;
        }
    }

    public final byte _return_byte() {
        return (byte)this._return_int();
    }

    public final char _return_char() {
        if (this.exception != null) {
            return '\u0000';
        }
        String s = this.interp.getResult().toString();
        if (s.length() == 1) {
            return s.charAt(0);
        }
        this.interp.setResult("expecting character but got \"" + s + "\"");
        this.interp.addErrorInfo("\n    (attempting to return character from binding)");
        this.interp.backgroundError();
        return '\u0000';
    }

    public final double _return_double() {
        if (this.exception != null) {
            return 0.0;
        }
        TclObject result = this.interp.getResult();
        try {
            return TclDouble.get(this.interp, result);
        }
        catch (TclException e) {
            this.interp.addErrorInfo("\n    (attempting to return floating-point number from binding)");
            this.interp.backgroundError();
            return 0.0;
        }
    }

    public final float _return_float() {
        return (float)this._return_double();
    }

    public final int _return_int() {
        if (this.exception != null) {
            return 0;
        }
        TclObject result = this.interp.getResult();
        try {
            return TclInteger.get(this.interp, result);
        }
        catch (TclException e) {
            this.interp.addErrorInfo("\n    (attempting to return integer number from binding)");
            this.interp.backgroundError();
            return 0;
        }
    }

    public final long _return_long() {
        return this._return_int();
    }

    public final short _return_short() {
        return (short)this._return_int();
    }

    public final Object _return_Object(String className) {
        if (this.exception != null) {
            return null;
        }
        if (className.equals("java.lang.String")) {
            return this.interp.getResult().toString();
        }
        Class<?> cls = null;
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new TclRuntimeError("unexpected exception " + e);
        }
        try {
            TclObject result = this.interp.getResult();
            Object obj = ReflectObject.get(this.interp, result);
            if (!cls.isInstance(obj)) {
                throw new TclException(this.interp, "cannot cast object " + result.toString() + " (" + obj.toString() + ") to required type " + className);
            }
            return obj;
        }
        catch (TclException e) {
            this.interp.addErrorInfo("\n    (attempting to return object from binding)");
            this.interp.backgroundError();
            return null;
        }
    }
}

