/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emf.utilities;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EStructuralFeatureImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.wst.common.internal.emf.utilities.CloneablePublic;
import org.eclipse.wst.common.internal.emf.utilities.Namespace;

public class NamespaceAdapter
extends AdapterImpl
implements CloneablePublic {
    protected static final String ADAPTER_TYPE;
    protected Map prefixesToNS;
    protected List namespaces;
    public static final EStructuralFeature NOTIFICATION_FEATURE;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.common.internal.emf.utilities.NamespaceAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ADAPTER_TYPE = clazz.getName();
        NOTIFICATION_FEATURE = new EStructuralFeatureImpl(){};
    }

    protected NamespaceAdapter() {
    }

    public static void addNamespace(String prefix, String uri, EObject obj) {
        if (obj == null) {
            return;
        }
        NamespaceAdapter adapter = NamespaceAdapter.getAdapter(obj);
        if (adapter != null) {
            adapter.addNamespace(prefix, uri);
        }
    }

    public static void removeNamespace(String prefix, EObject obj) {
        if (obj == null) {
            return;
        }
        NamespaceAdapter adapter = NamespaceAdapter.retrieveExistingAdapter(obj);
        if (adapter != null) {
            adapter.removeNamespace(prefix);
        }
    }

    public static String getResolvedNamespaceURI(String prefix, EObject obj) {
        if (prefix == null || obj == null) {
            return null;
        }
        EObject container = obj;
        while (container != null) {
            String nsURI = NamespaceAdapter.getNamespaceURIAtThisLevel(prefix, container);
            if (nsURI != null) {
                return nsURI;
            }
            container = container.eContainer();
        }
        return null;
    }

    public static String getNamespaceURIAtThisLevel(String prefix, EObject obj) {
        if (obj == null) {
            return null;
        }
        NamespaceAdapter adapter = NamespaceAdapter.retrieveExistingAdapter(obj);
        return adapter == null ? null : adapter.getNamespaceURI(prefix);
    }

    public static List getNamespaces(EObject obj) {
        if (obj == null) {
            return Collections.EMPTY_LIST;
        }
        NamespaceAdapter adapter = NamespaceAdapter.retrieveExistingAdapter(obj);
        return adapter == null ? null : adapter.getNamespaces();
    }

    protected static NamespaceAdapter retrieveExistingAdapter(EObject obj) {
        return (NamespaceAdapter)EcoreUtil.getExistingAdapter(obj, ADAPTER_TYPE);
    }

    protected static NamespaceAdapter getAdapter(EObject obj) {
        NamespaceAdapter adapter = NamespaceAdapter.retrieveExistingAdapter(obj);
        return adapter == null ? NamespaceAdapter.createAdapter(obj) : adapter;
    }

    protected static NamespaceAdapter createAdapter(EObject obj) {
        NamespaceAdapter adapter = new NamespaceAdapter();
        adapter.setTarget(obj);
        obj.eAdapters().add(adapter);
        return adapter;
    }

    protected void addNamespace(String prefix, String uri) {
        Namespace ns = new Namespace(prefix, uri);
        if (this.namespaces == null) {
            this.namespaces = new ArrayList();
        }
        if (this.prefixesToNS == null) {
            this.prefixesToNS = new HashMap();
        }
        this.prefixesToNS.put(prefix, ns);
        this.namespaces.add(ns);
        this.fireNotification(3, null, ns);
    }

    protected void removeNamespace(String prefix) {
        Namespace ns = null;
        if (this.prefixesToNS != null) {
            ns = (Namespace)this.prefixesToNS.get(prefix);
        }
        if (ns != null) {
            this.namespaces.remove(ns);
        }
        this.fireNotification(4, ns, null);
    }

    protected String getNamespaceURI(String prefix) {
        if (this.prefixesToNS == null) {
            return null;
        }
        Namespace ns = (Namespace)this.prefixesToNS.get(prefix);
        if (ns != null) {
            return ns.getNsURI();
        }
        return null;
    }

    public boolean isAdapterForType(Object type) {
        return ADAPTER_TYPE.equals(type);
    }

    public List getNamespaces() {
        return this.namespaces == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(this.namespaces);
    }

    protected void fireNotification(int type, Object oldValue, Object newValue) {
        if (this.target != null) {
            this.target.eNotify(new Notification(type, oldValue, newValue));
        }
    }

    public boolean hasNamespaces() {
        return this.namespaces != null && !this.namespaces.isEmpty();
    }

    public Object clone() {
        NamespaceAdapter result = new NamespaceAdapter();
        if (this.hasNamespaces()) {
            int i = 0;
            while (i < this.namespaces.size()) {
                Namespace ns = (Namespace)this.namespaces.get(i);
                result.addNamespace(ns.getPrefix(), ns.getNsURI());
                ++i;
            }
        }
        return result;
    }

    private static class Notification
    extends NotificationImpl {
        public Notification(int eventType, Object oldValue, Object newValue) {
            super(eventType, oldValue, newValue);
        }

        public Object getFeature() {
            return NOTIFICATION_FEATURE;
        }
    }
}

