/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.webservice.adapter;

import java.util.Iterator;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jst.j2ee.common.CommonPackage;
import org.eclipse.jst.j2ee.common.QName;
import org.eclipse.jst.j2ee.internal.webservice.adapter.AdapterQNameText;
import org.eclipse.jst.j2ee.internal.webservice.adapter.AdapterText;
import org.eclipse.jst.j2ee.internal.webservice.command.CommandAddElement;
import org.eclipse.jst.j2ee.internal.webservice.command.CommandRemoveElement;
import org.eclipse.jst.j2ee.webservice.internal.util.QNameHelper;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.componentcore.ArtifactEdit;

public class AdapterQNameElement
extends AdapterImpl
implements ModifyListener {
    private ArtifactEdit artifactEdit;
    private EObject parent_;
    private EClass childEClass_;
    private EStructuralFeature childFeature_;
    private boolean childNillable_;
    private EStructuralFeature[] features_;
    private boolean[] featuresNillable_;
    private Text[] featuresTexts_;
    private AdapterText[] featuresAdapters_;

    public AdapterQNameElement(ArtifactEdit anArtifactEdit, EClass childEClass, EStructuralFeature childFeature, boolean childNillable, Text nsURIText, Text localPartText) {
        this.artifactEdit = anArtifactEdit;
        this.parent_ = null;
        this.childEClass_ = childEClass;
        this.childFeature_ = childFeature;
        this.childNillable_ = childNillable;
        CommonPackage commonPKG = CommonPackage.eINSTANCE;
        this.features_ = new EStructuralFeature[2];
        this.features_[0] = commonPKG.getQName_NamespaceURI();
        this.features_[1] = commonPKG.getQName_LocalPart();
        this.featuresNillable_ = new boolean[2];
        this.featuresNillable_[0] = false;
        this.featuresNillable_[1] = false;
        this.featuresTexts_ = new Text[2];
        this.featuresTexts_[0] = nsURIText;
        this.featuresTexts_[1] = localPartText;
        this.addModifyListener();
        this.featuresAdapters_ = new AdapterText[this.features_.length];
        this.newAdapters(null);
    }

    public AdapterQNameElement(ArtifactEdit anArtifactEdit, EObject parent, EClass childEClass, EStructuralFeature childFeature, boolean childNillable, Text nsURIText, Text localPartText) {
        this(anArtifactEdit, childEClass, childFeature, childNillable, nsURIText, localPartText);
        this.adapt(parent);
    }

    private void newAdapters(EObject eObject) {
        if (eObject == null) {
            this.featuresAdapters_[0] = new AdapterQNameText(this.artifactEdit, this.features_[0], this.featuresTexts_[0], this.featuresNillable_[0]);
            this.featuresAdapters_[1] = new AdapterText(this.artifactEdit, this.features_[1], this.featuresTexts_[1], this.featuresNillable_[1]);
        } else {
            this.featuresAdapters_[0] = new AdapterQNameText(this.artifactEdit, eObject, this.features_[0], this.featuresTexts_[0], this.featuresNillable_[0]);
            this.featuresAdapters_[1] = new AdapterText(this.artifactEdit, eObject, this.features_[1], this.featuresTexts_[1], this.featuresNillable_[1]);
        }
    }

    private void addModifyListener() {
        int i = 0;
        while (i < this.featuresTexts_.length) {
            this.featuresTexts_[i].addModifyListener((ModifyListener)this);
            ++i;
        }
    }

    public void notifyChanged(Notification msg) {
        int type = msg.getEventType();
        if ((type == 1 || type == 2) && msg.getFeature() == this.childFeature_) {
            EObject child = (EObject)this.parent_.eGet(this.childFeature_);
            if (child == null && !this.childNillable_) {
                child = this.setChild();
            }
            int i = 0;
            while (i < this.featuresAdapters_.length) {
                this.featuresAdapters_[i].adapt(child);
                ++i;
            }
        }
    }

    public void modifyText(ModifyEvent e) {
        AbstractCommand command;
        boolean isTextsNull = this.isTextsNull();
        EObject child = (EObject)this.parent_.eGet(this.childFeature_);
        boolean childCanBeRemoved = true;
        if (child != null) {
            Iterator allfeatures = this.childEClass_.getEAllStructuralFeatures().iterator();
            while (allfeatures.hasNext()) {
                EStructuralFeature thisFeature = (EStructuralFeature)allfeatures.next();
                if (this.adaptingFeature(thisFeature) || !child.eIsSet(thisFeature)) continue;
                childCanBeRemoved = false;
                break;
            }
        }
        if (isTextsNull && child != null && this.childNillable_ && childCanBeRemoved) {
            this.disposeAdapters();
            this.parent_.eAdapters().remove(this);
            command = new CommandRemoveElement(null, null, this.parent_, this.childFeature_);
            this.artifactEdit.getContentModelRoot().eResource().setModified(true);
            this.artifactEdit.getCommandStack().execute(command);
            this.parent_.eAdapters().add(this);
            this.newAdapters(null);
        } else if (!isTextsNull && child == null) {
            this.disposeAdapters();
            this.parent_.eAdapters().remove(this);
            child = this.createChild();
            this.setFeaturesOnChild(child);
            command = new CommandAddElement(null, null, this.parent_, this.childFeature_, child);
            this.artifactEdit.getContentModelRoot().eResource().setModified(true);
            this.artifactEdit.getCommandStack().execute(command);
            this.parent_.eAdapters().add(this);
            this.newAdapters(child);
        }
    }

    private boolean isTextsNull() {
        int i = 0;
        while (i < this.featuresTexts_.length) {
            String text = this.featuresTexts_[i].getText();
            if (text != null && text.length() > 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void adapt(EObject eObject) {
        if (this.parent_ != null) {
            this.parent_.eAdapters().remove(this);
        }
        this.parent_ = eObject;
        EObject child = null;
        if (this.parent_ != null) {
            this.parent_.eAdapters().add(this);
            child = (EObject)this.parent_.eGet(this.childFeature_);
            if (child == null && !this.childNillable_) {
                child = this.setChild();
            }
        }
        this.removeModifyListener();
        int i = 0;
        while (i < this.featuresAdapters_.length) {
            this.featuresAdapters_[i].adapt(child);
            ++i;
        }
        this.addModifyListener();
    }

    private EObject setChild() {
        EObject child = this.createChild();
        this.parent_.eAdapters().remove(this);
        this.parent_.eSet(this.childFeature_, child);
        this.parent_.eAdapters().add(this);
        return child;
    }

    private EObject createChild() {
        EFactory childFactory = this.childEClass_.getEPackage().getEFactoryInstance();
        EObject child = childFactory.create(this.childEClass_);
        int i = 0;
        while (i < this.features_.length) {
            if (!this.featuresNillable_[i]) {
                child.eSet(this.features_[i], "");
            }
            ++i;
        }
        return child;
    }

    public void dispose() {
        if (this.parent_ != null) {
            this.parent_.eAdapters().remove(this);
        }
        this.disposeAdapters();
        this.removeModifyListener();
    }

    private void disposeAdapters() {
        int i = 0;
        while (i < this.featuresAdapters_.length) {
            this.featuresAdapters_[i].dispose();
            ++i;
        }
    }

    private void removeModifyListener() {
        int i = 0;
        while (i < this.featuresTexts_.length) {
            if (this.featuresTexts_[i] != null && !this.featuresTexts_[i].isDisposed()) {
                this.featuresTexts_[i].removeModifyListener((ModifyListener)this);
            }
            ++i;
        }
    }

    private boolean adaptingFeature(EStructuralFeature feature) {
        if (this.features_ == null) {
            return false;
        }
        int i = 0;
        while (i < this.features_.length) {
            if (feature == this.features_[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void setFeaturesOnChild(EObject child) {
        if (child instanceof QName) {
            QName qname = (QName)child;
            String namespaceURIValue = this.featuresTexts_[0].getText();
            String localPartValue = this.featuresTexts_[1].getText();
            if (namespaceURIValue == null || namespaceURIValue.length() == 0) {
                if (localPartValue != null && localPartValue.length() > 0) {
                    qname.setLocalPart(localPartValue);
                }
            } else {
                if (localPartValue == null) {
                    localPartValue = "";
                }
                QNameHelper.setQNameValue(qname, namespaceURIValue, localPartValue);
            }
        }
    }
}

