/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.web.archive.operations;

import java.io.FileNotFoundException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;

public class WTProjectStrategyUtils {
    public static File findSourceFile(Archive archive, String file) {
        if (WTProjectStrategyUtils.isClassFile(file)) {
            return WTProjectStrategyUtils.findSourceFileForClass(archive, file);
        }
        try {
            if (!WTProjectStrategyUtils.isOutputFile(file)) {
                return archive.getFile(file);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {}
        return null;
    }

    public static File findSourceFileForClass(Archive archive, String classFile) {
        File file;
        Path classFilePath = new Path(classFile);
        IPath sourceFilePath = classFilePath.removeFileExtension().addFileExtension("java");
        try {
            file = archive.getFile(sourceFilePath.toString());
            if (file != null) {
                return file;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {}
        sourceFilePath = new Path("WEB-INF/lib/").append(sourceFilePath);
        try {
            file = archive.getFile(sourceFilePath.toString());
            if (file != null) {
                return file;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {}
        return null;
    }

    public static boolean isClassFile(String uri) {
        return uri.startsWith("WEB-INF/classes/") && uri.endsWith(".class");
    }

    public static boolean isOutputFile(String uri) {
        return uri.startsWith("WEB-INF/classes/");
    }

    public static boolean isSourceFile(String uri) {
        return uri.startsWith("WEB-INF/") && uri.endsWith(".java");
    }

    public static String makeRelative(String pathString, String relToPathString) {
        Object path = new Path(pathString);
        Path relToPath = new Path(relToPathString);
        if (path.matchingFirstSegments((IPath)relToPath) == relToPath.segmentCount()) {
            path = path.removeFirstSegments(relToPath.segmentCount());
        }
        return path.toString();
    }
}

