/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.logger.proxy.Logger;

public class UpdateProjectClasspath {
    public UpdateProjectClasspath(String sourceFolder, String componentName, IProject jProject) {
        this.addSrcFolderToProject(sourceFolder, componentName, jProject);
    }

    private IClasspathEntry[] getClasspathEntries(String sourceFolder, String componentName, IProject jProject) {
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        list.add(JavaCore.newSourceEntry((IPath)jProject.getFullPath().append(sourceFolder)));
        IClasspathEntry[] classpath = new IClasspathEntry[list.size()];
        IPath newOutputPath = null;
        int i = 0;
        while (i < classpath.length) {
            classpath[i] = (IClasspathEntry)list.get(i);
            ((ClasspathEntry)classpath[i]).specificOutputLocation = newOutputPath = Path.fromOSString((String)(String.valueOf('/') + jProject.getName() + "/bin/"));
            ++i;
        }
        return classpath;
    }

    private void addSrcFolderToProject(String sourceFolder, String componentName, IProject jProject) {
        IJavaProject javaProject = JavaCore.create((IProject)jProject);
        try {
            IClasspathEntry[] oldEntries = javaProject.getRawClasspath();
            IClasspathEntry[] newEntries = this.getClasspathEntries(sourceFolder, componentName, jProject);
            ArrayList<IClasspathEntry> classpathList = new ArrayList<IClasspathEntry>();
            List<IClasspathEntry> oldEntriesList = Arrays.asList(oldEntries);
            classpathList.addAll(oldEntriesList);
            int j = 0;
            while (j < newEntries.length) {
                if (!oldEntriesList.contains(newEntries[j])) {
                    classpathList.add(newEntries[j]);
                }
                ++j;
            }
            IClasspathEntry[] classpathEntries = classpathList.toArray(new IClasspathEntry[classpathList.size()]);
            javaProject.setRawClasspath(classpathEntries, null);
        }
        catch (JavaModelException e) {
            Logger.getLogger().logError(e);
        }
    }

    private static IClasspathEntry[] getProjectDependency(IProject clientProj) {
        IClasspathEntry projectEntry = JavaCore.newProjectEntry((IPath)clientProj.getFullPath(), (boolean)true);
        return new IClasspathEntry[]{projectEntry};
    }

    private static boolean entryToChange(IClasspathEntry entry, IClasspathEntry[] entriesToChange) {
        int i = 0;
        while (i < entriesToChange.length) {
            if (entriesToChange[i].equals(entry)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void updateProjectDependency(String projectName, String referencedProjectName, boolean add) {
        IProject proj = ProjectUtilities.getProject(projectName);
        IProject refproj = ProjectUtilities.getProject(referencedProjectName);
        UpdateProjectClasspath.updateProjectDependency(proj, refproj, add);
    }

    public static void updateProjectDependency(IProject ejbProj, IProject clientProj, boolean add) {
        IJavaProject javaProject = JavaCore.create((IProject)ejbProj);
        try {
            IClasspathEntry[] oldEntries = javaProject.getRawClasspath();
            IClasspathEntry[] entriesToChange = UpdateProjectClasspath.getProjectDependency(clientProj);
            ArrayList<IClasspathEntry> classpathEntries = new ArrayList<IClasspathEntry>();
            int i = 0;
            while (i < oldEntries.length) {
                if (!UpdateProjectClasspath.entryToChange(oldEntries[i], entriesToChange)) {
                    classpathEntries.add(oldEntries[i]);
                }
                ++i;
            }
            if (add) {
                int j = 0;
                while (j < entriesToChange.length) {
                    boolean containsEntry = false;
                    if (entriesToChange[j].getEntryKind() == 2) {
                        int k = 0;
                        while (k < classpathEntries.size()) {
                            String newEntry;
                            String existingEntry = ((IClasspathEntry)classpathEntries.get(k)).getPath().segment(0);
                            if (existingEntry.equals(newEntry = entriesToChange[j].getPath().segment(0))) {
                                containsEntry = true;
                                break;
                            }
                            ++k;
                        }
                    }
                    if (!containsEntry) {
                        classpathEntries.add(entriesToChange[j]);
                    }
                    ++j;
                }
            }
            javaProject.setRawClasspath(classpathEntries.toArray(new IClasspathEntry[classpathEntries.size()]), null);
        }
        catch (JavaModelException e) {
            Logger.getLogger().logError(e);
        }
    }
}

