/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Container;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveRuntimeException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseApplication;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseArchive;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseConfiguration;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseModule;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseWARFile;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseconfigFactory;

public class LooseConfigRegister {
    protected static LooseConfigRegister singleton;
    private Map looseApplicationMap;
    protected boolean loadAttempted = false;
    protected LooseConfiguration looseConfiguration;
    public static final String LOOSE_CONFIG_PROPERTY = "was.loose.config";
    protected static final boolean DO_LOAD = true;
    public static final String DEBUG_PROPERTY_NAME = "commonarchive.looseconfig.debug";
    public static boolean debugEnabled;
    public static final String DEBUG_PREFIX = "LooseConfigRegister: ";

    static {
        String debugPropertyValue = System.getProperty(DEBUG_PROPERTY_NAME);
        debugEnabled = debugPropertyValue != null && debugPropertyValue.equalsIgnoreCase("true");
        LooseConfigRegister.debug("Class initialization [ " + LooseConfigRegister.class.getName() + " ]");
    }

    public static LooseConfigRegister singleton() {
        if (singleton == null) {
            LooseConfigRegister.debug("Constructed register singleton.");
            singleton = new LooseConfigRegister();
        }
        return singleton;
    }

    protected LooseConfigRegister() {
    }

    public List getLooseChildren(LooseArchive looseArchive) {
        if (looseArchive != null) {
            if (looseArchive.isEAR()) {
                return ((LooseApplication)looseArchive).getLooseArchives();
            }
            if (looseArchive.isWAR()) {
                return ((LooseWARFile)looseArchive).getLooseLibs();
            }
        }
        return Collections.EMPTY_LIST;
    }

    public LooseArchive findFirstLooseChild(String path, LooseArchive looseArchive) {
        String path_platform = LooseConfigRegister.normalize(path);
        Iterator children = this.getLooseChildren(looseArchive).iterator();
        LooseArchive selectedChild = null;
        while (selectedChild == null && children.hasNext()) {
            LooseArchive nextChild = (LooseArchive)children.next();
            String nextChildPath = nextChild.getUri();
            String nextChildPath_platform = LooseConfigRegister.normalize(nextChildPath);
            if (!LooseConfigRegister.stringsEqual(path_platform, nextChildPath_platform)) continue;
            if (!LooseConfigRegister.stringsEqual(path, nextChildPath)) {
                LooseConfigRegister.debug("Warning: normalized match of [ " + path + " ] with [ " + nextChildPath + " ]");
            }
            selectedChild = nextChild;
        }
        return selectedChild;
    }

    public LooseModule findLooseModule(Module module, EARFile ear) {
        LooseApplication looseApplication = this.findLooseApplication(ear.getURI());
        if (looseApplication == null) {
            return null;
        }
        return this.findLooseModule(looseApplication, module.getUri(), module.getAltDD());
    }

    public LooseModule findLooseModule(LooseApplication looseApplication, String modulePath, String altDD) {
        String modulePath_platform = LooseConfigRegister.normalize(modulePath);
        Iterator archives = looseApplication.getLooseArchives().iterator();
        LooseModule selectedModule = null;
        while (selectedModule == null && archives.hasNext()) {
            LooseModule nextModule;
            String nextModulePath;
            String nextModulePath_platform;
            LooseArchive nextElement = (LooseArchive)archives.next();
            if (!nextElement.isModule() || !LooseConfigRegister.stringsEqual(modulePath_platform, nextModulePath_platform = LooseConfigRegister.normalize(nextModulePath = (nextModule = (LooseModule)nextElement).getUri())) || !LooseConfigRegister.stringsEqual(altDD, nextModule.getAltDD())) continue;
            if (!LooseConfigRegister.stringsEqual(modulePath, nextModulePath)) {
                LooseConfigRegister.debug("Warning: Normalized match of [ " + modulePath + " ] with [ " + nextModulePath + " ]");
            }
            selectedModule = nextModule;
        }
        return selectedModule;
    }

    public Map getLooseEarMap() {
        return this.getLooseApplicationMap();
    }

    public Map getLooseApplicationMap() {
        if (this.looseApplicationMap == null) {
            this.looseApplicationMap = new HashMap();
        }
        return this.looseApplicationMap;
    }

    public void removeLooseMapping(String applicationPath) {
        this.removeLooseMapping_platform(applicationPath, LooseConfigRegister.normalize(applicationPath));
    }

    protected void removeLooseMapping_platform(String applicationPath, String applicationPath_platform) {
        LooseConfigRegister.debug("Removing application path from mapping [ " + applicationPath_platform + " ]");
        if (this.haveDocumentURI()) {
            LooseConfigRegister.debug("Warning: Use of loose mapping APIs with a set loose configuration property.\nThe use of loose mapping APIs is not supported when a loose configuration\nproperty has been set.");
        }
        if (applicationPath_platform == null) {
            return;
        }
        LooseApplication looseApplication = this.findLooseApplicationIfLoaded_platform(applicationPath, applicationPath_platform);
        if (looseApplication != null) {
            LooseConfigRegister.debug("Loose data was loaded for that application; removing.");
            this.removeLooseApplication(looseApplication);
        } else {
            LooseConfigRegister.debug("Loose data was not loaded for that application.");
        }
        URI looseConfigURI = (URI)this.getLooseApplicationMap().remove(applicationPath_platform);
        if (looseConfigURI == null) {
            LooseConfigRegister.debug("No loose mapping was found.");
        } else {
            LooseConfigRegister.debug("Removed loose mapping [ " + looseConfigURI + " ]");
        }
    }

    public void addLooseMapping(String applicationPath, String looseApplicationURI) {
        String applicationPath_platform = LooseConfigRegister.normalize(applicationPath);
        LooseConfigRegister.debug("Adding application path to mapping [ " + applicationPath_platform + " ]");
        LooseConfigRegister.debug("Loose application URI [ " + looseApplicationURI + " ]");
        if (applicationPath_platform == null) {
            LooseConfigRegister.debug("Null URI; no mapping was adding.");
            return;
        }
        this.removeLooseMapping_platform(applicationPath, applicationPath_platform);
        this.getLooseApplicationMap().put(applicationPath_platform, URI.createURI(looseApplicationURI));
    }

    public void addLooseMapping(Container container, String looseApplicationURI) {
        LooseConfigRegister.debug("Adding container to mapping [ " + container + " ]");
        LooseConfigRegister.debug("Loose application URI [ " + looseApplicationURI + " ]");
        if (container == null) {
            LooseConfigRegister.debug("Null container; no addition was performed.");
            return;
        }
        this.addLooseMapping(container.getURI(), looseApplicationURI);
    }

    public LooseApplication findLooseApplication(String applicationPath) {
        String applicationPath_platform = LooseConfigRegister.normalize(applicationPath);
        LooseConfigRegister.debug("Locating loose application [ " + applicationPath_platform + " ]");
        LooseApplication looseApplication = this.findLooseApplicationIfLoaded_platform(applicationPath, applicationPath_platform);
        if (looseApplication != null) {
            LooseConfigRegister.debug("Loose application was previously loaded.");
            return looseApplication;
        }
        LooseConfigRegister.debug("Loose application not already loaded.");
        if (this.haveDocumentURI()) {
            LooseConfigRegister.debug("A loose configuration document was specified; no load will be attempted.");
            return null;
        }
        LooseConfigRegister.debug("No loose configuration document; attempting load ...");
        URI looseConfigURI = (URI)this.getLooseApplicationMap().get(applicationPath_platform);
        if (looseConfigURI == null) {
            LooseConfigRegister.debug("No mapping was set for the requested application; answering null.");
            return null;
        }
        LooseConfigRegister.debug("Application mapped to loose configuration URI [ " + looseConfigURI + " ]");
        looseApplication = this.loadLooseApplication(looseConfigURI);
        if (looseApplication == null) {
            LooseConfigRegister.debug("Load was not successful; answering null.");
            return null;
        }
        LooseConfigRegister.debug("Load was successful ... adding and returning loose application.");
        this.addLooseApplication(looseApplication);
        return looseApplication;
    }

    public boolean getLoadAttempted() {
        return this.loadAttempted;
    }

    public LooseConfiguration primGetLooseConfiguration() {
        return this.looseConfiguration;
    }

    public void flush() {
        LooseConfigRegister.debug("Loose configuration has been flushed.");
        this.loadAttempted = false;
        this.looseConfiguration = null;
    }

    public void setLooseConfiguration(LooseConfiguration looseConfiguration) {
        LooseConfigRegister.debug("Assignment of loose configuration [ " + looseConfiguration + " ]");
        this.looseConfiguration = looseConfiguration;
    }

    public LooseConfiguration getLooseConfiguration() {
        if (this.looseConfiguration == null && !this.loadAttempted) {
            LooseConfiguration useLooseConfiguration;
            LooseConfigRegister.debug("Loading loose configuration ...");
            Resource res = this.loadLooseConfigurationResource();
            if (res != null && !res.getContents().isEmpty()) {
                LooseConfigRegister.debug("Loading loose configuration ... retrieving from loaded resource ...");
                useLooseConfiguration = (LooseConfiguration)res.getContents().get(0);
            } else {
                LooseConfigRegister.debug("Loading loose configuration ... creating new empty configuration ...");
                useLooseConfiguration = LooseconfigFactory.eINSTANCE.createLooseConfiguration();
            }
            this.looseConfiguration = useLooseConfiguration;
            this.loadAttempted = true;
            LooseConfigRegister.debug("Loose configuration [ " + this.looseConfiguration + " ]");
        }
        return this.looseConfiguration;
    }

    public void addLooseApplication(LooseApplication looseApplication) {
        LooseConfigRegister.debug("Adding loose application to loose configuration [ " + LooseConfigRegister.normalize(looseApplication.getUri()) + " ]");
        this.getLooseConfiguration().getApplications().add(looseApplication);
    }

    public void removeLooseApplication(LooseApplication looseApplication) {
        LooseConfigRegister.debug("Removing loose application from loose configuration [ " + LooseConfigRegister.normalize(looseApplication.getUri()) + " ]");
        this.getLooseConfiguration().getApplications().remove(looseApplication);
    }

    public Iterator getLooseApplications() {
        return this.getLooseConfiguration().getApplications().iterator();
    }

    public LooseApplication findLooseApplicationIfLoaded(String applicationPath) {
        return this.findLooseApplicationIfLoaded_platform(applicationPath, LooseConfigRegister.normalize(applicationPath));
    }

    protected LooseApplication findLooseApplicationIfLoaded_platform(String applicationPath, String applicationPath_platform) {
        Iterator useLooseApplications = this.getLooseApplications();
        LooseApplication selectedApplication = null;
        while (selectedApplication == null && useLooseApplications.hasNext()) {
            LooseApplication nextLooseApplication = (LooseApplication)useLooseApplications.next();
            String nextApplicationPath = nextLooseApplication.getUri();
            String nextApplicationPath_platform = LooseConfigRegister.normalize(nextApplicationPath);
            if (!LooseConfigRegister.stringsEqual(applicationPath_platform, nextApplicationPath_platform)) continue;
            if (!LooseConfigRegister.stringsEqual(applicationPath, nextApplicationPath)) {
                LooseConfigRegister.debug("Warning: Normalized match of [ " + applicationPath + " ] with [ " + nextApplicationPath + " ]");
            }
            selectedApplication = nextLooseApplication;
        }
        return selectedApplication;
    }

    protected LooseApplication loadLooseApplication(URI looseApplicationURI) {
        Resource res = this.loadResource(looseApplicationURI);
        if (res != null && !res.getContents().isEmpty()) {
            return (LooseApplication)res.getContents().get(0);
        }
        return null;
    }

    protected String getDocumentURI() {
        return System.getProperty(LOOSE_CONFIG_PROPERTY);
    }

    protected boolean haveDocumentURI() {
        return !ArchiveUtil.isNullOrEmpty(this.getDocumentURI());
    }

    protected Resource loadLooseConfigurationResource() {
        if (!this.haveDocumentURI()) {
            LooseConfigRegister.debug("Loading loose configuration file has no set URI; load result is null");
            return null;
        }
        LooseConfigRegister.debug("Loading loose configuration file; URI is set");
        return this.loadResource(URI.createURI(this.getDocumentURI()));
    }

    protected ResourceSet createResourceSet() {
        return new ResourceSetImpl();
    }

    protected Resource loadResource(URI uri) {
        if (uri == null) {
            return null;
        }
        LooseConfigRegister.debug("Loading loose application resource [ " + uri + " ]");
        try {
            return this.createResourceSet().getResource(uri, true);
        }
        catch (Exception ex) {
            LooseConfigRegister.debug("Loading loose application resource [ " + uri + " ] ... failed");
            throw new ArchiveRuntimeException("Exception occurred loading loose application from [ " + uri + " ] ", ex);
        }
    }

    public static String normalize(String path) {
        char sep;
        char otherSep;
        String path_platform = null;
        if (path != null && !path.equals(path_platform = path.replace(otherSep = (sep = File.separatorChar) == '/' ? (char)'\\' : '/', sep))) {
            LooseConfigRegister.debug("Normalized [ " + path + " ] to [ " + path_platform + " ]");
        }
        return path_platform;
    }

    public static boolean stringsEqual(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        return s1.equals(s2);
    }

    public static void debug(String text) {
        if (debugEnabled) {
            System.out.println(DEBUG_PREFIX + text);
        }
    }
}

