/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.ProtectionDomain;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveRuntimeException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;

public class ArchiveFileDynamicClassLoader
extends ClassLoader {
    protected Archive archive = null;
    protected ClassLoader extraClassLoader;
    protected boolean inEARFile;
    private static final String URL_PROTOCOL = "archive";
    private ArchiveURLStreamHandler handler;
    protected ProtectionDomain protectionDomain;
    protected static final int CLASS_TYPE = 0;
    protected static final int FILE_TYPE = 1;

    public ProtectionDomain setProtectionDomain(ProtectionDomain protectionDomain) {
        ProtectionDomain priorDomain = this.protectionDomain;
        this.protectionDomain = protectionDomain;
        return priorDomain;
    }

    public ProtectionDomain getProtectionDomain() {
        return this.protectionDomain;
    }

    public ArchiveFileDynamicClassLoader(Archive anArchive, ClassLoader parentCl, ClassLoader extraCl, ProtectionDomain pDomain) {
        super(parentCl);
        this.setArchive(anArchive);
        this.setExtraClassLoader(extraCl);
        this.inEARFile = anArchive.getContainer() != null && anArchive.getContainer().isEARFile();
        this.handler = new ArchiveURLStreamHandler();
        this.protectionDomain = pDomain;
    }

    public ArchiveFileDynamicClassLoader(Archive anArchive, ClassLoader parentCl, ClassLoader extraCl) {
        this(anArchive, parentCl, extraCl, null);
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        Class<?> result;
        byte[] bytes = this.getClassBytesFor(name);
        if (bytes != null) {
            result = this.protectionDomain == null ? this.defineClass(name, bytes, 0, bytes.length) : this.defineClass(name, bytes, 0, bytes.length, this.protectionDomain);
            if (result == null) {
                throw new ClassNotFoundException(name);
            }
        } else {
            throw new ClassNotFoundException(name);
        }
        return result;
    }

    public Archive getArchive() {
        return this.archive;
    }

    private byte[] getData(File file) {
        if (file != null) {
            try {
                return ArchiveUtil.inputStreamToBytes(file.getInputStream());
            }
            catch (FileNotFoundException e) {
                return null;
            }
            catch (IOException e) {
                throw new ArchiveRuntimeException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.io_ex_loading_EXC_, new Object[]{file.getName()}), e);
            }
        }
        return null;
    }

    protected byte[] getClassBytesFor(String className) {
        if (className == null) {
            return null;
        }
        String jarEntryName = ArchiveUtil.classNameToUri(className);
        return this.getData(this.getFile(jarEntryName));
    }

    protected EARFile getEARFile() {
        return (EARFile)this.getArchive().getContainer();
    }

    public ClassLoader getExtraClassLoader() {
        return this.extraClassLoader;
    }

    protected synchronized Class loadClass(String name, Set visitedArchives) throws ClassNotFoundException {
        if (visitedArchives.contains(this.getArchive())) {
            throw new ClassNotFoundException(name);
        }
        visitedArchives.add(this.getArchive());
        try {
            return super.loadClass(name, false);
        }
        catch (ClassNotFoundException ex) {
            return this.loadClassInDependentJarInEAR(name, visitedArchives);
        }
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            return super.loadClass(name, resolve);
        }
        catch (ClassNotFoundException ex) {
            Class c = this.loadClassInDependentJar(name);
            if (c != null && resolve) {
                this.resolveClass(c);
            }
            return c;
        }
    }

    protected Class loadClassInDependentJar(String name) throws ClassNotFoundException {
        if (this.inEARFile) {
            return this.loadClassInDependentJarInEAR(name);
        }
        if (this.getExtraClassLoader() != null) {
            return this.getExtraClassLoader().loadClass(name);
        }
        throw new ClassNotFoundException(name);
    }

    protected Class loadClassInDependentJarInEAR(String name, Set visitedArchives) throws ClassNotFoundException {
        Object obj = this.getResourceInDependentJarInEAR(name, visitedArchives, 0);
        if (obj == null) {
            throw new ClassNotFoundException(name);
        }
        return (Class)obj;
    }

    protected Class loadClassInDependentJarInEAR(String name) throws ClassNotFoundException {
        Object obj = this.getResourceInDependentJarInEAR(name, 0);
        if (obj == null) {
            throw new ClassNotFoundException(name);
        }
        return (Class)obj;
    }

    protected File getFileFromDependentJar(String name) {
        Object obj = this.getResourceInDependentJarInEAR(name, 1);
        if (obj != null) {
            return (File)obj;
        }
        return null;
    }

    protected Object getResourceInDependentJarInEAR(String name, int type) {
        HashSet<Archive> visitedArchives = new HashSet<Archive>(5);
        visitedArchives.add(this.getArchive());
        return this.getResourceInDependentJarInEAR(name, visitedArchives, type);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object getResourceInDependentJarInEAR(String name, Set visitedArchives, int type) {
        classpath = this.archive.getManifest().getClassPathTokenized();
        i = 0;
        while (true) {
            block13: {
                if (i >= classpath.length) {
                    return null;
                }
                uri = ArchiveUtil.deriveEARRelativeURI(classpath[i], this.archive);
                if (uri == null || !(jarFile = this.getEARFile().getFile(uri)).isArchive()) break block13;
                dep = (Archive)jarFile;
                switch (type) {
                    case 0: {
                        try {
                            return ((ArchiveFileDynamicClassLoader)dep.getArchiveClassLoader()).loadClass(name, visitedArchives);
                        }
                        catch (ClassNotFoundException noDice) {
                            ** break;
                        }
                    }
                    case 1: {
                        ** GOTO lbl-1000
                    }
                    default: {
                    }
                }
                {
                    catch (FileNotFoundException var6_7) {
                        // empty catch block
                    }
                }
                break block13;
lbl-1000:
                // 1 sources

                {
                    try {
                        return dep.getFile(name);
                    }
                    catch (FileNotFoundException noDice) {}
                    {
                        ** break;
                    }
                }
            }
            ++i;
        }
    }

    public void setArchive(Archive newArchive) {
        this.archive = newArchive;
    }

    public void setExtraClassLoader(ClassLoader newExtraClassLoader) {
        this.extraClassLoader = newExtraClassLoader;
    }

    public InputStream getResourceAsStream(String name) {
        try {
            File file = this.getFile(name);
            if (file != null) {
                return file.getInputStream();
            }
        }
        catch (IOException e) {
            throw new ArchiveRuntimeException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.io_ex_loading_EXC_, new Object[]{name}), e);
        }
        return null;
    }

    protected File getFileFromArchive(String name) {
        try {
            return this.getArchive().getFile(name);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    protected File getFile(String name) {
        File file = this.getFileFromArchive(name);
        if (file == null) {
            file = this.getFileFromDependentJar(name);
        }
        return file;
    }

    protected URL findResource(String name) {
        if (this.getFile(name) != null) {
            try {
                return new URL(null, "archive://" + name, this.handler);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private class ArchiveURLStreamHandler
    extends URLStreamHandler {
        protected URLConnection openConnection(URL url) throws IOException {
            return new ArchiveURLConnection(url);
        }
    }

    private class ArchiveURLConnection
    extends URLConnection {
        private String resourceName;

        protected ArchiveURLConnection(URL url) {
            super(url);
            this.resourceName = url.toString().substring(ArchiveFileDynamicClassLoader.URL_PROTOCOL.length() + 3);
        }

        public void connect() throws IOException {
        }

        public InputStream getInputStream() throws IOException {
            return ArchiveFileDynamicClassLoader.this.getResourceAsStream(this.resourceName);
        }
    }
}

