/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.strategy;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategyImpl;

public class ZipFileLoadStrategyImpl
extends LoadStrategyImpl {
    protected java.io.File file;
    protected ZipFile zipFile;

    public ZipFileLoadStrategyImpl() {
    }

    public ZipFileLoadStrategyImpl(java.io.File file) throws IOException {
        this.setFile(file);
        this.setZipFile(new ZipFile(file));
    }

    public void close() {
        super.close();
        try {
            this.getZipFile().close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected boolean primContains(String uri) {
        return this.getZipFile().getEntry(uri) != null;
    }

    public String getAbsolutePath() throws FileNotFoundException {
        return this.getFile().getAbsolutePath();
    }

    public java.io.File getFile() {
        return this.file;
    }

    public List getFiles() {
        ArrayList<File> list = new ArrayList<File>();
        Enumeration<? extends ZipEntry> entries = this.getZipFile().entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory() || this.collectedLooseArchiveFiles.containsKey(entry.getName())) continue;
            File aFile = this.createFile(entry.getName());
            aFile.setSize(entry.getSize());
            aFile.setLastModified(entry.getTime());
            list.add(aFile);
        }
        return list;
    }

    public InputStream getInputStream(String uri) throws IOException, FileNotFoundException {
        try {
            ZipEntry entry = this.getZipFile().getEntry(uri);
            if (entry == null) {
                throw new FileNotFoundException(uri);
            }
            return new BufferedInputStream(this.getZipFile().getInputStream(entry));
        }
        catch (IllegalStateException zipClosed) {
            throw new IOException(zipClosed.toString());
        }
    }

    public ZipFile getZipFile() {
        return this.zipFile;
    }

    public boolean isUsing(java.io.File aSystemFile) {
        return this.getFile() != null && this.getFile().equals(aSystemFile);
    }

    public void setFile(java.io.File newFile) {
        this.file = newFile;
    }

    public void setZipFile(ZipFile newZipFile) {
        this.zipFile = newZipFile;
    }
}

