/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.java.adapters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jem.internal.java.adapters.JavaXMIFactoryImpl;
import org.eclipse.jem.java.ArrayType;
import org.eclipse.jem.java.Field;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaDataType;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaParameter;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jem.java.Method;
import org.eclipse.jem.java.adapters.IJavaReflectionKey;
import org.eclipse.jem.java.adapters.IJavaReflectionKeyExtension;
import org.eclipse.jem.util.CharacterUtil;

public class JavaReflectionKey
implements IJavaReflectionKey {
    private static final Collection PRIMITIVES = new ArrayList(8);
    protected JavaXMIFactoryImpl.JavaXMIResource resource;
    protected List extensions;

    static {
        JavaReflectionKey.initializePrimitivesCollection();
    }

    public JavaReflectionKey(List extensions, JavaXMIFactoryImpl.JavaXMIResource resource) {
        this.extensions = extensions;
        this.resource = resource;
    }

    public ArrayType createArrayType() {
        return JavaReflectionKey.getJavaFactory().createArrayType();
    }

    public JavaClass createJavaClass() {
        return JavaReflectionKey.getJavaFactory().createJavaClass();
    }

    protected EClassifier getJavaDataType(String typeName) {
        JavaDataType result = JavaReflectionKey.getJavaFactory().createJavaDataType();
        result.setName(typeName);
        this.getPackage().getEClassifiers().add(result);
        this.resource.setID(result, typeName);
        return result;
    }

    public Field createJavaField() {
        return JavaReflectionKey.getJavaFactory().createField();
    }

    public Method createJavaMethod() {
        return JavaReflectionKey.getJavaFactory().createMethod();
    }

    public JavaParameter createJavaParameter() {
        return JavaReflectionKey.getJavaFactory().createJavaParameter();
    }

    public Object get(String key) {
        Object javaObject = this.getObjectFromExtensions(key);
        if (javaObject == null) {
            javaObject = this.getJavaObject(key);
        }
        return javaObject;
    }

    public EClassifier getArrayType(String typeName) {
        ArrayType arrayType = this.createArrayType();
        arrayType.setName(typeName);
        int pos = -1;
        int braces = 0;
        do {
            if ((pos = typeName.indexOf("[", pos + 1)) == -1) continue;
            ++braces;
        } while (pos != -1);
        arrayType.setArrayDimensions(braces);
        this.getPackage().getEClassifiers().add(arrayType);
        this.resource.setID(arrayType, typeName);
        return arrayType;
    }

    public EClassifier getJavaClass(String typeName) {
        JavaClass javaClass = this.createJavaClass();
        javaClass.setName(typeName);
        this.getPackage().getEClassifiers().add(javaClass);
        this.resource.setID(javaClass, typeName);
        return javaClass;
    }

    protected static JavaRefFactory getJavaFactory() {
        return JavaRefFactory.eINSTANCE;
    }

    protected Field getJavaField(String keyValue) {
        Field result = null;
        int memberDelimiter = keyValue.indexOf(46);
        String className = keyValue.substring(0, memberDelimiter);
        String memberName = keyValue.substring(memberDelimiter + 1);
        EClassifier javaClass = (EClassifier)this.primGet(className);
        if (javaClass == null) {
            javaClass = this.getJavaType(className);
        }
        if (javaClass != null && !((JavaHelpers)javaClass).isPrimitive()) {
            ((JavaClass)javaClass).getFields();
            result = (Field)this.primGet(keyValue);
            if (result == null) {
                Field tempField = this.createJavaField();
                tempField.setName(memberName);
                ((JavaClass)javaClass).getFields().add(tempField);
                result = tempField;
            }
        }
        return result;
    }

    protected Method getJavaMethod(String keyValue) {
        Method result = null;
        int memberDelimiter = keyValue.indexOf(46);
        String className = keyValue.substring(0, memberDelimiter);
        int parmDelimiter = keyValue.indexOf(40, memberDelimiter);
        String memberName = keyValue.substring(memberDelimiter + 1, parmDelimiter);
        EClassifier javaClass = (EClassifier)this.primGet(className);
        if (javaClass == null) {
            javaClass = this.getJavaType(className);
        }
        if (javaClass != null && !((JavaHelpers)javaClass).isPrimitive()) {
            ((JavaClass)javaClass).getMethods();
            result = (Method)this.primGet(keyValue);
            if (result == null) {
                Method tempMethod = this.createJavaMethod();
                tempMethod.setName(memberName);
                this.resource.setID(tempMethod, keyValue);
                ((JavaClass)javaClass).getMethods().add(tempMethod);
                result = tempMethod;
            }
        }
        return result;
    }

    public EObject getJavaObject(String keyValue) {
        ENamedElement result = null;
        int index = keyValue.indexOf(46);
        if (index > 0) {
            boolean isParameter;
            boolean bl = isParameter = keyValue.indexOf(45, index) != -1;
            if (isParameter) {
                result = this.getJavaParameter(keyValue);
            } else {
                boolean isField;
                int parmStart = keyValue.indexOf(40, index);
                boolean bl2 = isField = parmStart == -1;
                result = isField ? this.getJavaField(keyValue) : this.getJavaMethod(keyValue);
            }
        } else {
            result = this.getJavaType(keyValue);
        }
        return result;
    }

    protected Object getObjectFromExtensions(String keyValue) {
        if (this.extensions != null) {
            Iterator iter = this.extensions.iterator();
            while (iter.hasNext()) {
                IJavaReflectionKeyExtension extension2 = (IJavaReflectionKeyExtension)iter.next();
                Object obj = extension2.getObject(keyValue, this);
                if (obj == null) continue;
                return obj;
            }
        }
        return null;
    }

    protected JavaParameter getJavaParameter(String keyValue) {
        JavaParameter result = null;
        int memberDelimiter = keyValue.indexOf(46);
        int parmDelimiter = keyValue.indexOf(45, memberDelimiter);
        String parmName = keyValue.substring(parmDelimiter + 1);
        Method method2 = this.getJavaMethod(keyValue.substring(parmDelimiter));
        if (method2 != null && (result = method2.getParameter(parmName)) == null) {
            JavaParameter tempParameter = this.createJavaParameter();
            tempParameter.setName(parmName);
            method2.getParameters().add(tempParameter);
            result = tempParameter;
        }
        return result;
    }

    public EClassifier getJavaType(String typeName) {
        if (this.isPrimitive(typeName)) {
            return this.getJavaDataType(typeName);
        }
        if (this.isArray(typeName)) {
            return this.getArrayType(typeName);
        }
        if (this.isValidJavaIdentifier(typeName)) {
            return this.getJavaClass(typeName);
        }
        return null;
    }

    protected boolean isValidJavaIdentifier(String typeName) {
        CharacterUtil.StringIterator charIter;
        if (typeName.length() > 0 && CharacterUtil.isJavaIdentifierStart((charIter = new CharacterUtil.StringIterator(typeName)).next())) {
            while (charIter.hasNext()) {
                if (CharacterUtil.isJavaIdentifierPart(charIter.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Object primGet(String key) {
        return this.resource.primGetEObject(key);
    }

    protected EPackage getPackage() {
        return (EPackage)EcoreUtil.getObjectByType(this.resource.getContents(), EcorePackage.eINSTANCE.getEPackage());
    }

    private static void initializePrimitivesCollection() {
        PRIMITIVES.add("void");
        PRIMITIVES.add("boolean");
        PRIMITIVES.add("byte");
        PRIMITIVES.add("char");
        PRIMITIVES.add("double");
        PRIMITIVES.add("float");
        PRIMITIVES.add("int");
        PRIMITIVES.add("long");
        PRIMITIVES.add("short");
    }

    public boolean isArray(String typeName) {
        return typeName.endsWith("[]");
    }

    private boolean isPrimitive(String typeName) {
        return PRIMITIVES.contains(typeName);
    }
}

