/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.util.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.soap.encoding.soapenc.Base64;
import org.apache.soap.util.net.HTTPUtils;
import sun.net.www.protocol.http.HttpURLConnection;

public class SSLUtils {
    static String tunnelHost;
    static int tunnelPort;
    static String tunnelUserName;
    static String tunnelUserPassword;
    public static boolean traceEnabled;
    static int workedLast;

    public static final boolean isTrueExplicitly(String string) {
        return string != null && (string.equalsIgnoreCase("true") || string.equals("1") || string.equalsIgnoreCase("yes"));
    }

    public static Socket buildSSLSocket(String string, int n, String string2, int n2, String string3, String string4) throws IOException, UnknownHostException {
        boolean bl;
        if (traceEnabled) {
            System.out.println("org.apache.soap.util.net.SSLUtils.buildSSLSocket > Entry");
            System.out.println("org.apache.soap.util.net.SSLUtils.buildSSLSocket (input values):\n  host={" + string + "}\n  port={" + n + "}\n  proxyHost={" + tunnelHost + "}\n  proxyPort={" + tunnelPort + "}");
            if (tunnelUserName != null && !"".equals(tunnelUserName)) {
                System.out.println("  proxyUserName={*****}");
            } else {
                System.out.println("  proxyUserName={" + tunnelUserName + "}");
            }
            if (tunnelUserPassword != null && !"".equals(tunnelUserPassword)) {
                System.out.println("  proxyPassword={*****}");
            } else {
                System.out.println("  proxyPassword={" + tunnelUserPassword + "}");
            }
        }
        SSLSocket sSLSocket = null;
        SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        tunnelHost = System.getProperty("https.proxyHost");
        tunnelPort = Integer.getInteger("https.proxyPort", 80);
        tunnelUserName = System.getProperty("https.proxyUserName");
        tunnelUserPassword = System.getProperty("https.proxyPassword");
        String string5 = System.getProperty("https.nonProxyHosts");
        if (traceEnabled) {
            System.out.println("org.apache.soap.util.net.SSLUtils.buildSSLSocket (system values):\n  https.nonProxyHosts={" + string5 + "}\n  https.proxyHost={" + tunnelHost + "}\n  https.proxyPort={" + tunnelPort + "}");
            if (tunnelUserName != null && !"".equals(tunnelUserName)) {
                System.out.println("  https.proxyUserName={*****}");
            } else {
                System.out.println("  https.proxyUserName={" + tunnelUserName + "}");
            }
            if (tunnelUserPassword != null && !"".equals(tunnelUserPassword)) {
                System.out.println("  https.proxyPassword={*****}");
            } else {
                System.out.println("  https.proxyPassword={" + tunnelUserPassword + "}");
            }
        }
        if (tunnelHost != null) {
            bl = HTTPUtils.shouldUseProxy(string, string5);
        } else {
            tunnelHost = string2;
            tunnelPort = n2;
            tunnelUserName = string3;
            tunnelUserPassword = string4;
            bl = HTTPUtils.shouldUseProxy(string, string5);
        }
        if (traceEnabled) {
            System.out.println("org.apache.soap.util.net.SSLUtils.buildSSLSocket (final values):\n  shouldTunnel={" + bl + "}\n  tunnelHost={" + tunnelHost + "}\n  tunnelPort={" + tunnelPort + "}\n  host={" + string + "}\n  port={" + n + "}");
            if (tunnelUserName != null && !"".equals(tunnelUserName)) {
                System.out.println("  tunnelUserName={*****}");
            } else {
                System.out.println("  tunnelUserName={" + tunnelUserName + "}");
            }
            if (tunnelUserPassword != null && !"".equals(tunnelUserPassword)) {
                System.out.println("  tunnelUserPassword={*****}");
            } else {
                System.out.println("  tunnelUserPassword={" + tunnelUserPassword + "}");
            }
        }
        if (tunnelHost == null || !bl) {
            sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(string, n);
            if (traceEnabled) {
                System.out.println("org.apache.soap.util.net.SSLUtils.buildSSLSocket: SSL socket created successfully");
            }
        } else {
            Socket socket = SSLUtils.doTunnelHandshake(string, n, tunnelHost, tunnelPort, tunnelUserName, tunnelUserPassword);
            if (traceEnabled) {
                System.out.println("org.apache.soap.util.net.SSLUtils.buildSSLSocket: Returned from doTunnelHandshake");
            }
            if (traceEnabled) {
                System.out.println("org.apache.soap.util.net.SSLUtils.buildSSLSocket: Creating SSL socket through tunnel.");
            }
            sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(socket, string, n, true);
            if (traceEnabled) {
                System.out.println("org.apache.soap.util.net.SSLUtils.buildSSLSocket: SSL socket through tunnel created successfully");
            }
        }
        sSLSocket.startHandshake();
        if (traceEnabled) {
            System.out.println("org.apache.soap.util.net.SSLUtils.buildSSLSocket: Returned from sslSocket.startHandshake");
        }
        if (traceEnabled) {
            System.out.println("org.apache.soap.util.net.SSLUtils.buildSSLSocket < Exit");
        }
        return sSLSocket;
    }

    private static Socket doTunnelHandshake(String string, int n, String string2, int n2, String string3, String string4) throws IOException {
        if (traceEnabled) {
            System.out.println("org.apache.soap.util.net.SSLUtils.doTunnelHandshake > Entry");
        }
        String string5 = null;
        int n3 = 2;
        int n4 = workedLast;
        boolean bl = false;
        int n5 = 0;
        Socket socket = null;
        for (int i = n4; i < n3; ++i) {
            String string6;
            byte[] byArray;
            if (bl) {
                if (i == n4) {
                    continue;
                }
            } else {
                bl = true;
            }
            if (traceEnabled) {
                System.out.println("org.apache.soap.util.net.SSLUtils.doTunnelHandshake: Opening socket to " + string2 + ":" + n2);
            }
            socket = new Socket(string2, n2);
            OutputStream outputStream = socket.getOutputStream();
            ++n5;
            switch (i) {
                case 0: {
                    if (string3 == null || string4 == null) {
                        string5 = "CONNECT " + string + ":" + n + " HTTP/1.0\n" + "User-Agent: " + HttpURLConnection.userAgent + "\r\n\r\n";
                        break;
                    }
                    string5 = "CONNECT " + string + ":" + n + " HTTP/1.0\n" + "User-Agent: " + HttpURLConnection.userAgent + "\nProxy-authorization: " + " basic " + Base64.encode((string3 + ":" + string4).getBytes("8859_1")) + "\r\n\r\n";
                    break;
                }
                case 1: {
                    string5 = string3 == null || string4 == null ? "CONNECT " + string + ":" + n + " HTTP/1.0" + "\r\nUser-Agent: " + HttpURLConnection.userAgent + "\r\n\r\n" : "CONNECT " + string + ":" + n + " HTTP/1.0" + "\r\nProxy-Authorization: Basic " + Base64.encode((string3 + ":" + string4).getBytes("8859_1")) + "\r\nUser-Agent: " + HttpURLConnection.userAgent + "\r\n\r\n";
                }
            }
            if (traceEnabled) {
                System.out.println("org.apache.soap.util.net.SSLUtils.doTunnelHandshake: Attempting proxy string " + i);
                System.out.println("org.apache.soap.util.net.SSLUtils.doTunnelHandshake: msg to tunnel={\n" + string5 + "}");
            }
            try {
                byArray = string5.getBytes("ASCII7");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                byArray = string5.getBytes();
            }
            outputStream.write(byArray);
            outputStream.flush();
            if (traceEnabled) {
                System.out.println("org.apache.soap.util.net.SSLUtils.doTunnelHandshake: out.write was successful");
            }
            byte[] byArray2 = new byte[200];
            int n6 = 0;
            int n7 = 0;
            boolean bl2 = false;
            InputStream inputStream = socket.getInputStream();
            boolean bl3 = false;
            while (n7 < 2) {
                int n8 = inputStream.read();
                if (n8 < 0) {
                    if (traceEnabled) {
                        System.out.println("org.apache.soap.util.net.SSLUtils.doTunnelHandshake: Unexpected EOF from proxy");
                    }
                    throw new IOException("Unexpected EOF from proxy");
                }
                if (n8 == 10) {
                    bl2 = true;
                    ++n7;
                    continue;
                }
                if (n8 == 13) continue;
                n7 = 0;
                if (bl2 || n6 >= byArray2.length) continue;
                byArray2[n6++] = (byte)n8;
            }
            try {
                string6 = new String(byArray2, 0, n6, "ASCII7");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string6 = new String(byArray2, 0, n6);
            }
            if (traceEnabled) {
                System.out.println("org.apache.soap.util.net.SSLUtils.doTunnelHandshake: return from tunnel={" + string6 + "}");
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string6);
            stringTokenizer.nextToken();
            if (!stringTokenizer.nextToken().startsWith("200")) {
                if (n5 == n3) {
                    String string7 = "Unable to tunnel through " + string2 + ":" + n2 + ".  Proxy returns \"" + string6 + "\"";
                    if (traceEnabled) {
                        System.out.println("org.apache.soap.util.net.SSLUtils.doTunnelHandshake: " + string7);
                    }
                    throw new IOException(string7);
                }
                if (i == n4 && i != 0) {
                    i = -1;
                }
                if (traceEnabled) {
                    System.out.println("org.apache.soap.util.net.SSLUtils.doTunnelHandshake: Closing socket, retry with different string.");
                }
                socket.close();
                continue;
            }
            workedLast = i;
        }
        if (traceEnabled) {
            System.out.println("org.apache.soap.util.net.SSLUtils.doTunnelHandshake < Exit");
        }
        return socket;
    }

    static {
        traceEnabled = false;
        String string = "org.apache.soap.debug";
        try {
            String string2 = System.getProperty(string);
            boolean bl = SSLUtils.isTrueExplicitly(string2);
            if (bl) {
                traceEnabled = true;
            }
            if (traceEnabled) {
                String string3 = bl ? "enabled" : "disabled";
                System.out.println(string + " is " + string3);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        workedLast = 0;
    }
}

