/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.transport.http;

import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.StringTokenizer;
import java.util.Vector;

public class Cookie {
    private static final int DEFAULT_HTTP_PORT = 80;
    private long createdMillis;
    private URL url;
    private String defaultDomain;
    private int defaultPort;
    private String defaultPath;
    private String name;
    private String value;
    private String comment = null;
    private String domain = null;
    private long maxAge = Long.MAX_VALUE;
    private String path = null;
    private boolean secure = false;
    private String version = null;
    private String commentURL = null;
    private boolean discard = false;
    private int[] port = null;
    private long expires = Long.MAX_VALUE;
    private static SimpleDateFormat dateParser = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss z");

    public Cookie(URL uRL, String string) {
        String string2;
        String string3;
        string = Cookie.removeLeadingSpaces(string);
        int n = string.indexOf(59);
        if (n != -1) {
            string3 = string.substring(0, n);
            string2 = string.length() > n ? string.substring(n + 1) : "";
        } else {
            string3 = string;
            string2 = "";
        }
        n = string3.indexOf(61);
        if (n != -1) {
            this.name = string3.substring(0, n);
            this.value = string3.length() > n ? Cookie.removeEnclosingQuotes(string3.substring(n + 1)) : "";
        } else {
            this.name = string3;
            this.value = "";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string4;
            String string5;
            string3 = Cookie.removeLeadingSpaces(stringTokenizer.nextToken());
            n = string3.indexOf(61);
            if (n != -1) {
                string5 = string3.substring(0, n);
                string4 = string3.length() > n ? Cookie.removeEnclosingQuotes(string3.substring(n + 1)) : "";
            } else {
                string5 = string3;
                string4 = "";
            }
            if (string5.equalsIgnoreCase("Comment")) {
                if (this.comment != null) continue;
                this.comment = string4;
                continue;
            }
            if (string5.equalsIgnoreCase("Domain")) {
                if (this.domain != null) continue;
                this.domain = string4;
                continue;
            }
            if (string5.equalsIgnoreCase("Max-Age")) {
                if (this.maxAge != Long.MAX_VALUE) continue;
                try {
                    this.maxAge = Long.parseLong(string4);
                    this.expires = System.currentTimeMillis() + this.maxAge * 1000L;
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (string5.equalsIgnoreCase("Path")) {
                if (this.path != null) continue;
                this.path = string4;
                continue;
            }
            if (string5.equalsIgnoreCase("Secure")) {
                this.secure = true;
                continue;
            }
            if (string5.equalsIgnoreCase("Version")) {
                if (this.version != null) continue;
                this.version = string4;
                continue;
            }
            if (string5.equalsIgnoreCase("CommentURL")) {
                if (this.commentURL != null) continue;
                this.commentURL = string4;
                continue;
            }
            if (string5.equalsIgnoreCase("Discard")) {
                this.version = string4;
                continue;
            }
            if (string5.equalsIgnoreCase("Port")) {
                if (this.port != null) continue;
                if (string4.length() == 0) {
                    this.port = new int[0];
                    continue;
                }
                try {
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string4, ",");
                    int[] nArray = new int[stringTokenizer2.countTokens()];
                    int n2 = 0;
                    while (stringTokenizer2.hasMoreTokens()) {
                        nArray[n2++] = Integer.parseInt(stringTokenizer2.nextToken());
                    }
                    this.port = nArray;
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (!string5.equalsIgnoreCase("Expires") || this.expires != Long.MAX_VALUE) continue;
            try {
                this.expires = dateParser.parse(string4).getTime();
            }
            catch (ParseException parseException) {}
        }
        this.setURL(uRL);
        this.createdMillis = System.currentTimeMillis();
    }

    public static String buildCookieValue(URL uRL, Cookie[] cookieArray) {
        StringBuffer stringBuffer = new StringBuffer(512);
        for (int i = 0; i < cookieArray.length; ++i) {
            Cookie cookie = cookieArray[i];
            if (cookie.getExpired() || !cookie.sendToURL(uRL)) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(';');
            }
            stringBuffer.append(cookie.toString());
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Cookie)) {
            return false;
        }
        Cookie cookie = (Cookie)object;
        return this.name.equals(cookie.name) && this.value.equals(cookie.value) && Cookie.sameAttribute(this.domain, this.defaultDomain, cookie.domain, cookie.defaultDomain) && Cookie.sameAttribute(this.path, this.defaultPath, cookie.path, cookie.defaultPath) && Cookie.samePort(this.port, this.defaultPort, cookie.port, cookie.defaultPort);
    }

    public boolean getExpired() {
        return System.currentTimeMillis() > this.expires;
    }

    public static Cookie[] parseCookies(URL uRL, String string) {
        int n;
        int n2 = 0;
        boolean bl = false;
        Vector<Cookie> vector = new Vector<Cookie>();
        for (int i = 0; i < string.length(); ++i) {
            n = string.charAt(i);
            if (n == 34) {
                bl = !bl;
                continue;
            }
            if (n != 44 || bl || i >= 11 && string.substring(i - 11, i - 3).equalsIgnoreCase("expires=")) continue;
            vector.addElement(new Cookie(uRL, string.substring(n2, i)));
            n2 = i + 1;
        }
        if (n2 < string.length()) {
            vector.addElement(new Cookie(uRL, string.substring(n2)));
        }
        Cookie[] cookieArray = new Cookie[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            cookieArray[n] = (Cookie)vector.elementAt(n);
        }
        return cookieArray;
    }

    private static String removeEnclosingQuotes(String string) {
        return string.startsWith("\"") && string.endsWith("\"") ? string.substring(1, string.length() - 1) : string;
    }

    private static String removeLeadingSpaces(String string) {
        int n;
        for (n = 0; n < string.length() && string.charAt(n) == ' '; ++n) {
        }
        return n == 0 ? string : string.substring(n);
    }

    private static boolean sameAttribute(String string, String string2, String string3, String string4) {
        if (string != null && string3 != null) {
            return string.equals(string3);
        }
        if (string == null && string3 == null) {
            return string2.equals(string4);
        }
        return false;
    }

    public static boolean sameCookie(Cookie cookie, Cookie cookie2) {
        return cookie.name.equals(cookie2.name) && Cookie.sameAttribute(cookie.domain, cookie.defaultDomain, cookie2.domain, cookie2.defaultDomain) && Cookie.sameAttribute(cookie.path, cookie.defaultPath, cookie2.path, cookie2.defaultPath) && Cookie.samePort(cookie.port, cookie.defaultPort, cookie2.port, cookie2.defaultPort);
    }

    private static boolean samePort(int[] nArray, int n, int[] nArray2, int n2) {
        if (nArray != null && nArray2 != null) {
            if (nArray.length != nArray2.length) {
                return false;
            }
            if (nArray.length == 0) {
                return n == n2;
            }
            for (int i = 0; i < nArray.length; ++i) {
                int n3;
                for (n3 = 0; n3 < nArray2.length && nArray[i] != nArray2[n3]; ++n3) {
                }
                if (n3 < nArray2.length) continue;
                return false;
            }
            return true;
        }
        return nArray == null && nArray2 == null;
    }

    public boolean sendToURL(URL uRL) {
        if (this.domain != null ? uRL.getHost().indexOf(this.domain) == -1 : uRL.getHost().indexOf(this.defaultDomain) == -1) {
            return false;
        }
        if (this.path != null ? !uRL.getFile().startsWith(this.path) : !uRL.getFile().startsWith(this.defaultPath)) {
            return false;
        }
        if (this.port != null) {
            int n = uRL.getPort();
            if (n == -1) {
                n = 80;
            }
            if (this.port.length == 0) {
                if (this.defaultPort != n) {
                    return false;
                }
            } else {
                int n2;
                for (n2 = 0; n2 < this.port.length && this.port[n2] != n; ++n2) {
                }
                if (n2 >= this.port.length) {
                    return false;
                }
            }
        }
        return true;
    }

    private void setURL(URL uRL) {
        this.url = uRL;
        this.defaultDomain = uRL.getHost();
        this.defaultPort = uRL.getPort();
        if (this.defaultPort == -1) {
            this.defaultPort = 80;
        }
        this.defaultPath = uRL.getFile();
        int n = this.defaultPath.lastIndexOf(47);
        if (n != -1) {
            this.defaultPath = this.defaultPath.substring(0, n);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(512);
        if (this.version != null) {
            stringBuffer.append(";$version=");
            stringBuffer.append(this.version);
        }
        stringBuffer.append(this.name);
        stringBuffer.append('=');
        stringBuffer.append(this.value);
        if (this.domain != null) {
            stringBuffer.append(";$domain=");
            stringBuffer.append(this.domain);
        }
        if (this.path != null) {
            stringBuffer.append(";$path=");
            stringBuffer.append(this.path);
        }
        if (this.port != null) {
            stringBuffer.append(";$port");
            if (this.port.length > 0) {
                stringBuffer.append("=\"");
                for (int i = 0; i < this.port.length; ++i) {
                    if (i > 0) {
                        stringBuffer.append(',');
                    }
                    stringBuffer.append(this.port[i]);
                }
                stringBuffer.append('\"');
            }
        }
        return stringBuffer.toString();
    }

    public static Cookie[] updateCookies(Cookie[] cookieArray, Cookie[] cookieArray2) {
        int n;
        Cookie[] cookieArray3;
        int n2;
        Vector<Cookie[]> vector = new Vector<Cookie[]>();
        for (n2 = 0; n2 < cookieArray2.length; ++n2) {
            cookieArray3 = cookieArray2[n2];
            Cookie cookie = null;
            for (n = 0; n < cookieArray.length && !Cookie.sameCookie(cookie = cookieArray[n], (Cookie)cookieArray3); ++n) {
            }
            if (n < cookieArray.length) {
                cookie.value = cookieArray3.value;
                cookie.comment = cookieArray3.comment;
                cookie.commentURL = cookieArray3.commentURL;
                cookie.maxAge = cookieArray3.maxAge;
                cookie.secure = cookieArray3.secure;
                cookie.version = cookieArray3.version;
                cookie.expires = cookieArray3.expires;
                continue;
            }
            vector.addElement(cookieArray3);
        }
        if (vector.size() == 0) {
            return cookieArray;
        }
        cookieArray3 = new Cookie[cookieArray.length + vector.size()];
        for (n2 = 0; n2 < cookieArray.length; ++n2) {
            cookieArray3[n2] = cookieArray[n2];
        }
        for (n = 0; n < vector.size(); ++n) {
            cookieArray3[n2 + n] = (Cookie)vector.elementAt(n);
        }
        return cookieArray3;
    }
}

