/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soap.security.dsig;

import com.ibm.trl.soap.SOAPHeaderEntry;
import com.ibm.trl.soapimpl.SOAPDocumentImpl;
import com.ibm.trl.util.Logger;
import com.ibm.trl.util.xml.XPathProcessor;
import com.ibm.ws.wssecurity.xss4j.domutil.XPathCanonicalizer;
import com.ibm.ws.wssecurity.xss4j.dsig.KeyInfo;
import com.ibm.ws.wssecurity.xss4j.dsig.SignatureStructureException;
import com.ibm.ws.wssecurity.xss4j.dsig.XSignatureException;
import com.ibm.xml.soap.security.dsig.AlgorithmChecker;
import com.ibm.xml.soap.security.dsig.AuthenticatedPartsChecker;
import com.ibm.xml.soap.security.dsig.PKIXChecker;
import com.ibm.xml.soap.security.dsig.SOAPDSigLogger;
import com.ibm.xml.soap.security.dsig.SOAPSignatureHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.LDAPCertStoreParameters;
import java.security.cert.PKIXParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.soap.Constants;
import org.apache.soap.SOAPException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class SOAPVerifier
extends SOAPSignatureHandler {
    private static final String XPATH_CONFIG = "/" + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "SOAPVerifierConfig");
    private static final String XPATH_ACTOR = XPATH_CONFIG + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "SOAPActor");
    private static final String XPATH_ALLOWEDALGORITHMS = XPATH_CONFIG + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "AllowedAlgorithms");
    private static final String XPATH_ALGORITHM = XPATH_ALLOWEDALGORITHMS + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "Algorithm");
    private static final String XPATH_DEFAULTVERIFICATIONKEYS = XPATH_CONFIG + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "DefaultVerificationKeys");
    private static final String XPATH_DEFAULTPUBLICKEY = XPATH_DEFAULTVERIFICATIONKEYS + '/' + XPathProcessor.getXPath("http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
    private static final String XPATH_REQUIREDAUTHENTICATEDPARTS = XPATH_CONFIG + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "RequiredAuthenticatedParts");
    private static final String XPATH_REFERENCE = XPATH_REQUIREDAUTHENTICATEDPARTS + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "Reference");
    private static final String XPATH_PART = XPATH_REFERENCE + "/@part";
    private static final String XPATH_PKIXPARAMETERS = XPATH_CONFIG + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "PKIXParameters");
    private static final String XPATH_TRUSTANCHORLIST = XPATH_PKIXPARAMETERS + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "TrustAnchorList");
    private static final String XPATH_TRUSTANCHOR = XPATH_TRUSTANCHORLIST + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "TrustAnchor");
    private static final String XPATH_TRUSTANCHOR_KEYINFO = XPATH_TRUSTANCHOR + '/' + XPathProcessor.getXPath("http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
    private static final String XPATH_TRUSTANCHOR_KEYSTORE = XPATH_TRUSTANCHOR + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "KeyStore");
    private static final String XPATH_TRUSTEDROOTLIST = XPATH_PKIXPARAMETERS + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "TrustedRootList");
    private static final String XPATH_TRUSTEDROOT = XPATH_TRUSTEDROOTLIST + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "TrustedRoot");
    private static final String XPATH_TRUSTEDROOT_KEYINFO = XPATH_TRUSTEDROOT + '/' + XPathProcessor.getXPath("http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
    private static final String XPATH_TRUSTEDROOT_KEYSTORE = XPATH_TRUSTEDROOT + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "KeyStore");
    private static final String XPATH_INITIALPOLICIES = XPATH_PKIXPARAMETERS + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "InitialPolicies");
    private static final String XPATH_CERTIFICATEPOLICY = XPATH_INITIALPOLICIES + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "CertificatePolicy");
    private static final String XPATH_POLICYMAPPINGINHIBITED = XPATH_PKIXPARAMETERS + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "PolicyMappingInhibited");
    private static final String XPATH_EXPLICITPOLICYREQUIRED = XPATH_PKIXPARAMETERS + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "ExplicitPolicyRequired");
    private static final String XPATH_REVOCATIONENABLED = XPATH_PKIXPARAMETERS + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "RevocationEnabled");
    private static final String XPATH_TARGETKEYUSAGE = XPATH_PKIXPARAMETERS + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "TargetKeyUsage");
    private static final String XPATH_KEYUSAGE = XPATH_TARGETKEYUSAGE + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "KeyUsage");
    private static final String XPATH_TARGETEXTENDEDKEYUSAGE = XPATH_PKIXPARAMETERS + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "TargetExtendedKeyUsage");
    private static final String XPATH_EXTENDEDKEYUSAGE = XPATH_TARGETEXTENDEDKEYUSAGE + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "ExtendedKeyUsage");
    private static final String XPATH_CERTSTORELIST = XPATH_PKIXPARAMETERS + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "CertStoreList");
    private static final String XPATH_LDAPCERTSTORE = XPATH_CERTSTORELIST + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "LDAPCertStore");
    private static final String XPATH_LDAPSERVER = XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "LDAPServer");
    private static final String XPATH_COLLECTIONCERTSTORE = XPATH_CERTSTORELIST + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "CollectionCertStore");
    private static final String XPATH_X509CERTIFICATE = XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "X509Certificate");
    private static final String XPATH_CANONICALIZATIONMETHOD = ".//" + XPathProcessor.getXPath("http://www.w3.org/2000/09/xmldsig#", "CanonicalizationMethod");
    private static final String XPATH_SIGNATUREMETHOD = ".//" + XPathProcessor.getXPath("http://www.w3.org/2000/09/xmldsig#", "SignatureMethod");
    private static final String XPATH_DIGESTMETHOD = ".//" + XPathProcessor.getXPath("http://www.w3.org/2000/09/xmldsig#", "DigestMethod");
    private static final String XPATH_TRANSFORM = ".//" + XPathProcessor.getXPath("http://www.w3.org/2000/09/xmldsig#", "Transform");
    private static final String XPATH_ENCODING = ".//*/@Encoding";
    private static final String XPATH_LOG = XPATH_CONFIG + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "Log");
    private static final String XPATH_SOAPDSIGLOGGER = XPATH_LOG + '/' + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "SOAPDSigLogger");
    private String verifierActorURI;
    private AlgorithmChecker algorithmChecker;
    private AuthenticatedPartsChecker authenticatedPartsChecker;
    private List defaultPublicKeys;
    private List soapDSigLoggers;
    private PKIXChecker pkixChecker;
    private static final String ALGORITHM = "LDAP";
    private static final Map KEY_USAGE_TABLE = new HashMap();

    public void initialize(InputSource inputSource) throws SOAPException {
        Document document = this.loadDocument(inputSource, false);
        this.verifierActorURI = this.getActorURI(document);
        Logger.normal("Verifier actor URI: " + this.verifierActorURI, 3);
        this.algorithmChecker = this.getAlgorithmChecker(document);
        this.authenticatedPartsChecker = this.getAuthenticatedPartsChecker(document);
        this.defaultPublicKeys = this.getDefaultPublicKeys(document);
        this.soapDSigLoggers = this.getSOAPDSigLoggers(document);
        this.pkixChecker = this.getPKIXChecker(document);
    }

    private String getActorURI(Document document) throws SOAPException {
        NodeList nodeList = SOAPVerifier.processXPath(document, XPATH_ACTOR);
        if (nodeList == null || nodeList.getLength() < 1) {
            return "";
        }
        Element element = (Element)nodeList.item(0);
        if (element == null) {
            return "";
        }
        return element.getAttribute("URI");
    }

    private List getSOAPDSigLoggers(Document document) throws SOAPException {
        String string = null;
        try {
            LinkedList<SOAPDSigLogger> linkedList = new LinkedList<SOAPDSigLogger>();
            NodeList nodeList = SOAPVerifier.processXPath(document, XPATH_SOAPDSIGLOGGER);
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element = (Element)nodeList.item(i);
                string = element.getAttribute("class");
                Class<?> clazz = Class.forName(string);
                SOAPDSigLogger sOAPDSigLogger = (SOAPDSigLogger)clazz.newInstance();
                sOAPDSigLogger.init(element, this.home);
                linkedList.add(sOAPDSigLogger);
                Logger.normal("SOAPDSigLogger: class='" + clazz.getName() + "' params='" + new String(XPathCanonicalizer.serializeSubset((Node)element, (boolean)true)) + "' instance='" + sOAPDSigLogger + "'", 3);
            }
            return linkedList;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Can't load class: '" + string + "', please check your CLASSPATH and the class name.", classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Can't access to the constructor of " + string, illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Can't instantiate '" + string + "'", instantiationException);
        }
    }

    private AlgorithmChecker getAlgorithmChecker(Document document) throws SOAPException {
        AlgorithmChecker algorithmChecker = new AlgorithmChecker();
        NodeList nodeList = SOAPVerifier.processXPath(document, XPATH_ALGORITHM);
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element = (Element)nodeList.item(i);
            algorithmChecker.add(new AlgorithmChecker.Algorithm(element.getAttribute("type"), element.getAttribute("URI")));
        }
        Logger.normal("Allowed Algorithms: " + algorithmChecker, 3);
        return algorithmChecker;
    }

    private AuthenticatedPartsChecker getAuthenticatedPartsChecker(Document document) throws SOAPException {
        AuthenticatedPartsChecker authenticatedPartsChecker = new AuthenticatedPartsChecker();
        NodeList nodeList = SOAPVerifier.processXPath(document, XPATH_PART);
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            authenticatedPartsChecker.setFlag(nodeList.item(i).getNodeValue());
        }
        Logger.normal("Required Authenticated Parts: " + authenticatedPartsChecker, 3);
        return authenticatedPartsChecker;
    }

    private List getDefaultPublicKeys(Document document) throws SOAPException {
        LinkedList<KeyInfo> linkedList = new LinkedList<KeyInfo>();
        NodeList nodeList = SOAPVerifier.processXPath(document, XPATH_DEFAULTPUBLICKEY);
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            linkedList.add(this.createKeyInfo((Element)nodeList.item(i)));
        }
        return linkedList;
    }

    private static boolean checkOID(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (".0123456789".indexOf(c) >= 0) continue;
            return false;
        }
        return true;
    }

    private PKIXChecker getPKIXChecker(Document document) throws SOAPException {
        Object object;
        String string;
        Object object2;
        int n;
        int n2;
        Object[] objectArray;
        int n3;
        NodeList nodeList;
        Cloneable cloneable;
        PKIXChecker pKIXChecker = null;
        NodeList nodeList2 = SOAPVerifier.processXPath(document, XPATH_TRUSTANCHOR_KEYSTORE);
        NodeList nodeList3 = SOAPVerifier.processXPath(document, XPATH_TRUSTEDROOT_KEYSTORE);
        if (nodeList2.getLength() != 0) {
            pKIXChecker = new PKIXChecker(this.getKeyStore((Element)nodeList2.item(0)));
        } else if (nodeList3.getLength() != 0) {
            pKIXChecker = new PKIXChecker(this.getKeyStore((Element)nodeList3.item(0)));
        } else {
            int n4;
            X509Certificate[] x509CertificateArray;
            KeyInfo keyInfo;
            int n5;
            cloneable = new HashSet();
            nodeList = SOAPVerifier.processXPath(document, XPATH_TRUSTANCHOR_KEYINFO);
            n3 = nodeList.getLength();
            for (n5 = 0; n5 < n3; ++n5) {
                keyInfo = this.createKeyInfo((Element)nodeList.item(n5));
                objectArray = keyInfo.getX509Data();
                for (n2 = 0; n2 < objectArray.length; ++n2) {
                    x509CertificateArray = objectArray[n2].getCertificates();
                    for (n4 = 0; n4 < x509CertificateArray.length; ++n4) {
                        ((HashSet)cloneable).add(x509CertificateArray[n4]);
                    }
                }
            }
            nodeList = SOAPVerifier.processXPath(document, XPATH_TRUSTEDROOT_KEYINFO);
            n3 = nodeList.getLength();
            for (n5 = 0; n5 < n3; ++n5) {
                keyInfo = this.createKeyInfo((Element)nodeList.item(n5));
                objectArray = keyInfo.getX509Data();
                for (n2 = 0; n2 < objectArray.length; ++n2) {
                    x509CertificateArray = objectArray[n2].getCertificates();
                    for (n4 = 0; n4 < x509CertificateArray.length; ++n4) {
                        ((HashSet)cloneable).add(x509CertificateArray[n4]);
                    }
                }
            }
            pKIXChecker = new PKIXChecker((Set)((Object)cloneable));
        }
        cloneable = pKIXChecker.getTemplate();
        nodeList = SOAPVerifier.processXPath(document, XPATH_CERTIFICATEPOLICY + "/text()");
        n3 = nodeList.getLength();
        if (n3 != 0) {
            HashSet<String> hashSet = new HashSet<String>();
            for (int i = 0; i < n3; ++i) {
                hashSet.add(nodeList.item(i).getNodeValue().trim());
            }
            ((PKIXParameters)cloneable).setInitialPolicies(hashSet);
        }
        boolean bl = SOAPVerifier.evalFlag(document, XPATH_POLICYMAPPINGINHIBITED);
        ((PKIXParameters)cloneable).setPolicyMappingInhibited(bl);
        bl = SOAPVerifier.evalFlag(document, XPATH_EXPLICITPOLICYREQUIRED);
        ((PKIXParameters)cloneable).setExplicitPolicyRequired(bl);
        bl = SOAPVerifier.evalFlag(document, XPATH_REVOCATIONENABLED);
        ((PKIXParameters)cloneable).setRevocationEnabled(bl);
        X509CertSelector x509CertSelector = (X509CertSelector)((PKIXParameters)cloneable).getTargetCertConstraints();
        objectArray = new boolean[]{false, false, false, false, false, false, false, false, false};
        nodeList = SOAPVerifier.processXPath(document, XPATH_KEYUSAGE + "/text()");
        n3 = nodeList.getLength();
        for (n2 = 0; n2 < n3; ++n2) {
            this.enableKeyUsage(nodeList.item(n2).getNodeValue().trim(), (boolean[])objectArray);
        }
        if (Logger.getLevel() == 3) {
            HashSet<String> hashSet = new HashSet<String>(objectArray.length);
            for (int i = 0; i < objectArray.length; ++i) {
                hashSet.add(objectArray[i] != false ? "1" : "0");
            }
            Logger.normal("Key Usage: " + hashSet, 3);
        }
        x509CertSelector.setKeyUsage((boolean[])objectArray);
        HashSet<String> hashSet = new HashSet<String>();
        nodeList = SOAPVerifier.processXPath(document, XPATH_EXTENDEDKEYUSAGE + "/text()");
        n3 = nodeList.getLength();
        for (n = 0; n < n3; ++n) {
            String string2 = nodeList.item(n).getNodeValue().trim();
            if (!SOAPVerifier.checkOID(string2)) {
                Logger.normal("OID is needed in an ExtendedKeyUsage element: " + string2, 3);
                continue;
            }
            hashSet.add(string2);
        }
        try {
            Logger.normal("Extended Key Usage: " + hashSet, 3);
            x509CertSelector.setExtendedKeyUsage(hashSet);
        }
        catch (IOException iOException) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Invalid Extended Key Usage: " + hashSet, iOException);
        }
        nodeList = SOAPVerifier.processXPath(document, XPATH_LDAPCERTSTORE);
        n3 = nodeList.getLength();
        for (n = 0; n < n3; ++n) {
            int n6;
            Element element = (Element)nodeList.item(n);
            object2 = element.getAttribute("provider");
            string = SOAPVerifier.processXPath(element, XPATH_LDAPSERVER + "/@host").item(0).getNodeValue();
            object = this.createLDAPCertStore(string, n6 = Integer.parseInt(SOAPVerifier.processXPath(element, XPATH_LDAPSERVER + "/@port").item(0).getNodeValue()), (String)object2);
            if (object == null) continue;
            ((PKIXParameters)cloneable).addCertStore((CertStore)object);
        }
        nodeList = SOAPVerifier.processXPath(document, XPATH_COLLECTIONCERTSTORE);
        n3 = nodeList.getLength();
        HashMap<String, CertificateFactory> hashMap = new HashMap<String, CertificateFactory>();
        for (int i = 0; i < n3; ++i) {
            object2 = (Element)nodeList.item(i);
            string = object2.getAttribute("provider");
            CertificateFactory certificateFactory = (CertificateFactory)hashMap.get(string);
            if (certificateFactory == null) {
                certificateFactory = this.createCertificateFactory(string);
                hashMap.put(string, certificateFactory);
            }
            object = SOAPVerifier.processXPath((Node)object2, XPATH_X509CERTIFICATE + "/@href");
            CertStore certStore = this.createCollectionCertStore((NodeList)object, certificateFactory, string);
            ((PKIXParameters)cloneable).addCertStore(certStore);
        }
        return pKIXChecker;
    }

    private void verify(SOAPHeaderEntry sOAPHeaderEntry) throws SOAPException {
        Element element = this.soapSignature.getSignatureElement(sOAPHeaderEntry);
        this.checkAlgorithm(element, XPATH_CANONICALIZATIONMETHOD);
        this.checkAlgorithm(element, XPATH_SIGNATUREMETHOD);
        this.checkAlgorithm(element, XPATH_DIGESTMETHOD);
        this.checkAlgorithm(element, XPATH_TRANSFORM);
        this.checkEncoding(element);
        this.authenticatedPartsChecker.check(this.soapSignature.getIDResolver(), element);
        Object var3_3 = null;
        NodeList nodeList = element.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
        if (nodeList.getLength() == 0) {
            Element element2 = null;
            Iterator iterator = this.defaultPublicKeys.iterator();
            int n = 1;
            while (iterator.hasNext()) {
                Element element3;
                KeyInfo keyInfo = (KeyInfo)iterator.next();
                String string = (element3 = (Element)element.getOwnerDocument().importNode(keyInfo.getKeyInfo(), true)).getPrefix();
                String string2 = string == null ? "xmlns" : "xmlns:" + string;
                if ("".equals(element3.getAttribute(string2))) {
                    element3.setAttribute(string2, "http://www.w3.org/2000/09/xmldsig#");
                }
                if (element2 == null) {
                    element.appendChild(element3);
                } else {
                    element.replaceChild(element3, element2);
                }
                Logger.normal("Trying validation by using the default key #" + n++, 0);
                Logger.normal("Target SOAP-SEC header: " + new String(XPathCanonicalizer.serializeSubset((Node)sOAPHeaderEntry.getDOMEntity(), (boolean)true)), 0);
                this.checkValidity(sOAPHeaderEntry);
                element2 = element3;
            }
        } else {
            this.checkValidity(sOAPHeaderEntry);
        }
    }

    public void edit(Reader reader, Writer writer) throws SOAPException {
        try {
            SOAPDocumentImpl sOAPDocumentImpl = new SOAPDocumentImpl(this.loadDocument(new InputSource(reader), false));
            boolean bl = false;
            SOAPHeaderEntry[] sOAPHeaderEntryArray = this.soapSignature.getSignatureEntries(sOAPDocumentImpl);
            for (int i = 0; i < sOAPHeaderEntryArray.length; ++i) {
                Logger.normal("Found a <SOAP-SEC:Signature>, verifying...", 0);
                try {
                    this.verify(sOAPHeaderEntryArray[i]);
                    bl = true;
                    break;
                }
                catch (Exception exception) {
                    Logger.normal("Verification failed due to " + exception.getClass().getName() + ": " + exception.getMessage(), 0);
                    Logger.normal("Verification done", 0);
                    continue;
                }
            }
            Iterator iterator = this.soapDSigLoggers.iterator();
            if (bl) {
                while (iterator.hasNext()) {
                    SOAPDSigLogger sOAPDSigLogger = (SOAPDSigLogger)iterator.next();
                    sOAPDSigLogger.verificationSucceeded(sOAPDocumentImpl);
                }
            } else {
                while (iterator.hasNext()) {
                    SOAPDSigLogger sOAPDSigLogger = (SOAPDSigLogger)iterator.next();
                    sOAPDSigLogger.verificationFailed(sOAPDocumentImpl);
                }
                throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Invalid signature");
            }
            XPathCanonicalizer.serializeAll((Document)sOAPDocumentImpl.getDocument(), (boolean)true, (Writer)writer);
            writer.flush();
        }
        catch (IOException iOException) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "IO error", iOException);
        }
    }

    private void checkValidity(SOAPHeaderEntry sOAPHeaderEntry) throws SOAPException {
        try {
            Element element = this.soapSignature.getSignatureElement(sOAPHeaderEntry);
            Key key = this.pkixChecker.check(element);
            if (!this.soapSignature.verify(sOAPHeaderEntry, key)) {
                throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Invalid signature");
            }
        }
        catch (SignatureStructureException signatureStructureException) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Invalid signature element", signatureStructureException);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Invalid key spec", invalidKeySpecException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Unknown algorithm", noSuchAlgorithmException);
        }
        catch (CertificateException certificateException) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Invalid certificate", certificateException);
        }
    }

    private void checkAlgorithm(Element element, String string) throws SOAPException {
        Logger.normal("Checking algorithms...", 0);
        NodeList nodeList = SOAPVerifier.processXPath(element, string);
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            AlgorithmChecker.Algorithm algorithm = new AlgorithmChecker.Algorithm(element2.getLocalName(), element2.getAttribute("Algorithm"));
            if (this.algorithmChecker.check(algorithm)) continue;
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "" + algorithm + " is not allowed");
        }
        Logger.normal("Checking algorithms, done.", 0);
    }

    private void checkEncoding(Element element) throws SOAPException {
        Logger.normal("Checking encoding...", 0);
        NodeList nodeList = SOAPVerifier.processXPath(element, XPATH_ENCODING);
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            AlgorithmChecker.Algorithm algorithm = new AlgorithmChecker.Algorithm(nodeList.item(i).getLocalName(), nodeList.item(i).getNodeValue());
            if (this.algorithmChecker.check(algorithm)) continue;
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "" + algorithm + " is not allowed");
        }
        Logger.normal("Checking encoding, done.", 0);
    }

    KeyInfo createKeyInfo(Element element) throws SOAPException {
        try {
            return new KeyInfo(element);
        }
        catch (XSignatureException xSignatureException) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Invalid key spec: " + new String(XPathCanonicalizer.serializeSubset((Node)element, (boolean)true)), xSignatureException);
        }
    }

    CertStore createLDAPCertStore(String string, int n, String string2) throws SOAPException {
        try {
            LDAPCertStoreParameters lDAPCertStoreParameters = new LDAPCertStoreParameters(string, n);
            CertStore certStore = null;
            if ("".equals(string2)) {
                CertStore.getInstance(ALGORITHM, lDAPCertStoreParameters);
            } else {
                CertStore.getInstance(ALGORITHM, (CertStoreParameters)lDAPCertStoreParameters, string2);
            }
            return certStore;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Unknown algorithm: LDAP", noSuchAlgorithmException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            Logger.normal("LDAPCertStore: " + invalidAlgorithmParameterException.getMessage() + " host=" + string + " port=" + n, 4);
            return null;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "No such provider: " + string2, noSuchProviderException);
        }
        catch (Exception exception) {
            Logger.normal("Ignore an error: LDAPCertStore: " + exception.getMessage() + " host=" + string + " port=" + n, 3);
            return null;
        }
    }

    CertStore createCollectionCertStore(NodeList nodeList, CertificateFactory certificateFactory, String string) throws SOAPException {
        HashSet<X509Certificate> hashSet = new HashSet<X509Certificate>();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            String string2 = nodeList.item(i).getNodeValue();
            hashSet.add(this.loadX509Certificate(string2, certificateFactory));
        }
        try {
            CollectionCertStoreParameters collectionCertStoreParameters = new CollectionCertStoreParameters(hashSet);
            if ("".equals(string)) {
                return CertStore.getInstance("Collection", collectionCertStoreParameters);
            }
            return CertStore.getInstance("Collection", (CertStoreParameters)collectionCertStoreParameters, string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Can't create a CollectionCertStore", noSuchAlgorithmException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Can't create a CollectionCertStore", invalidAlgorithmParameterException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "No such provider: " + string, noSuchProviderException);
        }
    }

    private X509Certificate loadX509Certificate(String string, CertificateFactory certificateFactory) throws SOAPException {
        try {
            File file = new File(this.home, string);
            string = file.getCanonicalPath();
            Logger.normal("Loading an X509Certificate: " + string, 3);
            return (X509Certificate)certificateFactory.generateCertificate(new FileInputStream(file));
        }
        catch (IOException iOException) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Can't open an X509Certificate file: " + string, iOException);
        }
        catch (CertificateException certificateException) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Invalid X509Certificate: " + string, certificateException);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        SOAPVerifier sOAPVerifier = new SOAPVerifier();
        sOAPVerifier.initialize(new InputSource(stringArray[0]));
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(System.out);
        sOAPVerifier.edit(new FileReader(stringArray[1]), outputStreamWriter);
        ((Writer)outputStreamWriter).flush();
        System.out.flush();
    }

    private CertificateFactory createCertificateFactory(String string) throws SOAPException {
        try {
            if (string == null || "".equals(string)) {
                return CertificateFactory.getInstance("X.509");
            }
            return CertificateFactory.getInstance("X.509", string);
        }
        catch (CertificateException certificateException) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Can't create an X.509 CertificateFactory", certificateException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "No such provider: " + string, noSuchProviderException);
        }
    }

    private void enableKeyUsage(String string, boolean[] blArray) throws SOAPException {
        Integer n = (Integer)KEY_USAGE_TABLE.get(string);
        if (n == null) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Unknown OID: '" + string + "'");
        }
        int n2 = n;
        blArray[n2] = true;
    }

    static {
        int n = 0;
        KEY_USAGE_TABLE.put("DIGITAL_SIGNATURE", new Integer(n++));
        KEY_USAGE_TABLE.put("NON_REPUDIATION", new Integer(n++));
        KEY_USAGE_TABLE.put("KEY_ENCIPHERMENT", new Integer(n++));
        KEY_USAGE_TABLE.put("DATA_ENCHIPERMENT", new Integer(n++));
        KEY_USAGE_TABLE.put("KEY_AGREEMENT", new Integer(n++));
        KEY_USAGE_TABLE.put("KEY_CERT_SIGN", new Integer(n++));
        KEY_USAGE_TABLE.put("CRL_SIGN", new Integer(n++));
        KEY_USAGE_TABLE.put("ENCIPHER_ONLY", new Integer(n++));
        KEY_USAGE_TABLE.put("DECIPHER_ONLY", new Integer(n++));
    }
}

