/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soap.security.dsig;

import com.ibm.trl.soap.SOAPDocument;
import com.ibm.trl.util.xml.XPathProcessor;
import com.ibm.ws.wssecurity.xss4j.domutil.XPathCanonicalizer;
import com.ibm.xml.soap.security.dsig.SOAPDSigLogger;
import com.ibm.xml.soap.transport.AbstractSOAPHandler;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.soap.Constants;
import org.apache.soap.SOAPException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class SOAPDSigLoggerImpl
implements SOAPDSigLogger {
    private static final String TARGET_ALL = "all";
    private static final String TARGET_SUCCESS = "success";
    private static final String TARGET_FAIL = "fail";
    private static final int TYPE_UNKNOWN = 0;
    private static final int TYPE_ALL = 1;
    private static final int TYPE_SUCCESS = 2;
    private static final int TYPE_FAIL = 3;
    private static final Hashtable typeTable = new Hashtable();
    private static final String XPATH_LOGFILE;
    private final List logFiles = new LinkedList();

    private static int getType(String string) {
        Integer n = (Integer)typeTable.get(string);
        if (n == null) {
            return 0;
        }
        return n;
    }

    public void init(Element element, String string) throws SOAPException {
        try {
            NodeList nodeList = XPathProcessor.process(element, XPATH_LOGFILE);
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                LogFile logFile = new LogFile();
                logFile.init((Element)nodeList.item(i), string);
                this.logFiles.add(logFile);
            }
        }
        catch (SAXException sAXException) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Invalid XPath expression: " + XPATH_LOGFILE, sAXException);
        }
    }

    public void verificationSucceeded(SOAPDocument sOAPDocument) throws SOAPException {
        Iterator iterator = this.logFiles.iterator();
        while (iterator.hasNext()) {
            LogFile logFile = (LogFile)iterator.next();
            logFile.verificationSucceeded(sOAPDocument);
        }
    }

    public void verificationFailed(SOAPDocument sOAPDocument) throws SOAPException {
        Iterator iterator = this.logFiles.iterator();
        while (iterator.hasNext()) {
            LogFile logFile = (LogFile)iterator.next();
            logFile.verificationFailed(sOAPDocument);
        }
    }

    public String toString() {
        return "SOAPDSigLoggerImpl(logFiles=" + this.logFiles + ")";
    }

    private static String getTime() {
        return DateFormat.getDateTimeInstance(0, 0).format(new Date());
    }

    static {
        typeTable.put(TARGET_ALL, new Integer(1));
        typeTable.put(TARGET_SUCCESS, new Integer(2));
        typeTable.put(TARGET_FAIL, new Integer(3));
        XPATH_LOGFILE = "//" + XPathProcessor.getXPath("http://www.ibm.com/xml/soap/#SOAPSignature", "LogFile");
    }

    class LogFile
    implements SOAPDSigLogger {
        private String path = null;
        private boolean append = false;
        private Writer out = null;
        private boolean success = false;
        private boolean fail = false;

        LogFile() {
        }

        public void init(Element element, String string) throws SOAPException {
            this.path = element.getAttribute("path");
            this.append = AbstractSOAPHandler.isTrue(element.getAttribute("append"));
            try {
                this.out = new FileWriter(new File(string, this.path).getAbsolutePath(), this.append);
            }
            catch (IOException iOException) {
                throw new SOAPException(Constants.FAULT_CODE_SERVER, "Can't open the log file: " + this.path, iOException);
            }
            switch (SOAPDSigLoggerImpl.getType(element.getAttribute("target"))) {
                case 1: {
                    this.success = true;
                    this.fail = true;
                    break;
                }
                case 2: {
                    this.success = true;
                    break;
                }
                case 3: {
                    this.fail = true;
                    break;
                }
            }
        }

        public void verificationSucceeded(SOAPDocument sOAPDocument) throws SOAPException {
            try {
                if (this.out != null && this.success) {
                    this.out.write(SOAPDSigLoggerImpl.getTime() + " \"SUCCESS\" ");
                    XPathCanonicalizer.serializeAll((Document)sOAPDocument.getDocument(), (boolean)true, (Writer)this.out);
                    this.out.write("\n");
                    this.out.flush();
                }
            }
            catch (IOException iOException) {
                throw new SOAPException(Constants.FAULT_CODE_SERVER, "Can't write to the log file", iOException);
            }
        }

        public void verificationFailed(SOAPDocument sOAPDocument) throws SOAPException {
            try {
                if (this.out != null && this.fail) {
                    this.out.write(SOAPDSigLoggerImpl.getTime() + " \"FAIL\" ");
                    XPathCanonicalizer.serializeAll((Document)sOAPDocument.getDocument(), (boolean)true, (Writer)this.out);
                    this.out.write("\n");
                    this.out.flush();
                }
            }
            catch (IOException iOException) {
                throw new SOAPException(Constants.FAULT_CODE_SERVER, "Can't write to the log file", iOException);
            }
        }

        public String toString() {
            return "LogFile(path='" + this.path + "' append=" + this.append + " logSuccess=" + this.success + " logFail=" + this.fail + ")";
        }
    }
}

